<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.SalePointPeripheralSerialPortParametersBase
 * StructType
 * @subpackage Structs
 */
class Security_SalePointPeripheralSerialPortParametersBase extends Security_SalePointParametersBase
{
    /**
     * The BaudRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaudRate;
    /**
     * The DataBits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DataBits;
    /**
     * The Parity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Parity;
    /**
     * The StopBits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StopBits;
    /**
     * Constructor method for Security.SalePointPeripheralSerialPortParametersBase
     * @uses Security_SalePointPeripheralSerialPortParametersBase::setBaudRate()
     * @uses Security_SalePointPeripheralSerialPortParametersBase::setDataBits()
     * @uses Security_SalePointPeripheralSerialPortParametersBase::setParity()
     * @uses Security_SalePointPeripheralSerialPortParametersBase::setStopBits()
     * @param string $baudRate
     * @param int $dataBits
     * @param string $parity
     * @param string $stopBits
     */
    public function __construct($baudRate = null, $dataBits = null, $parity = null, $stopBits = null)
    {
        $this
            ->setBaudRate($baudRate)
            ->setDataBits($dataBits)
            ->setParity($parity)
            ->setStopBits($stopBits);
    }
    /**
     * Get BaudRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaudRate()
    {
        return isset($this->BaudRate) ? $this->BaudRate : null;
    }
    /**
     * Set BaudRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SerialPortBaudRate::valueIsValid()
     * @uses \patest\EnumType\SerialPortBaudRate::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $baudRate
     * @return \patest\StructType\Security_SalePointPeripheralSerialPortParametersBase
     */
    public function setBaudRate($baudRate = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SerialPortBaudRate::valueIsValid($baudRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SerialPortBaudRate', is_array($baudRate) ? implode(', ', $baudRate) : var_export($baudRate, true), implode(', ', \patest\EnumType\SerialPortBaudRate::getValidValues())), __LINE__);
        }
        if (is_null($baudRate) || (is_array($baudRate) && empty($baudRate))) {
            unset($this->BaudRate);
        } else {
            $this->BaudRate = $baudRate;
        }
        return $this;
    }
    /**
     * Get DataBits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDataBits()
    {
        return isset($this->DataBits) ? $this->DataBits : null;
    }
    /**
     * Set DataBits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dataBits
     * @return \patest\StructType\Security_SalePointPeripheralSerialPortParametersBase
     */
    public function setDataBits($dataBits = null)
    {
        // validation for constraint: int
        if (!is_null($dataBits) && !(is_int($dataBits) || ctype_digit($dataBits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dataBits, true), gettype($dataBits)), __LINE__);
        }
        if (is_null($dataBits) || (is_array($dataBits) && empty($dataBits))) {
            unset($this->DataBits);
        } else {
            $this->DataBits = $dataBits;
        }
        return $this;
    }
    /**
     * Get Parity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParity()
    {
        return isset($this->Parity) ? $this->Parity : null;
    }
    /**
     * Set Parity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SerialPortParity::valueIsValid()
     * @uses \patest\EnumType\SerialPortParity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parity
     * @return \patest\StructType\Security_SalePointPeripheralSerialPortParametersBase
     */
    public function setParity($parity = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SerialPortParity::valueIsValid($parity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SerialPortParity', is_array($parity) ? implode(', ', $parity) : var_export($parity, true), implode(', ', \patest\EnumType\SerialPortParity::getValidValues())), __LINE__);
        }
        if (is_null($parity) || (is_array($parity) && empty($parity))) {
            unset($this->Parity);
        } else {
            $this->Parity = $parity;
        }
        return $this;
    }
    /**
     * Get StopBits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStopBits()
    {
        return isset($this->StopBits) ? $this->StopBits : null;
    }
    /**
     * Set StopBits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SerialPortStopBits::valueIsValid()
     * @uses \patest\EnumType\SerialPortStopBits::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopBits
     * @return \patest\StructType\Security_SalePointPeripheralSerialPortParametersBase
     */
    public function setStopBits($stopBits = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SerialPortStopBits::valueIsValid($stopBits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SerialPortStopBits', is_array($stopBits) ? implode(', ', $stopBits) : var_export($stopBits, true), implode(', ', \patest\EnumType\SerialPortStopBits::getValidValues())), __LINE__);
        }
        if (is_null($stopBits) || (is_array($stopBits) && empty($stopBits))) {
            unset($this->StopBits);
        } else {
            $this->StopBits = $stopBits;
        }
        return $this;
    }
}
