<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.SMSCollectionParameters StructType
 * @subpackage Structs
 */
class Security_SMSCollectionParameters extends Security_CompanyParameterBase
{
    /**
     * The ApiKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApiKey;
    /**
     * The ApiURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApiURL;
    /**
     * The BarcodeHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeHeader;
    /**
     * The BitLyGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BitLyGroupId;
    /**
     * The BitLyToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BitLyToken;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * The CustomEventHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomEventHeader;
    /**
     * The CustomMinifyCss
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomMinifyCss;
    /**
     * The DisplayArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayArea;
    /**
     * The DisplayGate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayGate;
    /**
     * The DisplayGateLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayGateLabel;
    /**
     * The DisplayPriceTypeAlternativeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayPriceTypeAlternativeName;
    /**
     * The DisplaySeatCustomProperty1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplaySeatCustomProperty1;
    /**
     * The DisplaySeatCustomProperty2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplaySeatCustomProperty2;
    /**
     * The DisplaySeatCustomProperty3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplaySeatCustomProperty3;
    /**
     * The DisplaySeatCustomProperty4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplaySeatCustomProperty4;
    /**
     * The DisplaySector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplaySector;
    /**
     * The DisplayStand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayStand;
    /**
     * The DisplayTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayTransactionNumber;
    /**
     * The DisplayTurnstile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayTurnstile;
    /**
     * The EncryptionKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EncryptionKey;
    /**
     * The FromNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromNumber;
    /**
     * The HideSeatDetailsWhenAreaBAReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HideSeatDetailsWhenAreaBAReservation;
    /**
     * The HideSeatDetailsWhenEventSaleFlowModeBA
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HideSeatDetailsWhenEventSaleFlowModeBA;
    /**
     * The ImageIdToDisplay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ImageIdToDisplay;
    /**
     * The ImageToDisplayAsBackground
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImageToDisplayAsBackground;
    /**
     * The IsoCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsoCountryCode;
    /**
     * The MessagingServiceSid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MessagingServiceSid;
    /**
     * The PageHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PageHeader;
    /**
     * The PageTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PageTitle;
    /**
     * The RunStatusCheck
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RunStatusCheck;
    /**
     * The SendSmsIfShortFail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SendSmsIfShortFail;
    /**
     * The SendTicketGroupBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SendTicketGroupBy;
    /**
     * The ShowBarcodeAfterEventEndedInDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ShowBarcodeAfterEventEndedInDays;
    /**
     * The SignatureSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SignatureSize;
    /**
     * The SimpleSMSPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SimpleSMSPassword;
    /**
     * The SimpleSMSSenderName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SimpleSMSSenderName;
    /**
     * The SimpleSMSUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SimpleSMSUser;
    /**
     * The SMSProvider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SMSProvider;
    /**
     * The TurnOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TurnOn;
    /**
     * The URLPattern
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $URLPattern;
    /**
     * The URLTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $URLTemplate;
    /**
     * The VenueNamePrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VenueNamePrefix;
    /**
     * Constructor method for Security.SMSCollectionParameters
     * @uses Security_SMSCollectionParameters::setApiKey()
     * @uses Security_SMSCollectionParameters::setApiURL()
     * @uses Security_SMSCollectionParameters::setBarcodeHeader()
     * @uses Security_SMSCollectionParameters::setBitLyGroupId()
     * @uses Security_SMSCollectionParameters::setBitLyToken()
     * @uses Security_SMSCollectionParameters::setCountryCode()
     * @uses Security_SMSCollectionParameters::setCustomEventHeader()
     * @uses Security_SMSCollectionParameters::setCustomMinifyCss()
     * @uses Security_SMSCollectionParameters::setDisplayArea()
     * @uses Security_SMSCollectionParameters::setDisplayGate()
     * @uses Security_SMSCollectionParameters::setDisplayGateLabel()
     * @uses Security_SMSCollectionParameters::setDisplayPriceTypeAlternativeName()
     * @uses Security_SMSCollectionParameters::setDisplaySeatCustomProperty1()
     * @uses Security_SMSCollectionParameters::setDisplaySeatCustomProperty2()
     * @uses Security_SMSCollectionParameters::setDisplaySeatCustomProperty3()
     * @uses Security_SMSCollectionParameters::setDisplaySeatCustomProperty4()
     * @uses Security_SMSCollectionParameters::setDisplaySector()
     * @uses Security_SMSCollectionParameters::setDisplayStand()
     * @uses Security_SMSCollectionParameters::setDisplayTransactionNumber()
     * @uses Security_SMSCollectionParameters::setDisplayTurnstile()
     * @uses Security_SMSCollectionParameters::setEncryptionKey()
     * @uses Security_SMSCollectionParameters::setFromNumber()
     * @uses Security_SMSCollectionParameters::setHideSeatDetailsWhenAreaBAReservation()
     * @uses Security_SMSCollectionParameters::setHideSeatDetailsWhenEventSaleFlowModeBA()
     * @uses Security_SMSCollectionParameters::setImageIdToDisplay()
     * @uses Security_SMSCollectionParameters::setImageToDisplayAsBackground()
     * @uses Security_SMSCollectionParameters::setIsoCountryCode()
     * @uses Security_SMSCollectionParameters::setMessagingServiceSid()
     * @uses Security_SMSCollectionParameters::setPageHeader()
     * @uses Security_SMSCollectionParameters::setPageTitle()
     * @uses Security_SMSCollectionParameters::setRunStatusCheck()
     * @uses Security_SMSCollectionParameters::setSendSmsIfShortFail()
     * @uses Security_SMSCollectionParameters::setSendTicketGroupBy()
     * @uses Security_SMSCollectionParameters::setShowBarcodeAfterEventEndedInDays()
     * @uses Security_SMSCollectionParameters::setSignatureSize()
     * @uses Security_SMSCollectionParameters::setSimpleSMSPassword()
     * @uses Security_SMSCollectionParameters::setSimpleSMSSenderName()
     * @uses Security_SMSCollectionParameters::setSimpleSMSUser()
     * @uses Security_SMSCollectionParameters::setSMSProvider()
     * @uses Security_SMSCollectionParameters::setTurnOn()
     * @uses Security_SMSCollectionParameters::setURLPattern()
     * @uses Security_SMSCollectionParameters::setURLTemplate()
     * @uses Security_SMSCollectionParameters::setVenueNamePrefix()
     * @param string $apiKey
     * @param string $apiURL
     * @param string $barcodeHeader
     * @param string $bitLyGroupId
     * @param string $bitLyToken
     * @param string $countryCode
     * @param string $customEventHeader
     * @param string $customMinifyCss
     * @param string $displayArea
     * @param string $displayGate
     * @param string $displayGateLabel
     * @param string $displayPriceTypeAlternativeName
     * @param string $displaySeatCustomProperty1
     * @param string $displaySeatCustomProperty2
     * @param string $displaySeatCustomProperty3
     * @param string $displaySeatCustomProperty4
     * @param string $displaySector
     * @param string $displayStand
     * @param string $displayTransactionNumber
     * @param string $displayTurnstile
     * @param string $encryptionKey
     * @param string $fromNumber
     * @param string $hideSeatDetailsWhenAreaBAReservation
     * @param string $hideSeatDetailsWhenEventSaleFlowModeBA
     * @param int $imageIdToDisplay
     * @param string $imageToDisplayAsBackground
     * @param string $isoCountryCode
     * @param string $messagingServiceSid
     * @param string $pageHeader
     * @param string $pageTitle
     * @param bool $runStatusCheck
     * @param string $sendSmsIfShortFail
     * @param string $sendTicketGroupBy
     * @param int $showBarcodeAfterEventEndedInDays
     * @param int $signatureSize
     * @param string $simpleSMSPassword
     * @param string $simpleSMSSenderName
     * @param string $simpleSMSUser
     * @param string $sMSProvider
     * @param bool $turnOn
     * @param string $uRLPattern
     * @param string $uRLTemplate
     * @param string $venueNamePrefix
     */
    public function __construct($apiKey = null, $apiURL = null, $barcodeHeader = null, $bitLyGroupId = null, $bitLyToken = null, $countryCode = null, $customEventHeader = null, $customMinifyCss = null, $displayArea = null, $displayGate = null, $displayGateLabel = null, $displayPriceTypeAlternativeName = null, $displaySeatCustomProperty1 = null, $displaySeatCustomProperty2 = null, $displaySeatCustomProperty3 = null, $displaySeatCustomProperty4 = null, $displaySector = null, $displayStand = null, $displayTransactionNumber = null, $displayTurnstile = null, $encryptionKey = null, $fromNumber = null, $hideSeatDetailsWhenAreaBAReservation = null, $hideSeatDetailsWhenEventSaleFlowModeBA = null, $imageIdToDisplay = null, $imageToDisplayAsBackground = null, $isoCountryCode = null, $messagingServiceSid = null, $pageHeader = null, $pageTitle = null, $runStatusCheck = null, $sendSmsIfShortFail = null, $sendTicketGroupBy = null, $showBarcodeAfterEventEndedInDays = null, $signatureSize = null, $simpleSMSPassword = null, $simpleSMSSenderName = null, $simpleSMSUser = null, $sMSProvider = null, $turnOn = null, $uRLPattern = null, $uRLTemplate = null, $venueNamePrefix = null)
    {
        $this
            ->setApiKey($apiKey)
            ->setApiURL($apiURL)
            ->setBarcodeHeader($barcodeHeader)
            ->setBitLyGroupId($bitLyGroupId)
            ->setBitLyToken($bitLyToken)
            ->setCountryCode($countryCode)
            ->setCustomEventHeader($customEventHeader)
            ->setCustomMinifyCss($customMinifyCss)
            ->setDisplayArea($displayArea)
            ->setDisplayGate($displayGate)
            ->setDisplayGateLabel($displayGateLabel)
            ->setDisplayPriceTypeAlternativeName($displayPriceTypeAlternativeName)
            ->setDisplaySeatCustomProperty1($displaySeatCustomProperty1)
            ->setDisplaySeatCustomProperty2($displaySeatCustomProperty2)
            ->setDisplaySeatCustomProperty3($displaySeatCustomProperty3)
            ->setDisplaySeatCustomProperty4($displaySeatCustomProperty4)
            ->setDisplaySector($displaySector)
            ->setDisplayStand($displayStand)
            ->setDisplayTransactionNumber($displayTransactionNumber)
            ->setDisplayTurnstile($displayTurnstile)
            ->setEncryptionKey($encryptionKey)
            ->setFromNumber($fromNumber)
            ->setHideSeatDetailsWhenAreaBAReservation($hideSeatDetailsWhenAreaBAReservation)
            ->setHideSeatDetailsWhenEventSaleFlowModeBA($hideSeatDetailsWhenEventSaleFlowModeBA)
            ->setImageIdToDisplay($imageIdToDisplay)
            ->setImageToDisplayAsBackground($imageToDisplayAsBackground)
            ->setIsoCountryCode($isoCountryCode)
            ->setMessagingServiceSid($messagingServiceSid)
            ->setPageHeader($pageHeader)
            ->setPageTitle($pageTitle)
            ->setRunStatusCheck($runStatusCheck)
            ->setSendSmsIfShortFail($sendSmsIfShortFail)
            ->setSendTicketGroupBy($sendTicketGroupBy)
            ->setShowBarcodeAfterEventEndedInDays($showBarcodeAfterEventEndedInDays)
            ->setSignatureSize($signatureSize)
            ->setSimpleSMSPassword($simpleSMSPassword)
            ->setSimpleSMSSenderName($simpleSMSSenderName)
            ->setSimpleSMSUser($simpleSMSUser)
            ->setSMSProvider($sMSProvider)
            ->setTurnOn($turnOn)
            ->setURLPattern($uRLPattern)
            ->setURLTemplate($uRLTemplate)
            ->setVenueNamePrefix($venueNamePrefix);
    }
    /**
     * Get ApiKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApiKey()
    {
        return isset($this->ApiKey) ? $this->ApiKey : null;
    }
    /**
     * Set ApiKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apiKey
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiKey, true), gettype($apiKey)), __LINE__);
        }
        if (is_null($apiKey) || (is_array($apiKey) && empty($apiKey))) {
            unset($this->ApiKey);
        } else {
            $this->ApiKey = $apiKey;
        }
        return $this;
    }
    /**
     * Get ApiURL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApiURL()
    {
        return isset($this->ApiURL) ? $this->ApiURL : null;
    }
    /**
     * Set ApiURL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apiURL
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setApiURL($apiURL = null)
    {
        // validation for constraint: string
        if (!is_null($apiURL) && !is_string($apiURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiURL, true), gettype($apiURL)), __LINE__);
        }
        if (is_null($apiURL) || (is_array($apiURL) && empty($apiURL))) {
            unset($this->ApiURL);
        } else {
            $this->ApiURL = $apiURL;
        }
        return $this;
    }
    /**
     * Get BarcodeHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeHeader()
    {
        return isset($this->BarcodeHeader) ? $this->BarcodeHeader : null;
    }
    /**
     * Set BarcodeHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeHeader
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setBarcodeHeader($barcodeHeader = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeHeader) && !is_string($barcodeHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeHeader, true), gettype($barcodeHeader)), __LINE__);
        }
        if (is_null($barcodeHeader) || (is_array($barcodeHeader) && empty($barcodeHeader))) {
            unset($this->BarcodeHeader);
        } else {
            $this->BarcodeHeader = $barcodeHeader;
        }
        return $this;
    }
    /**
     * Get BitLyGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBitLyGroupId()
    {
        return isset($this->BitLyGroupId) ? $this->BitLyGroupId : null;
    }
    /**
     * Set BitLyGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bitLyGroupId
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setBitLyGroupId($bitLyGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($bitLyGroupId) && !is_string($bitLyGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bitLyGroupId, true), gettype($bitLyGroupId)), __LINE__);
        }
        if (is_null($bitLyGroupId) || (is_array($bitLyGroupId) && empty($bitLyGroupId))) {
            unset($this->BitLyGroupId);
        } else {
            $this->BitLyGroupId = $bitLyGroupId;
        }
        return $this;
    }
    /**
     * Get BitLyToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBitLyToken()
    {
        return isset($this->BitLyToken) ? $this->BitLyToken : null;
    }
    /**
     * Set BitLyToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bitLyToken
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setBitLyToken($bitLyToken = null)
    {
        // validation for constraint: string
        if (!is_null($bitLyToken) && !is_string($bitLyToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bitLyToken, true), gettype($bitLyToken)), __LINE__);
        }
        if (is_null($bitLyToken) || (is_array($bitLyToken) && empty($bitLyToken))) {
            unset($this->BitLyToken);
        } else {
            $this->BitLyToken = $bitLyToken;
        }
        return $this;
    }
    /**
     * Get CountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryCode
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get CustomEventHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomEventHeader()
    {
        return isset($this->CustomEventHeader) ? $this->CustomEventHeader : null;
    }
    /**
     * Set CustomEventHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customEventHeader
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setCustomEventHeader($customEventHeader = null)
    {
        // validation for constraint: string
        if (!is_null($customEventHeader) && !is_string($customEventHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customEventHeader, true), gettype($customEventHeader)), __LINE__);
        }
        if (is_null($customEventHeader) || (is_array($customEventHeader) && empty($customEventHeader))) {
            unset($this->CustomEventHeader);
        } else {
            $this->CustomEventHeader = $customEventHeader;
        }
        return $this;
    }
    /**
     * Get CustomMinifyCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomMinifyCss()
    {
        return isset($this->CustomMinifyCss) ? $this->CustomMinifyCss : null;
    }
    /**
     * Set CustomMinifyCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customMinifyCss
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setCustomMinifyCss($customMinifyCss = null)
    {
        // validation for constraint: string
        if (!is_null($customMinifyCss) && !is_string($customMinifyCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customMinifyCss, true), gettype($customMinifyCss)), __LINE__);
        }
        if (is_null($customMinifyCss) || (is_array($customMinifyCss) && empty($customMinifyCss))) {
            unset($this->CustomMinifyCss);
        } else {
            $this->CustomMinifyCss = $customMinifyCss;
        }
        return $this;
    }
    /**
     * Get DisplayArea value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayArea()
    {
        return isset($this->DisplayArea) ? $this->DisplayArea : null;
    }
    /**
     * Set DisplayArea value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayArea
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setDisplayArea($displayArea = null)
    {
        // validation for constraint: string
        if (!is_null($displayArea) && !is_string($displayArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayArea, true), gettype($displayArea)), __LINE__);
        }
        if (is_null($displayArea) || (is_array($displayArea) && empty($displayArea))) {
            unset($this->DisplayArea);
        } else {
            $this->DisplayArea = $displayArea;
        }
        return $this;
    }
    /**
     * Get DisplayGate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayGate()
    {
        return isset($this->DisplayGate) ? $this->DisplayGate : null;
    }
    /**
     * Set DisplayGate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayGate
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setDisplayGate($displayGate = null)
    {
        // validation for constraint: string
        if (!is_null($displayGate) && !is_string($displayGate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayGate, true), gettype($displayGate)), __LINE__);
        }
        if (is_null($displayGate) || (is_array($displayGate) && empty($displayGate))) {
            unset($this->DisplayGate);
        } else {
            $this->DisplayGate = $displayGate;
        }
        return $this;
    }
    /**
     * Get DisplayGateLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayGateLabel()
    {
        return isset($this->DisplayGateLabel) ? $this->DisplayGateLabel : null;
    }
    /**
     * Set DisplayGateLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayGateLabel
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setDisplayGateLabel($displayGateLabel = null)
    {
        // validation for constraint: string
        if (!is_null($displayGateLabel) && !is_string($displayGateLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayGateLabel, true), gettype($displayGateLabel)), __LINE__);
        }
        if (is_null($displayGateLabel) || (is_array($displayGateLabel) && empty($displayGateLabel))) {
            unset($this->DisplayGateLabel);
        } else {
            $this->DisplayGateLabel = $displayGateLabel;
        }
        return $this;
    }
    /**
     * Get DisplayPriceTypeAlternativeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayPriceTypeAlternativeName()
    {
        return isset($this->DisplayPriceTypeAlternativeName) ? $this->DisplayPriceTypeAlternativeName : null;
    }
    /**
     * Set DisplayPriceTypeAlternativeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayPriceTypeAlternativeName
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setDisplayPriceTypeAlternativeName($displayPriceTypeAlternativeName = null)
    {
        // validation for constraint: string
        if (!is_null($displayPriceTypeAlternativeName) && !is_string($displayPriceTypeAlternativeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayPriceTypeAlternativeName, true), gettype($displayPriceTypeAlternativeName)), __LINE__);
        }
        if (is_null($displayPriceTypeAlternativeName) || (is_array($displayPriceTypeAlternativeName) && empty($displayPriceTypeAlternativeName))) {
            unset($this->DisplayPriceTypeAlternativeName);
        } else {
            $this->DisplayPriceTypeAlternativeName = $displayPriceTypeAlternativeName;
        }
        return $this;
    }
    /**
     * Get DisplaySeatCustomProperty1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplaySeatCustomProperty1()
    {
        return isset($this->DisplaySeatCustomProperty1) ? $this->DisplaySeatCustomProperty1 : null;
    }
    /**
     * Set DisplaySeatCustomProperty1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displaySeatCustomProperty1
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setDisplaySeatCustomProperty1($displaySeatCustomProperty1 = null)
    {
        // validation for constraint: string
        if (!is_null($displaySeatCustomProperty1) && !is_string($displaySeatCustomProperty1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displaySeatCustomProperty1, true), gettype($displaySeatCustomProperty1)), __LINE__);
        }
        if (is_null($displaySeatCustomProperty1) || (is_array($displaySeatCustomProperty1) && empty($displaySeatCustomProperty1))) {
            unset($this->DisplaySeatCustomProperty1);
        } else {
            $this->DisplaySeatCustomProperty1 = $displaySeatCustomProperty1;
        }
        return $this;
    }
    /**
     * Get DisplaySeatCustomProperty2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplaySeatCustomProperty2()
    {
        return isset($this->DisplaySeatCustomProperty2) ? $this->DisplaySeatCustomProperty2 : null;
    }
    /**
     * Set DisplaySeatCustomProperty2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displaySeatCustomProperty2
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setDisplaySeatCustomProperty2($displaySeatCustomProperty2 = null)
    {
        // validation for constraint: string
        if (!is_null($displaySeatCustomProperty2) && !is_string($displaySeatCustomProperty2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displaySeatCustomProperty2, true), gettype($displaySeatCustomProperty2)), __LINE__);
        }
        if (is_null($displaySeatCustomProperty2) || (is_array($displaySeatCustomProperty2) && empty($displaySeatCustomProperty2))) {
            unset($this->DisplaySeatCustomProperty2);
        } else {
            $this->DisplaySeatCustomProperty2 = $displaySeatCustomProperty2;
        }
        return $this;
    }
    /**
     * Get DisplaySeatCustomProperty3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplaySeatCustomProperty3()
    {
        return isset($this->DisplaySeatCustomProperty3) ? $this->DisplaySeatCustomProperty3 : null;
    }
    /**
     * Set DisplaySeatCustomProperty3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displaySeatCustomProperty3
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setDisplaySeatCustomProperty3($displaySeatCustomProperty3 = null)
    {
        // validation for constraint: string
        if (!is_null($displaySeatCustomProperty3) && !is_string($displaySeatCustomProperty3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displaySeatCustomProperty3, true), gettype($displaySeatCustomProperty3)), __LINE__);
        }
        if (is_null($displaySeatCustomProperty3) || (is_array($displaySeatCustomProperty3) && empty($displaySeatCustomProperty3))) {
            unset($this->DisplaySeatCustomProperty3);
        } else {
            $this->DisplaySeatCustomProperty3 = $displaySeatCustomProperty3;
        }
        return $this;
    }
    /**
     * Get DisplaySeatCustomProperty4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplaySeatCustomProperty4()
    {
        return isset($this->DisplaySeatCustomProperty4) ? $this->DisplaySeatCustomProperty4 : null;
    }
    /**
     * Set DisplaySeatCustomProperty4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displaySeatCustomProperty4
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setDisplaySeatCustomProperty4($displaySeatCustomProperty4 = null)
    {
        // validation for constraint: string
        if (!is_null($displaySeatCustomProperty4) && !is_string($displaySeatCustomProperty4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displaySeatCustomProperty4, true), gettype($displaySeatCustomProperty4)), __LINE__);
        }
        if (is_null($displaySeatCustomProperty4) || (is_array($displaySeatCustomProperty4) && empty($displaySeatCustomProperty4))) {
            unset($this->DisplaySeatCustomProperty4);
        } else {
            $this->DisplaySeatCustomProperty4 = $displaySeatCustomProperty4;
        }
        return $this;
    }
    /**
     * Get DisplaySector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplaySector()
    {
        return isset($this->DisplaySector) ? $this->DisplaySector : null;
    }
    /**
     * Set DisplaySector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displaySector
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setDisplaySector($displaySector = null)
    {
        // validation for constraint: string
        if (!is_null($displaySector) && !is_string($displaySector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displaySector, true), gettype($displaySector)), __LINE__);
        }
        if (is_null($displaySector) || (is_array($displaySector) && empty($displaySector))) {
            unset($this->DisplaySector);
        } else {
            $this->DisplaySector = $displaySector;
        }
        return $this;
    }
    /**
     * Get DisplayStand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayStand()
    {
        return isset($this->DisplayStand) ? $this->DisplayStand : null;
    }
    /**
     * Set DisplayStand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayStand
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setDisplayStand($displayStand = null)
    {
        // validation for constraint: string
        if (!is_null($displayStand) && !is_string($displayStand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayStand, true), gettype($displayStand)), __LINE__);
        }
        if (is_null($displayStand) || (is_array($displayStand) && empty($displayStand))) {
            unset($this->DisplayStand);
        } else {
            $this->DisplayStand = $displayStand;
        }
        return $this;
    }
    /**
     * Get DisplayTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayTransactionNumber()
    {
        return isset($this->DisplayTransactionNumber) ? $this->DisplayTransactionNumber : null;
    }
    /**
     * Set DisplayTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayTransactionNumber
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setDisplayTransactionNumber($displayTransactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($displayTransactionNumber) && !is_string($displayTransactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayTransactionNumber, true), gettype($displayTransactionNumber)), __LINE__);
        }
        if (is_null($displayTransactionNumber) || (is_array($displayTransactionNumber) && empty($displayTransactionNumber))) {
            unset($this->DisplayTransactionNumber);
        } else {
            $this->DisplayTransactionNumber = $displayTransactionNumber;
        }
        return $this;
    }
    /**
     * Get DisplayTurnstile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayTurnstile()
    {
        return isset($this->DisplayTurnstile) ? $this->DisplayTurnstile : null;
    }
    /**
     * Set DisplayTurnstile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayTurnstile
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setDisplayTurnstile($displayTurnstile = null)
    {
        // validation for constraint: string
        if (!is_null($displayTurnstile) && !is_string($displayTurnstile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayTurnstile, true), gettype($displayTurnstile)), __LINE__);
        }
        if (is_null($displayTurnstile) || (is_array($displayTurnstile) && empty($displayTurnstile))) {
            unset($this->DisplayTurnstile);
        } else {
            $this->DisplayTurnstile = $displayTurnstile;
        }
        return $this;
    }
    /**
     * Get EncryptionKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEncryptionKey()
    {
        return isset($this->EncryptionKey) ? $this->EncryptionKey : null;
    }
    /**
     * Set EncryptionKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $encryptionKey
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setEncryptionKey($encryptionKey = null)
    {
        // validation for constraint: string
        if (!is_null($encryptionKey) && !is_string($encryptionKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encryptionKey, true), gettype($encryptionKey)), __LINE__);
        }
        if (is_null($encryptionKey) || (is_array($encryptionKey) && empty($encryptionKey))) {
            unset($this->EncryptionKey);
        } else {
            $this->EncryptionKey = $encryptionKey;
        }
        return $this;
    }
    /**
     * Get FromNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromNumber()
    {
        return isset($this->FromNumber) ? $this->FromNumber : null;
    }
    /**
     * Set FromNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromNumber
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setFromNumber($fromNumber = null)
    {
        // validation for constraint: string
        if (!is_null($fromNumber) && !is_string($fromNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromNumber, true), gettype($fromNumber)), __LINE__);
        }
        if (is_null($fromNumber) || (is_array($fromNumber) && empty($fromNumber))) {
            unset($this->FromNumber);
        } else {
            $this->FromNumber = $fromNumber;
        }
        return $this;
    }
    /**
     * Get HideSeatDetailsWhenAreaBAReservation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHideSeatDetailsWhenAreaBAReservation()
    {
        return isset($this->HideSeatDetailsWhenAreaBAReservation) ? $this->HideSeatDetailsWhenAreaBAReservation : null;
    }
    /**
     * Set HideSeatDetailsWhenAreaBAReservation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hideSeatDetailsWhenAreaBAReservation
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setHideSeatDetailsWhenAreaBAReservation($hideSeatDetailsWhenAreaBAReservation = null)
    {
        // validation for constraint: string
        if (!is_null($hideSeatDetailsWhenAreaBAReservation) && !is_string($hideSeatDetailsWhenAreaBAReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hideSeatDetailsWhenAreaBAReservation, true), gettype($hideSeatDetailsWhenAreaBAReservation)), __LINE__);
        }
        if (is_null($hideSeatDetailsWhenAreaBAReservation) || (is_array($hideSeatDetailsWhenAreaBAReservation) && empty($hideSeatDetailsWhenAreaBAReservation))) {
            unset($this->HideSeatDetailsWhenAreaBAReservation);
        } else {
            $this->HideSeatDetailsWhenAreaBAReservation = $hideSeatDetailsWhenAreaBAReservation;
        }
        return $this;
    }
    /**
     * Get HideSeatDetailsWhenEventSaleFlowModeBA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHideSeatDetailsWhenEventSaleFlowModeBA()
    {
        return isset($this->HideSeatDetailsWhenEventSaleFlowModeBA) ? $this->HideSeatDetailsWhenEventSaleFlowModeBA : null;
    }
    /**
     * Set HideSeatDetailsWhenEventSaleFlowModeBA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hideSeatDetailsWhenEventSaleFlowModeBA
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setHideSeatDetailsWhenEventSaleFlowModeBA($hideSeatDetailsWhenEventSaleFlowModeBA = null)
    {
        // validation for constraint: string
        if (!is_null($hideSeatDetailsWhenEventSaleFlowModeBA) && !is_string($hideSeatDetailsWhenEventSaleFlowModeBA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hideSeatDetailsWhenEventSaleFlowModeBA, true), gettype($hideSeatDetailsWhenEventSaleFlowModeBA)), __LINE__);
        }
        if (is_null($hideSeatDetailsWhenEventSaleFlowModeBA) || (is_array($hideSeatDetailsWhenEventSaleFlowModeBA) && empty($hideSeatDetailsWhenEventSaleFlowModeBA))) {
            unset($this->HideSeatDetailsWhenEventSaleFlowModeBA);
        } else {
            $this->HideSeatDetailsWhenEventSaleFlowModeBA = $hideSeatDetailsWhenEventSaleFlowModeBA;
        }
        return $this;
    }
    /**
     * Get ImageIdToDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getImageIdToDisplay()
    {
        return isset($this->ImageIdToDisplay) ? $this->ImageIdToDisplay : null;
    }
    /**
     * Set ImageIdToDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $imageIdToDisplay
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setImageIdToDisplay($imageIdToDisplay = null)
    {
        // validation for constraint: int
        if (!is_null($imageIdToDisplay) && !(is_int($imageIdToDisplay) || ctype_digit($imageIdToDisplay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($imageIdToDisplay, true), gettype($imageIdToDisplay)), __LINE__);
        }
        if (is_null($imageIdToDisplay) || (is_array($imageIdToDisplay) && empty($imageIdToDisplay))) {
            unset($this->ImageIdToDisplay);
        } else {
            $this->ImageIdToDisplay = $imageIdToDisplay;
        }
        return $this;
    }
    /**
     * Get ImageToDisplayAsBackground value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageToDisplayAsBackground()
    {
        return isset($this->ImageToDisplayAsBackground) ? $this->ImageToDisplayAsBackground : null;
    }
    /**
     * Set ImageToDisplayAsBackground value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageToDisplayAsBackground
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setImageToDisplayAsBackground($imageToDisplayAsBackground = null)
    {
        // validation for constraint: string
        if (!is_null($imageToDisplayAsBackground) && !is_string($imageToDisplayAsBackground)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageToDisplayAsBackground, true), gettype($imageToDisplayAsBackground)), __LINE__);
        }
        if (is_null($imageToDisplayAsBackground) || (is_array($imageToDisplayAsBackground) && empty($imageToDisplayAsBackground))) {
            unset($this->ImageToDisplayAsBackground);
        } else {
            $this->ImageToDisplayAsBackground = $imageToDisplayAsBackground;
        }
        return $this;
    }
    /**
     * Get IsoCountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsoCountryCode()
    {
        return isset($this->IsoCountryCode) ? $this->IsoCountryCode : null;
    }
    /**
     * Set IsoCountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isoCountryCode
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setIsoCountryCode($isoCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($isoCountryCode) && !is_string($isoCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isoCountryCode, true), gettype($isoCountryCode)), __LINE__);
        }
        if (is_null($isoCountryCode) || (is_array($isoCountryCode) && empty($isoCountryCode))) {
            unset($this->IsoCountryCode);
        } else {
            $this->IsoCountryCode = $isoCountryCode;
        }
        return $this;
    }
    /**
     * Get MessagingServiceSid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessagingServiceSid()
    {
        return isset($this->MessagingServiceSid) ? $this->MessagingServiceSid : null;
    }
    /**
     * Set MessagingServiceSid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $messagingServiceSid
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setMessagingServiceSid($messagingServiceSid = null)
    {
        // validation for constraint: string
        if (!is_null($messagingServiceSid) && !is_string($messagingServiceSid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messagingServiceSid, true), gettype($messagingServiceSid)), __LINE__);
        }
        if (is_null($messagingServiceSid) || (is_array($messagingServiceSid) && empty($messagingServiceSid))) {
            unset($this->MessagingServiceSid);
        } else {
            $this->MessagingServiceSid = $messagingServiceSid;
        }
        return $this;
    }
    /**
     * Get PageHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPageHeader()
    {
        return isset($this->PageHeader) ? $this->PageHeader : null;
    }
    /**
     * Set PageHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pageHeader
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setPageHeader($pageHeader = null)
    {
        // validation for constraint: string
        if (!is_null($pageHeader) && !is_string($pageHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageHeader, true), gettype($pageHeader)), __LINE__);
        }
        if (is_null($pageHeader) || (is_array($pageHeader) && empty($pageHeader))) {
            unset($this->PageHeader);
        } else {
            $this->PageHeader = $pageHeader;
        }
        return $this;
    }
    /**
     * Get PageTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPageTitle()
    {
        return isset($this->PageTitle) ? $this->PageTitle : null;
    }
    /**
     * Set PageTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pageTitle
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setPageTitle($pageTitle = null)
    {
        // validation for constraint: string
        if (!is_null($pageTitle) && !is_string($pageTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageTitle, true), gettype($pageTitle)), __LINE__);
        }
        if (is_null($pageTitle) || (is_array($pageTitle) && empty($pageTitle))) {
            unset($this->PageTitle);
        } else {
            $this->PageTitle = $pageTitle;
        }
        return $this;
    }
    /**
     * Get RunStatusCheck value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRunStatusCheck()
    {
        return isset($this->RunStatusCheck) ? $this->RunStatusCheck : null;
    }
    /**
     * Set RunStatusCheck value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $runStatusCheck
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setRunStatusCheck($runStatusCheck = null)
    {
        // validation for constraint: boolean
        if (!is_null($runStatusCheck) && !is_bool($runStatusCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($runStatusCheck, true), gettype($runStatusCheck)), __LINE__);
        }
        if (is_null($runStatusCheck) || (is_array($runStatusCheck) && empty($runStatusCheck))) {
            unset($this->RunStatusCheck);
        } else {
            $this->RunStatusCheck = $runStatusCheck;
        }
        return $this;
    }
    /**
     * Get SendSmsIfShortFail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSendSmsIfShortFail()
    {
        return isset($this->SendSmsIfShortFail) ? $this->SendSmsIfShortFail : null;
    }
    /**
     * Set SendSmsIfShortFail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sendSmsIfShortFail
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setSendSmsIfShortFail($sendSmsIfShortFail = null)
    {
        // validation for constraint: string
        if (!is_null($sendSmsIfShortFail) && !is_string($sendSmsIfShortFail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendSmsIfShortFail, true), gettype($sendSmsIfShortFail)), __LINE__);
        }
        if (is_null($sendSmsIfShortFail) || (is_array($sendSmsIfShortFail) && empty($sendSmsIfShortFail))) {
            unset($this->SendSmsIfShortFail);
        } else {
            $this->SendSmsIfShortFail = $sendSmsIfShortFail;
        }
        return $this;
    }
    /**
     * Get SendTicketGroupBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSendTicketGroupBy()
    {
        return isset($this->SendTicketGroupBy) ? $this->SendTicketGroupBy : null;
    }
    /**
     * Set SendTicketGroupBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sendTicketGroupBy
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setSendTicketGroupBy($sendTicketGroupBy = null)
    {
        // validation for constraint: string
        if (!is_null($sendTicketGroupBy) && !is_string($sendTicketGroupBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendTicketGroupBy, true), gettype($sendTicketGroupBy)), __LINE__);
        }
        if (is_null($sendTicketGroupBy) || (is_array($sendTicketGroupBy) && empty($sendTicketGroupBy))) {
            unset($this->SendTicketGroupBy);
        } else {
            $this->SendTicketGroupBy = $sendTicketGroupBy;
        }
        return $this;
    }
    /**
     * Get ShowBarcodeAfterEventEndedInDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShowBarcodeAfterEventEndedInDays()
    {
        return isset($this->ShowBarcodeAfterEventEndedInDays) ? $this->ShowBarcodeAfterEventEndedInDays : null;
    }
    /**
     * Set ShowBarcodeAfterEventEndedInDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $showBarcodeAfterEventEndedInDays
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setShowBarcodeAfterEventEndedInDays($showBarcodeAfterEventEndedInDays = null)
    {
        // validation for constraint: int
        if (!is_null($showBarcodeAfterEventEndedInDays) && !(is_int($showBarcodeAfterEventEndedInDays) || ctype_digit($showBarcodeAfterEventEndedInDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showBarcodeAfterEventEndedInDays, true), gettype($showBarcodeAfterEventEndedInDays)), __LINE__);
        }
        if (is_null($showBarcodeAfterEventEndedInDays) || (is_array($showBarcodeAfterEventEndedInDays) && empty($showBarcodeAfterEventEndedInDays))) {
            unset($this->ShowBarcodeAfterEventEndedInDays);
        } else {
            $this->ShowBarcodeAfterEventEndedInDays = $showBarcodeAfterEventEndedInDays;
        }
        return $this;
    }
    /**
     * Get SignatureSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSignatureSize()
    {
        return isset($this->SignatureSize) ? $this->SignatureSize : null;
    }
    /**
     * Set SignatureSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $signatureSize
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setSignatureSize($signatureSize = null)
    {
        // validation for constraint: int
        if (!is_null($signatureSize) && !(is_int($signatureSize) || ctype_digit($signatureSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($signatureSize, true), gettype($signatureSize)), __LINE__);
        }
        if (is_null($signatureSize) || (is_array($signatureSize) && empty($signatureSize))) {
            unset($this->SignatureSize);
        } else {
            $this->SignatureSize = $signatureSize;
        }
        return $this;
    }
    /**
     * Get SimpleSMSPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSimpleSMSPassword()
    {
        return isset($this->SimpleSMSPassword) ? $this->SimpleSMSPassword : null;
    }
    /**
     * Set SimpleSMSPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $simpleSMSPassword
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setSimpleSMSPassword($simpleSMSPassword = null)
    {
        // validation for constraint: string
        if (!is_null($simpleSMSPassword) && !is_string($simpleSMSPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($simpleSMSPassword, true), gettype($simpleSMSPassword)), __LINE__);
        }
        if (is_null($simpleSMSPassword) || (is_array($simpleSMSPassword) && empty($simpleSMSPassword))) {
            unset($this->SimpleSMSPassword);
        } else {
            $this->SimpleSMSPassword = $simpleSMSPassword;
        }
        return $this;
    }
    /**
     * Get SimpleSMSSenderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSimpleSMSSenderName()
    {
        return isset($this->SimpleSMSSenderName) ? $this->SimpleSMSSenderName : null;
    }
    /**
     * Set SimpleSMSSenderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $simpleSMSSenderName
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setSimpleSMSSenderName($simpleSMSSenderName = null)
    {
        // validation for constraint: string
        if (!is_null($simpleSMSSenderName) && !is_string($simpleSMSSenderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($simpleSMSSenderName, true), gettype($simpleSMSSenderName)), __LINE__);
        }
        if (is_null($simpleSMSSenderName) || (is_array($simpleSMSSenderName) && empty($simpleSMSSenderName))) {
            unset($this->SimpleSMSSenderName);
        } else {
            $this->SimpleSMSSenderName = $simpleSMSSenderName;
        }
        return $this;
    }
    /**
     * Get SimpleSMSUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSimpleSMSUser()
    {
        return isset($this->SimpleSMSUser) ? $this->SimpleSMSUser : null;
    }
    /**
     * Set SimpleSMSUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $simpleSMSUser
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setSimpleSMSUser($simpleSMSUser = null)
    {
        // validation for constraint: string
        if (!is_null($simpleSMSUser) && !is_string($simpleSMSUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($simpleSMSUser, true), gettype($simpleSMSUser)), __LINE__);
        }
        if (is_null($simpleSMSUser) || (is_array($simpleSMSUser) && empty($simpleSMSUser))) {
            unset($this->SimpleSMSUser);
        } else {
            $this->SimpleSMSUser = $simpleSMSUser;
        }
        return $this;
    }
    /**
     * Get SMSProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSMSProvider()
    {
        return isset($this->SMSProvider) ? $this->SMSProvider : null;
    }
    /**
     * Set SMSProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sMSProvider
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setSMSProvider($sMSProvider = null)
    {
        // validation for constraint: string
        if (!is_null($sMSProvider) && !is_string($sMSProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sMSProvider, true), gettype($sMSProvider)), __LINE__);
        }
        if (is_null($sMSProvider) || (is_array($sMSProvider) && empty($sMSProvider))) {
            unset($this->SMSProvider);
        } else {
            $this->SMSProvider = $sMSProvider;
        }
        return $this;
    }
    /**
     * Get TurnOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTurnOn()
    {
        return isset($this->TurnOn) ? $this->TurnOn : null;
    }
    /**
     * Set TurnOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $turnOn
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setTurnOn($turnOn = null)
    {
        // validation for constraint: boolean
        if (!is_null($turnOn) && !is_bool($turnOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($turnOn, true), gettype($turnOn)), __LINE__);
        }
        if (is_null($turnOn) || (is_array($turnOn) && empty($turnOn))) {
            unset($this->TurnOn);
        } else {
            $this->TurnOn = $turnOn;
        }
        return $this;
    }
    /**
     * Get URLPattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getURLPattern()
    {
        return isset($this->URLPattern) ? $this->URLPattern : null;
    }
    /**
     * Set URLPattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uRLPattern
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setURLPattern($uRLPattern = null)
    {
        // validation for constraint: string
        if (!is_null($uRLPattern) && !is_string($uRLPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRLPattern, true), gettype($uRLPattern)), __LINE__);
        }
        if (is_null($uRLPattern) || (is_array($uRLPattern) && empty($uRLPattern))) {
            unset($this->URLPattern);
        } else {
            $this->URLPattern = $uRLPattern;
        }
        return $this;
    }
    /**
     * Get URLTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getURLTemplate()
    {
        return isset($this->URLTemplate) ? $this->URLTemplate : null;
    }
    /**
     * Set URLTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uRLTemplate
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setURLTemplate($uRLTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($uRLTemplate) && !is_string($uRLTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRLTemplate, true), gettype($uRLTemplate)), __LINE__);
        }
        if (is_null($uRLTemplate) || (is_array($uRLTemplate) && empty($uRLTemplate))) {
            unset($this->URLTemplate);
        } else {
            $this->URLTemplate = $uRLTemplate;
        }
        return $this;
    }
    /**
     * Get VenueNamePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVenueNamePrefix()
    {
        return isset($this->VenueNamePrefix) ? $this->VenueNamePrefix : null;
    }
    /**
     * Set VenueNamePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $venueNamePrefix
     * @return \patest\StructType\Security_SMSCollectionParameters
     */
    public function setVenueNamePrefix($venueNamePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($venueNamePrefix) && !is_string($venueNamePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueNamePrefix, true), gettype($venueNamePrefix)), __LINE__);
        }
        if (is_null($venueNamePrefix) || (is_array($venueNamePrefix) && empty($venueNamePrefix))) {
            unset($this->VenueNamePrefix);
        } else {
            $this->VenueNamePrefix = $venueNamePrefix;
        }
        return $this;
    }
}
