<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.OposCardReaderParameters StructType
 * @subpackage Structs
 */
class Security_OposCardReaderParameters extends Security_SalePointParametersBase
{
    /**
     * The DeviceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceName;
    /**
     * Constructor method for Security.OposCardReaderParameters
     * @uses Security_OposCardReaderParameters::setDeviceName()
     * @param string $deviceName
     */
    public function __construct($deviceName = null)
    {
        $this
            ->setDeviceName($deviceName);
    }
    /**
     * Get DeviceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceName()
    {
        return isset($this->DeviceName) ? $this->DeviceName : null;
    }
    /**
     * Set DeviceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceName
     * @return \patest\StructType\Security_OposCardReaderParameters
     */
    public function setDeviceName($deviceName = null)
    {
        // validation for constraint: string
        if (!is_null($deviceName) && !is_string($deviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceName, true), gettype($deviceName)), __LINE__);
        }
        if (is_null($deviceName) || (is_array($deviceName) && empty($deviceName))) {
            unset($this->DeviceName);
        } else {
            $this->DeviceName = $deviceName;
        }
        return $this;
    }
}
