<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.HelpDeskCompanyParameters StructType
 * @subpackage Structs
 */
class Security_HelpDeskCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AllowedBookingRequestTypesInEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllowedBookingRequestTypesInEvents;
    /**
     * The AllowedBookingRequestTypesInSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllowedBookingRequestTypesInSeries;
    /**
     * Constructor method for Security.HelpDeskCompanyParameters
     * @uses Security_HelpDeskCompanyParameters::setAllowedBookingRequestTypesInEvents()
     * @uses Security_HelpDeskCompanyParameters::setAllowedBookingRequestTypesInSeries()
     * @param string $allowedBookingRequestTypesInEvents
     * @param string $allowedBookingRequestTypesInSeries
     */
    public function __construct($allowedBookingRequestTypesInEvents = null, $allowedBookingRequestTypesInSeries = null)
    {
        $this
            ->setAllowedBookingRequestTypesInEvents($allowedBookingRequestTypesInEvents)
            ->setAllowedBookingRequestTypesInSeries($allowedBookingRequestTypesInSeries);
    }
    /**
     * Get AllowedBookingRequestTypesInEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllowedBookingRequestTypesInEvents()
    {
        return isset($this->AllowedBookingRequestTypesInEvents) ? $this->AllowedBookingRequestTypesInEvents : null;
    }
    /**
     * Set AllowedBookingRequestTypesInEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allowedBookingRequestTypesInEvents
     * @return \patest\StructType\Security_HelpDeskCompanyParameters
     */
    public function setAllowedBookingRequestTypesInEvents($allowedBookingRequestTypesInEvents = null)
    {
        // validation for constraint: string
        if (!is_null($allowedBookingRequestTypesInEvents) && !is_string($allowedBookingRequestTypesInEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowedBookingRequestTypesInEvents, true), gettype($allowedBookingRequestTypesInEvents)), __LINE__);
        }
        if (is_null($allowedBookingRequestTypesInEvents) || (is_array($allowedBookingRequestTypesInEvents) && empty($allowedBookingRequestTypesInEvents))) {
            unset($this->AllowedBookingRequestTypesInEvents);
        } else {
            $this->AllowedBookingRequestTypesInEvents = $allowedBookingRequestTypesInEvents;
        }
        return $this;
    }
    /**
     * Get AllowedBookingRequestTypesInSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllowedBookingRequestTypesInSeries()
    {
        return isset($this->AllowedBookingRequestTypesInSeries) ? $this->AllowedBookingRequestTypesInSeries : null;
    }
    /**
     * Set AllowedBookingRequestTypesInSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allowedBookingRequestTypesInSeries
     * @return \patest\StructType\Security_HelpDeskCompanyParameters
     */
    public function setAllowedBookingRequestTypesInSeries($allowedBookingRequestTypesInSeries = null)
    {
        // validation for constraint: string
        if (!is_null($allowedBookingRequestTypesInSeries) && !is_string($allowedBookingRequestTypesInSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowedBookingRequestTypesInSeries, true), gettype($allowedBookingRequestTypesInSeries)), __LINE__);
        }
        if (is_null($allowedBookingRequestTypesInSeries) || (is_array($allowedBookingRequestTypesInSeries) && empty($allowedBookingRequestTypesInSeries))) {
            unset($this->AllowedBookingRequestTypesInSeries);
        } else {
            $this->AllowedBookingRequestTypesInSeries = $allowedBookingRequestTypesInSeries;
        }
        return $this;
    }
}
