<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.CurrentOrganizationUnit StructType
 * @subpackage Structs
 */
class Security_CurrentOrganizationUnit extends Security_OrganizationUnit
{
    /**
     * The AccountAcquirerFullName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountAcquirerFullName;
    /**
     * The AccountManagerFullName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountManagerFullName;
    /**
     * The BillingItems
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSecurity_OrganizationUnitBillingItem
     */
    public $BillingItems;
    /**
     * The IsPACompanyGlobalNumberPerOrganizationUnit
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPACompanyGlobalNumberPerOrganizationUnit;
    /**
     * The MasterOrgUnitLocalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MasterOrgUnitLocalId;
    /**
     * The MasterOrgUnitName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterOrgUnitName;
    /**
     * The PACompanyGlobalNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PACompanyGlobalNumber;
    /**
     * The ParentOrgUnitLocalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ParentOrgUnitLocalId;
    /**
     * The ParentOrgUnitName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParentOrgUnitName;
    /**
     * The TotalMyUsers
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalMyUsers;
    /**
     * The TotalMyUsersWithSubordinates
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalMyUsersWithSubordinates;
    /**
     * Constructor method for Security.CurrentOrganizationUnit
     * @uses Security_CurrentOrganizationUnit::setAccountAcquirerFullName()
     * @uses Security_CurrentOrganizationUnit::setAccountManagerFullName()
     * @uses Security_CurrentOrganizationUnit::setBillingItems()
     * @uses Security_CurrentOrganizationUnit::setIsPACompanyGlobalNumberPerOrganizationUnit()
     * @uses Security_CurrentOrganizationUnit::setMasterOrgUnitLocalId()
     * @uses Security_CurrentOrganizationUnit::setMasterOrgUnitName()
     * @uses Security_CurrentOrganizationUnit::setPACompanyGlobalNumber()
     * @uses Security_CurrentOrganizationUnit::setParentOrgUnitLocalId()
     * @uses Security_CurrentOrganizationUnit::setParentOrgUnitName()
     * @uses Security_CurrentOrganizationUnit::setTotalMyUsers()
     * @uses Security_CurrentOrganizationUnit::setTotalMyUsersWithSubordinates()
     * @param string $accountAcquirerFullName
     * @param string $accountManagerFullName
     * @param \patest\StructType\RecordSetOfSecurity_OrganizationUnitBillingItem $billingItems
     * @param bool $isPACompanyGlobalNumberPerOrganizationUnit
     * @param int $masterOrgUnitLocalId
     * @param string $masterOrgUnitName
     * @param int $pACompanyGlobalNumber
     * @param int $parentOrgUnitLocalId
     * @param string $parentOrgUnitName
     * @param int $totalMyUsers
     * @param int $totalMyUsersWithSubordinates
     */
    public function __construct($accountAcquirerFullName = null, $accountManagerFullName = null, \patest\StructType\RecordSetOfSecurity_OrganizationUnitBillingItem $billingItems = null, $isPACompanyGlobalNumberPerOrganizationUnit = null, $masterOrgUnitLocalId = null, $masterOrgUnitName = null, $pACompanyGlobalNumber = null, $parentOrgUnitLocalId = null, $parentOrgUnitName = null, $totalMyUsers = null, $totalMyUsersWithSubordinates = null)
    {
        $this
            ->setAccountAcquirerFullName($accountAcquirerFullName)
            ->setAccountManagerFullName($accountManagerFullName)
            ->setBillingItems($billingItems)
            ->setIsPACompanyGlobalNumberPerOrganizationUnit($isPACompanyGlobalNumberPerOrganizationUnit)
            ->setMasterOrgUnitLocalId($masterOrgUnitLocalId)
            ->setMasterOrgUnitName($masterOrgUnitName)
            ->setPACompanyGlobalNumber($pACompanyGlobalNumber)
            ->setParentOrgUnitLocalId($parentOrgUnitLocalId)
            ->setParentOrgUnitName($parentOrgUnitName)
            ->setTotalMyUsers($totalMyUsers)
            ->setTotalMyUsersWithSubordinates($totalMyUsersWithSubordinates);
    }
    /**
     * Get AccountAcquirerFullName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountAcquirerFullName()
    {
        return isset($this->AccountAcquirerFullName) ? $this->AccountAcquirerFullName : null;
    }
    /**
     * Set AccountAcquirerFullName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountAcquirerFullName
     * @return \patest\StructType\Security_CurrentOrganizationUnit
     */
    public function setAccountAcquirerFullName($accountAcquirerFullName = null)
    {
        // validation for constraint: string
        if (!is_null($accountAcquirerFullName) && !is_string($accountAcquirerFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountAcquirerFullName, true), gettype($accountAcquirerFullName)), __LINE__);
        }
        if (is_null($accountAcquirerFullName) || (is_array($accountAcquirerFullName) && empty($accountAcquirerFullName))) {
            unset($this->AccountAcquirerFullName);
        } else {
            $this->AccountAcquirerFullName = $accountAcquirerFullName;
        }
        return $this;
    }
    /**
     * Get AccountManagerFullName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountManagerFullName()
    {
        return isset($this->AccountManagerFullName) ? $this->AccountManagerFullName : null;
    }
    /**
     * Set AccountManagerFullName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountManagerFullName
     * @return \patest\StructType\Security_CurrentOrganizationUnit
     */
    public function setAccountManagerFullName($accountManagerFullName = null)
    {
        // validation for constraint: string
        if (!is_null($accountManagerFullName) && !is_string($accountManagerFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountManagerFullName, true), gettype($accountManagerFullName)), __LINE__);
        }
        if (is_null($accountManagerFullName) || (is_array($accountManagerFullName) && empty($accountManagerFullName))) {
            unset($this->AccountManagerFullName);
        } else {
            $this->AccountManagerFullName = $accountManagerFullName;
        }
        return $this;
    }
    /**
     * Get BillingItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSecurity_OrganizationUnitBillingItem|null
     */
    public function getBillingItems()
    {
        return isset($this->BillingItems) ? $this->BillingItems : null;
    }
    /**
     * Set BillingItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSecurity_OrganizationUnitBillingItem $billingItems
     * @return \patest\StructType\Security_CurrentOrganizationUnit
     */
    public function setBillingItems(\patest\StructType\RecordSetOfSecurity_OrganizationUnitBillingItem $billingItems = null)
    {
        if (is_null($billingItems) || (is_array($billingItems) && empty($billingItems))) {
            unset($this->BillingItems);
        } else {
            $this->BillingItems = $billingItems;
        }
        return $this;
    }
    /**
     * Get IsPACompanyGlobalNumberPerOrganizationUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPACompanyGlobalNumberPerOrganizationUnit()
    {
        return isset($this->IsPACompanyGlobalNumberPerOrganizationUnit) ? $this->IsPACompanyGlobalNumberPerOrganizationUnit : null;
    }
    /**
     * Set IsPACompanyGlobalNumberPerOrganizationUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPACompanyGlobalNumberPerOrganizationUnit
     * @return \patest\StructType\Security_CurrentOrganizationUnit
     */
    public function setIsPACompanyGlobalNumberPerOrganizationUnit($isPACompanyGlobalNumberPerOrganizationUnit = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPACompanyGlobalNumberPerOrganizationUnit) && !is_bool($isPACompanyGlobalNumberPerOrganizationUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPACompanyGlobalNumberPerOrganizationUnit, true), gettype($isPACompanyGlobalNumberPerOrganizationUnit)), __LINE__);
        }
        if (is_null($isPACompanyGlobalNumberPerOrganizationUnit) || (is_array($isPACompanyGlobalNumberPerOrganizationUnit) && empty($isPACompanyGlobalNumberPerOrganizationUnit))) {
            unset($this->IsPACompanyGlobalNumberPerOrganizationUnit);
        } else {
            $this->IsPACompanyGlobalNumberPerOrganizationUnit = $isPACompanyGlobalNumberPerOrganizationUnit;
        }
        return $this;
    }
    /**
     * Get MasterOrgUnitLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMasterOrgUnitLocalId()
    {
        return isset($this->MasterOrgUnitLocalId) ? $this->MasterOrgUnitLocalId : null;
    }
    /**
     * Set MasterOrgUnitLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $masterOrgUnitLocalId
     * @return \patest\StructType\Security_CurrentOrganizationUnit
     */
    public function setMasterOrgUnitLocalId($masterOrgUnitLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($masterOrgUnitLocalId) && !(is_int($masterOrgUnitLocalId) || ctype_digit($masterOrgUnitLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($masterOrgUnitLocalId, true), gettype($masterOrgUnitLocalId)), __LINE__);
        }
        if (is_null($masterOrgUnitLocalId) || (is_array($masterOrgUnitLocalId) && empty($masterOrgUnitLocalId))) {
            unset($this->MasterOrgUnitLocalId);
        } else {
            $this->MasterOrgUnitLocalId = $masterOrgUnitLocalId;
        }
        return $this;
    }
    /**
     * Get MasterOrgUnitName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterOrgUnitName()
    {
        return isset($this->MasterOrgUnitName) ? $this->MasterOrgUnitName : null;
    }
    /**
     * Set MasterOrgUnitName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterOrgUnitName
     * @return \patest\StructType\Security_CurrentOrganizationUnit
     */
    public function setMasterOrgUnitName($masterOrgUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($masterOrgUnitName) && !is_string($masterOrgUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterOrgUnitName, true), gettype($masterOrgUnitName)), __LINE__);
        }
        if (is_null($masterOrgUnitName) || (is_array($masterOrgUnitName) && empty($masterOrgUnitName))) {
            unset($this->MasterOrgUnitName);
        } else {
            $this->MasterOrgUnitName = $masterOrgUnitName;
        }
        return $this;
    }
    /**
     * Get PACompanyGlobalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPACompanyGlobalNumber()
    {
        return isset($this->PACompanyGlobalNumber) ? $this->PACompanyGlobalNumber : null;
    }
    /**
     * Set PACompanyGlobalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pACompanyGlobalNumber
     * @return \patest\StructType\Security_CurrentOrganizationUnit
     */
    public function setPACompanyGlobalNumber($pACompanyGlobalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pACompanyGlobalNumber) && !(is_int($pACompanyGlobalNumber) || ctype_digit($pACompanyGlobalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pACompanyGlobalNumber, true), gettype($pACompanyGlobalNumber)), __LINE__);
        }
        if (is_null($pACompanyGlobalNumber) || (is_array($pACompanyGlobalNumber) && empty($pACompanyGlobalNumber))) {
            unset($this->PACompanyGlobalNumber);
        } else {
            $this->PACompanyGlobalNumber = $pACompanyGlobalNumber;
        }
        return $this;
    }
    /**
     * Get ParentOrgUnitLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getParentOrgUnitLocalId()
    {
        return isset($this->ParentOrgUnitLocalId) ? $this->ParentOrgUnitLocalId : null;
    }
    /**
     * Set ParentOrgUnitLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $parentOrgUnitLocalId
     * @return \patest\StructType\Security_CurrentOrganizationUnit
     */
    public function setParentOrgUnitLocalId($parentOrgUnitLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($parentOrgUnitLocalId) && !(is_int($parentOrgUnitLocalId) || ctype_digit($parentOrgUnitLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentOrgUnitLocalId, true), gettype($parentOrgUnitLocalId)), __LINE__);
        }
        if (is_null($parentOrgUnitLocalId) || (is_array($parentOrgUnitLocalId) && empty($parentOrgUnitLocalId))) {
            unset($this->ParentOrgUnitLocalId);
        } else {
            $this->ParentOrgUnitLocalId = $parentOrgUnitLocalId;
        }
        return $this;
    }
    /**
     * Get ParentOrgUnitName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentOrgUnitName()
    {
        return isset($this->ParentOrgUnitName) ? $this->ParentOrgUnitName : null;
    }
    /**
     * Set ParentOrgUnitName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentOrgUnitName
     * @return \patest\StructType\Security_CurrentOrganizationUnit
     */
    public function setParentOrgUnitName($parentOrgUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($parentOrgUnitName) && !is_string($parentOrgUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentOrgUnitName, true), gettype($parentOrgUnitName)), __LINE__);
        }
        if (is_null($parentOrgUnitName) || (is_array($parentOrgUnitName) && empty($parentOrgUnitName))) {
            unset($this->ParentOrgUnitName);
        } else {
            $this->ParentOrgUnitName = $parentOrgUnitName;
        }
        return $this;
    }
    /**
     * Get TotalMyUsers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalMyUsers()
    {
        return isset($this->TotalMyUsers) ? $this->TotalMyUsers : null;
    }
    /**
     * Set TotalMyUsers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalMyUsers
     * @return \patest\StructType\Security_CurrentOrganizationUnit
     */
    public function setTotalMyUsers($totalMyUsers = null)
    {
        // validation for constraint: int
        if (!is_null($totalMyUsers) && !(is_int($totalMyUsers) || ctype_digit($totalMyUsers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalMyUsers, true), gettype($totalMyUsers)), __LINE__);
        }
        if (is_null($totalMyUsers) || (is_array($totalMyUsers) && empty($totalMyUsers))) {
            unset($this->TotalMyUsers);
        } else {
            $this->TotalMyUsers = $totalMyUsers;
        }
        return $this;
    }
    /**
     * Get TotalMyUsersWithSubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalMyUsersWithSubordinates()
    {
        return isset($this->TotalMyUsersWithSubordinates) ? $this->TotalMyUsersWithSubordinates : null;
    }
    /**
     * Set TotalMyUsersWithSubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalMyUsersWithSubordinates
     * @return \patest\StructType\Security_CurrentOrganizationUnit
     */
    public function setTotalMyUsersWithSubordinates($totalMyUsersWithSubordinates = null)
    {
        // validation for constraint: int
        if (!is_null($totalMyUsersWithSubordinates) && !(is_int($totalMyUsersWithSubordinates) || ctype_digit($totalMyUsersWithSubordinates))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalMyUsersWithSubordinates, true), gettype($totalMyUsersWithSubordinates)), __LINE__);
        }
        if (is_null($totalMyUsersWithSubordinates) || (is_array($totalMyUsersWithSubordinates) && empty($totalMyUsersWithSubordinates))) {
            unset($this->TotalMyUsersWithSubordinates);
        } else {
            $this->TotalMyUsersWithSubordinates = $totalMyUsersWithSubordinates;
        }
        return $this;
    }
}
