<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.CompanyParameterBase StructType
 * @subpackage Structs
 */
class Security_CompanyParameterBase extends AnyEntity
{
    /**
     * The AccessPermissions
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccessPermissions;
    /**
     * The Level
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Level;
    /**
     * Constructor method for Security.CompanyParameterBase
     * @uses Security_CompanyParameterBase::setAccessPermissions()
     * @uses Security_CompanyParameterBase::setLevel()
     * @param string[] $accessPermissions
     * @param string $level
     */
    public function __construct(array $accessPermissions = array(), $level = null)
    {
        $this
            ->setAccessPermissions($accessPermissions)
            ->setLevel($level);
    }
    /**
     * Get AccessPermissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccessPermissions()
    {
        return isset($this->AccessPermissions) ? $this->AccessPermissions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessPermissions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessPermissions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $security_CompanyParameterBaseAccessPermissionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EntityAccessPermission::valueIsValid($security_CompanyParameterBaseAccessPermissionsItem)) {
                $invalidValues[] = is_object($security_CompanyParameterBaseAccessPermissionsItem) ? get_class($security_CompanyParameterBaseAccessPermissionsItem) : sprintf('%s(%s)', gettype($security_CompanyParameterBaseAccessPermissionsItem), var_export($security_CompanyParameterBaseAccessPermissionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EntityAccessPermission', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EntityAccessPermission::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccessPermissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EntityAccessPermission::valueIsValid()
     * @uses \patest\EnumType\EntityAccessPermission::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accessPermissions
     * @return \patest\StructType\Security_CompanyParameterBase
     */
    public function setAccessPermissions(array $accessPermissions = array())
    {
        // validation for constraint: list
        if ('' !== ($accessPermissionsArrayErrorMessage = self::validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions($accessPermissions))) {
            throw new \InvalidArgumentException($accessPermissionsArrayErrorMessage, __LINE__);
        }
        if (is_null($accessPermissions) || (is_array($accessPermissions) && empty($accessPermissions))) {
            unset($this->AccessPermissions);
        } else {
            $this->AccessPermissions = is_array($accessPermissions) ? implode(' ', $accessPermissions) : null;
        }
        return $this;
    }
    /**
     * Get Level value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLevel()
    {
        return isset($this->Level) ? $this->Level : null;
    }
    /**
     * Set Level value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ParameterNodeType::valueIsValid()
     * @uses \patest\EnumType\ParameterNodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $level
     * @return \patest\StructType\Security_CompanyParameterBase
     */
    public function setLevel($level = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ParameterNodeType::valueIsValid($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ParameterNodeType', is_array($level) ? implode(', ', $level) : var_export($level, true), implode(', ', \patest\EnumType\ParameterNodeType::getValidValues())), __LINE__);
        }
        if (is_null($level) || (is_array($level) && empty($level))) {
            unset($this->Level);
        } else {
            $this->Level = $level;
        }
        return $this;
    }
}
