<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.BulkOperationsCompanyParameters StructType
 * @subpackage Structs
 */
class Security_BulkOperationsCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AllowPartialTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowPartialTransaction;
    /**
     * The PrintTransactionConfirmationLetter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintTransactionConfirmationLetter;
    /**
     * Constructor method for Security.BulkOperationsCompanyParameters
     * @uses Security_BulkOperationsCompanyParameters::setAllowPartialTransaction()
     * @uses Security_BulkOperationsCompanyParameters::setPrintTransactionConfirmationLetter()
     * @param bool $allowPartialTransaction
     * @param bool $printTransactionConfirmationLetter
     */
    public function __construct($allowPartialTransaction = null, $printTransactionConfirmationLetter = null)
    {
        $this
            ->setAllowPartialTransaction($allowPartialTransaction)
            ->setPrintTransactionConfirmationLetter($printTransactionConfirmationLetter);
    }
    /**
     * Get AllowPartialTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowPartialTransaction()
    {
        return isset($this->AllowPartialTransaction) ? $this->AllowPartialTransaction : null;
    }
    /**
     * Set AllowPartialTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowPartialTransaction
     * @return \patest\StructType\Security_BulkOperationsCompanyParameters
     */
    public function setAllowPartialTransaction($allowPartialTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPartialTransaction) && !is_bool($allowPartialTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowPartialTransaction, true), gettype($allowPartialTransaction)), __LINE__);
        }
        if (is_null($allowPartialTransaction) || (is_array($allowPartialTransaction) && empty($allowPartialTransaction))) {
            unset($this->AllowPartialTransaction);
        } else {
            $this->AllowPartialTransaction = $allowPartialTransaction;
        }
        return $this;
    }
    /**
     * Get PrintTransactionConfirmationLetter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintTransactionConfirmationLetter()
    {
        return isset($this->PrintTransactionConfirmationLetter) ? $this->PrintTransactionConfirmationLetter : null;
    }
    /**
     * Set PrintTransactionConfirmationLetter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printTransactionConfirmationLetter
     * @return \patest\StructType\Security_BulkOperationsCompanyParameters
     */
    public function setPrintTransactionConfirmationLetter($printTransactionConfirmationLetter = null)
    {
        // validation for constraint: boolean
        if (!is_null($printTransactionConfirmationLetter) && !is_bool($printTransactionConfirmationLetter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printTransactionConfirmationLetter, true), gettype($printTransactionConfirmationLetter)), __LINE__);
        }
        if (is_null($printTransactionConfirmationLetter) || (is_array($printTransactionConfirmationLetter) && empty($printTransactionConfirmationLetter))) {
            unset($this->PrintTransactionConfirmationLetter);
        } else {
            $this->PrintTransactionConfirmationLetter = $printTransactionConfirmationLetter;
        }
        return $this;
    }
}
