<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.BatchEntryCompanyParameters StructType
 * @subpackage Structs
 */
class Security_BatchEntryCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The BatchEntryDefaultAppeal
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchEntryDefaultAppeal;
    /**
     * The BatchEntryDefaultCampaign
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchEntryDefaultCampaign;
    /**
     * The BatchEntryDefaultDonation
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchEntryDefaultDonation;
    /**
     * The BatchEntryDefaultFund
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchEntryDefaultFund;
    /**
     * The BatchEntryDefaultMembership
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchEntryDefaultMembership;
    /**
     * The BatchEntryDefaultPaymentMethodCash
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchEntryDefaultPaymentMethodCash;
    /**
     * The BatchEntryDefaultPaymentMethodCheque
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchEntryDefaultPaymentMethodCheque;
    /**
     * The BatchEntryDefaultPriceTypeMemberships
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchEntryDefaultPriceTypeMemberships;
    /**
     * Constructor method for Security.BatchEntryCompanyParameters
     * @uses Security_BatchEntryCompanyParameters::setBatchEntryDefaultAppeal()
     * @uses Security_BatchEntryCompanyParameters::setBatchEntryDefaultCampaign()
     * @uses Security_BatchEntryCompanyParameters::setBatchEntryDefaultDonation()
     * @uses Security_BatchEntryCompanyParameters::setBatchEntryDefaultFund()
     * @uses Security_BatchEntryCompanyParameters::setBatchEntryDefaultMembership()
     * @uses Security_BatchEntryCompanyParameters::setBatchEntryDefaultPaymentMethodCash()
     * @uses Security_BatchEntryCompanyParameters::setBatchEntryDefaultPaymentMethodCheque()
     * @uses Security_BatchEntryCompanyParameters::setBatchEntryDefaultPriceTypeMemberships()
     * @param string $batchEntryDefaultAppeal
     * @param string $batchEntryDefaultCampaign
     * @param string $batchEntryDefaultDonation
     * @param string $batchEntryDefaultFund
     * @param string $batchEntryDefaultMembership
     * @param string $batchEntryDefaultPaymentMethodCash
     * @param string $batchEntryDefaultPaymentMethodCheque
     * @param string $batchEntryDefaultPriceTypeMemberships
     */
    public function __construct($batchEntryDefaultAppeal = null, $batchEntryDefaultCampaign = null, $batchEntryDefaultDonation = null, $batchEntryDefaultFund = null, $batchEntryDefaultMembership = null, $batchEntryDefaultPaymentMethodCash = null, $batchEntryDefaultPaymentMethodCheque = null, $batchEntryDefaultPriceTypeMemberships = null)
    {
        $this
            ->setBatchEntryDefaultAppeal($batchEntryDefaultAppeal)
            ->setBatchEntryDefaultCampaign($batchEntryDefaultCampaign)
            ->setBatchEntryDefaultDonation($batchEntryDefaultDonation)
            ->setBatchEntryDefaultFund($batchEntryDefaultFund)
            ->setBatchEntryDefaultMembership($batchEntryDefaultMembership)
            ->setBatchEntryDefaultPaymentMethodCash($batchEntryDefaultPaymentMethodCash)
            ->setBatchEntryDefaultPaymentMethodCheque($batchEntryDefaultPaymentMethodCheque)
            ->setBatchEntryDefaultPriceTypeMemberships($batchEntryDefaultPriceTypeMemberships);
    }
    /**
     * Get BatchEntryDefaultAppeal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchEntryDefaultAppeal()
    {
        return isset($this->BatchEntryDefaultAppeal) ? $this->BatchEntryDefaultAppeal : null;
    }
    /**
     * Set BatchEntryDefaultAppeal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchEntryDefaultAppeal
     * @return \patest\StructType\Security_BatchEntryCompanyParameters
     */
    public function setBatchEntryDefaultAppeal($batchEntryDefaultAppeal = null)
    {
        // validation for constraint: string
        if (!is_null($batchEntryDefaultAppeal) && !is_string($batchEntryDefaultAppeal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchEntryDefaultAppeal, true), gettype($batchEntryDefaultAppeal)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchEntryDefaultAppeal) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchEntryDefaultAppeal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchEntryDefaultAppeal, true)), __LINE__);
        }
        if (is_null($batchEntryDefaultAppeal) || (is_array($batchEntryDefaultAppeal) && empty($batchEntryDefaultAppeal))) {
            unset($this->BatchEntryDefaultAppeal);
        } else {
            $this->BatchEntryDefaultAppeal = $batchEntryDefaultAppeal;
        }
        return $this;
    }
    /**
     * Get BatchEntryDefaultCampaign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchEntryDefaultCampaign()
    {
        return isset($this->BatchEntryDefaultCampaign) ? $this->BatchEntryDefaultCampaign : null;
    }
    /**
     * Set BatchEntryDefaultCampaign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchEntryDefaultCampaign
     * @return \patest\StructType\Security_BatchEntryCompanyParameters
     */
    public function setBatchEntryDefaultCampaign($batchEntryDefaultCampaign = null)
    {
        // validation for constraint: string
        if (!is_null($batchEntryDefaultCampaign) && !is_string($batchEntryDefaultCampaign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchEntryDefaultCampaign, true), gettype($batchEntryDefaultCampaign)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchEntryDefaultCampaign) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchEntryDefaultCampaign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchEntryDefaultCampaign, true)), __LINE__);
        }
        if (is_null($batchEntryDefaultCampaign) || (is_array($batchEntryDefaultCampaign) && empty($batchEntryDefaultCampaign))) {
            unset($this->BatchEntryDefaultCampaign);
        } else {
            $this->BatchEntryDefaultCampaign = $batchEntryDefaultCampaign;
        }
        return $this;
    }
    /**
     * Get BatchEntryDefaultDonation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchEntryDefaultDonation()
    {
        return isset($this->BatchEntryDefaultDonation) ? $this->BatchEntryDefaultDonation : null;
    }
    /**
     * Set BatchEntryDefaultDonation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchEntryDefaultDonation
     * @return \patest\StructType\Security_BatchEntryCompanyParameters
     */
    public function setBatchEntryDefaultDonation($batchEntryDefaultDonation = null)
    {
        // validation for constraint: string
        if (!is_null($batchEntryDefaultDonation) && !is_string($batchEntryDefaultDonation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchEntryDefaultDonation, true), gettype($batchEntryDefaultDonation)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchEntryDefaultDonation) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchEntryDefaultDonation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchEntryDefaultDonation, true)), __LINE__);
        }
        if (is_null($batchEntryDefaultDonation) || (is_array($batchEntryDefaultDonation) && empty($batchEntryDefaultDonation))) {
            unset($this->BatchEntryDefaultDonation);
        } else {
            $this->BatchEntryDefaultDonation = $batchEntryDefaultDonation;
        }
        return $this;
    }
    /**
     * Get BatchEntryDefaultFund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchEntryDefaultFund()
    {
        return isset($this->BatchEntryDefaultFund) ? $this->BatchEntryDefaultFund : null;
    }
    /**
     * Set BatchEntryDefaultFund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchEntryDefaultFund
     * @return \patest\StructType\Security_BatchEntryCompanyParameters
     */
    public function setBatchEntryDefaultFund($batchEntryDefaultFund = null)
    {
        // validation for constraint: string
        if (!is_null($batchEntryDefaultFund) && !is_string($batchEntryDefaultFund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchEntryDefaultFund, true), gettype($batchEntryDefaultFund)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchEntryDefaultFund) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchEntryDefaultFund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchEntryDefaultFund, true)), __LINE__);
        }
        if (is_null($batchEntryDefaultFund) || (is_array($batchEntryDefaultFund) && empty($batchEntryDefaultFund))) {
            unset($this->BatchEntryDefaultFund);
        } else {
            $this->BatchEntryDefaultFund = $batchEntryDefaultFund;
        }
        return $this;
    }
    /**
     * Get BatchEntryDefaultMembership value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchEntryDefaultMembership()
    {
        return isset($this->BatchEntryDefaultMembership) ? $this->BatchEntryDefaultMembership : null;
    }
    /**
     * Set BatchEntryDefaultMembership value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchEntryDefaultMembership
     * @return \patest\StructType\Security_BatchEntryCompanyParameters
     */
    public function setBatchEntryDefaultMembership($batchEntryDefaultMembership = null)
    {
        // validation for constraint: string
        if (!is_null($batchEntryDefaultMembership) && !is_string($batchEntryDefaultMembership)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchEntryDefaultMembership, true), gettype($batchEntryDefaultMembership)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchEntryDefaultMembership) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchEntryDefaultMembership)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchEntryDefaultMembership, true)), __LINE__);
        }
        if (is_null($batchEntryDefaultMembership) || (is_array($batchEntryDefaultMembership) && empty($batchEntryDefaultMembership))) {
            unset($this->BatchEntryDefaultMembership);
        } else {
            $this->BatchEntryDefaultMembership = $batchEntryDefaultMembership;
        }
        return $this;
    }
    /**
     * Get BatchEntryDefaultPaymentMethodCash value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchEntryDefaultPaymentMethodCash()
    {
        return isset($this->BatchEntryDefaultPaymentMethodCash) ? $this->BatchEntryDefaultPaymentMethodCash : null;
    }
    /**
     * Set BatchEntryDefaultPaymentMethodCash value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchEntryDefaultPaymentMethodCash
     * @return \patest\StructType\Security_BatchEntryCompanyParameters
     */
    public function setBatchEntryDefaultPaymentMethodCash($batchEntryDefaultPaymentMethodCash = null)
    {
        // validation for constraint: string
        if (!is_null($batchEntryDefaultPaymentMethodCash) && !is_string($batchEntryDefaultPaymentMethodCash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchEntryDefaultPaymentMethodCash, true), gettype($batchEntryDefaultPaymentMethodCash)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchEntryDefaultPaymentMethodCash) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchEntryDefaultPaymentMethodCash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchEntryDefaultPaymentMethodCash, true)), __LINE__);
        }
        if (is_null($batchEntryDefaultPaymentMethodCash) || (is_array($batchEntryDefaultPaymentMethodCash) && empty($batchEntryDefaultPaymentMethodCash))) {
            unset($this->BatchEntryDefaultPaymentMethodCash);
        } else {
            $this->BatchEntryDefaultPaymentMethodCash = $batchEntryDefaultPaymentMethodCash;
        }
        return $this;
    }
    /**
     * Get BatchEntryDefaultPaymentMethodCheque value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchEntryDefaultPaymentMethodCheque()
    {
        return isset($this->BatchEntryDefaultPaymentMethodCheque) ? $this->BatchEntryDefaultPaymentMethodCheque : null;
    }
    /**
     * Set BatchEntryDefaultPaymentMethodCheque value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchEntryDefaultPaymentMethodCheque
     * @return \patest\StructType\Security_BatchEntryCompanyParameters
     */
    public function setBatchEntryDefaultPaymentMethodCheque($batchEntryDefaultPaymentMethodCheque = null)
    {
        // validation for constraint: string
        if (!is_null($batchEntryDefaultPaymentMethodCheque) && !is_string($batchEntryDefaultPaymentMethodCheque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchEntryDefaultPaymentMethodCheque, true), gettype($batchEntryDefaultPaymentMethodCheque)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchEntryDefaultPaymentMethodCheque) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchEntryDefaultPaymentMethodCheque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchEntryDefaultPaymentMethodCheque, true)), __LINE__);
        }
        if (is_null($batchEntryDefaultPaymentMethodCheque) || (is_array($batchEntryDefaultPaymentMethodCheque) && empty($batchEntryDefaultPaymentMethodCheque))) {
            unset($this->BatchEntryDefaultPaymentMethodCheque);
        } else {
            $this->BatchEntryDefaultPaymentMethodCheque = $batchEntryDefaultPaymentMethodCheque;
        }
        return $this;
    }
    /**
     * Get BatchEntryDefaultPriceTypeMemberships value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchEntryDefaultPriceTypeMemberships()
    {
        return isset($this->BatchEntryDefaultPriceTypeMemberships) ? $this->BatchEntryDefaultPriceTypeMemberships : null;
    }
    /**
     * Set BatchEntryDefaultPriceTypeMemberships value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchEntryDefaultPriceTypeMemberships
     * @return \patest\StructType\Security_BatchEntryCompanyParameters
     */
    public function setBatchEntryDefaultPriceTypeMemberships($batchEntryDefaultPriceTypeMemberships = null)
    {
        // validation for constraint: string
        if (!is_null($batchEntryDefaultPriceTypeMemberships) && !is_string($batchEntryDefaultPriceTypeMemberships)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchEntryDefaultPriceTypeMemberships, true), gettype($batchEntryDefaultPriceTypeMemberships)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchEntryDefaultPriceTypeMemberships) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchEntryDefaultPriceTypeMemberships)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchEntryDefaultPriceTypeMemberships, true)), __LINE__);
        }
        if (is_null($batchEntryDefaultPriceTypeMemberships) || (is_array($batchEntryDefaultPriceTypeMemberships) && empty($batchEntryDefaultPriceTypeMemberships))) {
            unset($this->BatchEntryDefaultPriceTypeMemberships);
        } else {
            $this->BatchEntryDefaultPriceTypeMemberships = $batchEntryDefaultPriceTypeMemberships;
        }
        return $this;
    }
}
