<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.ApprovalRequestFilter StructType
 * @subpackage Structs
 */
class Security_ApprovalRequestFilter extends FilterEntity
{
    /**
     * The AdminUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AdminUserId;
    /**
     * The ExecutionStatusEx
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionStatusEx;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The OperationForApproval
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $OperationForApproval;
    /**
     * The RequestingUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestingUserId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Security.ApprovalRequestFilter
     * @uses Security_ApprovalRequestFilter::setAdminUserId()
     * @uses Security_ApprovalRequestFilter::setExecutionStatusEx()
     * @uses Security_ApprovalRequestFilter::setFromDate()
     * @uses Security_ApprovalRequestFilter::setOperationForApproval()
     * @uses Security_ApprovalRequestFilter::setRequestingUserId()
     * @uses Security_ApprovalRequestFilter::setStatus()
     * @uses Security_ApprovalRequestFilter::setToDate()
     * @uses Security_ApprovalRequestFilter::setTransactionNumber()
     * @param string $adminUserId
     * @param string $executionStatusEx
     * @param string $fromDate
     * @param string[] $operationForApproval
     * @param string $requestingUserId
     * @param string $status
     * @param string $toDate
     * @param int $transactionNumber
     */
    public function __construct($adminUserId = null, $executionStatusEx = null, $fromDate = null, array $operationForApproval = array(), $requestingUserId = null, $status = null, $toDate = null, $transactionNumber = null)
    {
        $this
            ->setAdminUserId($adminUserId)
            ->setExecutionStatusEx($executionStatusEx)
            ->setFromDate($fromDate)
            ->setOperationForApproval($operationForApproval)
            ->setRequestingUserId($requestingUserId)
            ->setStatus($status)
            ->setToDate($toDate)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get AdminUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdminUserId()
    {
        return isset($this->AdminUserId) ? $this->AdminUserId : null;
    }
    /**
     * Set AdminUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adminUserId
     * @return \patest\StructType\Security_ApprovalRequestFilter
     */
    public function setAdminUserId($adminUserId = null)
    {
        // validation for constraint: string
        if (!is_null($adminUserId) && !is_string($adminUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adminUserId, true), gettype($adminUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($adminUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $adminUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($adminUserId, true)), __LINE__);
        }
        if (is_null($adminUserId) || (is_array($adminUserId) && empty($adminUserId))) {
            unset($this->AdminUserId);
        } else {
            $this->AdminUserId = $adminUserId;
        }
        return $this;
    }
    /**
     * Get ExecutionStatusEx value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionStatusEx()
    {
        return isset($this->ExecutionStatusEx) ? $this->ExecutionStatusEx : null;
    }
    /**
     * Set ExecutionStatusEx value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestExecutionStatus::valueIsValid()
     * @uses \patest\EnumType\RequestExecutionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $executionStatusEx
     * @return \patest\StructType\Security_ApprovalRequestFilter
     */
    public function setExecutionStatusEx($executionStatusEx = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestExecutionStatus::valueIsValid($executionStatusEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestExecutionStatus', is_array($executionStatusEx) ? implode(', ', $executionStatusEx) : var_export($executionStatusEx, true), implode(', ', \patest\EnumType\RequestExecutionStatus::getValidValues())), __LINE__);
        }
        if (is_null($executionStatusEx) || (is_array($executionStatusEx) && empty($executionStatusEx))) {
            unset($this->ExecutionStatusEx);
        } else {
            $this->ExecutionStatusEx = $executionStatusEx;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Security_ApprovalRequestFilter
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get OperationForApproval value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getOperationForApproval()
    {
        return isset($this->OperationForApproval) ? $this->OperationForApproval : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOperationForApproval method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperationForApproval method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperationForApprovalForArrayConstraintsFromSetOperationForApproval(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $security_ApprovalRequestFilterOperationForApprovalItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OperationForApprovalType::valueIsValid($security_ApprovalRequestFilterOperationForApprovalItem)) {
                $invalidValues[] = is_object($security_ApprovalRequestFilterOperationForApprovalItem) ? get_class($security_ApprovalRequestFilterOperationForApprovalItem) : sprintf('%s(%s)', gettype($security_ApprovalRequestFilterOperationForApprovalItem), var_export($security_ApprovalRequestFilterOperationForApprovalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OperationForApprovalType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OperationForApprovalType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperationForApproval value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OperationForApprovalType::valueIsValid()
     * @uses \patest\EnumType\OperationForApprovalType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $operationForApproval
     * @return \patest\StructType\Security_ApprovalRequestFilter
     */
    public function setOperationForApproval(array $operationForApproval = array())
    {
        // validation for constraint: list
        if ('' !== ($operationForApprovalArrayErrorMessage = self::validateOperationForApprovalForArrayConstraintsFromSetOperationForApproval($operationForApproval))) {
            throw new \InvalidArgumentException($operationForApprovalArrayErrorMessage, __LINE__);
        }
        if (is_null($operationForApproval) || (is_array($operationForApproval) && empty($operationForApproval))) {
            unset($this->OperationForApproval);
        } else {
            $this->OperationForApproval = is_array($operationForApproval) ? implode(' ', $operationForApproval) : null;
        }
        return $this;
    }
    /**
     * Get RequestingUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestingUserId()
    {
        return isset($this->RequestingUserId) ? $this->RequestingUserId : null;
    }
    /**
     * Set RequestingUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestingUserId
     * @return \patest\StructType\Security_ApprovalRequestFilter
     */
    public function setRequestingUserId($requestingUserId = null)
    {
        // validation for constraint: string
        if (!is_null($requestingUserId) && !is_string($requestingUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestingUserId, true), gettype($requestingUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestingUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestingUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestingUserId, true)), __LINE__);
        }
        if (is_null($requestingUserId) || (is_array($requestingUserId) && empty($requestingUserId))) {
            unset($this->RequestingUserId);
        } else {
            $this->RequestingUserId = $requestingUserId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ApprovalDecisionType::valueIsValid()
     * @uses \patest\EnumType\ApprovalDecisionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Security_ApprovalRequestFilter
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ApprovalDecisionType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ApprovalDecisionType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\ApprovalDecisionType::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Security_ApprovalRequestFilter
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Security_ApprovalRequestFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
