<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.ApplicationChannelBySystemName StructType
 * @subpackage Structs
 */
class Security_ApplicationChannelBySystemName extends AnyEntity
{
    /**
     * The HolderTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderTenantId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The SystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemName;
    /**
     * Constructor method for Security.ApplicationChannelBySystemName
     * @uses Security_ApplicationChannelBySystemName::setHolderTenantId()
     * @uses Security_ApplicationChannelBySystemName::setName()
     * @uses Security_ApplicationChannelBySystemName::setSystemName()
     * @param int $holderTenantId
     * @param \patest\StructType\GlobalString $name
     * @param string $systemName
     */
    public function __construct($holderTenantId = null, \patest\StructType\GlobalString $name = null, $systemName = null)
    {
        $this
            ->setHolderTenantId($holderTenantId)
            ->setName($name)
            ->setSystemName($systemName);
    }
    /**
     * Get HolderTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderTenantId()
    {
        return isset($this->HolderTenantId) ? $this->HolderTenantId : null;
    }
    /**
     * Set HolderTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderTenantId
     * @return \patest\StructType\Security_ApplicationChannelBySystemName
     */
    public function setHolderTenantId($holderTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($holderTenantId) && !(is_int($holderTenantId) || ctype_digit($holderTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderTenantId, true), gettype($holderTenantId)), __LINE__);
        }
        if (is_null($holderTenantId) || (is_array($holderTenantId) && empty($holderTenantId))) {
            unset($this->HolderTenantId);
        } else {
            $this->HolderTenantId = $holderTenantId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Security_ApplicationChannelBySystemName
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemName()
    {
        return isset($this->SystemName) ? $this->SystemName : null;
    }
    /**
     * Set SystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemName
     * @return \patest\StructType\Security_ApplicationChannelBySystemName
     */
    public function setSystemName($systemName = null)
    {
        // validation for constraint: string
        if (!is_null($systemName) && !is_string($systemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemName, true), gettype($systemName)), __LINE__);
        }
        if (is_null($systemName) || (is_array($systemName) && empty($systemName))) {
            unset($this->SystemName);
        } else {
            $this->SystemName = $systemName;
        }
        return $this;
    }
}
