<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatingPlanManagerSessionSeatInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatingPlanManagerSessionSeatInfo
 * @subpackage Structs
 */
class SeatingPlanManagerSessionSeatInfo extends AbstractStructBase
{
    /**
     * The IsSubsTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSubsTicket;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The Relation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $Relation;
    /**
     * The SeatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatId;
    /**
     * Constructor method for SeatingPlanManagerSessionSeatInfo
     * @uses SeatingPlanManagerSessionSeatInfo::setIsSubsTicket()
     * @uses SeatingPlanManagerSessionSeatInfo::setPriceTypeId()
     * @uses SeatingPlanManagerSessionSeatInfo::setPriceTypeName()
     * @uses SeatingPlanManagerSessionSeatInfo::setRelation()
     * @uses SeatingPlanManagerSessionSeatInfo::setSeatId()
     * @param bool $isSubsTicket
     * @param string $priceTypeId
     * @param string $priceTypeName
     * @param string[] $relation
     * @param int $seatId
     */
    public function __construct($isSubsTicket = null, $priceTypeId = null, $priceTypeName = null, array $relation = array(), $seatId = null)
    {
        $this
            ->setIsSubsTicket($isSubsTicket)
            ->setPriceTypeId($priceTypeId)
            ->setPriceTypeName($priceTypeName)
            ->setRelation($relation)
            ->setSeatId($seatId);
    }
    /**
     * Get IsSubsTicket value
     * @return bool|null
     */
    public function getIsSubsTicket()
    {
        return $this->IsSubsTicket;
    }
    /**
     * Set IsSubsTicket value
     * @param bool $isSubsTicket
     * @return \patest\StructType\SeatingPlanManagerSessionSeatInfo
     */
    public function setIsSubsTicket($isSubsTicket = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubsTicket) && !is_bool($isSubsTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubsTicket, true), gettype($isSubsTicket)), __LINE__);
        }
        $this->IsSubsTicket = $isSubsTicket;
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\SeatingPlanManagerSessionSeatInfo
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\SeatingPlanManagerSessionSeatInfo
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get Relation value
     * @return string[]|null
     */
    public function getRelation()
    {
        return $this->Relation;
    }
    /**
     * This method is responsible for validating the values passed to the setRelation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelationForArrayConstraintsFromSetRelation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatingPlanManagerSessionSeatInfoRelationItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\SeatToSessionRelation::valueIsValid($seatingPlanManagerSessionSeatInfoRelationItem)) {
                $invalidValues[] = is_object($seatingPlanManagerSessionSeatInfoRelationItem) ? get_class($seatingPlanManagerSessionSeatInfoRelationItem) : sprintf('%s(%s)', gettype($seatingPlanManagerSessionSeatInfoRelationItem), var_export($seatingPlanManagerSessionSeatInfoRelationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatToSessionRelation', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\SeatToSessionRelation::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Relation value
     * @uses \patest\EnumType\SeatToSessionRelation::valueIsValid()
     * @uses \patest\EnumType\SeatToSessionRelation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $relation
     * @return \patest\StructType\SeatingPlanManagerSessionSeatInfo
     */
    public function setRelation(array $relation = array())
    {
        // validation for constraint: list
        if ('' !== ($relationArrayErrorMessage = self::validateRelationForArrayConstraintsFromSetRelation($relation))) {
            throw new \InvalidArgumentException($relationArrayErrorMessage, __LINE__);
        }
        $this->Relation = is_array($relation) ? implode(' ', $relation) : null;
        return $this;
    }
    /**
     * Get SeatId value
     * @return int|null
     */
    public function getSeatId()
    {
        return $this->SeatId;
    }
    /**
     * Set SeatId value
     * @param int $seatId
     * @return \patest\StructType\SeatingPlanManagerSessionSeatInfo
     */
    public function setSeatId($seatId = null)
    {
        // validation for constraint: int
        if (!is_null($seatId) && !(is_int($seatId) || ctype_digit($seatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatId, true), gettype($seatId)), __LINE__);
        }
        $this->SeatId = $seatId;
        return $this;
    }
}
