<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatStatusInformation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatStatusInformation
 * @subpackage Structs
 */
class SeatStatusInformation extends AbstractStructBase
{
    /**
     * The AllocationGuids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AllocationGuids;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The Availability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Availability;
    /**
     * The LockGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockGuid;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The AppCh
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AppCh;
    /**
     * The Res
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Res;
    /**
     * The SM
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SM;
    /**
     * The SMGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SMGuid;
    /**
     * The W4Prt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $W4Prt;
    /**
     * The SILS
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SILS;
    /**
     * The SIT
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SIT;
    /**
     * The IsResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsResale;
    /**
     * The IsTicketScanned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTicketScanned;
    /**
     * The SessionInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatSessionInfo
     */
    public $SessionInfo;
    /**
     * The PriceLevelCombinationIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PriceLevelCombinationIndex;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The HasPriceOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasPriceOverride;
    /**
     * The IsTransfer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsTransfer;
    /**
     * Constructor method for SeatStatusInformation
     * @uses SeatStatusInformation::setAllocationGuids()
     * @uses SeatStatusInformation::setApplicationChannel()
     * @uses SeatStatusInformation::setAvailability()
     * @uses SeatStatusInformation::setLockGuid()
     * @uses SeatStatusInformation::setPriceTypeId()
     * @uses SeatStatusInformation::setPriceTypeName()
     * @uses SeatStatusInformation::setAppCh()
     * @uses SeatStatusInformation::setRes()
     * @uses SeatStatusInformation::setSM()
     * @uses SeatStatusInformation::setSMGuid()
     * @uses SeatStatusInformation::setW4Prt()
     * @uses SeatStatusInformation::setSILS()
     * @uses SeatStatusInformation::setSIT()
     * @uses SeatStatusInformation::setIsResale()
     * @uses SeatStatusInformation::setIsTicketScanned()
     * @uses SeatStatusInformation::setSessionInfo()
     * @uses SeatStatusInformation::setPriceLevelCombinationIndex()
     * @uses SeatStatusInformation::setPriceLevelId()
     * @uses SeatStatusInformation::setHasPriceOverride()
     * @uses SeatStatusInformation::setIsTransfer()
     * @param \patest\ArrayType\ArrayOfguid $allocationGuids
     * @param string $applicationChannel
     * @param string[] $availability
     * @param string $lockGuid
     * @param string $priceTypeId
     * @param string $priceTypeName
     * @param int $appCh
     * @param int $res
     * @param int $sM
     * @param string $sMGuid
     * @param bool $w4Prt
     * @param string $sILS
     * @param string $sIT
     * @param bool $isResale
     * @param bool $isTicketScanned
     * @param \patest\StructType\SeatSessionInfo $sessionInfo
     * @param int $priceLevelCombinationIndex
     * @param string $priceLevelId
     * @param bool $hasPriceOverride
     * @param bool $isTransfer
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $allocationGuids = null, $applicationChannel = null, array $availability = array(), $lockGuid = null, $priceTypeId = null, $priceTypeName = null, $appCh = null, $res = null, $sM = null, $sMGuid = null, $w4Prt = null, $sILS = null, $sIT = null, $isResale = null, $isTicketScanned = null, \patest\StructType\SeatSessionInfo $sessionInfo = null, $priceLevelCombinationIndex = null, $priceLevelId = null, $hasPriceOverride = null, $isTransfer = null)
    {
        $this
            ->setAllocationGuids($allocationGuids)
            ->setApplicationChannel($applicationChannel)
            ->setAvailability($availability)
            ->setLockGuid($lockGuid)
            ->setPriceTypeId($priceTypeId)
            ->setPriceTypeName($priceTypeName)
            ->setAppCh($appCh)
            ->setRes($res)
            ->setSM($sM)
            ->setSMGuid($sMGuid)
            ->setW4Prt($w4Prt)
            ->setSILS($sILS)
            ->setSIT($sIT)
            ->setIsResale($isResale)
            ->setIsTicketScanned($isTicketScanned)
            ->setSessionInfo($sessionInfo)
            ->setPriceLevelCombinationIndex($priceLevelCombinationIndex)
            ->setPriceLevelId($priceLevelId)
            ->setHasPriceOverride($hasPriceOverride)
            ->setIsTransfer($isTransfer);
    }
    /**
     * Get AllocationGuids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAllocationGuids()
    {
        return isset($this->AllocationGuids) ? $this->AllocationGuids : null;
    }
    /**
     * Set AllocationGuids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $allocationGuids
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setAllocationGuids(\patest\ArrayType\ArrayOfguid $allocationGuids = null)
    {
        if (is_null($allocationGuids) || (is_array($allocationGuids) && empty($allocationGuids))) {
            unset($this->AllocationGuids);
        } else {
            $this->AllocationGuids = $allocationGuids;
        }
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get Availability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAvailability()
    {
        return isset($this->Availability) ? $this->Availability : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAvailability method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAvailability method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAvailabilityForArrayConstraintsFromSetAvailability(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatStatusInformationAvailabilityItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\UserSeatAvailabilities::valueIsValid($seatStatusInformationAvailabilityItem)) {
                $invalidValues[] = is_object($seatStatusInformationAvailabilityItem) ? get_class($seatStatusInformationAvailabilityItem) : sprintf('%s(%s)', gettype($seatStatusInformationAvailabilityItem), var_export($seatStatusInformationAvailabilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\UserSeatAvailabilities', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\UserSeatAvailabilities::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Availability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\UserSeatAvailabilities::valueIsValid()
     * @uses \patest\EnumType\UserSeatAvailabilities::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $availability
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setAvailability(array $availability = array())
    {
        // validation for constraint: list
        if ('' !== ($availabilityArrayErrorMessage = self::validateAvailabilityForArrayConstraintsFromSetAvailability($availability))) {
            throw new \InvalidArgumentException($availabilityArrayErrorMessage, __LINE__);
        }
        if (is_null($availability) || (is_array($availability) && empty($availability))) {
            unset($this->Availability);
        } else {
            $this->Availability = is_array($availability) ? implode(' ', $availability) : null;
        }
        return $this;
    }
    /**
     * Get LockGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockGuid()
    {
        return isset($this->LockGuid) ? $this->LockGuid : null;
    }
    /**
     * Set LockGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockGuid
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setLockGuid($lockGuid = null)
    {
        // validation for constraint: string
        if (!is_null($lockGuid) && !is_string($lockGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockGuid, true), gettype($lockGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockGuid, true)), __LINE__);
        }
        if (is_null($lockGuid) || (is_array($lockGuid) && empty($lockGuid))) {
            unset($this->LockGuid);
        } else {
            $this->LockGuid = $lockGuid;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get AppCh value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAppCh()
    {
        return isset($this->AppCh) ? $this->AppCh : null;
    }
    /**
     * Set AppCh value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $appCh
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setAppCh($appCh = null)
    {
        // validation for constraint: int
        if (!is_null($appCh) && !(is_int($appCh) || ctype_digit($appCh))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($appCh, true), gettype($appCh)), __LINE__);
        }
        if (is_null($appCh) || (is_array($appCh) && empty($appCh))) {
            unset($this->AppCh);
        } else {
            $this->AppCh = $appCh;
        }
        return $this;
    }
    /**
     * Get Res value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRes()
    {
        return isset($this->Res) ? $this->Res : null;
    }
    /**
     * Set Res value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $res
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setRes($res = null)
    {
        // validation for constraint: int
        if (!is_null($res) && !(is_int($res) || ctype_digit($res))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($res, true), gettype($res)), __LINE__);
        }
        if (is_null($res) || (is_array($res) && empty($res))) {
            unset($this->Res);
        } else {
            $this->Res = $res;
        }
        return $this;
    }
    /**
     * Get SM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSM()
    {
        return isset($this->SM) ? $this->SM : null;
    }
    /**
     * Set SM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sM
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setSM($sM = null)
    {
        // validation for constraint: int
        if (!is_null($sM) && !(is_int($sM) || ctype_digit($sM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sM, true), gettype($sM)), __LINE__);
        }
        if (is_null($sM) || (is_array($sM) && empty($sM))) {
            unset($this->SM);
        } else {
            $this->SM = $sM;
        }
        return $this;
    }
    /**
     * Get SMGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSMGuid()
    {
        return isset($this->SMGuid) ? $this->SMGuid : null;
    }
    /**
     * Set SMGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sMGuid
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setSMGuid($sMGuid = null)
    {
        // validation for constraint: string
        if (!is_null($sMGuid) && !is_string($sMGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sMGuid, true), gettype($sMGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sMGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sMGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sMGuid, true)), __LINE__);
        }
        if (is_null($sMGuid) || (is_array($sMGuid) && empty($sMGuid))) {
            unset($this->SMGuid);
        } else {
            $this->SMGuid = $sMGuid;
        }
        return $this;
    }
    /**
     * Get W4Prt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getW4Prt()
    {
        return isset($this->W4Prt) ? $this->W4Prt : null;
    }
    /**
     * Set W4Prt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $w4Prt
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setW4Prt($w4Prt = null)
    {
        // validation for constraint: boolean
        if (!is_null($w4Prt) && !is_bool($w4Prt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($w4Prt, true), gettype($w4Prt)), __LINE__);
        }
        if (is_null($w4Prt) || (is_array($w4Prt) && empty($w4Prt))) {
            unset($this->W4Prt);
        } else {
            $this->W4Prt = $w4Prt;
        }
        return $this;
    }
    /**
     * Get SILS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSILS()
    {
        return isset($this->SILS) ? $this->SILS : null;
    }
    /**
     * Set SILS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sILS
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setSILS($sILS = null)
    {
        // validation for constraint: string
        if (!is_null($sILS) && !is_string($sILS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sILS, true), gettype($sILS)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sILS) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sILS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sILS, true)), __LINE__);
        }
        if (is_null($sILS) || (is_array($sILS) && empty($sILS))) {
            unset($this->SILS);
        } else {
            $this->SILS = $sILS;
        }
        return $this;
    }
    /**
     * Get SIT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSIT()
    {
        return isset($this->SIT) ? $this->SIT : null;
    }
    /**
     * Set SIT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sIT
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setSIT($sIT = null)
    {
        // validation for constraint: string
        if (!is_null($sIT) && !is_string($sIT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sIT, true), gettype($sIT)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sIT) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sIT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sIT, true)), __LINE__);
        }
        if (is_null($sIT) || (is_array($sIT) && empty($sIT))) {
            unset($this->SIT);
        } else {
            $this->SIT = $sIT;
        }
        return $this;
    }
    /**
     * Get IsResale value
     * @return bool|null
     */
    public function getIsResale()
    {
        return $this->IsResale;
    }
    /**
     * Set IsResale value
     * @param bool $isResale
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setIsResale($isResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResale) && !is_bool($isResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResale, true), gettype($isResale)), __LINE__);
        }
        $this->IsResale = $isResale;
        return $this;
    }
    /**
     * Get IsTicketScanned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTicketScanned()
    {
        return isset($this->IsTicketScanned) ? $this->IsTicketScanned : null;
    }
    /**
     * Set IsTicketScanned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTicketScanned
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setIsTicketScanned($isTicketScanned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTicketScanned) && !is_bool($isTicketScanned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTicketScanned, true), gettype($isTicketScanned)), __LINE__);
        }
        if (is_null($isTicketScanned) || (is_array($isTicketScanned) && empty($isTicketScanned))) {
            unset($this->IsTicketScanned);
        } else {
            $this->IsTicketScanned = $isTicketScanned;
        }
        return $this;
    }
    /**
     * Get SessionInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatSessionInfo|null
     */
    public function getSessionInfo()
    {
        return isset($this->SessionInfo) ? $this->SessionInfo : null;
    }
    /**
     * Set SessionInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatSessionInfo $sessionInfo
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setSessionInfo(\patest\StructType\SeatSessionInfo $sessionInfo = null)
    {
        if (is_null($sessionInfo) || (is_array($sessionInfo) && empty($sessionInfo))) {
            unset($this->SessionInfo);
        } else {
            $this->SessionInfo = $sessionInfo;
        }
        return $this;
    }
    /**
     * Get PriceLevelCombinationIndex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriceLevelCombinationIndex()
    {
        return isset($this->PriceLevelCombinationIndex) ? $this->PriceLevelCombinationIndex : null;
    }
    /**
     * Set PriceLevelCombinationIndex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priceLevelCombinationIndex
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setPriceLevelCombinationIndex($priceLevelCombinationIndex = null)
    {
        // validation for constraint: int
        if (!is_null($priceLevelCombinationIndex) && !(is_int($priceLevelCombinationIndex) || ctype_digit($priceLevelCombinationIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceLevelCombinationIndex, true), gettype($priceLevelCombinationIndex)), __LINE__);
        }
        if (is_null($priceLevelCombinationIndex) || (is_array($priceLevelCombinationIndex) && empty($priceLevelCombinationIndex))) {
            unset($this->PriceLevelCombinationIndex);
        } else {
            $this->PriceLevelCombinationIndex = $priceLevelCombinationIndex;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get HasPriceOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasPriceOverride()
    {
        return isset($this->HasPriceOverride) ? $this->HasPriceOverride : null;
    }
    /**
     * Set HasPriceOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasPriceOverride
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setHasPriceOverride($hasPriceOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasPriceOverride) && !is_bool($hasPriceOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasPriceOverride, true), gettype($hasPriceOverride)), __LINE__);
        }
        if (is_null($hasPriceOverride) || (is_array($hasPriceOverride) && empty($hasPriceOverride))) {
            unset($this->HasPriceOverride);
        } else {
            $this->HasPriceOverride = $hasPriceOverride;
        }
        return $this;
    }
    /**
     * Get IsTransfer value
     * @return bool|null
     */
    public function getIsTransfer()
    {
        return $this->IsTransfer;
    }
    /**
     * Set IsTransfer value
     * @param bool $isTransfer
     * @return \patest\StructType\SeatStatusInformation
     */
    public function setIsTransfer($isTransfer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTransfer) && !is_bool($isTransfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTransfer, true), gettype($isTransfer)), __LINE__);
        }
        $this->IsTransfer = $isTransfer;
        return $this;
    }
}
