<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatDesign StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatDesign
 * @subpackage Structs
 */
class SeatDesign extends AbstractStructBase
{
    /**
     * The Angle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Angle;
    /**
     * The CustomProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $CustomProperties;
    /**
     * The DefaultAllocationGuids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $DefaultAllocationGuids;
    /**
     * The DefaultLockGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultLockGuid;
    /**
     * The GateCombinationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GateCombinationId;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Height;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The LocationOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $LocationOptions;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Note;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Ordinal;
    /**
     * The ParentRowGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentRowGuid;
    /**
     * The PriceLevelGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelGuid;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The PrivatePropertyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrivatePropertyId;
    /**
     * The SeatTypeGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatTypeGuid;
    /**
     * The TurnstileCombinationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TurnstileCombinationId;
    /**
     * The ViewFromSeatImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ViewFromSeatImageId;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Width;
    /**
     * The X
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $X;
    /**
     * The Y
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Y;
    /**
     * The IsBulk
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsBulk;
    /**
     * The ClubAccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClubAccess;
    /**
     * The EntryGate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntryGate;
    /**
     * The Level
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Level;
    /**
     * The SecondaryClubAccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecondaryClubAccess;
    /**
     * Constructor method for SeatDesign
     * @uses SeatDesign::setAngle()
     * @uses SeatDesign::setCustomProperties()
     * @uses SeatDesign::setDefaultAllocationGuids()
     * @uses SeatDesign::setDefaultLockGuid()
     * @uses SeatDesign::setGateCombinationId()
     * @uses SeatDesign::setHeight()
     * @uses SeatDesign::setId()
     * @uses SeatDesign::setLocationOptions()
     * @uses SeatDesign::setName()
     * @uses SeatDesign::setNote()
     * @uses SeatDesign::setOrdinal()
     * @uses SeatDesign::setParentRowGuid()
     * @uses SeatDesign::setPriceLevelGuid()
     * @uses SeatDesign::setPriority()
     * @uses SeatDesign::setPrivatePropertyId()
     * @uses SeatDesign::setSeatTypeGuid()
     * @uses SeatDesign::setTurnstileCombinationId()
     * @uses SeatDesign::setViewFromSeatImageId()
     * @uses SeatDesign::setWidth()
     * @uses SeatDesign::setX()
     * @uses SeatDesign::setY()
     * @uses SeatDesign::setIsBulk()
     * @uses SeatDesign::setClubAccess()
     * @uses SeatDesign::setEntryGate()
     * @uses SeatDesign::setLevel()
     * @uses SeatDesign::setSecondaryClubAccess()
     * @param float $angle
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $customProperties
     * @param \patest\ArrayType\ArrayOfguid $defaultAllocationGuids
     * @param string $defaultLockGuid
     * @param int $gateCombinationId
     * @param float $height
     * @param int $id
     * @param string[] $locationOptions
     * @param string $name
     * @param \patest\StructType\GlobalString $note
     * @param int $ordinal
     * @param string $parentRowGuid
     * @param string $priceLevelGuid
     * @param int $priority
     * @param string $privatePropertyId
     * @param string $seatTypeGuid
     * @param int $turnstileCombinationId
     * @param int $viewFromSeatImageId
     * @param float $width
     * @param float $x
     * @param float $y
     * @param bool $isBulk
     * @param string $clubAccess
     * @param string $entryGate
     * @param string $level
     * @param string $secondaryClubAccess
     */
    public function __construct($angle = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $customProperties = null, \patest\ArrayType\ArrayOfguid $defaultAllocationGuids = null, $defaultLockGuid = null, $gateCombinationId = null, $height = null, $id = null, array $locationOptions = array(), $name = null, \patest\StructType\GlobalString $note = null, $ordinal = null, $parentRowGuid = null, $priceLevelGuid = null, $priority = null, $privatePropertyId = null, $seatTypeGuid = null, $turnstileCombinationId = null, $viewFromSeatImageId = null, $width = null, $x = null, $y = null, $isBulk = null, $clubAccess = null, $entryGate = null, $level = null, $secondaryClubAccess = null)
    {
        $this
            ->setAngle($angle)
            ->setCustomProperties($customProperties)
            ->setDefaultAllocationGuids($defaultAllocationGuids)
            ->setDefaultLockGuid($defaultLockGuid)
            ->setGateCombinationId($gateCombinationId)
            ->setHeight($height)
            ->setId($id)
            ->setLocationOptions($locationOptions)
            ->setName($name)
            ->setNote($note)
            ->setOrdinal($ordinal)
            ->setParentRowGuid($parentRowGuid)
            ->setPriceLevelGuid($priceLevelGuid)
            ->setPriority($priority)
            ->setPrivatePropertyId($privatePropertyId)
            ->setSeatTypeGuid($seatTypeGuid)
            ->setTurnstileCombinationId($turnstileCombinationId)
            ->setViewFromSeatImageId($viewFromSeatImageId)
            ->setWidth($width)
            ->setX($x)
            ->setY($y)
            ->setIsBulk($isBulk)
            ->setClubAccess($clubAccess)
            ->setEntryGate($entryGate)
            ->setLevel($level)
            ->setSecondaryClubAccess($secondaryClubAccess);
    }
    /**
     * Get Angle value
     * @return float|null
     */
    public function getAngle()
    {
        return $this->Angle;
    }
    /**
     * Set Angle value
     * @param float $angle
     * @return \patest\StructType\SeatDesign
     */
    public function setAngle($angle = null)
    {
        // validation for constraint: float
        if (!is_null($angle) && !(is_float($angle) || is_numeric($angle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($angle, true), gettype($angle)), __LINE__);
        }
        $this->Angle = $angle;
        return $this;
    }
    /**
     * Get CustomProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getCustomProperties()
    {
        return isset($this->CustomProperties) ? $this->CustomProperties : null;
    }
    /**
     * Set CustomProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $customProperties
     * @return \patest\StructType\SeatDesign
     */
    public function setCustomProperties(\patest\ArrayType\ArrayOfKeyValueOfstringstring $customProperties = null)
    {
        if (is_null($customProperties) || (is_array($customProperties) && empty($customProperties))) {
            unset($this->CustomProperties);
        } else {
            $this->CustomProperties = $customProperties;
        }
        return $this;
    }
    /**
     * Get DefaultAllocationGuids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getDefaultAllocationGuids()
    {
        return isset($this->DefaultAllocationGuids) ? $this->DefaultAllocationGuids : null;
    }
    /**
     * Set DefaultAllocationGuids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $defaultAllocationGuids
     * @return \patest\StructType\SeatDesign
     */
    public function setDefaultAllocationGuids(\patest\ArrayType\ArrayOfguid $defaultAllocationGuids = null)
    {
        if (is_null($defaultAllocationGuids) || (is_array($defaultAllocationGuids) && empty($defaultAllocationGuids))) {
            unset($this->DefaultAllocationGuids);
        } else {
            $this->DefaultAllocationGuids = $defaultAllocationGuids;
        }
        return $this;
    }
    /**
     * Get DefaultLockGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultLockGuid()
    {
        return isset($this->DefaultLockGuid) ? $this->DefaultLockGuid : null;
    }
    /**
     * Set DefaultLockGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultLockGuid
     * @return \patest\StructType\SeatDesign
     */
    public function setDefaultLockGuid($defaultLockGuid = null)
    {
        // validation for constraint: string
        if (!is_null($defaultLockGuid) && !is_string($defaultLockGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultLockGuid, true), gettype($defaultLockGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultLockGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultLockGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultLockGuid, true)), __LINE__);
        }
        if (is_null($defaultLockGuid) || (is_array($defaultLockGuid) && empty($defaultLockGuid))) {
            unset($this->DefaultLockGuid);
        } else {
            $this->DefaultLockGuid = $defaultLockGuid;
        }
        return $this;
    }
    /**
     * Get GateCombinationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGateCombinationId()
    {
        return isset($this->GateCombinationId) ? $this->GateCombinationId : null;
    }
    /**
     * Set GateCombinationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $gateCombinationId
     * @return \patest\StructType\SeatDesign
     */
    public function setGateCombinationId($gateCombinationId = null)
    {
        // validation for constraint: int
        if (!is_null($gateCombinationId) && !(is_int($gateCombinationId) || ctype_digit($gateCombinationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gateCombinationId, true), gettype($gateCombinationId)), __LINE__);
        }
        if (is_null($gateCombinationId) || (is_array($gateCombinationId) && empty($gateCombinationId))) {
            unset($this->GateCombinationId);
        } else {
            $this->GateCombinationId = $gateCombinationId;
        }
        return $this;
    }
    /**
     * Get Height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param float $height
     * @return \patest\StructType\SeatDesign
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \patest\StructType\SeatDesign
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get LocationOptions value
     * @return string[]|null
     */
    public function getLocationOptions()
    {
        return $this->LocationOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setLocationOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocationOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationOptionsForArrayConstraintsFromSetLocationOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatDesignLocationOptionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\SeatLocationOptions::valueIsValid($seatDesignLocationOptionsItem)) {
                $invalidValues[] = is_object($seatDesignLocationOptionsItem) ? get_class($seatDesignLocationOptionsItem) : sprintf('%s(%s)', gettype($seatDesignLocationOptionsItem), var_export($seatDesignLocationOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatLocationOptions', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\SeatLocationOptions::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LocationOptions value
     * @uses \patest\EnumType\SeatLocationOptions::valueIsValid()
     * @uses \patest\EnumType\SeatLocationOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $locationOptions
     * @return \patest\StructType\SeatDesign
     */
    public function setLocationOptions(array $locationOptions = array())
    {
        // validation for constraint: list
        if ('' !== ($locationOptionsArrayErrorMessage = self::validateLocationOptionsForArrayConstraintsFromSetLocationOptions($locationOptions))) {
            throw new \InvalidArgumentException($locationOptionsArrayErrorMessage, __LINE__);
        }
        $this->LocationOptions = is_array($locationOptions) ? implode(' ', $locationOptions) : null;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\SeatDesign
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $note
     * @return \patest\StructType\SeatDesign
     */
    public function setNote(\patest\StructType\GlobalString $note = null)
    {
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * @return int|null
     */
    public function getOrdinal()
    {
        return $this->Ordinal;
    }
    /**
     * Set Ordinal value
     * @param int $ordinal
     * @return \patest\StructType\SeatDesign
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        $this->Ordinal = $ordinal;
        return $this;
    }
    /**
     * Get ParentRowGuid value
     * @return string|null
     */
    public function getParentRowGuid()
    {
        return $this->ParentRowGuid;
    }
    /**
     * Set ParentRowGuid value
     * @param string $parentRowGuid
     * @return \patest\StructType\SeatDesign
     */
    public function setParentRowGuid($parentRowGuid = null)
    {
        // validation for constraint: string
        if (!is_null($parentRowGuid) && !is_string($parentRowGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentRowGuid, true), gettype($parentRowGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentRowGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentRowGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentRowGuid, true)), __LINE__);
        }
        $this->ParentRowGuid = $parentRowGuid;
        return $this;
    }
    /**
     * Get PriceLevelGuid value
     * @return string|null
     */
    public function getPriceLevelGuid()
    {
        return $this->PriceLevelGuid;
    }
    /**
     * Set PriceLevelGuid value
     * @param string $priceLevelGuid
     * @return \patest\StructType\SeatDesign
     */
    public function setPriceLevelGuid($priceLevelGuid = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelGuid) && !is_string($priceLevelGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelGuid, true), gettype($priceLevelGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelGuid, true)), __LINE__);
        }
        $this->PriceLevelGuid = $priceLevelGuid;
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\SeatDesign
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get PrivatePropertyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrivatePropertyId()
    {
        return isset($this->PrivatePropertyId) ? $this->PrivatePropertyId : null;
    }
    /**
     * Set PrivatePropertyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $privatePropertyId
     * @return \patest\StructType\SeatDesign
     */
    public function setPrivatePropertyId($privatePropertyId = null)
    {
        // validation for constraint: string
        if (!is_null($privatePropertyId) && !is_string($privatePropertyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privatePropertyId, true), gettype($privatePropertyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($privatePropertyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $privatePropertyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($privatePropertyId, true)), __LINE__);
        }
        if (is_null($privatePropertyId) || (is_array($privatePropertyId) && empty($privatePropertyId))) {
            unset($this->PrivatePropertyId);
        } else {
            $this->PrivatePropertyId = $privatePropertyId;
        }
        return $this;
    }
    /**
     * Get SeatTypeGuid value
     * @return string|null
     */
    public function getSeatTypeGuid()
    {
        return $this->SeatTypeGuid;
    }
    /**
     * Set SeatTypeGuid value
     * @param string $seatTypeGuid
     * @return \patest\StructType\SeatDesign
     */
    public function setSeatTypeGuid($seatTypeGuid = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeGuid) && !is_string($seatTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeGuid, true), gettype($seatTypeGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatTypeGuid, true)), __LINE__);
        }
        $this->SeatTypeGuid = $seatTypeGuid;
        return $this;
    }
    /**
     * Get TurnstileCombinationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTurnstileCombinationId()
    {
        return isset($this->TurnstileCombinationId) ? $this->TurnstileCombinationId : null;
    }
    /**
     * Set TurnstileCombinationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $turnstileCombinationId
     * @return \patest\StructType\SeatDesign
     */
    public function setTurnstileCombinationId($turnstileCombinationId = null)
    {
        // validation for constraint: int
        if (!is_null($turnstileCombinationId) && !(is_int($turnstileCombinationId) || ctype_digit($turnstileCombinationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($turnstileCombinationId, true), gettype($turnstileCombinationId)), __LINE__);
        }
        if (is_null($turnstileCombinationId) || (is_array($turnstileCombinationId) && empty($turnstileCombinationId))) {
            unset($this->TurnstileCombinationId);
        } else {
            $this->TurnstileCombinationId = $turnstileCombinationId;
        }
        return $this;
    }
    /**
     * Get ViewFromSeatImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getViewFromSeatImageId()
    {
        return isset($this->ViewFromSeatImageId) ? $this->ViewFromSeatImageId : null;
    }
    /**
     * Set ViewFromSeatImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $viewFromSeatImageId
     * @return \patest\StructType\SeatDesign
     */
    public function setViewFromSeatImageId($viewFromSeatImageId = null)
    {
        // validation for constraint: int
        if (!is_null($viewFromSeatImageId) && !(is_int($viewFromSeatImageId) || ctype_digit($viewFromSeatImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($viewFromSeatImageId, true), gettype($viewFromSeatImageId)), __LINE__);
        }
        if (is_null($viewFromSeatImageId) || (is_array($viewFromSeatImageId) && empty($viewFromSeatImageId))) {
            unset($this->ViewFromSeatImageId);
        } else {
            $this->ViewFromSeatImageId = $viewFromSeatImageId;
        }
        return $this;
    }
    /**
     * Get Width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param float $width
     * @return \patest\StructType\SeatDesign
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get X value
     * @return float|null
     */
    public function getX()
    {
        return $this->X;
    }
    /**
     * Set X value
     * @param float $x
     * @return \patest\StructType\SeatDesign
     */
    public function setX($x = null)
    {
        // validation for constraint: float
        if (!is_null($x) && !(is_float($x) || is_numeric($x))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($x, true), gettype($x)), __LINE__);
        }
        $this->X = $x;
        return $this;
    }
    /**
     * Get Y value
     * @return float|null
     */
    public function getY()
    {
        return $this->Y;
    }
    /**
     * Set Y value
     * @param float $y
     * @return \patest\StructType\SeatDesign
     */
    public function setY($y = null)
    {
        // validation for constraint: float
        if (!is_null($y) && !(is_float($y) || is_numeric($y))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($y, true), gettype($y)), __LINE__);
        }
        $this->Y = $y;
        return $this;
    }
    /**
     * Get IsBulk value
     * @return bool|null
     */
    public function getIsBulk()
    {
        return $this->IsBulk;
    }
    /**
     * Set IsBulk value
     * @param bool $isBulk
     * @return \patest\StructType\SeatDesign
     */
    public function setIsBulk($isBulk = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBulk) && !is_bool($isBulk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBulk, true), gettype($isBulk)), __LINE__);
        }
        $this->IsBulk = $isBulk;
        return $this;
    }
    /**
     * Get ClubAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClubAccess()
    {
        return isset($this->ClubAccess) ? $this->ClubAccess : null;
    }
    /**
     * Set ClubAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clubAccess
     * @return \patest\StructType\SeatDesign
     */
    public function setClubAccess($clubAccess = null)
    {
        // validation for constraint: string
        if (!is_null($clubAccess) && !is_string($clubAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clubAccess, true), gettype($clubAccess)), __LINE__);
        }
        if (is_null($clubAccess) || (is_array($clubAccess) && empty($clubAccess))) {
            unset($this->ClubAccess);
        } else {
            $this->ClubAccess = $clubAccess;
        }
        return $this;
    }
    /**
     * Get EntryGate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntryGate()
    {
        return isset($this->EntryGate) ? $this->EntryGate : null;
    }
    /**
     * Set EntryGate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entryGate
     * @return \patest\StructType\SeatDesign
     */
    public function setEntryGate($entryGate = null)
    {
        // validation for constraint: string
        if (!is_null($entryGate) && !is_string($entryGate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryGate, true), gettype($entryGate)), __LINE__);
        }
        if (is_null($entryGate) || (is_array($entryGate) && empty($entryGate))) {
            unset($this->EntryGate);
        } else {
            $this->EntryGate = $entryGate;
        }
        return $this;
    }
    /**
     * Get Level value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLevel()
    {
        return isset($this->Level) ? $this->Level : null;
    }
    /**
     * Set Level value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $level
     * @return \patest\StructType\SeatDesign
     */
    public function setLevel($level = null)
    {
        // validation for constraint: string
        if (!is_null($level) && !is_string($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($level, true), gettype($level)), __LINE__);
        }
        if (is_null($level) || (is_array($level) && empty($level))) {
            unset($this->Level);
        } else {
            $this->Level = $level;
        }
        return $this;
    }
    /**
     * Get SecondaryClubAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondaryClubAccess()
    {
        return isset($this->SecondaryClubAccess) ? $this->SecondaryClubAccess : null;
    }
    /**
     * Set SecondaryClubAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondaryClubAccess
     * @return \patest\StructType\SeatDesign
     */
    public function setSecondaryClubAccess($secondaryClubAccess = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryClubAccess) && !is_string($secondaryClubAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryClubAccess, true), gettype($secondaryClubAccess)), __LINE__);
        }
        if (is_null($secondaryClubAccess) || (is_array($secondaryClubAccess) && empty($secondaryClubAccess))) {
            unset($this->SecondaryClubAccess);
        } else {
            $this->SecondaryClubAccess = $secondaryClubAccess;
        }
        return $this;
    }
}
