<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchParameters StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SearchParameters
 * @subpackage Structs
 */
class SearchParameters extends AbstractStructBase
{
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The DeliveryMethodIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $DeliveryMethodIds;
    /**
     * The EventExtendedData1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventExtendedData1;
    /**
     * The EventFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventFromDate;
    /**
     * The EventOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventOwnerId;
    /**
     * The EventToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventToDate;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The IncludeAgentTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IncludeAgentTickets;
    /**
     * The IncludeLoadedOnCardTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IncludeLoadedOnCardTickets;
    /**
     * The IncludeMarketDriven
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeMarketDriven;
    /**
     * The IncludeMovedTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IncludeMovedTickets;
    /**
     * The IncludeTicketsInSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IncludeTicketsInSubscription;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The SiteLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SiteLocalId;
    /**
     * The TransactionFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionFromDate;
    /**
     * The TransactionToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionToDate;
    /**
     * Constructor method for SearchParameters
     * @uses SearchParameters::setApplicationChannel()
     * @uses SearchParameters::setDeliveryMethodIds()
     * @uses SearchParameters::setEventExtendedData1()
     * @uses SearchParameters::setEventFromDate()
     * @uses SearchParameters::setEventOwnerId()
     * @uses SearchParameters::setEventToDate()
     * @uses SearchParameters::setHallId()
     * @uses SearchParameters::setIncludeAgentTickets()
     * @uses SearchParameters::setIncludeLoadedOnCardTickets()
     * @uses SearchParameters::setIncludeMarketDriven()
     * @uses SearchParameters::setIncludeMovedTickets()
     * @uses SearchParameters::setIncludeTicketsInSubscription()
     * @uses SearchParameters::setShowId()
     * @uses SearchParameters::setSiteLocalId()
     * @uses SearchParameters::setTransactionFromDate()
     * @uses SearchParameters::setTransactionToDate()
     * @param string $applicationChannel
     * @param \patest\ArrayType\ArrayOfguid $deliveryMethodIds
     * @param string $eventExtendedData1
     * @param string $eventFromDate
     * @param string $eventOwnerId
     * @param string $eventToDate
     * @param string $hallId
     * @param string $includeAgentTickets
     * @param string $includeLoadedOnCardTickets
     * @param bool $includeMarketDriven
     * @param string $includeMovedTickets
     * @param string $includeTicketsInSubscription
     * @param string $showId
     * @param int $siteLocalId
     * @param string $transactionFromDate
     * @param string $transactionToDate
     */
    public function __construct($applicationChannel = null, \patest\ArrayType\ArrayOfguid $deliveryMethodIds = null, $eventExtendedData1 = null, $eventFromDate = null, $eventOwnerId = null, $eventToDate = null, $hallId = null, $includeAgentTickets = null, $includeLoadedOnCardTickets = null, $includeMarketDriven = null, $includeMovedTickets = null, $includeTicketsInSubscription = null, $showId = null, $siteLocalId = null, $transactionFromDate = null, $transactionToDate = null)
    {
        $this
            ->setApplicationChannel($applicationChannel)
            ->setDeliveryMethodIds($deliveryMethodIds)
            ->setEventExtendedData1($eventExtendedData1)
            ->setEventFromDate($eventFromDate)
            ->setEventOwnerId($eventOwnerId)
            ->setEventToDate($eventToDate)
            ->setHallId($hallId)
            ->setIncludeAgentTickets($includeAgentTickets)
            ->setIncludeLoadedOnCardTickets($includeLoadedOnCardTickets)
            ->setIncludeMarketDriven($includeMarketDriven)
            ->setIncludeMovedTickets($includeMovedTickets)
            ->setIncludeTicketsInSubscription($includeTicketsInSubscription)
            ->setShowId($showId)
            ->setSiteLocalId($siteLocalId)
            ->setTransactionFromDate($transactionFromDate)
            ->setTransactionToDate($transactionToDate);
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\SearchParameters
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get DeliveryMethodIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getDeliveryMethodIds()
    {
        return isset($this->DeliveryMethodIds) ? $this->DeliveryMethodIds : null;
    }
    /**
     * Set DeliveryMethodIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $deliveryMethodIds
     * @return \patest\StructType\SearchParameters
     */
    public function setDeliveryMethodIds(\patest\ArrayType\ArrayOfguid $deliveryMethodIds = null)
    {
        if (is_null($deliveryMethodIds) || (is_array($deliveryMethodIds) && empty($deliveryMethodIds))) {
            unset($this->DeliveryMethodIds);
        } else {
            $this->DeliveryMethodIds = $deliveryMethodIds;
        }
        return $this;
    }
    /**
     * Get EventExtendedData1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventExtendedData1()
    {
        return isset($this->EventExtendedData1) ? $this->EventExtendedData1 : null;
    }
    /**
     * Set EventExtendedData1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventExtendedData1
     * @return \patest\StructType\SearchParameters
     */
    public function setEventExtendedData1($eventExtendedData1 = null)
    {
        // validation for constraint: string
        if (!is_null($eventExtendedData1) && !is_string($eventExtendedData1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventExtendedData1, true), gettype($eventExtendedData1)), __LINE__);
        }
        if (is_null($eventExtendedData1) || (is_array($eventExtendedData1) && empty($eventExtendedData1))) {
            unset($this->EventExtendedData1);
        } else {
            $this->EventExtendedData1 = $eventExtendedData1;
        }
        return $this;
    }
    /**
     * Get EventFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventFromDate()
    {
        return isset($this->EventFromDate) ? $this->EventFromDate : null;
    }
    /**
     * Set EventFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventFromDate
     * @return \patest\StructType\SearchParameters
     */
    public function setEventFromDate($eventFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventFromDate) && !is_string($eventFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventFromDate, true), gettype($eventFromDate)), __LINE__);
        }
        if (is_null($eventFromDate) || (is_array($eventFromDate) && empty($eventFromDate))) {
            unset($this->EventFromDate);
        } else {
            $this->EventFromDate = $eventFromDate;
        }
        return $this;
    }
    /**
     * Get EventOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventOwnerId()
    {
        return isset($this->EventOwnerId) ? $this->EventOwnerId : null;
    }
    /**
     * Set EventOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventOwnerId
     * @return \patest\StructType\SearchParameters
     */
    public function setEventOwnerId($eventOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($eventOwnerId) && !is_string($eventOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventOwnerId, true), gettype($eventOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventOwnerId, true)), __LINE__);
        }
        if (is_null($eventOwnerId) || (is_array($eventOwnerId) && empty($eventOwnerId))) {
            unset($this->EventOwnerId);
        } else {
            $this->EventOwnerId = $eventOwnerId;
        }
        return $this;
    }
    /**
     * Get EventToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventToDate()
    {
        return isset($this->EventToDate) ? $this->EventToDate : null;
    }
    /**
     * Set EventToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventToDate
     * @return \patest\StructType\SearchParameters
     */
    public function setEventToDate($eventToDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventToDate) && !is_string($eventToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventToDate, true), gettype($eventToDate)), __LINE__);
        }
        if (is_null($eventToDate) || (is_array($eventToDate) && empty($eventToDate))) {
            unset($this->EventToDate);
        } else {
            $this->EventToDate = $eventToDate;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\SearchParameters
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get IncludeAgentTickets value
     * @return string|null
     */
    public function getIncludeAgentTickets()
    {
        return $this->IncludeAgentTickets;
    }
    /**
     * Set IncludeAgentTickets value
     * @uses \patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeAgentTickets
     * @return \patest\StructType\SearchParameters
     */
    public function setIncludeAgentTickets($includeAgentTickets = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy::valueIsValid($includeAgentTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy', is_array($includeAgentTickets) ? implode(', ', $includeAgentTickets) : var_export($includeAgentTickets, true), implode(', ', \patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy::getValidValues())), __LINE__);
        }
        $this->IncludeAgentTickets = $includeAgentTickets;
        return $this;
    }
    /**
     * Get IncludeLoadedOnCardTickets value
     * @return string|null
     */
    public function getIncludeLoadedOnCardTickets()
    {
        return $this->IncludeLoadedOnCardTickets;
    }
    /**
     * Set IncludeLoadedOnCardTickets value
     * @uses \patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeLoadedOnCardTickets
     * @return \patest\StructType\SearchParameters
     */
    public function setIncludeLoadedOnCardTickets($includeLoadedOnCardTickets = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy::valueIsValid($includeLoadedOnCardTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy', is_array($includeLoadedOnCardTickets) ? implode(', ', $includeLoadedOnCardTickets) : var_export($includeLoadedOnCardTickets, true), implode(', ', \patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy::getValidValues())), __LINE__);
        }
        $this->IncludeLoadedOnCardTickets = $includeLoadedOnCardTickets;
        return $this;
    }
    /**
     * Get IncludeMarketDriven value
     * @return bool|null
     */
    public function getIncludeMarketDriven()
    {
        return $this->IncludeMarketDriven;
    }
    /**
     * Set IncludeMarketDriven value
     * @param bool $includeMarketDriven
     * @return \patest\StructType\SearchParameters
     */
    public function setIncludeMarketDriven($includeMarketDriven = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeMarketDriven) && !is_bool($includeMarketDriven)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeMarketDriven, true), gettype($includeMarketDriven)), __LINE__);
        }
        $this->IncludeMarketDriven = $includeMarketDriven;
        return $this;
    }
    /**
     * Get IncludeMovedTickets value
     * @return string|null
     */
    public function getIncludeMovedTickets()
    {
        return $this->IncludeMovedTickets;
    }
    /**
     * Set IncludeMovedTickets value
     * @uses \patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeMovedTickets
     * @return \patest\StructType\SearchParameters
     */
    public function setIncludeMovedTickets($includeMovedTickets = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy::valueIsValid($includeMovedTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy', is_array($includeMovedTickets) ? implode(', ', $includeMovedTickets) : var_export($includeMovedTickets, true), implode(', ', \patest\EnumType\BatchPrintIncludeLoadedOnCardTicketsPolicy::getValidValues())), __LINE__);
        }
        $this->IncludeMovedTickets = $includeMovedTickets;
        return $this;
    }
    /**
     * Get IncludeTicketsInSubscription value
     * @return string|null
     */
    public function getIncludeTicketsInSubscription()
    {
        return $this->IncludeTicketsInSubscription;
    }
    /**
     * Set IncludeTicketsInSubscription value
     * @uses \patest\EnumType\BatchPrintIncludeTicketsInSubscriptionPolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintIncludeTicketsInSubscriptionPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeTicketsInSubscription
     * @return \patest\StructType\SearchParameters
     */
    public function setIncludeTicketsInSubscription($includeTicketsInSubscription = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintIncludeTicketsInSubscriptionPolicy::valueIsValid($includeTicketsInSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintIncludeTicketsInSubscriptionPolicy', is_array($includeTicketsInSubscription) ? implode(', ', $includeTicketsInSubscription) : var_export($includeTicketsInSubscription, true), implode(', ', \patest\EnumType\BatchPrintIncludeTicketsInSubscriptionPolicy::getValidValues())), __LINE__);
        }
        $this->IncludeTicketsInSubscription = $includeTicketsInSubscription;
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\SearchParameters
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get SiteLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSiteLocalId()
    {
        return isset($this->SiteLocalId) ? $this->SiteLocalId : null;
    }
    /**
     * Set SiteLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $siteLocalId
     * @return \patest\StructType\SearchParameters
     */
    public function setSiteLocalId($siteLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($siteLocalId) && !(is_int($siteLocalId) || ctype_digit($siteLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siteLocalId, true), gettype($siteLocalId)), __LINE__);
        }
        if (is_null($siteLocalId) || (is_array($siteLocalId) && empty($siteLocalId))) {
            unset($this->SiteLocalId);
        } else {
            $this->SiteLocalId = $siteLocalId;
        }
        return $this;
    }
    /**
     * Get TransactionFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionFromDate()
    {
        return isset($this->TransactionFromDate) ? $this->TransactionFromDate : null;
    }
    /**
     * Set TransactionFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionFromDate
     * @return \patest\StructType\SearchParameters
     */
    public function setTransactionFromDate($transactionFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionFromDate) && !is_string($transactionFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionFromDate, true), gettype($transactionFromDate)), __LINE__);
        }
        if (is_null($transactionFromDate) || (is_array($transactionFromDate) && empty($transactionFromDate))) {
            unset($this->TransactionFromDate);
        } else {
            $this->TransactionFromDate = $transactionFromDate;
        }
        return $this;
    }
    /**
     * Get TransactionToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionToDate()
    {
        return isset($this->TransactionToDate) ? $this->TransactionToDate : null;
    }
    /**
     * Set TransactionToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionToDate
     * @return \patest\StructType\SearchParameters
     */
    public function setTransactionToDate($transactionToDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionToDate) && !is_string($transactionToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionToDate, true), gettype($transactionToDate)), __LINE__);
        }
        if (is_null($transactionToDate) || (is_array($transactionToDate) && empty($transactionToDate))) {
            unset($this->TransactionToDate);
        } else {
            $this->TransactionToDate = $transactionToDate;
        }
        return $this;
    }
}
