<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScanBarcodeResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ScanBarcodeResponse
 * @subpackage Structs
 */
class ScanBarcodeResponse extends ExtensibleDataContract
{
    /**
     * The BarcodeInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AnyEntity
     */
    public $BarcodeInfo;
    /**
     * The BarcodeInfoPreparedText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeInfoPreparedText;
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Color;
    /**
     * The FaultCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FaultCode;
    /**
     * The FaultDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $FaultDescription;
    /**
     * The SoundFileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SoundFileName;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Success;
    /**
     * Constructor method for ScanBarcodeResponse
     * @uses ScanBarcodeResponse::setBarcodeInfo()
     * @uses ScanBarcodeResponse::setBarcodeInfoPreparedText()
     * @uses ScanBarcodeResponse::setColor()
     * @uses ScanBarcodeResponse::setFaultCode()
     * @uses ScanBarcodeResponse::setFaultDescription()
     * @uses ScanBarcodeResponse::setSoundFileName()
     * @uses ScanBarcodeResponse::setSuccess()
     * @param \patest\StructType\AnyEntity $barcodeInfo
     * @param string $barcodeInfoPreparedText
     * @param string $color
     * @param string $faultCode
     * @param \patest\StructType\GlobalString $faultDescription
     * @param string $soundFileName
     * @param bool $success
     */
    public function __construct(\patest\StructType\AnyEntity $barcodeInfo = null, $barcodeInfoPreparedText = null, $color = null, $faultCode = null, \patest\StructType\GlobalString $faultDescription = null, $soundFileName = null, $success = null)
    {
        $this
            ->setBarcodeInfo($barcodeInfo)
            ->setBarcodeInfoPreparedText($barcodeInfoPreparedText)
            ->setColor($color)
            ->setFaultCode($faultCode)
            ->setFaultDescription($faultDescription)
            ->setSoundFileName($soundFileName)
            ->setSuccess($success);
    }
    /**
     * Get BarcodeInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AnyEntity|null
     */
    public function getBarcodeInfo()
    {
        return isset($this->BarcodeInfo) ? $this->BarcodeInfo : null;
    }
    /**
     * Set BarcodeInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AnyEntity $barcodeInfo
     * @return \patest\StructType\ScanBarcodeResponse
     */
    public function setBarcodeInfo(\patest\StructType\AnyEntity $barcodeInfo = null)
    {
        if (is_null($barcodeInfo) || (is_array($barcodeInfo) && empty($barcodeInfo))) {
            unset($this->BarcodeInfo);
        } else {
            $this->BarcodeInfo = $barcodeInfo;
        }
        return $this;
    }
    /**
     * Get BarcodeInfoPreparedText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeInfoPreparedText()
    {
        return isset($this->BarcodeInfoPreparedText) ? $this->BarcodeInfoPreparedText : null;
    }
    /**
     * Set BarcodeInfoPreparedText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeInfoPreparedText
     * @return \patest\StructType\ScanBarcodeResponse
     */
    public function setBarcodeInfoPreparedText($barcodeInfoPreparedText = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeInfoPreparedText) && !is_string($barcodeInfoPreparedText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeInfoPreparedText, true), gettype($barcodeInfoPreparedText)), __LINE__);
        }
        if (is_null($barcodeInfoPreparedText) || (is_array($barcodeInfoPreparedText) && empty($barcodeInfoPreparedText))) {
            unset($this->BarcodeInfoPreparedText);
        } else {
            $this->BarcodeInfoPreparedText = $barcodeInfoPreparedText;
        }
        return $this;
    }
    /**
     * Get Color value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getColor()
    {
        return isset($this->Color) ? $this->Color : null;
    }
    /**
     * Set Color value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $color
     * @return \patest\StructType\ScanBarcodeResponse
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        if (is_null($color) || (is_array($color) && empty($color))) {
            unset($this->Color);
        } else {
            $this->Color = $color;
        }
        return $this;
    }
    /**
     * Get FaultCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaultCode()
    {
        return isset($this->FaultCode) ? $this->FaultCode : null;
    }
    /**
     * Set FaultCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faultCode
     * @return \patest\StructType\ScanBarcodeResponse
     */
    public function setFaultCode($faultCode = null)
    {
        // validation for constraint: string
        if (!is_null($faultCode) && !is_string($faultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultCode, true), gettype($faultCode)), __LINE__);
        }
        if (is_null($faultCode) || (is_array($faultCode) && empty($faultCode))) {
            unset($this->FaultCode);
        } else {
            $this->FaultCode = $faultCode;
        }
        return $this;
    }
    /**
     * Get FaultDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFaultDescription()
    {
        return isset($this->FaultDescription) ? $this->FaultDescription : null;
    }
    /**
     * Set FaultDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $faultDescription
     * @return \patest\StructType\ScanBarcodeResponse
     */
    public function setFaultDescription(\patest\StructType\GlobalString $faultDescription = null)
    {
        if (is_null($faultDescription) || (is_array($faultDescription) && empty($faultDescription))) {
            unset($this->FaultDescription);
        } else {
            $this->FaultDescription = $faultDescription;
        }
        return $this;
    }
    /**
     * Get SoundFileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoundFileName()
    {
        return isset($this->SoundFileName) ? $this->SoundFileName : null;
    }
    /**
     * Set SoundFileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $soundFileName
     * @return \patest\StructType\ScanBarcodeResponse
     */
    public function setSoundFileName($soundFileName = null)
    {
        // validation for constraint: string
        if (!is_null($soundFileName) && !is_string($soundFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soundFileName, true), gettype($soundFileName)), __LINE__);
        }
        if (is_null($soundFileName) || (is_array($soundFileName) && empty($soundFileName))) {
            unset($this->SoundFileName);
        } else {
            $this->SoundFileName = $soundFileName;
        }
        return $this;
    }
    /**
     * Get Success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \patest\StructType\ScanBarcodeResponse
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
}
