<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.UnpaidItemsFilter StructType
 * @subpackage Structs
 */
class Sales_UnpaidItemsFilter extends FilterEntity
{
    /**
     * The FromDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDateTime;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemName;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The ToDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDateTime;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The UnpaidAmountGreaterThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UnpaidAmountGreaterThan;
    /**
     * The UnpaidAmountLessThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UnpaidAmountLessThan;
    /**
     * The UnpaidAmountType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnpaidAmountType;
    /**
     * Constructor method for Sales.UnpaidItemsFilter
     * @uses Sales_UnpaidItemsFilter::setFromDateTime()
     * @uses Sales_UnpaidItemsFilter::setItemName()
     * @uses Sales_UnpaidItemsFilter::setItemType()
     * @uses Sales_UnpaidItemsFilter::setToDateTime()
     * @uses Sales_UnpaidItemsFilter::setTransactionNumber()
     * @uses Sales_UnpaidItemsFilter::setUnpaidAmountGreaterThan()
     * @uses Sales_UnpaidItemsFilter::setUnpaidAmountLessThan()
     * @uses Sales_UnpaidItemsFilter::setUnpaidAmountType()
     * @param string $fromDateTime
     * @param string $itemName
     * @param int $itemType
     * @param string $toDateTime
     * @param int $transactionNumber
     * @param int $unpaidAmountGreaterThan
     * @param int $unpaidAmountLessThan
     * @param string $unpaidAmountType
     */
    public function __construct($fromDateTime = null, $itemName = null, $itemType = null, $toDateTime = null, $transactionNumber = null, $unpaidAmountGreaterThan = null, $unpaidAmountLessThan = null, $unpaidAmountType = null)
    {
        $this
            ->setFromDateTime($fromDateTime)
            ->setItemName($itemName)
            ->setItemType($itemType)
            ->setToDateTime($toDateTime)
            ->setTransactionNumber($transactionNumber)
            ->setUnpaidAmountGreaterThan($unpaidAmountGreaterThan)
            ->setUnpaidAmountLessThan($unpaidAmountLessThan)
            ->setUnpaidAmountType($unpaidAmountType);
    }
    /**
     * Get FromDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDateTime()
    {
        return isset($this->FromDateTime) ? $this->FromDateTime : null;
    }
    /**
     * Set FromDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDateTime
     * @return \patest\StructType\Sales_UnpaidItemsFilter
     */
    public function setFromDateTime($fromDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($fromDateTime) && !is_string($fromDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDateTime, true), gettype($fromDateTime)), __LINE__);
        }
        if (is_null($fromDateTime) || (is_array($fromDateTime) && empty($fromDateTime))) {
            unset($this->FromDateTime);
        } else {
            $this->FromDateTime = $fromDateTime;
        }
        return $this;
    }
    /**
     * Get ItemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemName()
    {
        return isset($this->ItemName) ? $this->ItemName : null;
    }
    /**
     * Set ItemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemName
     * @return \patest\StructType\Sales_UnpaidItemsFilter
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        if (is_null($itemName) || (is_array($itemName) && empty($itemName))) {
            unset($this->ItemName);
        } else {
            $this->ItemName = $itemName;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Sales_UnpaidItemsFilter
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get ToDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDateTime()
    {
        return isset($this->ToDateTime) ? $this->ToDateTime : null;
    }
    /**
     * Set ToDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDateTime
     * @return \patest\StructType\Sales_UnpaidItemsFilter
     */
    public function setToDateTime($toDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($toDateTime) && !is_string($toDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDateTime, true), gettype($toDateTime)), __LINE__);
        }
        if (is_null($toDateTime) || (is_array($toDateTime) && empty($toDateTime))) {
            unset($this->ToDateTime);
        } else {
            $this->ToDateTime = $toDateTime;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Sales_UnpaidItemsFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get UnpaidAmountGreaterThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUnpaidAmountGreaterThan()
    {
        return isset($this->UnpaidAmountGreaterThan) ? $this->UnpaidAmountGreaterThan : null;
    }
    /**
     * Set UnpaidAmountGreaterThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $unpaidAmountGreaterThan
     * @return \patest\StructType\Sales_UnpaidItemsFilter
     */
    public function setUnpaidAmountGreaterThan($unpaidAmountGreaterThan = null)
    {
        // validation for constraint: int
        if (!is_null($unpaidAmountGreaterThan) && !(is_int($unpaidAmountGreaterThan) || ctype_digit($unpaidAmountGreaterThan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unpaidAmountGreaterThan, true), gettype($unpaidAmountGreaterThan)), __LINE__);
        }
        if (is_null($unpaidAmountGreaterThan) || (is_array($unpaidAmountGreaterThan) && empty($unpaidAmountGreaterThan))) {
            unset($this->UnpaidAmountGreaterThan);
        } else {
            $this->UnpaidAmountGreaterThan = $unpaidAmountGreaterThan;
        }
        return $this;
    }
    /**
     * Get UnpaidAmountLessThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUnpaidAmountLessThan()
    {
        return isset($this->UnpaidAmountLessThan) ? $this->UnpaidAmountLessThan : null;
    }
    /**
     * Set UnpaidAmountLessThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $unpaidAmountLessThan
     * @return \patest\StructType\Sales_UnpaidItemsFilter
     */
    public function setUnpaidAmountLessThan($unpaidAmountLessThan = null)
    {
        // validation for constraint: int
        if (!is_null($unpaidAmountLessThan) && !(is_int($unpaidAmountLessThan) || ctype_digit($unpaidAmountLessThan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unpaidAmountLessThan, true), gettype($unpaidAmountLessThan)), __LINE__);
        }
        if (is_null($unpaidAmountLessThan) || (is_array($unpaidAmountLessThan) && empty($unpaidAmountLessThan))) {
            unset($this->UnpaidAmountLessThan);
        } else {
            $this->UnpaidAmountLessThan = $unpaidAmountLessThan;
        }
        return $this;
    }
    /**
     * Get UnpaidAmountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnpaidAmountType()
    {
        return isset($this->UnpaidAmountType) ? $this->UnpaidAmountType : null;
    }
    /**
     * Set UnpaidAmountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\UnpaidFilterType::valueIsValid()
     * @uses \patest\EnumType\UnpaidFilterType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unpaidAmountType
     * @return \patest\StructType\Sales_UnpaidItemsFilter
     */
    public function setUnpaidAmountType($unpaidAmountType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\UnpaidFilterType::valueIsValid($unpaidAmountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\UnpaidFilterType', is_array($unpaidAmountType) ? implode(', ', $unpaidAmountType) : var_export($unpaidAmountType, true), implode(', ', \patest\EnumType\UnpaidFilterType::getValidValues())), __LINE__);
        }
        if (is_null($unpaidAmountType) || (is_array($unpaidAmountType) && empty($unpaidAmountType))) {
            unset($this->UnpaidAmountType);
        } else {
            $this->UnpaidAmountType = $unpaidAmountType;
        }
        return $this;
    }
}
