<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.Transaction StructType
 * @subpackage Structs
 */
class Sales_Transaction extends DistributableEntity
{
    /**
     * The AccountContactPersonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountContactPersonId;
    /**
     * The AccountGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountGroupId;
    /**
     * The AccountingJournalEntriesCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AccountingJournalEntriesCount;
    /**
     * The AccountingJournalError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountingJournalError;
    /**
     * The AccountingJournalStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountingJournalStatus;
    /**
     * The AgencyAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgencyAccountId;
    /**
     * The AgencyContactPersonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgencyContactPersonId;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The Basket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_Basket
     */
    public $Basket;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CommitDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDate;
    /**
     * The CompanyCommitDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyCommitDate;
    /**
     * The ConfirmationShiftGlobalNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConfirmationShiftGlobalNumber;
    /**
     * The ConfirmationShiftId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConfirmationShiftId;
    /**
     * The ConnectionAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConnectionAuditId;
    /**
     * The CreditNoteId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreditNoteId;
    /**
     * The CreditNoteNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreditNoteNumber;
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraInfo;
    /**
     * The ForeignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForeignId;
    /**
     * The InteractionChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InteractionChannel;
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvoiceId;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InvoiceNumber;
    /**
     * The InvoiceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceType;
    /**
     * The IsPrintable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrintable;
    /**
     * The LiaPmStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LiaPmStatus;
    /**
     * The LiaStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LiaStatus;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The OnBehalfOfAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OnBehalfOfAccountId;
    /**
     * The PaymentBreakdown
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentBreakdown;
    /**
     * The PurposeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PurposeId;
    /**
     * The RecoAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RecoAccountId;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The RetailerCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RetailerCompanyId;
    /**
     * The RetailerTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RetailerTransactionNumber;
    /**
     * The SaleModeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleModeId;
    /**
     * The SellerBranchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SellerBranchId;
    /**
     * The SellerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SellerId;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The SupplierIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SupplierIds
     */
    public $SupplierIds;
    /**
     * The TotalActualPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalActualPayment;
    /**
     * The TotalTransactionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalTransactionValue;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The UserOfAffiliateAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserOfAffiliateAccountId;
    /**
     * The WorkflowType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkflowType;
    /**
     * The WorkShiftGlobalNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WorkShiftGlobalNumber;
    /**
     * The WorkShiftId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WorkShiftId;
    /**
     * Constructor method for Sales.Transaction
     * @uses Sales_Transaction::setAccountContactPersonId()
     * @uses Sales_Transaction::setAccountGroupId()
     * @uses Sales_Transaction::setAccountingJournalEntriesCount()
     * @uses Sales_Transaction::setAccountingJournalError()
     * @uses Sales_Transaction::setAccountingJournalStatus()
     * @uses Sales_Transaction::setAgencyAccountId()
     * @uses Sales_Transaction::setAgencyContactPersonId()
     * @uses Sales_Transaction::setApplicationChannel()
     * @uses Sales_Transaction::setBasket()
     * @uses Sales_Transaction::setClientId()
     * @uses Sales_Transaction::setCommitDate()
     * @uses Sales_Transaction::setCompanyCommitDate()
     * @uses Sales_Transaction::setConfirmationShiftGlobalNumber()
     * @uses Sales_Transaction::setConfirmationShiftId()
     * @uses Sales_Transaction::setConnectionAuditId()
     * @uses Sales_Transaction::setCreditNoteId()
     * @uses Sales_Transaction::setCreditNoteNumber()
     * @uses Sales_Transaction::setExtraInfo()
     * @uses Sales_Transaction::setForeignId()
     * @uses Sales_Transaction::setInteractionChannel()
     * @uses Sales_Transaction::setInvoiceId()
     * @uses Sales_Transaction::setInvoiceNumber()
     * @uses Sales_Transaction::setInvoiceType()
     * @uses Sales_Transaction::setIsPrintable()
     * @uses Sales_Transaction::setLiaPmStatus()
     * @uses Sales_Transaction::setLiaStatus()
     * @uses Sales_Transaction::setNotes()
     * @uses Sales_Transaction::setOnBehalfOfAccountId()
     * @uses Sales_Transaction::setPaymentBreakdown()
     * @uses Sales_Transaction::setPurposeId()
     * @uses Sales_Transaction::setRecoAccountId()
     * @uses Sales_Transaction::setReferenceNumber()
     * @uses Sales_Transaction::setRetailerCompanyId()
     * @uses Sales_Transaction::setRetailerTransactionNumber()
     * @uses Sales_Transaction::setSaleModeId()
     * @uses Sales_Transaction::setSellerBranchId()
     * @uses Sales_Transaction::setSellerId()
     * @uses Sales_Transaction::setState()
     * @uses Sales_Transaction::setSupplierIds()
     * @uses Sales_Transaction::setTotalActualPayment()
     * @uses Sales_Transaction::setTotalTransactionValue()
     * @uses Sales_Transaction::setTransactionNumber()
     * @uses Sales_Transaction::setUserOfAffiliateAccountId()
     * @uses Sales_Transaction::setWorkflowType()
     * @uses Sales_Transaction::setWorkShiftGlobalNumber()
     * @uses Sales_Transaction::setWorkShiftId()
     * @param string $accountContactPersonId
     * @param string $accountGroupId
     * @param int $accountingJournalEntriesCount
     * @param string $accountingJournalError
     * @param string $accountingJournalStatus
     * @param string $agencyAccountId
     * @param string $agencyContactPersonId
     * @param string $applicationChannel
     * @param \patest\StructType\Sales_Basket $basket
     * @param string $clientId
     * @param string $commitDate
     * @param string $companyCommitDate
     * @param int $confirmationShiftGlobalNumber
     * @param int $confirmationShiftId
     * @param int $connectionAuditId
     * @param string $creditNoteId
     * @param int $creditNoteNumber
     * @param string $extraInfo
     * @param string $foreignId
     * @param string $interactionChannel
     * @param string $invoiceId
     * @param int $invoiceNumber
     * @param string $invoiceType
     * @param bool $isPrintable
     * @param string $liaPmStatus
     * @param string $liaStatus
     * @param string $notes
     * @param string $onBehalfOfAccountId
     * @param string $paymentBreakdown
     * @param int $purposeId
     * @param string $recoAccountId
     * @param int $referenceNumber
     * @param int $retailerCompanyId
     * @param int $retailerTransactionNumber
     * @param string $saleModeId
     * @param string $sellerBranchId
     * @param string $sellerId
     * @param string $state
     * @param \patest\StructType\SupplierIds $supplierIds
     * @param \patest\StructType\Money $totalActualPayment
     * @param \patest\StructType\Money $totalTransactionValue
     * @param int $transactionNumber
     * @param string $userOfAffiliateAccountId
     * @param string $workflowType
     * @param int $workShiftGlobalNumber
     * @param int $workShiftId
     */
    public function __construct($accountContactPersonId = null, $accountGroupId = null, $accountingJournalEntriesCount = null, $accountingJournalError = null, $accountingJournalStatus = null, $agencyAccountId = null, $agencyContactPersonId = null, $applicationChannel = null, \patest\StructType\Sales_Basket $basket = null, $clientId = null, $commitDate = null, $companyCommitDate = null, $confirmationShiftGlobalNumber = null, $confirmationShiftId = null, $connectionAuditId = null, $creditNoteId = null, $creditNoteNumber = null, $extraInfo = null, $foreignId = null, $interactionChannel = null, $invoiceId = null, $invoiceNumber = null, $invoiceType = null, $isPrintable = null, $liaPmStatus = null, $liaStatus = null, $notes = null, $onBehalfOfAccountId = null, $paymentBreakdown = null, $purposeId = null, $recoAccountId = null, $referenceNumber = null, $retailerCompanyId = null, $retailerTransactionNumber = null, $saleModeId = null, $sellerBranchId = null, $sellerId = null, $state = null, \patest\StructType\SupplierIds $supplierIds = null, \patest\StructType\Money $totalActualPayment = null, \patest\StructType\Money $totalTransactionValue = null, $transactionNumber = null, $userOfAffiliateAccountId = null, $workflowType = null, $workShiftGlobalNumber = null, $workShiftId = null)
    {
        $this
            ->setAccountContactPersonId($accountContactPersonId)
            ->setAccountGroupId($accountGroupId)
            ->setAccountingJournalEntriesCount($accountingJournalEntriesCount)
            ->setAccountingJournalError($accountingJournalError)
            ->setAccountingJournalStatus($accountingJournalStatus)
            ->setAgencyAccountId($agencyAccountId)
            ->setAgencyContactPersonId($agencyContactPersonId)
            ->setApplicationChannel($applicationChannel)
            ->setBasket($basket)
            ->setClientId($clientId)
            ->setCommitDate($commitDate)
            ->setCompanyCommitDate($companyCommitDate)
            ->setConfirmationShiftGlobalNumber($confirmationShiftGlobalNumber)
            ->setConfirmationShiftId($confirmationShiftId)
            ->setConnectionAuditId($connectionAuditId)
            ->setCreditNoteId($creditNoteId)
            ->setCreditNoteNumber($creditNoteNumber)
            ->setExtraInfo($extraInfo)
            ->setForeignId($foreignId)
            ->setInteractionChannel($interactionChannel)
            ->setInvoiceId($invoiceId)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceType($invoiceType)
            ->setIsPrintable($isPrintable)
            ->setLiaPmStatus($liaPmStatus)
            ->setLiaStatus($liaStatus)
            ->setNotes($notes)
            ->setOnBehalfOfAccountId($onBehalfOfAccountId)
            ->setPaymentBreakdown($paymentBreakdown)
            ->setPurposeId($purposeId)
            ->setRecoAccountId($recoAccountId)
            ->setReferenceNumber($referenceNumber)
            ->setRetailerCompanyId($retailerCompanyId)
            ->setRetailerTransactionNumber($retailerTransactionNumber)
            ->setSaleModeId($saleModeId)
            ->setSellerBranchId($sellerBranchId)
            ->setSellerId($sellerId)
            ->setState($state)
            ->setSupplierIds($supplierIds)
            ->setTotalActualPayment($totalActualPayment)
            ->setTotalTransactionValue($totalTransactionValue)
            ->setTransactionNumber($transactionNumber)
            ->setUserOfAffiliateAccountId($userOfAffiliateAccountId)
            ->setWorkflowType($workflowType)
            ->setWorkShiftGlobalNumber($workShiftGlobalNumber)
            ->setWorkShiftId($workShiftId);
    }
    /**
     * Get AccountContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountContactPersonId()
    {
        return isset($this->AccountContactPersonId) ? $this->AccountContactPersonId : null;
    }
    /**
     * Set AccountContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountContactPersonId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setAccountContactPersonId($accountContactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($accountContactPersonId) && !is_string($accountContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountContactPersonId, true), gettype($accountContactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountContactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountContactPersonId, true)), __LINE__);
        }
        if (is_null($accountContactPersonId) || (is_array($accountContactPersonId) && empty($accountContactPersonId))) {
            unset($this->AccountContactPersonId);
        } else {
            $this->AccountContactPersonId = $accountContactPersonId;
        }
        return $this;
    }
    /**
     * Get AccountGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountGroupId()
    {
        return isset($this->AccountGroupId) ? $this->AccountGroupId : null;
    }
    /**
     * Set AccountGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountGroupId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setAccountGroupId($accountGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($accountGroupId) && !is_string($accountGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountGroupId, true), gettype($accountGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountGroupId, true)), __LINE__);
        }
        if (is_null($accountGroupId) || (is_array($accountGroupId) && empty($accountGroupId))) {
            unset($this->AccountGroupId);
        } else {
            $this->AccountGroupId = $accountGroupId;
        }
        return $this;
    }
    /**
     * Get AccountingJournalEntriesCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAccountingJournalEntriesCount()
    {
        return isset($this->AccountingJournalEntriesCount) ? $this->AccountingJournalEntriesCount : null;
    }
    /**
     * Set AccountingJournalEntriesCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $accountingJournalEntriesCount
     * @return \patest\StructType\Sales_Transaction
     */
    public function setAccountingJournalEntriesCount($accountingJournalEntriesCount = null)
    {
        // validation for constraint: int
        if (!is_null($accountingJournalEntriesCount) && !(is_int($accountingJournalEntriesCount) || ctype_digit($accountingJournalEntriesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountingJournalEntriesCount, true), gettype($accountingJournalEntriesCount)), __LINE__);
        }
        if (is_null($accountingJournalEntriesCount) || (is_array($accountingJournalEntriesCount) && empty($accountingJournalEntriesCount))) {
            unset($this->AccountingJournalEntriesCount);
        } else {
            $this->AccountingJournalEntriesCount = $accountingJournalEntriesCount;
        }
        return $this;
    }
    /**
     * Get AccountingJournalError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountingJournalError()
    {
        return isset($this->AccountingJournalError) ? $this->AccountingJournalError : null;
    }
    /**
     * Set AccountingJournalError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountingJournalError
     * @return \patest\StructType\Sales_Transaction
     */
    public function setAccountingJournalError($accountingJournalError = null)
    {
        // validation for constraint: string
        if (!is_null($accountingJournalError) && !is_string($accountingJournalError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountingJournalError, true), gettype($accountingJournalError)), __LINE__);
        }
        if (is_null($accountingJournalError) || (is_array($accountingJournalError) && empty($accountingJournalError))) {
            unset($this->AccountingJournalError);
        } else {
            $this->AccountingJournalError = $accountingJournalError;
        }
        return $this;
    }
    /**
     * Get AccountingJournalStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountingJournalStatus()
    {
        return isset($this->AccountingJournalStatus) ? $this->AccountingJournalStatus : null;
    }
    /**
     * Set AccountingJournalStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccountingJournalTransactionStatus::valueIsValid()
     * @uses \patest\EnumType\AccountingJournalTransactionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountingJournalStatus
     * @return \patest\StructType\Sales_Transaction
     */
    public function setAccountingJournalStatus($accountingJournalStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccountingJournalTransactionStatus::valueIsValid($accountingJournalStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccountingJournalTransactionStatus', is_array($accountingJournalStatus) ? implode(', ', $accountingJournalStatus) : var_export($accountingJournalStatus, true), implode(', ', \patest\EnumType\AccountingJournalTransactionStatus::getValidValues())), __LINE__);
        }
        if (is_null($accountingJournalStatus) || (is_array($accountingJournalStatus) && empty($accountingJournalStatus))) {
            unset($this->AccountingJournalStatus);
        } else {
            $this->AccountingJournalStatus = $accountingJournalStatus;
        }
        return $this;
    }
    /**
     * Get AgencyAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyAccountId()
    {
        return isset($this->AgencyAccountId) ? $this->AgencyAccountId : null;
    }
    /**
     * Set AgencyAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyAccountId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setAgencyAccountId($agencyAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($agencyAccountId) && !is_string($agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyAccountId, true), gettype($agencyAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agencyAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agencyAccountId, true)), __LINE__);
        }
        if (is_null($agencyAccountId) || (is_array($agencyAccountId) && empty($agencyAccountId))) {
            unset($this->AgencyAccountId);
        } else {
            $this->AgencyAccountId = $agencyAccountId;
        }
        return $this;
    }
    /**
     * Get AgencyContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyContactPersonId()
    {
        return isset($this->AgencyContactPersonId) ? $this->AgencyContactPersonId : null;
    }
    /**
     * Set AgencyContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyContactPersonId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setAgencyContactPersonId($agencyContactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($agencyContactPersonId) && !is_string($agencyContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyContactPersonId, true), gettype($agencyContactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agencyContactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agencyContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agencyContactPersonId, true)), __LINE__);
        }
        if (is_null($agencyContactPersonId) || (is_array($agencyContactPersonId) && empty($agencyContactPersonId))) {
            unset($this->AgencyContactPersonId);
        } else {
            $this->AgencyContactPersonId = $agencyContactPersonId;
        }
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Sales_Transaction
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get Basket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_Basket|null
     */
    public function getBasket()
    {
        return isset($this->Basket) ? $this->Basket : null;
    }
    /**
     * Set Basket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_Basket $basket
     * @return \patest\StructType\Sales_Transaction
     */
    public function setBasket(\patest\StructType\Sales_Basket $basket = null)
    {
        if (is_null($basket) || (is_array($basket) && empty($basket))) {
            unset($this->Basket);
        } else {
            $this->Basket = $basket;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CommitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDate()
    {
        return isset($this->CommitDate) ? $this->CommitDate : null;
    }
    /**
     * Set CommitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDate
     * @return \patest\StructType\Sales_Transaction
     */
    public function setCommitDate($commitDate = null)
    {
        // validation for constraint: string
        if (!is_null($commitDate) && !is_string($commitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDate, true), gettype($commitDate)), __LINE__);
        }
        if (is_null($commitDate) || (is_array($commitDate) && empty($commitDate))) {
            unset($this->CommitDate);
        } else {
            $this->CommitDate = $commitDate;
        }
        return $this;
    }
    /**
     * Get CompanyCommitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyCommitDate()
    {
        return isset($this->CompanyCommitDate) ? $this->CompanyCommitDate : null;
    }
    /**
     * Set CompanyCommitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyCommitDate
     * @return \patest\StructType\Sales_Transaction
     */
    public function setCompanyCommitDate($companyCommitDate = null)
    {
        // validation for constraint: string
        if (!is_null($companyCommitDate) && !is_string($companyCommitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCommitDate, true), gettype($companyCommitDate)), __LINE__);
        }
        if (is_null($companyCommitDate) || (is_array($companyCommitDate) && empty($companyCommitDate))) {
            unset($this->CompanyCommitDate);
        } else {
            $this->CompanyCommitDate = $companyCommitDate;
        }
        return $this;
    }
    /**
     * Get ConfirmationShiftGlobalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConfirmationShiftGlobalNumber()
    {
        return isset($this->ConfirmationShiftGlobalNumber) ? $this->ConfirmationShiftGlobalNumber : null;
    }
    /**
     * Set ConfirmationShiftGlobalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $confirmationShiftGlobalNumber
     * @return \patest\StructType\Sales_Transaction
     */
    public function setConfirmationShiftGlobalNumber($confirmationShiftGlobalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($confirmationShiftGlobalNumber) && !(is_int($confirmationShiftGlobalNumber) || ctype_digit($confirmationShiftGlobalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($confirmationShiftGlobalNumber, true), gettype($confirmationShiftGlobalNumber)), __LINE__);
        }
        if (is_null($confirmationShiftGlobalNumber) || (is_array($confirmationShiftGlobalNumber) && empty($confirmationShiftGlobalNumber))) {
            unset($this->ConfirmationShiftGlobalNumber);
        } else {
            $this->ConfirmationShiftGlobalNumber = $confirmationShiftGlobalNumber;
        }
        return $this;
    }
    /**
     * Get ConfirmationShiftId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConfirmationShiftId()
    {
        return isset($this->ConfirmationShiftId) ? $this->ConfirmationShiftId : null;
    }
    /**
     * Set ConfirmationShiftId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $confirmationShiftId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setConfirmationShiftId($confirmationShiftId = null)
    {
        // validation for constraint: int
        if (!is_null($confirmationShiftId) && !(is_int($confirmationShiftId) || ctype_digit($confirmationShiftId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($confirmationShiftId, true), gettype($confirmationShiftId)), __LINE__);
        }
        if (is_null($confirmationShiftId) || (is_array($confirmationShiftId) && empty($confirmationShiftId))) {
            unset($this->ConfirmationShiftId);
        } else {
            $this->ConfirmationShiftId = $confirmationShiftId;
        }
        return $this;
    }
    /**
     * Get ConnectionAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConnectionAuditId()
    {
        return isset($this->ConnectionAuditId) ? $this->ConnectionAuditId : null;
    }
    /**
     * Set ConnectionAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $connectionAuditId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setConnectionAuditId($connectionAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($connectionAuditId) && !(is_int($connectionAuditId) || ctype_digit($connectionAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($connectionAuditId, true), gettype($connectionAuditId)), __LINE__);
        }
        if (is_null($connectionAuditId) || (is_array($connectionAuditId) && empty($connectionAuditId))) {
            unset($this->ConnectionAuditId);
        } else {
            $this->ConnectionAuditId = $connectionAuditId;
        }
        return $this;
    }
    /**
     * Get CreditNoteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditNoteId()
    {
        return isset($this->CreditNoteId) ? $this->CreditNoteId : null;
    }
    /**
     * Set CreditNoteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditNoteId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setCreditNoteId($creditNoteId = null)
    {
        // validation for constraint: string
        if (!is_null($creditNoteId) && !is_string($creditNoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditNoteId, true), gettype($creditNoteId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($creditNoteId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $creditNoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($creditNoteId, true)), __LINE__);
        }
        if (is_null($creditNoteId) || (is_array($creditNoteId) && empty($creditNoteId))) {
            unset($this->CreditNoteId);
        } else {
            $this->CreditNoteId = $creditNoteId;
        }
        return $this;
    }
    /**
     * Get CreditNoteNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreditNoteNumber()
    {
        return isset($this->CreditNoteNumber) ? $this->CreditNoteNumber : null;
    }
    /**
     * Set CreditNoteNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creditNoteNumber
     * @return \patest\StructType\Sales_Transaction
     */
    public function setCreditNoteNumber($creditNoteNumber = null)
    {
        // validation for constraint: int
        if (!is_null($creditNoteNumber) && !(is_int($creditNoteNumber) || ctype_digit($creditNoteNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creditNoteNumber, true), gettype($creditNoteNumber)), __LINE__);
        }
        if (is_null($creditNoteNumber) || (is_array($creditNoteNumber) && empty($creditNoteNumber))) {
            unset($this->CreditNoteNumber);
        } else {
            $this->CreditNoteNumber = $creditNoteNumber;
        }
        return $this;
    }
    /**
     * Get ExtraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * Set ExtraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraInfo
     * @return \patest\StructType\Sales_Transaction
     */
    public function setExtraInfo($extraInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extraInfo) && !is_string($extraInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInfo, true), gettype($extraInfo)), __LINE__);
        }
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Get ForeignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForeignId()
    {
        return isset($this->ForeignId) ? $this->ForeignId : null;
    }
    /**
     * Set ForeignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $foreignId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setForeignId($foreignId = null)
    {
        // validation for constraint: string
        if (!is_null($foreignId) && !is_string($foreignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foreignId, true), gettype($foreignId)), __LINE__);
        }
        if (is_null($foreignId) || (is_array($foreignId) && empty($foreignId))) {
            unset($this->ForeignId);
        } else {
            $this->ForeignId = $foreignId;
        }
        return $this;
    }
    /**
     * Get InteractionChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInteractionChannel()
    {
        return isset($this->InteractionChannel) ? $this->InteractionChannel : null;
    }
    /**
     * Set InteractionChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionInteractionChannel::valueIsValid()
     * @uses \patest\EnumType\TransactionInteractionChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interactionChannel
     * @return \patest\StructType\Sales_Transaction
     */
    public function setInteractionChannel($interactionChannel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionInteractionChannel::valueIsValid($interactionChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionInteractionChannel', is_array($interactionChannel) ? implode(', ', $interactionChannel) : var_export($interactionChannel, true), implode(', ', \patest\EnumType\TransactionInteractionChannel::getValidValues())), __LINE__);
        }
        if (is_null($interactionChannel) || (is_array($interactionChannel) && empty($interactionChannel))) {
            unset($this->InteractionChannel);
        } else {
            $this->InteractionChannel = $interactionChannel;
        }
        return $this;
    }
    /**
     * Get InvoiceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceId()
    {
        return isset($this->InvoiceId) ? $this->InvoiceId : null;
    }
    /**
     * Set InvoiceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invoiceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invoiceId, true)), __LINE__);
        }
        if (is_null($invoiceId) || (is_array($invoiceId) && empty($invoiceId))) {
            unset($this->InvoiceId);
        } else {
            $this->InvoiceId = $invoiceId;
        }
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInvoiceNumber()
    {
        return isset($this->InvoiceNumber) ? $this->InvoiceNumber : null;
    }
    /**
     * Set InvoiceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $invoiceNumber
     * @return \patest\StructType\Sales_Transaction
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceNumber) && !(is_int($invoiceNumber) || ctype_digit($invoiceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        if (is_null($invoiceNumber) || (is_array($invoiceNumber) && empty($invoiceNumber))) {
            unset($this->InvoiceNumber);
        } else {
            $this->InvoiceNumber = $invoiceNumber;
        }
        return $this;
    }
    /**
     * Get InvoiceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceType()
    {
        return isset($this->InvoiceType) ? $this->InvoiceType : null;
    }
    /**
     * Set InvoiceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccountingDocumentType::valueIsValid()
     * @uses \patest\EnumType\AccountingDocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $invoiceType
     * @return \patest\StructType\Sales_Transaction
     */
    public function setInvoiceType($invoiceType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccountingDocumentType::valueIsValid($invoiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccountingDocumentType', is_array($invoiceType) ? implode(', ', $invoiceType) : var_export($invoiceType, true), implode(', ', \patest\EnumType\AccountingDocumentType::getValidValues())), __LINE__);
        }
        if (is_null($invoiceType) || (is_array($invoiceType) && empty($invoiceType))) {
            unset($this->InvoiceType);
        } else {
            $this->InvoiceType = $invoiceType;
        }
        return $this;
    }
    /**
     * Get IsPrintable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrintable()
    {
        return isset($this->IsPrintable) ? $this->IsPrintable : null;
    }
    /**
     * Set IsPrintable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrintable
     * @return \patest\StructType\Sales_Transaction
     */
    public function setIsPrintable($isPrintable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrintable) && !is_bool($isPrintable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrintable, true), gettype($isPrintable)), __LINE__);
        }
        if (is_null($isPrintable) || (is_array($isPrintable) && empty($isPrintable))) {
            unset($this->IsPrintable);
        } else {
            $this->IsPrintable = $isPrintable;
        }
        return $this;
    }
    /**
     * Get LiaPmStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLiaPmStatus()
    {
        return isset($this->LiaPmStatus) ? $this->LiaPmStatus : null;
    }
    /**
     * Set LiaPmStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BusinessOperationLiaStatus::valueIsValid()
     * @uses \patest\EnumType\BusinessOperationLiaStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $liaPmStatus
     * @return \patest\StructType\Sales_Transaction
     */
    public function setLiaPmStatus($liaPmStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BusinessOperationLiaStatus::valueIsValid($liaPmStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BusinessOperationLiaStatus', is_array($liaPmStatus) ? implode(', ', $liaPmStatus) : var_export($liaPmStatus, true), implode(', ', \patest\EnumType\BusinessOperationLiaStatus::getValidValues())), __LINE__);
        }
        if (is_null($liaPmStatus) || (is_array($liaPmStatus) && empty($liaPmStatus))) {
            unset($this->LiaPmStatus);
        } else {
            $this->LiaPmStatus = $liaPmStatus;
        }
        return $this;
    }
    /**
     * Get LiaStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLiaStatus()
    {
        return isset($this->LiaStatus) ? $this->LiaStatus : null;
    }
    /**
     * Set LiaStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BusinessOperationLiaStatus::valueIsValid()
     * @uses \patest\EnumType\BusinessOperationLiaStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $liaStatus
     * @return \patest\StructType\Sales_Transaction
     */
    public function setLiaStatus($liaStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BusinessOperationLiaStatus::valueIsValid($liaStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BusinessOperationLiaStatus', is_array($liaStatus) ? implode(', ', $liaStatus) : var_export($liaStatus, true), implode(', ', \patest\EnumType\BusinessOperationLiaStatus::getValidValues())), __LINE__);
        }
        if (is_null($liaStatus) || (is_array($liaStatus) && empty($liaStatus))) {
            unset($this->LiaStatus);
        } else {
            $this->LiaStatus = $liaStatus;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\Sales_Transaction
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get OnBehalfOfAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnBehalfOfAccountId()
    {
        return isset($this->OnBehalfOfAccountId) ? $this->OnBehalfOfAccountId : null;
    }
    /**
     * Set OnBehalfOfAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onBehalfOfAccountId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setOnBehalfOfAccountId($onBehalfOfAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($onBehalfOfAccountId) && !is_string($onBehalfOfAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onBehalfOfAccountId, true), gettype($onBehalfOfAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($onBehalfOfAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $onBehalfOfAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($onBehalfOfAccountId, true)), __LINE__);
        }
        if (is_null($onBehalfOfAccountId) || (is_array($onBehalfOfAccountId) && empty($onBehalfOfAccountId))) {
            unset($this->OnBehalfOfAccountId);
        } else {
            $this->OnBehalfOfAccountId = $onBehalfOfAccountId;
        }
        return $this;
    }
    /**
     * Get PaymentBreakdown value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentBreakdown()
    {
        return isset($this->PaymentBreakdown) ? $this->PaymentBreakdown : null;
    }
    /**
     * Set PaymentBreakdown value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentBreakdown
     * @return \patest\StructType\Sales_Transaction
     */
    public function setPaymentBreakdown($paymentBreakdown = null)
    {
        // validation for constraint: string
        if (!is_null($paymentBreakdown) && !is_string($paymentBreakdown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentBreakdown, true), gettype($paymentBreakdown)), __LINE__);
        }
        if (is_null($paymentBreakdown) || (is_array($paymentBreakdown) && empty($paymentBreakdown))) {
            unset($this->PaymentBreakdown);
        } else {
            $this->PaymentBreakdown = $paymentBreakdown;
        }
        return $this;
    }
    /**
     * Get PurposeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPurposeId()
    {
        return isset($this->PurposeId) ? $this->PurposeId : null;
    }
    /**
     * Set PurposeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $purposeId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setPurposeId($purposeId = null)
    {
        // validation for constraint: int
        if (!is_null($purposeId) && !(is_int($purposeId) || ctype_digit($purposeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($purposeId, true), gettype($purposeId)), __LINE__);
        }
        if (is_null($purposeId) || (is_array($purposeId) && empty($purposeId))) {
            unset($this->PurposeId);
        } else {
            $this->PurposeId = $purposeId;
        }
        return $this;
    }
    /**
     * Get RecoAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecoAccountId()
    {
        return isset($this->RecoAccountId) ? $this->RecoAccountId : null;
    }
    /**
     * Set RecoAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recoAccountId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setRecoAccountId($recoAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($recoAccountId) && !is_string($recoAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recoAccountId, true), gettype($recoAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($recoAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $recoAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($recoAccountId, true)), __LINE__);
        }
        if (is_null($recoAccountId) || (is_array($recoAccountId) && empty($recoAccountId))) {
            unset($this->RecoAccountId);
        } else {
            $this->RecoAccountId = $recoAccountId;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return isset($this->ReferenceNumber) ? $this->ReferenceNumber : null;
    }
    /**
     * Set ReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $referenceNumber
     * @return \patest\StructType\Sales_Transaction
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        if (is_null($referenceNumber) || (is_array($referenceNumber) && empty($referenceNumber))) {
            unset($this->ReferenceNumber);
        } else {
            $this->ReferenceNumber = $referenceNumber;
        }
        return $this;
    }
    /**
     * Get RetailerCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRetailerCompanyId()
    {
        return isset($this->RetailerCompanyId) ? $this->RetailerCompanyId : null;
    }
    /**
     * Set RetailerCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $retailerCompanyId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setRetailerCompanyId($retailerCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($retailerCompanyId) && !(is_int($retailerCompanyId) || ctype_digit($retailerCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retailerCompanyId, true), gettype($retailerCompanyId)), __LINE__);
        }
        if (is_null($retailerCompanyId) || (is_array($retailerCompanyId) && empty($retailerCompanyId))) {
            unset($this->RetailerCompanyId);
        } else {
            $this->RetailerCompanyId = $retailerCompanyId;
        }
        return $this;
    }
    /**
     * Get RetailerTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRetailerTransactionNumber()
    {
        return isset($this->RetailerTransactionNumber) ? $this->RetailerTransactionNumber : null;
    }
    /**
     * Set RetailerTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $retailerTransactionNumber
     * @return \patest\StructType\Sales_Transaction
     */
    public function setRetailerTransactionNumber($retailerTransactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($retailerTransactionNumber) && !(is_int($retailerTransactionNumber) || ctype_digit($retailerTransactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retailerTransactionNumber, true), gettype($retailerTransactionNumber)), __LINE__);
        }
        if (is_null($retailerTransactionNumber) || (is_array($retailerTransactionNumber) && empty($retailerTransactionNumber))) {
            unset($this->RetailerTransactionNumber);
        } else {
            $this->RetailerTransactionNumber = $retailerTransactionNumber;
        }
        return $this;
    }
    /**
     * Get SaleModeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleModeId()
    {
        return isset($this->SaleModeId) ? $this->SaleModeId : null;
    }
    /**
     * Set SaleModeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleModeId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setSaleModeId($saleModeId = null)
    {
        // validation for constraint: string
        if (!is_null($saleModeId) && !is_string($saleModeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleModeId, true), gettype($saleModeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleModeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleModeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleModeId, true)), __LINE__);
        }
        if (is_null($saleModeId) || (is_array($saleModeId) && empty($saleModeId))) {
            unset($this->SaleModeId);
        } else {
            $this->SaleModeId = $saleModeId;
        }
        return $this;
    }
    /**
     * Get SellerBranchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellerBranchId()
    {
        return isset($this->SellerBranchId) ? $this->SellerBranchId : null;
    }
    /**
     * Set SellerBranchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sellerBranchId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setSellerBranchId($sellerBranchId = null)
    {
        // validation for constraint: string
        if (!is_null($sellerBranchId) && !is_string($sellerBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerBranchId, true), gettype($sellerBranchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sellerBranchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sellerBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sellerBranchId, true)), __LINE__);
        }
        if (is_null($sellerBranchId) || (is_array($sellerBranchId) && empty($sellerBranchId))) {
            unset($this->SellerBranchId);
        } else {
            $this->SellerBranchId = $sellerBranchId;
        }
        return $this;
    }
    /**
     * Get SellerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellerId()
    {
        return isset($this->SellerId) ? $this->SellerId : null;
    }
    /**
     * Set SellerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sellerId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setSellerId($sellerId = null)
    {
        // validation for constraint: string
        if (!is_null($sellerId) && !is_string($sellerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerId, true), gettype($sellerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sellerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sellerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sellerId, true)), __LINE__);
        }
        if (is_null($sellerId) || (is_array($sellerId) && empty($sellerId))) {
            unset($this->SellerId);
        } else {
            $this->SellerId = $sellerId;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionState::valueIsValid()
     * @uses \patest\EnumType\TransactionState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\Sales_Transaction
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\TransactionState::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get SupplierIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SupplierIds|null
     */
    public function getSupplierIds()
    {
        return isset($this->SupplierIds) ? $this->SupplierIds : null;
    }
    /**
     * Set SupplierIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SupplierIds $supplierIds
     * @return \patest\StructType\Sales_Transaction
     */
    public function setSupplierIds(\patest\StructType\SupplierIds $supplierIds = null)
    {
        if (is_null($supplierIds) || (is_array($supplierIds) && empty($supplierIds))) {
            unset($this->SupplierIds);
        } else {
            $this->SupplierIds = $supplierIds;
        }
        return $this;
    }
    /**
     * Get TotalActualPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalActualPayment()
    {
        return isset($this->TotalActualPayment) ? $this->TotalActualPayment : null;
    }
    /**
     * Set TotalActualPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalActualPayment
     * @return \patest\StructType\Sales_Transaction
     */
    public function setTotalActualPayment(\patest\StructType\Money $totalActualPayment = null)
    {
        if (is_null($totalActualPayment) || (is_array($totalActualPayment) && empty($totalActualPayment))) {
            unset($this->TotalActualPayment);
        } else {
            $this->TotalActualPayment = $totalActualPayment;
        }
        return $this;
    }
    /**
     * Get TotalTransactionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalTransactionValue()
    {
        return isset($this->TotalTransactionValue) ? $this->TotalTransactionValue : null;
    }
    /**
     * Set TotalTransactionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalTransactionValue
     * @return \patest\StructType\Sales_Transaction
     */
    public function setTotalTransactionValue(\patest\StructType\Money $totalTransactionValue = null)
    {
        if (is_null($totalTransactionValue) || (is_array($totalTransactionValue) && empty($totalTransactionValue))) {
            unset($this->TotalTransactionValue);
        } else {
            $this->TotalTransactionValue = $totalTransactionValue;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Sales_Transaction
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get UserOfAffiliateAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserOfAffiliateAccountId()
    {
        return isset($this->UserOfAffiliateAccountId) ? $this->UserOfAffiliateAccountId : null;
    }
    /**
     * Set UserOfAffiliateAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userOfAffiliateAccountId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setUserOfAffiliateAccountId($userOfAffiliateAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($userOfAffiliateAccountId) && !is_string($userOfAffiliateAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userOfAffiliateAccountId, true), gettype($userOfAffiliateAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userOfAffiliateAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userOfAffiliateAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userOfAffiliateAccountId, true)), __LINE__);
        }
        if (is_null($userOfAffiliateAccountId) || (is_array($userOfAffiliateAccountId) && empty($userOfAffiliateAccountId))) {
            unset($this->UserOfAffiliateAccountId);
        } else {
            $this->UserOfAffiliateAccountId = $userOfAffiliateAccountId;
        }
        return $this;
    }
    /**
     * Get WorkflowType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkflowType()
    {
        return isset($this->WorkflowType) ? $this->WorkflowType : null;
    }
    /**
     * Set WorkflowType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\WorkflowType::valueIsValid()
     * @uses \patest\EnumType\WorkflowType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $workflowType
     * @return \patest\StructType\Sales_Transaction
     */
    public function setWorkflowType($workflowType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\WorkflowType::valueIsValid($workflowType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\WorkflowType', is_array($workflowType) ? implode(', ', $workflowType) : var_export($workflowType, true), implode(', ', \patest\EnumType\WorkflowType::getValidValues())), __LINE__);
        }
        if (is_null($workflowType) || (is_array($workflowType) && empty($workflowType))) {
            unset($this->WorkflowType);
        } else {
            $this->WorkflowType = $workflowType;
        }
        return $this;
    }
    /**
     * Get WorkShiftGlobalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWorkShiftGlobalNumber()
    {
        return isset($this->WorkShiftGlobalNumber) ? $this->WorkShiftGlobalNumber : null;
    }
    /**
     * Set WorkShiftGlobalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $workShiftGlobalNumber
     * @return \patest\StructType\Sales_Transaction
     */
    public function setWorkShiftGlobalNumber($workShiftGlobalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($workShiftGlobalNumber) && !(is_int($workShiftGlobalNumber) || ctype_digit($workShiftGlobalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($workShiftGlobalNumber, true), gettype($workShiftGlobalNumber)), __LINE__);
        }
        if (is_null($workShiftGlobalNumber) || (is_array($workShiftGlobalNumber) && empty($workShiftGlobalNumber))) {
            unset($this->WorkShiftGlobalNumber);
        } else {
            $this->WorkShiftGlobalNumber = $workShiftGlobalNumber;
        }
        return $this;
    }
    /**
     * Get WorkShiftId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWorkShiftId()
    {
        return isset($this->WorkShiftId) ? $this->WorkShiftId : null;
    }
    /**
     * Set WorkShiftId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $workShiftId
     * @return \patest\StructType\Sales_Transaction
     */
    public function setWorkShiftId($workShiftId = null)
    {
        // validation for constraint: int
        if (!is_null($workShiftId) && !(is_int($workShiftId) || ctype_digit($workShiftId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($workShiftId, true), gettype($workShiftId)), __LINE__);
        }
        if (is_null($workShiftId) || (is_array($workShiftId) && empty($workShiftId))) {
            unset($this->WorkShiftId);
        } else {
            $this->WorkShiftId = $workShiftId;
        }
        return $this;
    }
}
