<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ShowPromptElement StructType
 * @subpackage Structs
 */
class Sales_ShowPromptElement extends Sales_ProductPromptElement
{
    /**
     * The MinTicketsPerShow
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinTicketsPerShow;
    /**
     * Constructor method for Sales.ShowPromptElement
     * @uses Sales_ShowPromptElement::setMinTicketsPerShow()
     * @param int $minTicketsPerShow
     */
    public function __construct($minTicketsPerShow = null)
    {
        $this
            ->setMinTicketsPerShow($minTicketsPerShow);
    }
    /**
     * Get MinTicketsPerShow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinTicketsPerShow()
    {
        return isset($this->MinTicketsPerShow) ? $this->MinTicketsPerShow : null;
    }
    /**
     * Set MinTicketsPerShow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minTicketsPerShow
     * @return \patest\StructType\Sales_ShowPromptElement
     */
    public function setMinTicketsPerShow($minTicketsPerShow = null)
    {
        // validation for constraint: int
        if (!is_null($minTicketsPerShow) && !(is_int($minTicketsPerShow) || ctype_digit($minTicketsPerShow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minTicketsPerShow, true), gettype($minTicketsPerShow)), __LINE__);
        }
        if (is_null($minTicketsPerShow) || (is_array($minTicketsPerShow) && empty($minTicketsPerShow))) {
            unset($this->MinTicketsPerShow);
        } else {
            $this->MinTicketsPerShow = $minTicketsPerShow;
        }
        return $this;
    }
}
