<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.Shift StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Sales.Shift
 * @subpackage Structs
 */
class Sales_Shift extends DistributableEntity
{
    /**
     * The BatchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchId;
    /**
     * The ClosingDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClosingDateTime;
    /**
     * The GlobalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GlobalNumber;
    /**
     * The OpenSums
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_OpenSum
     */
    public $OpenSums;
    /**
     * The OpenSumsXml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpenSumsXml;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The SaleDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleDate;
    /**
     * The StateEnum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StateEnum;
    /**
     * The TillId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TillId;
    /**
     * Constructor method for Sales.Shift
     * @uses Sales_Shift::setBatchId()
     * @uses Sales_Shift::setClosingDateTime()
     * @uses Sales_Shift::setGlobalNumber()
     * @uses Sales_Shift::setOpenSums()
     * @uses Sales_Shift::setOpenSumsXml()
     * @uses Sales_Shift::setOrganizationUnitId()
     * @uses Sales_Shift::setSaleDate()
     * @uses Sales_Shift::setStateEnum()
     * @uses Sales_Shift::setTillId()
     * @param string $batchId
     * @param string $closingDateTime
     * @param int $globalNumber
     * @param \patest\StructType\RecordSetOfSales_OpenSum $openSums
     * @param string $openSumsXml
     * @param string $organizationUnitId
     * @param string $saleDate
     * @param int $stateEnum
     * @param string $tillId
     */
    public function __construct($batchId = null, $closingDateTime = null, $globalNumber = null, \patest\StructType\RecordSetOfSales_OpenSum $openSums = null, $openSumsXml = null, $organizationUnitId = null, $saleDate = null, $stateEnum = null, $tillId = null)
    {
        $this
            ->setBatchId($batchId)
            ->setClosingDateTime($closingDateTime)
            ->setGlobalNumber($globalNumber)
            ->setOpenSums($openSums)
            ->setOpenSumsXml($openSumsXml)
            ->setOrganizationUnitId($organizationUnitId)
            ->setSaleDate($saleDate)
            ->setStateEnum($stateEnum)
            ->setTillId($tillId);
    }
    /**
     * Get BatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchId()
    {
        return isset($this->BatchId) ? $this->BatchId : null;
    }
    /**
     * Set BatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchId
     * @return \patest\StructType\Sales_Shift
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: string
        if (!is_null($batchId) && !is_string($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchId, true), gettype($batchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchId, true)), __LINE__);
        }
        if (is_null($batchId) || (is_array($batchId) && empty($batchId))) {
            unset($this->BatchId);
        } else {
            $this->BatchId = $batchId;
        }
        return $this;
    }
    /**
     * Get ClosingDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClosingDateTime()
    {
        return isset($this->ClosingDateTime) ? $this->ClosingDateTime : null;
    }
    /**
     * Set ClosingDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $closingDateTime
     * @return \patest\StructType\Sales_Shift
     */
    public function setClosingDateTime($closingDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($closingDateTime) && !is_string($closingDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closingDateTime, true), gettype($closingDateTime)), __LINE__);
        }
        if (is_null($closingDateTime) || (is_array($closingDateTime) && empty($closingDateTime))) {
            unset($this->ClosingDateTime);
        } else {
            $this->ClosingDateTime = $closingDateTime;
        }
        return $this;
    }
    /**
     * Get GlobalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGlobalNumber()
    {
        return isset($this->GlobalNumber) ? $this->GlobalNumber : null;
    }
    /**
     * Set GlobalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $globalNumber
     * @return \patest\StructType\Sales_Shift
     */
    public function setGlobalNumber($globalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($globalNumber) && !(is_int($globalNumber) || ctype_digit($globalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($globalNumber, true), gettype($globalNumber)), __LINE__);
        }
        if (is_null($globalNumber) || (is_array($globalNumber) && empty($globalNumber))) {
            unset($this->GlobalNumber);
        } else {
            $this->GlobalNumber = $globalNumber;
        }
        return $this;
    }
    /**
     * Get OpenSums value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_OpenSum|null
     */
    public function getOpenSums()
    {
        return isset($this->OpenSums) ? $this->OpenSums : null;
    }
    /**
     * Set OpenSums value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_OpenSum $openSums
     * @return \patest\StructType\Sales_Shift
     */
    public function setOpenSums(\patest\StructType\RecordSetOfSales_OpenSum $openSums = null)
    {
        if (is_null($openSums) || (is_array($openSums) && empty($openSums))) {
            unset($this->OpenSums);
        } else {
            $this->OpenSums = $openSums;
        }
        return $this;
    }
    /**
     * Get OpenSumsXml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpenSumsXml()
    {
        return isset($this->OpenSumsXml) ? $this->OpenSumsXml : null;
    }
    /**
     * Set OpenSumsXml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $openSumsXml
     * @return \patest\StructType\Sales_Shift
     */
    public function setOpenSumsXml($openSumsXml = null)
    {
        // validation for constraint: string
        if (!is_null($openSumsXml) && !is_string($openSumsXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openSumsXml, true), gettype($openSumsXml)), __LINE__);
        }
        if (is_null($openSumsXml) || (is_array($openSumsXml) && empty($openSumsXml))) {
            unset($this->OpenSumsXml);
        } else {
            $this->OpenSumsXml = $openSumsXml;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Sales_Shift
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get SaleDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleDate()
    {
        return isset($this->SaleDate) ? $this->SaleDate : null;
    }
    /**
     * Set SaleDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleDate
     * @return \patest\StructType\Sales_Shift
     */
    public function setSaleDate($saleDate = null)
    {
        // validation for constraint: string
        if (!is_null($saleDate) && !is_string($saleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleDate, true), gettype($saleDate)), __LINE__);
        }
        if (is_null($saleDate) || (is_array($saleDate) && empty($saleDate))) {
            unset($this->SaleDate);
        } else {
            $this->SaleDate = $saleDate;
        }
        return $this;
    }
    /**
     * Get StateEnum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStateEnum()
    {
        return isset($this->StateEnum) ? $this->StateEnum : null;
    }
    /**
     * Set StateEnum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $stateEnum
     * @return \patest\StructType\Sales_Shift
     */
    public function setStateEnum($stateEnum = null)
    {
        // validation for constraint: int
        if (!is_null($stateEnum) && !(is_int($stateEnum) || ctype_digit($stateEnum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stateEnum, true), gettype($stateEnum)), __LINE__);
        }
        if (is_null($stateEnum) || (is_array($stateEnum) && empty($stateEnum))) {
            unset($this->StateEnum);
        } else {
            $this->StateEnum = $stateEnum;
        }
        return $this;
    }
    /**
     * Get TillId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTillId()
    {
        return isset($this->TillId) ? $this->TillId : null;
    }
    /**
     * Set TillId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tillId
     * @return \patest\StructType\Sales_Shift
     */
    public function setTillId($tillId = null)
    {
        // validation for constraint: string
        if (!is_null($tillId) && !is_string($tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillId, true), gettype($tillId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tillId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tillId, true)), __LINE__);
        }
        if (is_null($tillId) || (is_array($tillId) && empty($tillId))) {
            unset($this->TillId);
        } else {
            $this->TillId = $tillId;
        }
        return $this;
    }
}
