<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.SeriesPromptElement StructType
 * @subpackage Structs
 */
class Sales_SeriesPromptElement extends Sales_ProductPromptElement
{
    /**
     * The MinSubscriptionsPerSeries
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinSubscriptionsPerSeries;
    /**
     * Constructor method for Sales.SeriesPromptElement
     * @uses Sales_SeriesPromptElement::setMinSubscriptionsPerSeries()
     * @param int $minSubscriptionsPerSeries
     */
    public function __construct($minSubscriptionsPerSeries = null)
    {
        $this
            ->setMinSubscriptionsPerSeries($minSubscriptionsPerSeries);
    }
    /**
     * Get MinSubscriptionsPerSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinSubscriptionsPerSeries()
    {
        return isset($this->MinSubscriptionsPerSeries) ? $this->MinSubscriptionsPerSeries : null;
    }
    /**
     * Set MinSubscriptionsPerSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minSubscriptionsPerSeries
     * @return \patest\StructType\Sales_SeriesPromptElement
     */
    public function setMinSubscriptionsPerSeries($minSubscriptionsPerSeries = null)
    {
        // validation for constraint: int
        if (!is_null($minSubscriptionsPerSeries) && !(is_int($minSubscriptionsPerSeries) || ctype_digit($minSubscriptionsPerSeries))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minSubscriptionsPerSeries, true), gettype($minSubscriptionsPerSeries)), __LINE__);
        }
        if (is_null($minSubscriptionsPerSeries) || (is_array($minSubscriptionsPerSeries) && empty($minSubscriptionsPerSeries))) {
            unset($this->MinSubscriptionsPerSeries);
        } else {
            $this->MinSubscriptionsPerSeries = $minSubscriptionsPerSeries;
        }
        return $this;
    }
}
