<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.SendByEmailData StructType
 * @subpackage Structs
 */
class Sales_SendByEmailData extends AnyEntity
{
    /**
     * The CCRecipients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CCRecipients;
    /**
     * The EmailBodyOptionalMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailBodyOptionalMessage;
    /**
     * The InvoiceDocumentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvoiceDocumentId;
    /**
     * The ToRecipients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToRecipients;
    /**
     * Constructor method for Sales.SendByEmailData
     * @uses Sales_SendByEmailData::setCCRecipients()
     * @uses Sales_SendByEmailData::setEmailBodyOptionalMessage()
     * @uses Sales_SendByEmailData::setInvoiceDocumentId()
     * @uses Sales_SendByEmailData::setToRecipients()
     * @param string $cCRecipients
     * @param string $emailBodyOptionalMessage
     * @param string $invoiceDocumentId
     * @param string $toRecipients
     */
    public function __construct($cCRecipients = null, $emailBodyOptionalMessage = null, $invoiceDocumentId = null, $toRecipients = null)
    {
        $this
            ->setCCRecipients($cCRecipients)
            ->setEmailBodyOptionalMessage($emailBodyOptionalMessage)
            ->setInvoiceDocumentId($invoiceDocumentId)
            ->setToRecipients($toRecipients);
    }
    /**
     * Get CCRecipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCCRecipients()
    {
        return isset($this->CCRecipients) ? $this->CCRecipients : null;
    }
    /**
     * Set CCRecipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cCRecipients
     * @return \patest\StructType\Sales_SendByEmailData
     */
    public function setCCRecipients($cCRecipients = null)
    {
        // validation for constraint: string
        if (!is_null($cCRecipients) && !is_string($cCRecipients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCRecipients, true), gettype($cCRecipients)), __LINE__);
        }
        if (is_null($cCRecipients) || (is_array($cCRecipients) && empty($cCRecipients))) {
            unset($this->CCRecipients);
        } else {
            $this->CCRecipients = $cCRecipients;
        }
        return $this;
    }
    /**
     * Get EmailBodyOptionalMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailBodyOptionalMessage()
    {
        return isset($this->EmailBodyOptionalMessage) ? $this->EmailBodyOptionalMessage : null;
    }
    /**
     * Set EmailBodyOptionalMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailBodyOptionalMessage
     * @return \patest\StructType\Sales_SendByEmailData
     */
    public function setEmailBodyOptionalMessage($emailBodyOptionalMessage = null)
    {
        // validation for constraint: string
        if (!is_null($emailBodyOptionalMessage) && !is_string($emailBodyOptionalMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailBodyOptionalMessage, true), gettype($emailBodyOptionalMessage)), __LINE__);
        }
        if (is_null($emailBodyOptionalMessage) || (is_array($emailBodyOptionalMessage) && empty($emailBodyOptionalMessage))) {
            unset($this->EmailBodyOptionalMessage);
        } else {
            $this->EmailBodyOptionalMessage = $emailBodyOptionalMessage;
        }
        return $this;
    }
    /**
     * Get InvoiceDocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceDocumentId()
    {
        return isset($this->InvoiceDocumentId) ? $this->InvoiceDocumentId : null;
    }
    /**
     * Set InvoiceDocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceDocumentId
     * @return \patest\StructType\Sales_SendByEmailData
     */
    public function setInvoiceDocumentId($invoiceDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDocumentId) && !is_string($invoiceDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDocumentId, true), gettype($invoiceDocumentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invoiceDocumentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invoiceDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invoiceDocumentId, true)), __LINE__);
        }
        if (is_null($invoiceDocumentId) || (is_array($invoiceDocumentId) && empty($invoiceDocumentId))) {
            unset($this->InvoiceDocumentId);
        } else {
            $this->InvoiceDocumentId = $invoiceDocumentId;
        }
        return $this;
    }
    /**
     * Get ToRecipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToRecipients()
    {
        return isset($this->ToRecipients) ? $this->ToRecipients : null;
    }
    /**
     * Set ToRecipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toRecipients
     * @return \patest\StructType\Sales_SendByEmailData
     */
    public function setToRecipients($toRecipients = null)
    {
        // validation for constraint: string
        if (!is_null($toRecipients) && !is_string($toRecipients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toRecipients, true), gettype($toRecipients)), __LINE__);
        }
        if (is_null($toRecipients) || (is_array($toRecipients) && empty($toRecipients))) {
            unset($this->ToRecipients);
        } else {
            $this->ToRecipients = $toRecipients;
        }
        return $this;
    }
}
