<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.SaleMode StructType
 * @subpackage Structs
 */
class Sales_SaleMode extends DistributableEntity
{
    /**
     * The AccountTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccountTypeIds
     */
    public $AccountTypeIds;
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The AgencyMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgencyMode;
    /**
     * The ClientDetailsPopupMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientDetailsPopupMode;
    /**
     * The ClientDetailsScreenId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientDetailsScreenId;
    /**
     * The DeliveryPageOpensAutomatically
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DeliveryPageOpensAutomatically;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The ExtraDataScreenId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraDataScreenId;
    /**
     * The GenerateCustomerOrderForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GenerateCustomerOrderForm;
    /**
     * The GraphicRepresentation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Graphics_GraphicRepresentation
     */
    public $GraphicRepresentation;
    /**
     * The HighlightColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HighlightColor;
    /**
     * The InteractionChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InteractionChannel;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OnBehalfOfAccountRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OnBehalfOfAccountRequired;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The SaleModeGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleModeGroupId;
    /**
     * The SellTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SellTo;
    /**
     * The SellToAccountMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SellToAccountMode;
    /**
     * The SuppressPopupAlerts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SuppressPopupAlerts;
    /**
     * The SuppressTransactionValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SuppressTransactionValidation;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Sales.SaleMode
     * @uses Sales_SaleMode::setAccountTypeIds()
     * @uses Sales_SaleMode::setAclSchemeId()
     * @uses Sales_SaleMode::setAgencyMode()
     * @uses Sales_SaleMode::setClientDetailsPopupMode()
     * @uses Sales_SaleMode::setClientDetailsScreenId()
     * @uses Sales_SaleMode::setDeliveryPageOpensAutomatically()
     * @uses Sales_SaleMode::setDescription()
     * @uses Sales_SaleMode::setExtraDataScreenId()
     * @uses Sales_SaleMode::setGenerateCustomerOrderForm()
     * @uses Sales_SaleMode::setGraphicRepresentation()
     * @uses Sales_SaleMode::setHighlightColor()
     * @uses Sales_SaleMode::setInteractionChannel()
     * @uses Sales_SaleMode::setIsActive()
     * @uses Sales_SaleMode::setIsSystem()
     * @uses Sales_SaleMode::setName()
     * @uses Sales_SaleMode::setOnBehalfOfAccountRequired()
     * @uses Sales_SaleMode::setOrganizationUnitId()
     * @uses Sales_SaleMode::setSaleModeGroupId()
     * @uses Sales_SaleMode::setSellTo()
     * @uses Sales_SaleMode::setSellToAccountMode()
     * @uses Sales_SaleMode::setSuppressPopupAlerts()
     * @uses Sales_SaleMode::setSuppressTransactionValidation()
     * @uses Sales_SaleMode::setVisibleBySubordinates()
     * @param \patest\StructType\AccountTypeIds $accountTypeIds
     * @param int $aclSchemeId
     * @param string $agencyMode
     * @param string $clientDetailsPopupMode
     * @param string $clientDetailsScreenId
     * @param bool $deliveryPageOpensAutomatically
     * @param \patest\StructType\GlobalString $description
     * @param string $extraDataScreenId
     * @param bool $generateCustomerOrderForm
     * @param \patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation
     * @param string $highlightColor
     * @param string $interactionChannel
     * @param bool $isActive
     * @param bool $isSystem
     * @param \patest\StructType\GlobalString $name
     * @param bool $onBehalfOfAccountRequired
     * @param string $organizationUnitId
     * @param string $saleModeGroupId
     * @param string $sellTo
     * @param string $sellToAccountMode
     * @param bool $suppressPopupAlerts
     * @param bool $suppressTransactionValidation
     * @param bool $visibleBySubordinates
     */
    public function __construct(\patest\StructType\AccountTypeIds $accountTypeIds = null, $aclSchemeId = null, $agencyMode = null, $clientDetailsPopupMode = null, $clientDetailsScreenId = null, $deliveryPageOpensAutomatically = null, \patest\StructType\GlobalString $description = null, $extraDataScreenId = null, $generateCustomerOrderForm = null, \patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation = null, $highlightColor = null, $interactionChannel = null, $isActive = null, $isSystem = null, \patest\StructType\GlobalString $name = null, $onBehalfOfAccountRequired = null, $organizationUnitId = null, $saleModeGroupId = null, $sellTo = null, $sellToAccountMode = null, $suppressPopupAlerts = null, $suppressTransactionValidation = null, $visibleBySubordinates = null)
    {
        $this
            ->setAccountTypeIds($accountTypeIds)
            ->setAclSchemeId($aclSchemeId)
            ->setAgencyMode($agencyMode)
            ->setClientDetailsPopupMode($clientDetailsPopupMode)
            ->setClientDetailsScreenId($clientDetailsScreenId)
            ->setDeliveryPageOpensAutomatically($deliveryPageOpensAutomatically)
            ->setDescription($description)
            ->setExtraDataScreenId($extraDataScreenId)
            ->setGenerateCustomerOrderForm($generateCustomerOrderForm)
            ->setGraphicRepresentation($graphicRepresentation)
            ->setHighlightColor($highlightColor)
            ->setInteractionChannel($interactionChannel)
            ->setIsActive($isActive)
            ->setIsSystem($isSystem)
            ->setName($name)
            ->setOnBehalfOfAccountRequired($onBehalfOfAccountRequired)
            ->setOrganizationUnitId($organizationUnitId)
            ->setSaleModeGroupId($saleModeGroupId)
            ->setSellTo($sellTo)
            ->setSellToAccountMode($sellToAccountMode)
            ->setSuppressPopupAlerts($suppressPopupAlerts)
            ->setSuppressTransactionValidation($suppressTransactionValidation)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AccountTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccountTypeIds|null
     */
    public function getAccountTypeIds()
    {
        return isset($this->AccountTypeIds) ? $this->AccountTypeIds : null;
    }
    /**
     * Set AccountTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccountTypeIds $accountTypeIds
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setAccountTypeIds(\patest\StructType\AccountTypeIds $accountTypeIds = null)
    {
        if (is_null($accountTypeIds) || (is_array($accountTypeIds) && empty($accountTypeIds))) {
            unset($this->AccountTypeIds);
        } else {
            $this->AccountTypeIds = $accountTypeIds;
        }
        return $this;
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get AgencyMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyMode()
    {
        return isset($this->AgencyMode) ? $this->AgencyMode : null;
    }
    /**
     * Set AgencyMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AgencySelectionMode::valueIsValid()
     * @uses \patest\EnumType\AgencySelectionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $agencyMode
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setAgencyMode($agencyMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AgencySelectionMode::valueIsValid($agencyMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AgencySelectionMode', is_array($agencyMode) ? implode(', ', $agencyMode) : var_export($agencyMode, true), implode(', ', \patest\EnumType\AgencySelectionMode::getValidValues())), __LINE__);
        }
        if (is_null($agencyMode) || (is_array($agencyMode) && empty($agencyMode))) {
            unset($this->AgencyMode);
        } else {
            $this->AgencyMode = $agencyMode;
        }
        return $this;
    }
    /**
     * Get ClientDetailsPopupMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientDetailsPopupMode()
    {
        return isset($this->ClientDetailsPopupMode) ? $this->ClientDetailsPopupMode : null;
    }
    /**
     * Set ClientDetailsPopupMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ClientDetailsPopupMode::valueIsValid()
     * @uses \patest\EnumType\ClientDetailsPopupMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientDetailsPopupMode
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setClientDetailsPopupMode($clientDetailsPopupMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ClientDetailsPopupMode::valueIsValid($clientDetailsPopupMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClientDetailsPopupMode', is_array($clientDetailsPopupMode) ? implode(', ', $clientDetailsPopupMode) : var_export($clientDetailsPopupMode, true), implode(', ', \patest\EnumType\ClientDetailsPopupMode::getValidValues())), __LINE__);
        }
        if (is_null($clientDetailsPopupMode) || (is_array($clientDetailsPopupMode) && empty($clientDetailsPopupMode))) {
            unset($this->ClientDetailsPopupMode);
        } else {
            $this->ClientDetailsPopupMode = $clientDetailsPopupMode;
        }
        return $this;
    }
    /**
     * Get ClientDetailsScreenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientDetailsScreenId()
    {
        return isset($this->ClientDetailsScreenId) ? $this->ClientDetailsScreenId : null;
    }
    /**
     * Set ClientDetailsScreenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientDetailsScreenId
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setClientDetailsScreenId($clientDetailsScreenId = null)
    {
        // validation for constraint: string
        if (!is_null($clientDetailsScreenId) && !is_string($clientDetailsScreenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientDetailsScreenId, true), gettype($clientDetailsScreenId)), __LINE__);
        }
        if (is_null($clientDetailsScreenId) || (is_array($clientDetailsScreenId) && empty($clientDetailsScreenId))) {
            unset($this->ClientDetailsScreenId);
        } else {
            $this->ClientDetailsScreenId = $clientDetailsScreenId;
        }
        return $this;
    }
    /**
     * Get DeliveryPageOpensAutomatically value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDeliveryPageOpensAutomatically()
    {
        return isset($this->DeliveryPageOpensAutomatically) ? $this->DeliveryPageOpensAutomatically : null;
    }
    /**
     * Set DeliveryPageOpensAutomatically value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $deliveryPageOpensAutomatically
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setDeliveryPageOpensAutomatically($deliveryPageOpensAutomatically = null)
    {
        // validation for constraint: boolean
        if (!is_null($deliveryPageOpensAutomatically) && !is_bool($deliveryPageOpensAutomatically)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deliveryPageOpensAutomatically, true), gettype($deliveryPageOpensAutomatically)), __LINE__);
        }
        if (is_null($deliveryPageOpensAutomatically) || (is_array($deliveryPageOpensAutomatically) && empty($deliveryPageOpensAutomatically))) {
            unset($this->DeliveryPageOpensAutomatically);
        } else {
            $this->DeliveryPageOpensAutomatically = $deliveryPageOpensAutomatically;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExtraDataScreenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraDataScreenId()
    {
        return isset($this->ExtraDataScreenId) ? $this->ExtraDataScreenId : null;
    }
    /**
     * Set ExtraDataScreenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraDataScreenId
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setExtraDataScreenId($extraDataScreenId = null)
    {
        // validation for constraint: string
        if (!is_null($extraDataScreenId) && !is_string($extraDataScreenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraDataScreenId, true), gettype($extraDataScreenId)), __LINE__);
        }
        if (is_null($extraDataScreenId) || (is_array($extraDataScreenId) && empty($extraDataScreenId))) {
            unset($this->ExtraDataScreenId);
        } else {
            $this->ExtraDataScreenId = $extraDataScreenId;
        }
        return $this;
    }
    /**
     * Get GenerateCustomerOrderForm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGenerateCustomerOrderForm()
    {
        return isset($this->GenerateCustomerOrderForm) ? $this->GenerateCustomerOrderForm : null;
    }
    /**
     * Set GenerateCustomerOrderForm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $generateCustomerOrderForm
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setGenerateCustomerOrderForm($generateCustomerOrderForm = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateCustomerOrderForm) && !is_bool($generateCustomerOrderForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateCustomerOrderForm, true), gettype($generateCustomerOrderForm)), __LINE__);
        }
        if (is_null($generateCustomerOrderForm) || (is_array($generateCustomerOrderForm) && empty($generateCustomerOrderForm))) {
            unset($this->GenerateCustomerOrderForm);
        } else {
            $this->GenerateCustomerOrderForm = $generateCustomerOrderForm;
        }
        return $this;
    }
    /**
     * Get GraphicRepresentation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Graphics_GraphicRepresentation|null
     */
    public function getGraphicRepresentation()
    {
        return isset($this->GraphicRepresentation) ? $this->GraphicRepresentation : null;
    }
    /**
     * Set GraphicRepresentation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setGraphicRepresentation(\patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation = null)
    {
        if (is_null($graphicRepresentation) || (is_array($graphicRepresentation) && empty($graphicRepresentation))) {
            unset($this->GraphicRepresentation);
        } else {
            $this->GraphicRepresentation = $graphicRepresentation;
        }
        return $this;
    }
    /**
     * Get HighlightColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHighlightColor()
    {
        return isset($this->HighlightColor) ? $this->HighlightColor : null;
    }
    /**
     * Set HighlightColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $highlightColor
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setHighlightColor($highlightColor = null)
    {
        // validation for constraint: string
        if (!is_null($highlightColor) && !is_string($highlightColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($highlightColor, true), gettype($highlightColor)), __LINE__);
        }
        if (is_null($highlightColor) || (is_array($highlightColor) && empty($highlightColor))) {
            unset($this->HighlightColor);
        } else {
            $this->HighlightColor = $highlightColor;
        }
        return $this;
    }
    /**
     * Get InteractionChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInteractionChannel()
    {
        return isset($this->InteractionChannel) ? $this->InteractionChannel : null;
    }
    /**
     * Set InteractionChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionInteractionChannel::valueIsValid()
     * @uses \patest\EnumType\TransactionInteractionChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interactionChannel
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setInteractionChannel($interactionChannel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionInteractionChannel::valueIsValid($interactionChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionInteractionChannel', is_array($interactionChannel) ? implode(', ', $interactionChannel) : var_export($interactionChannel, true), implode(', ', \patest\EnumType\TransactionInteractionChannel::getValidValues())), __LINE__);
        }
        if (is_null($interactionChannel) || (is_array($interactionChannel) && empty($interactionChannel))) {
            unset($this->InteractionChannel);
        } else {
            $this->InteractionChannel = $interactionChannel;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OnBehalfOfAccountRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOnBehalfOfAccountRequired()
    {
        return isset($this->OnBehalfOfAccountRequired) ? $this->OnBehalfOfAccountRequired : null;
    }
    /**
     * Set OnBehalfOfAccountRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $onBehalfOfAccountRequired
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setOnBehalfOfAccountRequired($onBehalfOfAccountRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($onBehalfOfAccountRequired) && !is_bool($onBehalfOfAccountRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onBehalfOfAccountRequired, true), gettype($onBehalfOfAccountRequired)), __LINE__);
        }
        if (is_null($onBehalfOfAccountRequired) || (is_array($onBehalfOfAccountRequired) && empty($onBehalfOfAccountRequired))) {
            unset($this->OnBehalfOfAccountRequired);
        } else {
            $this->OnBehalfOfAccountRequired = $onBehalfOfAccountRequired;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get SaleModeGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleModeGroupId()
    {
        return isset($this->SaleModeGroupId) ? $this->SaleModeGroupId : null;
    }
    /**
     * Set SaleModeGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleModeGroupId
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setSaleModeGroupId($saleModeGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($saleModeGroupId) && !is_string($saleModeGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleModeGroupId, true), gettype($saleModeGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleModeGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleModeGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleModeGroupId, true)), __LINE__);
        }
        if (is_null($saleModeGroupId) || (is_array($saleModeGroupId) && empty($saleModeGroupId))) {
            unset($this->SaleModeGroupId);
        } else {
            $this->SaleModeGroupId = $saleModeGroupId;
        }
        return $this;
    }
    /**
     * Get SellTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellTo()
    {
        return isset($this->SellTo) ? $this->SellTo : null;
    }
    /**
     * Set SellTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SellTo::valueIsValid()
     * @uses \patest\EnumType\SellTo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sellTo
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setSellTo($sellTo = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SellTo::valueIsValid($sellTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SellTo', is_array($sellTo) ? implode(', ', $sellTo) : var_export($sellTo, true), implode(', ', \patest\EnumType\SellTo::getValidValues())), __LINE__);
        }
        if (is_null($sellTo) || (is_array($sellTo) && empty($sellTo))) {
            unset($this->SellTo);
        } else {
            $this->SellTo = $sellTo;
        }
        return $this;
    }
    /**
     * Get SellToAccountMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellToAccountMode()
    {
        return isset($this->SellToAccountMode) ? $this->SellToAccountMode : null;
    }
    /**
     * Set SellToAccountMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SellToAccountMode::valueIsValid()
     * @uses \patest\EnumType\SellToAccountMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sellToAccountMode
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setSellToAccountMode($sellToAccountMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SellToAccountMode::valueIsValid($sellToAccountMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SellToAccountMode', is_array($sellToAccountMode) ? implode(', ', $sellToAccountMode) : var_export($sellToAccountMode, true), implode(', ', \patest\EnumType\SellToAccountMode::getValidValues())), __LINE__);
        }
        if (is_null($sellToAccountMode) || (is_array($sellToAccountMode) && empty($sellToAccountMode))) {
            unset($this->SellToAccountMode);
        } else {
            $this->SellToAccountMode = $sellToAccountMode;
        }
        return $this;
    }
    /**
     * Get SuppressPopupAlerts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSuppressPopupAlerts()
    {
        return isset($this->SuppressPopupAlerts) ? $this->SuppressPopupAlerts : null;
    }
    /**
     * Set SuppressPopupAlerts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $suppressPopupAlerts
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setSuppressPopupAlerts($suppressPopupAlerts = null)
    {
        // validation for constraint: boolean
        if (!is_null($suppressPopupAlerts) && !is_bool($suppressPopupAlerts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($suppressPopupAlerts, true), gettype($suppressPopupAlerts)), __LINE__);
        }
        if (is_null($suppressPopupAlerts) || (is_array($suppressPopupAlerts) && empty($suppressPopupAlerts))) {
            unset($this->SuppressPopupAlerts);
        } else {
            $this->SuppressPopupAlerts = $suppressPopupAlerts;
        }
        return $this;
    }
    /**
     * Get SuppressTransactionValidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSuppressTransactionValidation()
    {
        return isset($this->SuppressTransactionValidation) ? $this->SuppressTransactionValidation : null;
    }
    /**
     * Set SuppressTransactionValidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $suppressTransactionValidation
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setSuppressTransactionValidation($suppressTransactionValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($suppressTransactionValidation) && !is_bool($suppressTransactionValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($suppressTransactionValidation, true), gettype($suppressTransactionValidation)), __LINE__);
        }
        if (is_null($suppressTransactionValidation) || (is_array($suppressTransactionValidation) && empty($suppressTransactionValidation))) {
            unset($this->SuppressTransactionValidation);
        } else {
            $this->SuppressTransactionValidation = $suppressTransactionValidation;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Sales_SaleMode
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
