<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.SMSCollectionSender StructType
 * @subpackage Structs
 */
class Sales_SMSCollectionSender extends PersistableEntity
{
    /**
     * The ClickCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClickCount;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreatedUtcDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedUtcDate;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The CultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CultureId;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The ExternalMessageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalMessageId;
    /**
     * The FinalMessageStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FinalMessageStatus;
    /**
     * The IsHandled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHandled;
    /**
     * The IsSuccessful
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSuccessful;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The LastProcessUtcDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastProcessUtcDate;
    /**
     * The MessageStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MessageStatus;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mobile;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Request;
    /**
     * The Response
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Response;
    /**
     * The RetryCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RetryCount;
    /**
     * The SearchableMobile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SearchableMobile;
    /**
     * The ServiceSpecificIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceSpecificIds;
    /**
     * The TrackMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TrackMessage;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Sales.SMSCollectionSender
     * @uses Sales_SMSCollectionSender::setClickCount()
     * @uses Sales_SMSCollectionSender::setClientId()
     * @uses Sales_SMSCollectionSender::setCreatedUtcDate()
     * @uses Sales_SMSCollectionSender::setCrmId()
     * @uses Sales_SMSCollectionSender::setCultureId()
     * @uses Sales_SMSCollectionSender::setEmail()
     * @uses Sales_SMSCollectionSender::setErrorMessage()
     * @uses Sales_SMSCollectionSender::setExternalMessageId()
     * @uses Sales_SMSCollectionSender::setFinalMessageStatus()
     * @uses Sales_SMSCollectionSender::setIsHandled()
     * @uses Sales_SMSCollectionSender::setIsSuccessful()
     * @uses Sales_SMSCollectionSender::setItemType()
     * @uses Sales_SMSCollectionSender::setLastProcessUtcDate()
     * @uses Sales_SMSCollectionSender::setMessageStatus()
     * @uses Sales_SMSCollectionSender::setMobile()
     * @uses Sales_SMSCollectionSender::setProductId()
     * @uses Sales_SMSCollectionSender::setRequest()
     * @uses Sales_SMSCollectionSender::setResponse()
     * @uses Sales_SMSCollectionSender::setRetryCount()
     * @uses Sales_SMSCollectionSender::setSearchableMobile()
     * @uses Sales_SMSCollectionSender::setServiceSpecificIds()
     * @uses Sales_SMSCollectionSender::setTrackMessage()
     * @uses Sales_SMSCollectionSender::setTransactionGuid()
     * @uses Sales_SMSCollectionSender::setTransactionNumber()
     * @param int $clickCount
     * @param string $clientId
     * @param string $createdUtcDate
     * @param string $crmId
     * @param int $cultureId
     * @param string $email
     * @param string $errorMessage
     * @param string $externalMessageId
     * @param string $finalMessageStatus
     * @param bool $isHandled
     * @param bool $isSuccessful
     * @param int $itemType
     * @param string $lastProcessUtcDate
     * @param string $messageStatus
     * @param string $mobile
     * @param string $productId
     * @param string $request
     * @param string $response
     * @param int $retryCount
     * @param string $searchableMobile
     * @param string $serviceSpecificIds
     * @param bool $trackMessage
     * @param string $transactionGuid
     * @param int $transactionNumber
     */
    public function __construct($clickCount = null, $clientId = null, $createdUtcDate = null, $crmId = null, $cultureId = null, $email = null, $errorMessage = null, $externalMessageId = null, $finalMessageStatus = null, $isHandled = null, $isSuccessful = null, $itemType = null, $lastProcessUtcDate = null, $messageStatus = null, $mobile = null, $productId = null, $request = null, $response = null, $retryCount = null, $searchableMobile = null, $serviceSpecificIds = null, $trackMessage = null, $transactionGuid = null, $transactionNumber = null)
    {
        $this
            ->setClickCount($clickCount)
            ->setClientId($clientId)
            ->setCreatedUtcDate($createdUtcDate)
            ->setCrmId($crmId)
            ->setCultureId($cultureId)
            ->setEmail($email)
            ->setErrorMessage($errorMessage)
            ->setExternalMessageId($externalMessageId)
            ->setFinalMessageStatus($finalMessageStatus)
            ->setIsHandled($isHandled)
            ->setIsSuccessful($isSuccessful)
            ->setItemType($itemType)
            ->setLastProcessUtcDate($lastProcessUtcDate)
            ->setMessageStatus($messageStatus)
            ->setMobile($mobile)
            ->setProductId($productId)
            ->setRequest($request)
            ->setResponse($response)
            ->setRetryCount($retryCount)
            ->setSearchableMobile($searchableMobile)
            ->setServiceSpecificIds($serviceSpecificIds)
            ->setTrackMessage($trackMessage)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get ClickCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClickCount()
    {
        return isset($this->ClickCount) ? $this->ClickCount : null;
    }
    /**
     * Set ClickCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $clickCount
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setClickCount($clickCount = null)
    {
        // validation for constraint: int
        if (!is_null($clickCount) && !(is_int($clickCount) || ctype_digit($clickCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clickCount, true), gettype($clickCount)), __LINE__);
        }
        if (is_null($clickCount) || (is_array($clickCount) && empty($clickCount))) {
            unset($this->ClickCount);
        } else {
            $this->ClickCount = $clickCount;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreatedUtcDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedUtcDate()
    {
        return isset($this->CreatedUtcDate) ? $this->CreatedUtcDate : null;
    }
    /**
     * Set CreatedUtcDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdUtcDate
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setCreatedUtcDate($createdUtcDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdUtcDate) && !is_string($createdUtcDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdUtcDate, true), gettype($createdUtcDate)), __LINE__);
        }
        if (is_null($createdUtcDate) || (is_array($createdUtcDate) && empty($createdUtcDate))) {
            unset($this->CreatedUtcDate);
        } else {
            $this->CreatedUtcDate = $createdUtcDate;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get CultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCultureId()
    {
        return isset($this->CultureId) ? $this->CultureId : null;
    }
    /**
     * Set CultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cultureId
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setCultureId($cultureId = null)
    {
        // validation for constraint: int
        if (!is_null($cultureId) && !(is_int($cultureId) || ctype_digit($cultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cultureId, true), gettype($cultureId)), __LINE__);
        }
        if (is_null($cultureId) || (is_array($cultureId) && empty($cultureId))) {
            unset($this->CultureId);
        } else {
            $this->CultureId = $cultureId;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get ExternalMessageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalMessageId()
    {
        return isset($this->ExternalMessageId) ? $this->ExternalMessageId : null;
    }
    /**
     * Set ExternalMessageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalMessageId
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setExternalMessageId($externalMessageId = null)
    {
        // validation for constraint: string
        if (!is_null($externalMessageId) && !is_string($externalMessageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalMessageId, true), gettype($externalMessageId)), __LINE__);
        }
        if (is_null($externalMessageId) || (is_array($externalMessageId) && empty($externalMessageId))) {
            unset($this->ExternalMessageId);
        } else {
            $this->ExternalMessageId = $externalMessageId;
        }
        return $this;
    }
    /**
     * Get FinalMessageStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinalMessageStatus()
    {
        return isset($this->FinalMessageStatus) ? $this->FinalMessageStatus : null;
    }
    /**
     * Set FinalMessageStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinalMessageStatus::valueIsValid()
     * @uses \patest\EnumType\FinalMessageStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $finalMessageStatus
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setFinalMessageStatus($finalMessageStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinalMessageStatus::valueIsValid($finalMessageStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinalMessageStatus', is_array($finalMessageStatus) ? implode(', ', $finalMessageStatus) : var_export($finalMessageStatus, true), implode(', ', \patest\EnumType\FinalMessageStatus::getValidValues())), __LINE__);
        }
        if (is_null($finalMessageStatus) || (is_array($finalMessageStatus) && empty($finalMessageStatus))) {
            unset($this->FinalMessageStatus);
        } else {
            $this->FinalMessageStatus = $finalMessageStatus;
        }
        return $this;
    }
    /**
     * Get IsHandled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHandled()
    {
        return isset($this->IsHandled) ? $this->IsHandled : null;
    }
    /**
     * Set IsHandled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHandled
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setIsHandled($isHandled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHandled) && !is_bool($isHandled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHandled, true), gettype($isHandled)), __LINE__);
        }
        if (is_null($isHandled) || (is_array($isHandled) && empty($isHandled))) {
            unset($this->IsHandled);
        } else {
            $this->IsHandled = $isHandled;
        }
        return $this;
    }
    /**
     * Get IsSuccessful value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSuccessful()
    {
        return isset($this->IsSuccessful) ? $this->IsSuccessful : null;
    }
    /**
     * Set IsSuccessful value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSuccessful
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setIsSuccessful($isSuccessful = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSuccessful) && !is_bool($isSuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSuccessful, true), gettype($isSuccessful)), __LINE__);
        }
        if (is_null($isSuccessful) || (is_array($isSuccessful) && empty($isSuccessful))) {
            unset($this->IsSuccessful);
        } else {
            $this->IsSuccessful = $isSuccessful;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get LastProcessUtcDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastProcessUtcDate()
    {
        return isset($this->LastProcessUtcDate) ? $this->LastProcessUtcDate : null;
    }
    /**
     * Set LastProcessUtcDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastProcessUtcDate
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setLastProcessUtcDate($lastProcessUtcDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastProcessUtcDate) && !is_string($lastProcessUtcDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastProcessUtcDate, true), gettype($lastProcessUtcDate)), __LINE__);
        }
        if (is_null($lastProcessUtcDate) || (is_array($lastProcessUtcDate) && empty($lastProcessUtcDate))) {
            unset($this->LastProcessUtcDate);
        } else {
            $this->LastProcessUtcDate = $lastProcessUtcDate;
        }
        return $this;
    }
    /**
     * Get MessageStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessageStatus()
    {
        return isset($this->MessageStatus) ? $this->MessageStatus : null;
    }
    /**
     * Set MessageStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $messageStatus
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setMessageStatus($messageStatus = null)
    {
        // validation for constraint: string
        if (!is_null($messageStatus) && !is_string($messageStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageStatus, true), gettype($messageStatus)), __LINE__);
        }
        if (is_null($messageStatus) || (is_array($messageStatus) && empty($messageStatus))) {
            unset($this->MessageStatus);
        } else {
            $this->MessageStatus = $messageStatus;
        }
        return $this;
    }
    /**
     * Get Mobile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobile()
    {
        return isset($this->Mobile) ? $this->Mobile : null;
    }
    /**
     * Set Mobile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobile
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        if (is_null($mobile) || (is_array($mobile) && empty($mobile))) {
            unset($this->Mobile);
        } else {
            $this->Mobile = $mobile;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductId()
    {
        return isset($this->ProductId) ? $this->ProductId : null;
    }
    /**
     * Set ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productId
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->ProductId);
        } else {
            $this->ProductId = $productId;
        }
        return $this;
    }
    /**
     * Get Request value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequest()
    {
        return isset($this->Request) ? $this->Request : null;
    }
    /**
     * Set Request value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $request
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setRequest($request = null)
    {
        // validation for constraint: string
        if (!is_null($request) && !is_string($request)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request, true), gettype($request)), __LINE__);
        }
        if (is_null($request) || (is_array($request) && empty($request))) {
            unset($this->Request);
        } else {
            $this->Request = $request;
        }
        return $this;
    }
    /**
     * Get Response value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponse()
    {
        return isset($this->Response) ? $this->Response : null;
    }
    /**
     * Set Response value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $response
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setResponse($response = null)
    {
        // validation for constraint: string
        if (!is_null($response) && !is_string($response)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response, true), gettype($response)), __LINE__);
        }
        if (is_null($response) || (is_array($response) && empty($response))) {
            unset($this->Response);
        } else {
            $this->Response = $response;
        }
        return $this;
    }
    /**
     * Get RetryCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRetryCount()
    {
        return isset($this->RetryCount) ? $this->RetryCount : null;
    }
    /**
     * Set RetryCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $retryCount
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setRetryCount($retryCount = null)
    {
        // validation for constraint: int
        if (!is_null($retryCount) && !(is_int($retryCount) || ctype_digit($retryCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retryCount, true), gettype($retryCount)), __LINE__);
        }
        if (is_null($retryCount) || (is_array($retryCount) && empty($retryCount))) {
            unset($this->RetryCount);
        } else {
            $this->RetryCount = $retryCount;
        }
        return $this;
    }
    /**
     * Get SearchableMobile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSearchableMobile()
    {
        return isset($this->SearchableMobile) ? $this->SearchableMobile : null;
    }
    /**
     * Set SearchableMobile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $searchableMobile
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setSearchableMobile($searchableMobile = null)
    {
        // validation for constraint: string
        if (!is_null($searchableMobile) && !is_string($searchableMobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchableMobile, true), gettype($searchableMobile)), __LINE__);
        }
        if (is_null($searchableMobile) || (is_array($searchableMobile) && empty($searchableMobile))) {
            unset($this->SearchableMobile);
        } else {
            $this->SearchableMobile = $searchableMobile;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceSpecificIds()
    {
        return isset($this->ServiceSpecificIds) ? $this->ServiceSpecificIds : null;
    }
    /**
     * Set ServiceSpecificIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceSpecificIds
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setServiceSpecificIds($serviceSpecificIds = null)
    {
        // validation for constraint: string
        if (!is_null($serviceSpecificIds) && !is_string($serviceSpecificIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceSpecificIds, true), gettype($serviceSpecificIds)), __LINE__);
        }
        if (is_null($serviceSpecificIds) || (is_array($serviceSpecificIds) && empty($serviceSpecificIds))) {
            unset($this->ServiceSpecificIds);
        } else {
            $this->ServiceSpecificIds = $serviceSpecificIds;
        }
        return $this;
    }
    /**
     * Get TrackMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTrackMessage()
    {
        return isset($this->TrackMessage) ? $this->TrackMessage : null;
    }
    /**
     * Set TrackMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $trackMessage
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setTrackMessage($trackMessage = null)
    {
        // validation for constraint: boolean
        if (!is_null($trackMessage) && !is_bool($trackMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($trackMessage, true), gettype($trackMessage)), __LINE__);
        }
        if (is_null($trackMessage) || (is_array($trackMessage) && empty($trackMessage))) {
            unset($this->TrackMessage);
        } else {
            $this->TrackMessage = $trackMessage;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Sales_SMSCollectionSender
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
