<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ReservationItemEnhanced StructType
 * @subpackage Structs
 */
class Sales_ReservationItemEnhanced extends PersistableEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The DefinitionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefinitionId;
    /**
     * The DueAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DueAmount;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventGuid;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDate;
    /**
     * The ExtraFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraFields;
    /**
     * The GroupProductKey
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupProductKey;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HasHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasHistory;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The IdInTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInTransaction;
    /**
     * The IsCancelled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCancelled;
    /**
     * The IsComplimentary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsComplimentary;
    /**
     * The IsPrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrinted;
    /**
     * The IsTicketObsolete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTicketObsolete;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Item;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ItemName;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The NormalizedRowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NormalizedRowName;
    /**
     * The NormalizedSeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NormalizedSeatName;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The PriceLevelGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelGuid;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PurchaserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserId;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SalesRepClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepClientId;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SectorName;
    /**
     * The ServiceSpecificId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServiceSpecificId;
    /**
     * The StandId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StandId;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNotes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionNotes;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TransactionReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionReferenceNumber;
    /**
     * Constructor method for Sales.ReservationItemEnhanced
     * @uses Sales_ReservationItemEnhanced::setAreaId()
     * @uses Sales_ReservationItemEnhanced::setDefinitionId()
     * @uses Sales_ReservationItemEnhanced::setDueAmount()
     * @uses Sales_ReservationItemEnhanced::setEventDate()
     * @uses Sales_ReservationItemEnhanced::setEventGuid()
     * @uses Sales_ReservationItemEnhanced::setExpiryDate()
     * @uses Sales_ReservationItemEnhanced::setExtraFields()
     * @uses Sales_ReservationItemEnhanced::setGroupProductKey()
     * @uses Sales_ReservationItemEnhanced::setHallId()
     * @uses Sales_ReservationItemEnhanced::setHasHistory()
     * @uses Sales_ReservationItemEnhanced::setHolderCompanyId()
     * @uses Sales_ReservationItemEnhanced::setIdInTransaction()
     * @uses Sales_ReservationItemEnhanced::setIsCancelled()
     * @uses Sales_ReservationItemEnhanced::setIsComplimentary()
     * @uses Sales_ReservationItemEnhanced::setIsPrinted()
     * @uses Sales_ReservationItemEnhanced::setIsTicketObsolete()
     * @uses Sales_ReservationItemEnhanced::setItem()
     * @uses Sales_ReservationItemEnhanced::setItemName()
     * @uses Sales_ReservationItemEnhanced::setItemType()
     * @uses Sales_ReservationItemEnhanced::setNormalizedRowName()
     * @uses Sales_ReservationItemEnhanced::setNormalizedSeatName()
     * @uses Sales_ReservationItemEnhanced::setOwnerId()
     * @uses Sales_ReservationItemEnhanced::setPriceLevelGuid()
     * @uses Sales_ReservationItemEnhanced::setPriceTypeId()
     * @uses Sales_ReservationItemEnhanced::setPurchaserId()
     * @uses Sales_ReservationItemEnhanced::setRowName()
     * @uses Sales_ReservationItemEnhanced::setSalesRepClientId()
     * @uses Sales_ReservationItemEnhanced::setSeatName()
     * @uses Sales_ReservationItemEnhanced::setSectorName()
     * @uses Sales_ReservationItemEnhanced::setServiceSpecificId()
     * @uses Sales_ReservationItemEnhanced::setStandId()
     * @uses Sales_ReservationItemEnhanced::setSubscriptionNumber()
     * @uses Sales_ReservationItemEnhanced::setTransactionDate()
     * @uses Sales_ReservationItemEnhanced::setTransactionGuid()
     * @uses Sales_ReservationItemEnhanced::setTransactionNotes()
     * @uses Sales_ReservationItemEnhanced::setTransactionNumber()
     * @uses Sales_ReservationItemEnhanced::setTransactionReferenceNumber()
     * @param string $areaId
     * @param string $definitionId
     * @param \patest\StructType\Money $dueAmount
     * @param string $eventDate
     * @param string $eventGuid
     * @param string $expiryDate
     * @param string $extraFields
     * @param string $groupProductKey
     * @param string $hallId
     * @param bool $hasHistory
     * @param int $holderCompanyId
     * @param int $idInTransaction
     * @param bool $isCancelled
     * @param bool $isComplimentary
     * @param bool $isPrinted
     * @param bool $isTicketObsolete
     * @param string $item
     * @param \patest\StructType\GlobalString $itemName
     * @param int $itemType
     * @param string $normalizedRowName
     * @param string $normalizedSeatName
     * @param string $ownerId
     * @param string $priceLevelGuid
     * @param string $priceTypeId
     * @param string $purchaserId
     * @param string $rowName
     * @param string $salesRepClientId
     * @param string $seatName
     * @param \patest\StructType\GlobalString $sectorName
     * @param string $serviceSpecificId
     * @param string $standId
     * @param string $subscriptionNumber
     * @param string $transactionDate
     * @param string $transactionGuid
     * @param string $transactionNotes
     * @param int $transactionNumber
     * @param int $transactionReferenceNumber
     */
    public function __construct($areaId = null, $definitionId = null, \patest\StructType\Money $dueAmount = null, $eventDate = null, $eventGuid = null, $expiryDate = null, $extraFields = null, $groupProductKey = null, $hallId = null, $hasHistory = null, $holderCompanyId = null, $idInTransaction = null, $isCancelled = null, $isComplimentary = null, $isPrinted = null, $isTicketObsolete = null, $item = null, \patest\StructType\GlobalString $itemName = null, $itemType = null, $normalizedRowName = null, $normalizedSeatName = null, $ownerId = null, $priceLevelGuid = null, $priceTypeId = null, $purchaserId = null, $rowName = null, $salesRepClientId = null, $seatName = null, \patest\StructType\GlobalString $sectorName = null, $serviceSpecificId = null, $standId = null, $subscriptionNumber = null, $transactionDate = null, $transactionGuid = null, $transactionNotes = null, $transactionNumber = null, $transactionReferenceNumber = null)
    {
        $this
            ->setAreaId($areaId)
            ->setDefinitionId($definitionId)
            ->setDueAmount($dueAmount)
            ->setEventDate($eventDate)
            ->setEventGuid($eventGuid)
            ->setExpiryDate($expiryDate)
            ->setExtraFields($extraFields)
            ->setGroupProductKey($groupProductKey)
            ->setHallId($hallId)
            ->setHasHistory($hasHistory)
            ->setHolderCompanyId($holderCompanyId)
            ->setIdInTransaction($idInTransaction)
            ->setIsCancelled($isCancelled)
            ->setIsComplimentary($isComplimentary)
            ->setIsPrinted($isPrinted)
            ->setIsTicketObsolete($isTicketObsolete)
            ->setItem($item)
            ->setItemName($itemName)
            ->setItemType($itemType)
            ->setNormalizedRowName($normalizedRowName)
            ->setNormalizedSeatName($normalizedSeatName)
            ->setOwnerId($ownerId)
            ->setPriceLevelGuid($priceLevelGuid)
            ->setPriceTypeId($priceTypeId)
            ->setPurchaserId($purchaserId)
            ->setRowName($rowName)
            ->setSalesRepClientId($salesRepClientId)
            ->setSeatName($seatName)
            ->setSectorName($sectorName)
            ->setServiceSpecificId($serviceSpecificId)
            ->setStandId($standId)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setTransactionDate($transactionDate)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNotes($transactionNotes)
            ->setTransactionNumber($transactionNumber)
            ->setTransactionReferenceNumber($transactionReferenceNumber);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get DefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefinitionId()
    {
        return isset($this->DefinitionId) ? $this->DefinitionId : null;
    }
    /**
     * Set DefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $definitionId
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setDefinitionId($definitionId = null)
    {
        // validation for constraint: string
        if (!is_null($definitionId) && !is_string($definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($definitionId, true), gettype($definitionId)), __LINE__);
        }
        if (is_null($definitionId) || (is_array($definitionId) && empty($definitionId))) {
            unset($this->DefinitionId);
        } else {
            $this->DefinitionId = $definitionId;
        }
        return $this;
    }
    /**
     * Get DueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDueAmount()
    {
        return isset($this->DueAmount) ? $this->DueAmount : null;
    }
    /**
     * Set DueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $dueAmount
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setDueAmount(\patest\StructType\Money $dueAmount = null)
    {
        if (is_null($dueAmount) || (is_array($dueAmount) && empty($dueAmount))) {
            unset($this->DueAmount);
        } else {
            $this->DueAmount = $dueAmount;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventGuid()
    {
        return isset($this->EventGuid) ? $this->EventGuid : null;
    }
    /**
     * Set EventGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventGuid
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setEventGuid($eventGuid = null)
    {
        // validation for constraint: string
        if (!is_null($eventGuid) && !is_string($eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGuid, true), gettype($eventGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventGuid, true)), __LINE__);
        }
        if (is_null($eventGuid) || (is_array($eventGuid) && empty($eventGuid))) {
            unset($this->EventGuid);
        } else {
            $this->EventGuid = $eventGuid;
        }
        return $this;
    }
    /**
     * Get ExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDate()
    {
        return isset($this->ExpiryDate) ? $this->ExpiryDate : null;
    }
    /**
     * Set ExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDate
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        if (is_null($expiryDate) || (is_array($expiryDate) && empty($expiryDate))) {
            unset($this->ExpiryDate);
        } else {
            $this->ExpiryDate = $expiryDate;
        }
        return $this;
    }
    /**
     * Get ExtraFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraFields()
    {
        return isset($this->ExtraFields) ? $this->ExtraFields : null;
    }
    /**
     * Set ExtraFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraFields
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setExtraFields($extraFields = null)
    {
        // validation for constraint: string
        if (!is_null($extraFields) && !is_string($extraFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraFields, true), gettype($extraFields)), __LINE__);
        }
        if (is_null($extraFields) || (is_array($extraFields) && empty($extraFields))) {
            unset($this->ExtraFields);
        } else {
            $this->ExtraFields = $extraFields;
        }
        return $this;
    }
    /**
     * Get GroupProductKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupProductKey()
    {
        return isset($this->GroupProductKey) ? $this->GroupProductKey : null;
    }
    /**
     * Set GroupProductKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupProductKey
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setGroupProductKey($groupProductKey = null)
    {
        // validation for constraint: string
        if (!is_null($groupProductKey) && !is_string($groupProductKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupProductKey, true), gettype($groupProductKey)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($groupProductKey) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $groupProductKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($groupProductKey, true)), __LINE__);
        }
        if (is_null($groupProductKey) || (is_array($groupProductKey) && empty($groupProductKey))) {
            unset($this->GroupProductKey);
        } else {
            $this->GroupProductKey = $groupProductKey;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HasHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasHistory()
    {
        return isset($this->HasHistory) ? $this->HasHistory : null;
    }
    /**
     * Set HasHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasHistory
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setHasHistory($hasHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasHistory) && !is_bool($hasHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasHistory, true), gettype($hasHistory)), __LINE__);
        }
        if (is_null($hasHistory) || (is_array($hasHistory) && empty($hasHistory))) {
            unset($this->HasHistory);
        } else {
            $this->HasHistory = $hasHistory;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get IdInTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInTransaction()
    {
        return isset($this->IdInTransaction) ? $this->IdInTransaction : null;
    }
    /**
     * Set IdInTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInTransaction
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setIdInTransaction($idInTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInTransaction) && !(is_int($idInTransaction) || ctype_digit($idInTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInTransaction, true), gettype($idInTransaction)), __LINE__);
        }
        if (is_null($idInTransaction) || (is_array($idInTransaction) && empty($idInTransaction))) {
            unset($this->IdInTransaction);
        } else {
            $this->IdInTransaction = $idInTransaction;
        }
        return $this;
    }
    /**
     * Get IsCancelled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCancelled()
    {
        return isset($this->IsCancelled) ? $this->IsCancelled : null;
    }
    /**
     * Set IsCancelled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCancelled
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setIsCancelled($isCancelled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCancelled) && !is_bool($isCancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCancelled, true), gettype($isCancelled)), __LINE__);
        }
        if (is_null($isCancelled) || (is_array($isCancelled) && empty($isCancelled))) {
            unset($this->IsCancelled);
        } else {
            $this->IsCancelled = $isCancelled;
        }
        return $this;
    }
    /**
     * Get IsComplimentary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsComplimentary()
    {
        return isset($this->IsComplimentary) ? $this->IsComplimentary : null;
    }
    /**
     * Set IsComplimentary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isComplimentary
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setIsComplimentary($isComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplimentary) && !is_bool($isComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplimentary, true), gettype($isComplimentary)), __LINE__);
        }
        if (is_null($isComplimentary) || (is_array($isComplimentary) && empty($isComplimentary))) {
            unset($this->IsComplimentary);
        } else {
            $this->IsComplimentary = $isComplimentary;
        }
        return $this;
    }
    /**
     * Get IsPrinted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrinted()
    {
        return isset($this->IsPrinted) ? $this->IsPrinted : null;
    }
    /**
     * Set IsPrinted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrinted
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setIsPrinted($isPrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinted) && !is_bool($isPrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinted, true), gettype($isPrinted)), __LINE__);
        }
        if (is_null($isPrinted) || (is_array($isPrinted) && empty($isPrinted))) {
            unset($this->IsPrinted);
        } else {
            $this->IsPrinted = $isPrinted;
        }
        return $this;
    }
    /**
     * Get IsTicketObsolete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTicketObsolete()
    {
        return isset($this->IsTicketObsolete) ? $this->IsTicketObsolete : null;
    }
    /**
     * Set IsTicketObsolete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTicketObsolete
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setIsTicketObsolete($isTicketObsolete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTicketObsolete) && !is_bool($isTicketObsolete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTicketObsolete, true), gettype($isTicketObsolete)), __LINE__);
        }
        if (is_null($isTicketObsolete) || (is_array($isTicketObsolete) && empty($isTicketObsolete))) {
            unset($this->IsTicketObsolete);
        } else {
            $this->IsTicketObsolete = $isTicketObsolete;
        }
        return $this;
    }
    /**
     * Get Item value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItem()
    {
        return isset($this->Item) ? $this->Item : null;
    }
    /**
     * Set Item value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $item
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setItem($item = null)
    {
        // validation for constraint: string
        if (!is_null($item) && !is_string($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item, true), gettype($item)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($item) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($item, true)), __LINE__);
        }
        if (is_null($item) || (is_array($item) && empty($item))) {
            unset($this->Item);
        } else {
            $this->Item = $item;
        }
        return $this;
    }
    /**
     * Get ItemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getItemName()
    {
        return isset($this->ItemName) ? $this->ItemName : null;
    }
    /**
     * Set ItemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $itemName
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setItemName(\patest\StructType\GlobalString $itemName = null)
    {
        if (is_null($itemName) || (is_array($itemName) && empty($itemName))) {
            unset($this->ItemName);
        } else {
            $this->ItemName = $itemName;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get NormalizedRowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNormalizedRowName()
    {
        return isset($this->NormalizedRowName) ? $this->NormalizedRowName : null;
    }
    /**
     * Set NormalizedRowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $normalizedRowName
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setNormalizedRowName($normalizedRowName = null)
    {
        // validation for constraint: string
        if (!is_null($normalizedRowName) && !is_string($normalizedRowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalizedRowName, true), gettype($normalizedRowName)), __LINE__);
        }
        if (is_null($normalizedRowName) || (is_array($normalizedRowName) && empty($normalizedRowName))) {
            unset($this->NormalizedRowName);
        } else {
            $this->NormalizedRowName = $normalizedRowName;
        }
        return $this;
    }
    /**
     * Get NormalizedSeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNormalizedSeatName()
    {
        return isset($this->NormalizedSeatName) ? $this->NormalizedSeatName : null;
    }
    /**
     * Set NormalizedSeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $normalizedSeatName
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setNormalizedSeatName($normalizedSeatName = null)
    {
        // validation for constraint: string
        if (!is_null($normalizedSeatName) && !is_string($normalizedSeatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalizedSeatName, true), gettype($normalizedSeatName)), __LINE__);
        }
        if (is_null($normalizedSeatName) || (is_array($normalizedSeatName) && empty($normalizedSeatName))) {
            unset($this->NormalizedSeatName);
        } else {
            $this->NormalizedSeatName = $normalizedSeatName;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get PriceLevelGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelGuid()
    {
        return isset($this->PriceLevelGuid) ? $this->PriceLevelGuid : null;
    }
    /**
     * Set PriceLevelGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelGuid
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setPriceLevelGuid($priceLevelGuid = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelGuid) && !is_string($priceLevelGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelGuid, true), gettype($priceLevelGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelGuid, true)), __LINE__);
        }
        if (is_null($priceLevelGuid) || (is_array($priceLevelGuid) && empty($priceLevelGuid))) {
            unset($this->PriceLevelGuid);
        } else {
            $this->PriceLevelGuid = $priceLevelGuid;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PurchaserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserId()
    {
        return isset($this->PurchaserId) ? $this->PurchaserId : null;
    }
    /**
     * Set PurchaserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserId
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setPurchaserId($purchaserId = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserId) && !is_string($purchaserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserId, true), gettype($purchaserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserId, true)), __LINE__);
        }
        if (is_null($purchaserId) || (is_array($purchaserId) && empty($purchaserId))) {
            unset($this->PurchaserId);
        } else {
            $this->PurchaserId = $purchaserId;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SalesRepClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepClientId()
    {
        return isset($this->SalesRepClientId) ? $this->SalesRepClientId : null;
    }
    /**
     * Set SalesRepClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepClientId
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setSalesRepClientId($salesRepClientId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepClientId) && !is_string($salesRepClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepClientId, true), gettype($salesRepClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepClientId, true)), __LINE__);
        }
        if (is_null($salesRepClientId) || (is_array($salesRepClientId) && empty($salesRepClientId))) {
            unset($this->SalesRepClientId);
        } else {
            $this->SalesRepClientId = $salesRepClientId;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sectorName
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setSectorName(\patest\StructType\GlobalString $sectorName = null)
    {
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceSpecificId()
    {
        return isset($this->ServiceSpecificId) ? $this->ServiceSpecificId : null;
    }
    /**
     * Set ServiceSpecificId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceSpecificId
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setServiceSpecificId($serviceSpecificId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceSpecificId) && !is_string($serviceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceSpecificId, true), gettype($serviceSpecificId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($serviceSpecificId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $serviceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($serviceSpecificId, true)), __LINE__);
        }
        if (is_null($serviceSpecificId) || (is_array($serviceSpecificId) && empty($serviceSpecificId))) {
            unset($this->ServiceSpecificId);
        } else {
            $this->ServiceSpecificId = $serviceSpecificId;
        }
        return $this;
    }
    /**
     * Get StandId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStandId()
    {
        return isset($this->StandId) ? $this->StandId : null;
    }
    /**
     * Set StandId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $standId
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setStandId($standId = null)
    {
        // validation for constraint: string
        if (!is_null($standId) && !is_string($standId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standId, true), gettype($standId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($standId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $standId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($standId, true)), __LINE__);
        }
        if (is_null($standId) || (is_array($standId) && empty($standId))) {
            unset($this->StandId);
        } else {
            $this->StandId = $standId;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionNotes()
    {
        return isset($this->TransactionNotes) ? $this->TransactionNotes : null;
    }
    /**
     * Set TransactionNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionNotes
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setTransactionNotes($transactionNotes = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNotes) && !is_string($transactionNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNotes, true), gettype($transactionNotes)), __LINE__);
        }
        if (is_null($transactionNotes) || (is_array($transactionNotes) && empty($transactionNotes))) {
            unset($this->TransactionNotes);
        } else {
            $this->TransactionNotes = $transactionNotes;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionReferenceNumber()
    {
        return isset($this->TransactionReferenceNumber) ? $this->TransactionReferenceNumber : null;
    }
    /**
     * Set TransactionReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionReferenceNumber
     * @return \patest\StructType\Sales_ReservationItemEnhanced
     */
    public function setTransactionReferenceNumber($transactionReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionReferenceNumber) && !(is_int($transactionReferenceNumber) || ctype_digit($transactionReferenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionReferenceNumber, true), gettype($transactionReferenceNumber)), __LINE__);
        }
        if (is_null($transactionReferenceNumber) || (is_array($transactionReferenceNumber) && empty($transactionReferenceNumber))) {
            unset($this->TransactionReferenceNumber);
        } else {
            $this->TransactionReferenceNumber = $transactionReferenceNumber;
        }
        return $this;
    }
}
