<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.Prompt StructType
 * @subpackage Structs
 */
class Sales_Prompt extends Sales_Combination
{
    /**
     * The DialogFormName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DialogFormName;
    /**
     * The LinkExtrasToProductOfElement
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LinkExtrasToProductOfElement;
    /**
     * The MessageToDisplay
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MessageToDisplay;
    /**
     * The MessageType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MessageType;
    /**
     * The ShowOnExtraPage
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowOnExtraPage;
    /**
     * The SubType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubType;
    /**
     * Constructor method for Sales.Prompt
     * @uses Sales_Prompt::setDialogFormName()
     * @uses Sales_Prompt::setLinkExtrasToProductOfElement()
     * @uses Sales_Prompt::setMessageToDisplay()
     * @uses Sales_Prompt::setMessageType()
     * @uses Sales_Prompt::setShowOnExtraPage()
     * @uses Sales_Prompt::setSubType()
     * @param string $dialogFormName
     * @param string $linkExtrasToProductOfElement
     * @param \patest\StructType\GlobalString $messageToDisplay
     * @param string $messageType
     * @param bool $showOnExtraPage
     * @param string $subType
     */
    public function __construct($dialogFormName = null, $linkExtrasToProductOfElement = null, \patest\StructType\GlobalString $messageToDisplay = null, $messageType = null, $showOnExtraPage = null, $subType = null)
    {
        $this
            ->setDialogFormName($dialogFormName)
            ->setLinkExtrasToProductOfElement($linkExtrasToProductOfElement)
            ->setMessageToDisplay($messageToDisplay)
            ->setMessageType($messageType)
            ->setShowOnExtraPage($showOnExtraPage)
            ->setSubType($subType);
    }
    /**
     * Get DialogFormName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDialogFormName()
    {
        return isset($this->DialogFormName) ? $this->DialogFormName : null;
    }
    /**
     * Set DialogFormName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dialogFormName
     * @return \patest\StructType\Sales_Prompt
     */
    public function setDialogFormName($dialogFormName = null)
    {
        // validation for constraint: string
        if (!is_null($dialogFormName) && !is_string($dialogFormName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dialogFormName, true), gettype($dialogFormName)), __LINE__);
        }
        if (is_null($dialogFormName) || (is_array($dialogFormName) && empty($dialogFormName))) {
            unset($this->DialogFormName);
        } else {
            $this->DialogFormName = $dialogFormName;
        }
        return $this;
    }
    /**
     * Get LinkExtrasToProductOfElement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkExtrasToProductOfElement()
    {
        return isset($this->LinkExtrasToProductOfElement) ? $this->LinkExtrasToProductOfElement : null;
    }
    /**
     * Set LinkExtrasToProductOfElement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkExtrasToProductOfElement
     * @return \patest\StructType\Sales_Prompt
     */
    public function setLinkExtrasToProductOfElement($linkExtrasToProductOfElement = null)
    {
        // validation for constraint: string
        if (!is_null($linkExtrasToProductOfElement) && !is_string($linkExtrasToProductOfElement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkExtrasToProductOfElement, true), gettype($linkExtrasToProductOfElement)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($linkExtrasToProductOfElement) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $linkExtrasToProductOfElement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($linkExtrasToProductOfElement, true)), __LINE__);
        }
        if (is_null($linkExtrasToProductOfElement) || (is_array($linkExtrasToProductOfElement) && empty($linkExtrasToProductOfElement))) {
            unset($this->LinkExtrasToProductOfElement);
        } else {
            $this->LinkExtrasToProductOfElement = $linkExtrasToProductOfElement;
        }
        return $this;
    }
    /**
     * Get MessageToDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMessageToDisplay()
    {
        return isset($this->MessageToDisplay) ? $this->MessageToDisplay : null;
    }
    /**
     * Set MessageToDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $messageToDisplay
     * @return \patest\StructType\Sales_Prompt
     */
    public function setMessageToDisplay(\patest\StructType\GlobalString $messageToDisplay = null)
    {
        if (is_null($messageToDisplay) || (is_array($messageToDisplay) && empty($messageToDisplay))) {
            unset($this->MessageToDisplay);
        } else {
            $this->MessageToDisplay = $messageToDisplay;
        }
        return $this;
    }
    /**
     * Get MessageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessageType()
    {
        return isset($this->MessageType) ? $this->MessageType : null;
    }
    /**
     * Set MessageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PromptMessageType::valueIsValid()
     * @uses \patest\EnumType\PromptMessageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messageType
     * @return \patest\StructType\Sales_Prompt
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PromptMessageType::valueIsValid($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PromptMessageType', is_array($messageType) ? implode(', ', $messageType) : var_export($messageType, true), implode(', ', \patest\EnumType\PromptMessageType::getValidValues())), __LINE__);
        }
        if (is_null($messageType) || (is_array($messageType) && empty($messageType))) {
            unset($this->MessageType);
        } else {
            $this->MessageType = $messageType;
        }
        return $this;
    }
    /**
     * Get ShowOnExtraPage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowOnExtraPage()
    {
        return isset($this->ShowOnExtraPage) ? $this->ShowOnExtraPage : null;
    }
    /**
     * Set ShowOnExtraPage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showOnExtraPage
     * @return \patest\StructType\Sales_Prompt
     */
    public function setShowOnExtraPage($showOnExtraPage = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOnExtraPage) && !is_bool($showOnExtraPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOnExtraPage, true), gettype($showOnExtraPage)), __LINE__);
        }
        if (is_null($showOnExtraPage) || (is_array($showOnExtraPage) && empty($showOnExtraPage))) {
            unset($this->ShowOnExtraPage);
        } else {
            $this->ShowOnExtraPage = $showOnExtraPage;
        }
        return $this;
    }
    /**
     * Get SubType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubType()
    {
        return isset($this->SubType) ? $this->SubType : null;
    }
    /**
     * Set SubType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PromptSubType::valueIsValid()
     * @uses \patest\EnumType\PromptSubType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subType
     * @return \patest\StructType\Sales_Prompt
     */
    public function setSubType($subType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PromptSubType::valueIsValid($subType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PromptSubType', is_array($subType) ? implode(', ', $subType) : var_export($subType, true), implode(', ', \patest\EnumType\PromptSubType::getValidValues())), __LINE__);
        }
        if (is_null($subType) || (is_array($subType) && empty($subType))) {
            unset($this->SubType);
        } else {
            $this->SubType = $subType;
        }
        return $this;
    }
}
