<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.PromoCodeProductPackageElement StructType
 * @subpackage Structs
 */
class Sales_PromoCodeProductPackageElement extends Sales_ProductPackageElement
{
    /**
     * The AllocationTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AllocationTypeId;
    /**
     * The PriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceTypes
     */
    public $PriceTypes;
    /**
     * Constructor method for Sales.PromoCodeProductPackageElement
     * @uses Sales_PromoCodeProductPackageElement::setAllocationTypeId()
     * @uses Sales_PromoCodeProductPackageElement::setPriceTypes()
     * @param string $allocationTypeId
     * @param \patest\StructType\PriceTypes $priceTypes
     */
    public function __construct($allocationTypeId = null, \patest\StructType\PriceTypes $priceTypes = null)
    {
        $this
            ->setAllocationTypeId($allocationTypeId)
            ->setPriceTypes($priceTypes);
    }
    /**
     * Get AllocationTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationTypeId()
    {
        return isset($this->AllocationTypeId) ? $this->AllocationTypeId : null;
    }
    /**
     * Set AllocationTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationTypeId
     * @return \patest\StructType\Sales_PromoCodeProductPackageElement
     */
    public function setAllocationTypeId($allocationTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($allocationTypeId) && !is_string($allocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationTypeId, true), gettype($allocationTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($allocationTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $allocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($allocationTypeId, true)), __LINE__);
        }
        if (is_null($allocationTypeId) || (is_array($allocationTypeId) && empty($allocationTypeId))) {
            unset($this->AllocationTypeId);
        } else {
            $this->AllocationTypeId = $allocationTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceTypes|null
     */
    public function getPriceTypes()
    {
        return isset($this->PriceTypes) ? $this->PriceTypes : null;
    }
    /**
     * Set PriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceTypes $priceTypes
     * @return \patest\StructType\Sales_PromoCodeProductPackageElement
     */
    public function setPriceTypes(\patest\StructType\PriceTypes $priceTypes = null)
    {
        if (is_null($priceTypes) || (is_array($priceTypes) && empty($priceTypes))) {
            unset($this->PriceTypes);
        } else {
            $this->PriceTypes = $priceTypes;
        }
        return $this;
    }
}
