<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ProductPriceType StructType
 * @subpackage Structs
 */
class Sales_ProductPriceType extends AnyEntity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The MaxPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MaxPrice;
    /**
     * The MinPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MinPrice;
    /**
     * Constructor method for Sales.ProductPriceType
     * @uses Sales_ProductPriceType::setDescription()
     * @uses Sales_ProductPriceType::setId()
     * @uses Sales_ProductPriceType::setMaxPrice()
     * @uses Sales_ProductPriceType::setMinPrice()
     * @param string $description
     * @param string $id
     * @param \patest\StructType\Money $maxPrice
     * @param \patest\StructType\Money $minPrice
     */
    public function __construct($description = null, $id = null, \patest\StructType\Money $maxPrice = null, \patest\StructType\Money $minPrice = null)
    {
        $this
            ->setDescription($description)
            ->setId($id)
            ->setMaxPrice($maxPrice)
            ->setMinPrice($minPrice);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Sales_ProductPriceType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Sales_ProductPriceType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get MaxPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMaxPrice()
    {
        return isset($this->MaxPrice) ? $this->MaxPrice : null;
    }
    /**
     * Set MaxPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $maxPrice
     * @return \patest\StructType\Sales_ProductPriceType
     */
    public function setMaxPrice(\patest\StructType\Money $maxPrice = null)
    {
        if (is_null($maxPrice) || (is_array($maxPrice) && empty($maxPrice))) {
            unset($this->MaxPrice);
        } else {
            $this->MaxPrice = $maxPrice;
        }
        return $this;
    }
    /**
     * Get MinPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMinPrice()
    {
        return isset($this->MinPrice) ? $this->MinPrice : null;
    }
    /**
     * Set MinPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $minPrice
     * @return \patest\StructType\Sales_ProductPriceType
     */
    public function setMinPrice(\patest\StructType\Money $minPrice = null)
    {
        if (is_null($minPrice) || (is_array($minPrice) && empty($minPrice))) {
            unset($this->MinPrice);
        } else {
            $this->MinPrice = $minPrice;
        }
        return $this;
    }
}
