<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.Printing.SaleMode StructType
 * @subpackage Structs
 */
class Sales_Printing_SaleMode extends Printing_Item_ComplexProperty_Base
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The InteractionChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InteractionChannel;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * Constructor method for Sales.Printing.SaleMode
     * @uses Sales_Printing_SaleMode::setDescription()
     * @uses Sales_Printing_SaleMode::setInteractionChannel()
     * @uses Sales_Printing_SaleMode::setName()
     * @param \patest\StructType\GlobalString $description
     * @param string $interactionChannel
     * @param \patest\StructType\GlobalString $name
     */
    public function __construct(\patest\StructType\GlobalString $description = null, $interactionChannel = null, \patest\StructType\GlobalString $name = null)
    {
        $this
            ->setDescription($description)
            ->setInteractionChannel($interactionChannel)
            ->setName($name);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Sales_Printing_SaleMode
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get InteractionChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInteractionChannel()
    {
        return isset($this->InteractionChannel) ? $this->InteractionChannel : null;
    }
    /**
     * Set InteractionChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionInteractionChannel::valueIsValid()
     * @uses \patest\EnumType\TransactionInteractionChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interactionChannel
     * @return \patest\StructType\Sales_Printing_SaleMode
     */
    public function setInteractionChannel($interactionChannel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionInteractionChannel::valueIsValid($interactionChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionInteractionChannel', is_array($interactionChannel) ? implode(', ', $interactionChannel) : var_export($interactionChannel, true), implode(', ', \patest\EnumType\TransactionInteractionChannel::getValidValues())), __LINE__);
        }
        if (is_null($interactionChannel) || (is_array($interactionChannel) && empty($interactionChannel))) {
            unset($this->InteractionChannel);
        } else {
            $this->InteractionChannel = $interactionChannel;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Sales_Printing_SaleMode
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
