<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.PriceModifiersFinancialJournal StructType
 * @subpackage Structs
 */
class Sales_PriceModifiersFinancialJournal extends PersistableEntity
{
    /**
     * The CreditAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CreditAmount;
    /**
     * The CreditKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditKind;
    /**
     * The DateTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTimeUtc;
    /**
     * The DebitAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DebitAmount;
    /**
     * The NetCreditAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $NetCreditAmount;
    /**
     * The NetDebitAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $NetDebitAmount;
    /**
     * The OperationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OperationId;
    /**
     * The ParentPriceModifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentPriceModifierId;
    /**
     * The PaymentInstallmentsScheduleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentInstallmentsScheduleId;
    /**
     * The PaymentItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentItemId;
    /**
     * The PriceModifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceModifierId;
    /**
     * The PriceModifierType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceModifierType;
    /**
     * The RootSubTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RootSubTargetId;
    /**
     * The RootTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RootTargetId;
    /**
     * The RootTargetKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RootTargetKind;
    /**
     * Constructor method for Sales.PriceModifiersFinancialJournal
     * @uses Sales_PriceModifiersFinancialJournal::setCreditAmount()
     * @uses Sales_PriceModifiersFinancialJournal::setCreditKind()
     * @uses Sales_PriceModifiersFinancialJournal::setDateTimeUtc()
     * @uses Sales_PriceModifiersFinancialJournal::setDebitAmount()
     * @uses Sales_PriceModifiersFinancialJournal::setNetCreditAmount()
     * @uses Sales_PriceModifiersFinancialJournal::setNetDebitAmount()
     * @uses Sales_PriceModifiersFinancialJournal::setOperationId()
     * @uses Sales_PriceModifiersFinancialJournal::setParentPriceModifierId()
     * @uses Sales_PriceModifiersFinancialJournal::setPaymentInstallmentsScheduleId()
     * @uses Sales_PriceModifiersFinancialJournal::setPaymentItemId()
     * @uses Sales_PriceModifiersFinancialJournal::setPriceModifierId()
     * @uses Sales_PriceModifiersFinancialJournal::setPriceModifierType()
     * @uses Sales_PriceModifiersFinancialJournal::setRootSubTargetId()
     * @uses Sales_PriceModifiersFinancialJournal::setRootTargetId()
     * @uses Sales_PriceModifiersFinancialJournal::setRootTargetKind()
     * @param \patest\StructType\Money $creditAmount
     * @param string $creditKind
     * @param string $dateTimeUtc
     * @param \patest\StructType\Money $debitAmount
     * @param \patest\StructType\Money $netCreditAmount
     * @param \patest\StructType\Money $netDebitAmount
     * @param string $operationId
     * @param string $parentPriceModifierId
     * @param string $paymentInstallmentsScheduleId
     * @param string $paymentItemId
     * @param string $priceModifierId
     * @param string $priceModifierType
     * @param string $rootSubTargetId
     * @param string $rootTargetId
     * @param string $rootTargetKind
     */
    public function __construct(\patest\StructType\Money $creditAmount = null, $creditKind = null, $dateTimeUtc = null, \patest\StructType\Money $debitAmount = null, \patest\StructType\Money $netCreditAmount = null, \patest\StructType\Money $netDebitAmount = null, $operationId = null, $parentPriceModifierId = null, $paymentInstallmentsScheduleId = null, $paymentItemId = null, $priceModifierId = null, $priceModifierType = null, $rootSubTargetId = null, $rootTargetId = null, $rootTargetKind = null)
    {
        $this
            ->setCreditAmount($creditAmount)
            ->setCreditKind($creditKind)
            ->setDateTimeUtc($dateTimeUtc)
            ->setDebitAmount($debitAmount)
            ->setNetCreditAmount($netCreditAmount)
            ->setNetDebitAmount($netDebitAmount)
            ->setOperationId($operationId)
            ->setParentPriceModifierId($parentPriceModifierId)
            ->setPaymentInstallmentsScheduleId($paymentInstallmentsScheduleId)
            ->setPaymentItemId($paymentItemId)
            ->setPriceModifierId($priceModifierId)
            ->setPriceModifierType($priceModifierType)
            ->setRootSubTargetId($rootSubTargetId)
            ->setRootTargetId($rootTargetId)
            ->setRootTargetKind($rootTargetKind);
    }
    /**
     * Get CreditAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCreditAmount()
    {
        return isset($this->CreditAmount) ? $this->CreditAmount : null;
    }
    /**
     * Set CreditAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $creditAmount
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setCreditAmount(\patest\StructType\Money $creditAmount = null)
    {
        if (is_null($creditAmount) || (is_array($creditAmount) && empty($creditAmount))) {
            unset($this->CreditAmount);
        } else {
            $this->CreditAmount = $creditAmount;
        }
        return $this;
    }
    /**
     * Get CreditKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditKind()
    {
        return isset($this->CreditKind) ? $this->CreditKind : null;
    }
    /**
     * Set CreditKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialJournalCreditKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalCreditKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creditKind
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setCreditKind($creditKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalCreditKind::valueIsValid($creditKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalCreditKind', is_array($creditKind) ? implode(', ', $creditKind) : var_export($creditKind, true), implode(', ', \patest\EnumType\FinancialJournalCreditKind::getValidValues())), __LINE__);
        }
        if (is_null($creditKind) || (is_array($creditKind) && empty($creditKind))) {
            unset($this->CreditKind);
        } else {
            $this->CreditKind = $creditKind;
        }
        return $this;
    }
    /**
     * Get DateTimeUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTimeUtc()
    {
        return isset($this->DateTimeUtc) ? $this->DateTimeUtc : null;
    }
    /**
     * Set DateTimeUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTimeUtc
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setDateTimeUtc($dateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeUtc) && !is_string($dateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeUtc, true), gettype($dateTimeUtc)), __LINE__);
        }
        if (is_null($dateTimeUtc) || (is_array($dateTimeUtc) && empty($dateTimeUtc))) {
            unset($this->DateTimeUtc);
        } else {
            $this->DateTimeUtc = $dateTimeUtc;
        }
        return $this;
    }
    /**
     * Get DebitAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDebitAmount()
    {
        return isset($this->DebitAmount) ? $this->DebitAmount : null;
    }
    /**
     * Set DebitAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $debitAmount
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setDebitAmount(\patest\StructType\Money $debitAmount = null)
    {
        if (is_null($debitAmount) || (is_array($debitAmount) && empty($debitAmount))) {
            unset($this->DebitAmount);
        } else {
            $this->DebitAmount = $debitAmount;
        }
        return $this;
    }
    /**
     * Get NetCreditAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getNetCreditAmount()
    {
        return isset($this->NetCreditAmount) ? $this->NetCreditAmount : null;
    }
    /**
     * Set NetCreditAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $netCreditAmount
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setNetCreditAmount(\patest\StructType\Money $netCreditAmount = null)
    {
        if (is_null($netCreditAmount) || (is_array($netCreditAmount) && empty($netCreditAmount))) {
            unset($this->NetCreditAmount);
        } else {
            $this->NetCreditAmount = $netCreditAmount;
        }
        return $this;
    }
    /**
     * Get NetDebitAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getNetDebitAmount()
    {
        return isset($this->NetDebitAmount) ? $this->NetDebitAmount : null;
    }
    /**
     * Set NetDebitAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $netDebitAmount
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setNetDebitAmount(\patest\StructType\Money $netDebitAmount = null)
    {
        if (is_null($netDebitAmount) || (is_array($netDebitAmount) && empty($netDebitAmount))) {
            unset($this->NetDebitAmount);
        } else {
            $this->NetDebitAmount = $netDebitAmount;
        }
        return $this;
    }
    /**
     * Get OperationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationId()
    {
        return isset($this->OperationId) ? $this->OperationId : null;
    }
    /**
     * Set OperationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationId
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setOperationId($operationId = null)
    {
        // validation for constraint: string
        if (!is_null($operationId) && !is_string($operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationId, true), gettype($operationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($operationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($operationId, true)), __LINE__);
        }
        if (is_null($operationId) || (is_array($operationId) && empty($operationId))) {
            unset($this->OperationId);
        } else {
            $this->OperationId = $operationId;
        }
        return $this;
    }
    /**
     * Get ParentPriceModifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentPriceModifierId()
    {
        return isset($this->ParentPriceModifierId) ? $this->ParentPriceModifierId : null;
    }
    /**
     * Set ParentPriceModifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentPriceModifierId
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setParentPriceModifierId($parentPriceModifierId = null)
    {
        // validation for constraint: string
        if (!is_null($parentPriceModifierId) && !is_string($parentPriceModifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentPriceModifierId, true), gettype($parentPriceModifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentPriceModifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentPriceModifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentPriceModifierId, true)), __LINE__);
        }
        if (is_null($parentPriceModifierId) || (is_array($parentPriceModifierId) && empty($parentPriceModifierId))) {
            unset($this->ParentPriceModifierId);
        } else {
            $this->ParentPriceModifierId = $parentPriceModifierId;
        }
        return $this;
    }
    /**
     * Get PaymentInstallmentsScheduleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentInstallmentsScheduleId()
    {
        return isset($this->PaymentInstallmentsScheduleId) ? $this->PaymentInstallmentsScheduleId : null;
    }
    /**
     * Set PaymentInstallmentsScheduleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentInstallmentsScheduleId
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setPaymentInstallmentsScheduleId($paymentInstallmentsScheduleId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInstallmentsScheduleId) && !is_string($paymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInstallmentsScheduleId, true), gettype($paymentInstallmentsScheduleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentInstallmentsScheduleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentInstallmentsScheduleId, true)), __LINE__);
        }
        if (is_null($paymentInstallmentsScheduleId) || (is_array($paymentInstallmentsScheduleId) && empty($paymentInstallmentsScheduleId))) {
            unset($this->PaymentInstallmentsScheduleId);
        } else {
            $this->PaymentInstallmentsScheduleId = $paymentInstallmentsScheduleId;
        }
        return $this;
    }
    /**
     * Get PaymentItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentItemId()
    {
        return isset($this->PaymentItemId) ? $this->PaymentItemId : null;
    }
    /**
     * Set PaymentItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentItemId
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setPaymentItemId($paymentItemId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemId) && !is_string($paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemId, true), gettype($paymentItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentItemId, true)), __LINE__);
        }
        if (is_null($paymentItemId) || (is_array($paymentItemId) && empty($paymentItemId))) {
            unset($this->PaymentItemId);
        } else {
            $this->PaymentItemId = $paymentItemId;
        }
        return $this;
    }
    /**
     * Get PriceModifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceModifierId()
    {
        return isset($this->PriceModifierId) ? $this->PriceModifierId : null;
    }
    /**
     * Set PriceModifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceModifierId
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setPriceModifierId($priceModifierId = null)
    {
        // validation for constraint: string
        if (!is_null($priceModifierId) && !is_string($priceModifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceModifierId, true), gettype($priceModifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceModifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceModifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceModifierId, true)), __LINE__);
        }
        if (is_null($priceModifierId) || (is_array($priceModifierId) && empty($priceModifierId))) {
            unset($this->PriceModifierId);
        } else {
            $this->PriceModifierId = $priceModifierId;
        }
        return $this;
    }
    /**
     * Get PriceModifierType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceModifierType()
    {
        return isset($this->PriceModifierType) ? $this->PriceModifierType : null;
    }
    /**
     * Set PriceModifierType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceModifierType
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setPriceModifierType($priceModifierType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierType::valueIsValid($priceModifierType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierType', is_array($priceModifierType) ? implode(', ', $priceModifierType) : var_export($priceModifierType, true), implode(', ', \patest\EnumType\PriceModifierType::getValidValues())), __LINE__);
        }
        if (is_null($priceModifierType) || (is_array($priceModifierType) && empty($priceModifierType))) {
            unset($this->PriceModifierType);
        } else {
            $this->PriceModifierType = $priceModifierType;
        }
        return $this;
    }
    /**
     * Get RootSubTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRootSubTargetId()
    {
        return isset($this->RootSubTargetId) ? $this->RootSubTargetId : null;
    }
    /**
     * Set RootSubTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rootSubTargetId
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setRootSubTargetId($rootSubTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($rootSubTargetId) && !is_string($rootSubTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rootSubTargetId, true), gettype($rootSubTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($rootSubTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $rootSubTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($rootSubTargetId, true)), __LINE__);
        }
        if (is_null($rootSubTargetId) || (is_array($rootSubTargetId) && empty($rootSubTargetId))) {
            unset($this->RootSubTargetId);
        } else {
            $this->RootSubTargetId = $rootSubTargetId;
        }
        return $this;
    }
    /**
     * Get RootTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRootTargetId()
    {
        return isset($this->RootTargetId) ? $this->RootTargetId : null;
    }
    /**
     * Set RootTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rootTargetId
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setRootTargetId($rootTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($rootTargetId) && !is_string($rootTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rootTargetId, true), gettype($rootTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($rootTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $rootTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($rootTargetId, true)), __LINE__);
        }
        if (is_null($rootTargetId) || (is_array($rootTargetId) && empty($rootTargetId))) {
            unset($this->RootTargetId);
        } else {
            $this->RootTargetId = $rootTargetId;
        }
        return $this;
    }
    /**
     * Get RootTargetKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRootTargetKind()
    {
        return isset($this->RootTargetKind) ? $this->RootTargetKind : null;
    }
    /**
     * Set RootTargetKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialJournalTargetKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalTargetKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rootTargetKind
     * @return \patest\StructType\Sales_PriceModifiersFinancialJournal
     */
    public function setRootTargetKind($rootTargetKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalTargetKind::valueIsValid($rootTargetKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalTargetKind', is_array($rootTargetKind) ? implode(', ', $rootTargetKind) : var_export($rootTargetKind, true), implode(', ', \patest\EnumType\FinancialJournalTargetKind::getValidValues())), __LINE__);
        }
        if (is_null($rootTargetKind) || (is_array($rootTargetKind) && empty($rootTargetKind))) {
            unset($this->RootTargetKind);
        } else {
            $this->RootTargetKind = $rootTargetKind;
        }
        return $this;
    }
}
