<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.PriceModifier StructType
 * @subpackage Structs
 */
class Sales_PriceModifier extends PersistableEntity
{
    /**
     * The BackwardTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BackwardTransactionId;
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $BaseAmount;
    /**
     * The Children
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_PriceModifier
     */
    public $Children;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_PriceModifier
     */
    public $Details;
    /**
     * The EffectiveAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $EffectiveAmount;
    /**
     * The ForwardTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ForwardTransactionId;
    /**
     * The IdInBackwardTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInBackwardTransaction;
    /**
     * The IdInForwardTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInForwardTransaction;
    /**
     * The IdInSupplierTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInSupplierTransaction;
    /**
     * The InsertionMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsertionMode;
    /**
     * The IsEffective
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEffective;
    /**
     * The IsIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIncluded;
    /**
     * The IsPartOfFacePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPartOfFacePrice;
    /**
     * The IsSubscriptionSourcedCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubscriptionSourcedCommission;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The Master
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Master;
    /**
     * The OrganizationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationId;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Parent;
    /**
     * The PayEffectiveness
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayEffectiveness;
    /**
     * The PriceModifierDefinition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_PriceModifiersDefinitionInfo
     */
    public $PriceModifierDefinition;
    /**
     * The PriceModifierId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PriceModifierId;
    /**
     * The SourceAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SourceAmount;
    /**
     * The SupplierCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SupplierCompanyId;
    /**
     * The SupplierTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SupplierTransactionId;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TaxAmount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmount;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionId;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Type;
    /**
     * Constructor method for Sales.PriceModifier
     * @uses Sales_PriceModifier::setBackwardTransactionId()
     * @uses Sales_PriceModifier::setBaseAmount()
     * @uses Sales_PriceModifier::setChildren()
     * @uses Sales_PriceModifier::setDescription()
     * @uses Sales_PriceModifier::setDetails()
     * @uses Sales_PriceModifier::setEffectiveAmount()
     * @uses Sales_PriceModifier::setForwardTransactionId()
     * @uses Sales_PriceModifier::setIdInBackwardTransaction()
     * @uses Sales_PriceModifier::setIdInForwardTransaction()
     * @uses Sales_PriceModifier::setIdInSupplierTransaction()
     * @uses Sales_PriceModifier::setInsertionMode()
     * @uses Sales_PriceModifier::setIsEffective()
     * @uses Sales_PriceModifier::setIsIncluded()
     * @uses Sales_PriceModifier::setIsPartOfFacePrice()
     * @uses Sales_PriceModifier::setIsSubscriptionSourcedCommission()
     * @uses Sales_PriceModifier::setItemId()
     * @uses Sales_PriceModifier::setMaster()
     * @uses Sales_PriceModifier::setOrganizationId()
     * @uses Sales_PriceModifier::setOrigin()
     * @uses Sales_PriceModifier::setParent()
     * @uses Sales_PriceModifier::setPayEffectiveness()
     * @uses Sales_PriceModifier::setPriceModifierDefinition()
     * @uses Sales_PriceModifier::setPriceModifierId()
     * @uses Sales_PriceModifier::setSourceAmount()
     * @uses Sales_PriceModifier::setSupplierCompanyId()
     * @uses Sales_PriceModifier::setSupplierTransactionId()
     * @uses Sales_PriceModifier::setTaxAmount()
     * @uses Sales_PriceModifier::setTotalAmount()
     * @uses Sales_PriceModifier::setTransactionId()
     * @uses Sales_PriceModifier::setType()
     * @param string $backwardTransactionId
     * @param \patest\StructType\Money $baseAmount
     * @param \patest\StructType\RecordSetOfSales_PriceModifier $children
     * @param \patest\StructType\GlobalString $description
     * @param \patest\StructType\RecordSetOfSales_PriceModifier $details
     * @param \patest\StructType\Money $effectiveAmount
     * @param string $forwardTransactionId
     * @param int $idInBackwardTransaction
     * @param int $idInForwardTransaction
     * @param int $idInSupplierTransaction
     * @param string $insertionMode
     * @param bool $isEffective
     * @param bool $isIncluded
     * @param bool $isPartOfFacePrice
     * @param bool $isSubscriptionSourcedCommission
     * @param int $itemId
     * @param int $master
     * @param string $organizationId
     * @param string $origin
     * @param int $parent
     * @param string $payEffectiveness
     * @param \patest\StructType\Sales_PriceModifiersDefinitionInfo $priceModifierDefinition
     * @param int $priceModifierId
     * @param \patest\StructType\Money $sourceAmount
     * @param int $supplierCompanyId
     * @param string $supplierTransactionId
     * @param \patest\StructType\Money $taxAmount
     * @param \patest\StructType\Money $totalAmount
     * @param int $transactionId
     * @param int $type
     */
    public function __construct($backwardTransactionId = null, \patest\StructType\Money $baseAmount = null, \patest\StructType\RecordSetOfSales_PriceModifier $children = null, \patest\StructType\GlobalString $description = null, \patest\StructType\RecordSetOfSales_PriceModifier $details = null, \patest\StructType\Money $effectiveAmount = null, $forwardTransactionId = null, $idInBackwardTransaction = null, $idInForwardTransaction = null, $idInSupplierTransaction = null, $insertionMode = null, $isEffective = null, $isIncluded = null, $isPartOfFacePrice = null, $isSubscriptionSourcedCommission = null, $itemId = null, $master = null, $organizationId = null, $origin = null, $parent = null, $payEffectiveness = null, \patest\StructType\Sales_PriceModifiersDefinitionInfo $priceModifierDefinition = null, $priceModifierId = null, \patest\StructType\Money $sourceAmount = null, $supplierCompanyId = null, $supplierTransactionId = null, \patest\StructType\Money $taxAmount = null, \patest\StructType\Money $totalAmount = null, $transactionId = null, $type = null)
    {
        $this
            ->setBackwardTransactionId($backwardTransactionId)
            ->setBaseAmount($baseAmount)
            ->setChildren($children)
            ->setDescription($description)
            ->setDetails($details)
            ->setEffectiveAmount($effectiveAmount)
            ->setForwardTransactionId($forwardTransactionId)
            ->setIdInBackwardTransaction($idInBackwardTransaction)
            ->setIdInForwardTransaction($idInForwardTransaction)
            ->setIdInSupplierTransaction($idInSupplierTransaction)
            ->setInsertionMode($insertionMode)
            ->setIsEffective($isEffective)
            ->setIsIncluded($isIncluded)
            ->setIsPartOfFacePrice($isPartOfFacePrice)
            ->setIsSubscriptionSourcedCommission($isSubscriptionSourcedCommission)
            ->setItemId($itemId)
            ->setMaster($master)
            ->setOrganizationId($organizationId)
            ->setOrigin($origin)
            ->setParent($parent)
            ->setPayEffectiveness($payEffectiveness)
            ->setPriceModifierDefinition($priceModifierDefinition)
            ->setPriceModifierId($priceModifierId)
            ->setSourceAmount($sourceAmount)
            ->setSupplierCompanyId($supplierCompanyId)
            ->setSupplierTransactionId($supplierTransactionId)
            ->setTaxAmount($taxAmount)
            ->setTotalAmount($totalAmount)
            ->setTransactionId($transactionId)
            ->setType($type);
    }
    /**
     * Get BackwardTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackwardTransactionId()
    {
        return isset($this->BackwardTransactionId) ? $this->BackwardTransactionId : null;
    }
    /**
     * Set BackwardTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backwardTransactionId
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setBackwardTransactionId($backwardTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($backwardTransactionId) && !is_string($backwardTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backwardTransactionId, true), gettype($backwardTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($backwardTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $backwardTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($backwardTransactionId, true)), __LINE__);
        }
        if (is_null($backwardTransactionId) || (is_array($backwardTransactionId) && empty($backwardTransactionId))) {
            unset($this->BackwardTransactionId);
        } else {
            $this->BackwardTransactionId = $backwardTransactionId;
        }
        return $this;
    }
    /**
     * Get BaseAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getBaseAmount()
    {
        return isset($this->BaseAmount) ? $this->BaseAmount : null;
    }
    /**
     * Set BaseAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $baseAmount
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setBaseAmount(\patest\StructType\Money $baseAmount = null)
    {
        if (is_null($baseAmount) || (is_array($baseAmount) && empty($baseAmount))) {
            unset($this->BaseAmount);
        } else {
            $this->BaseAmount = $baseAmount;
        }
        return $this;
    }
    /**
     * Get Children value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_PriceModifier|null
     */
    public function getChildren()
    {
        return isset($this->Children) ? $this->Children : null;
    }
    /**
     * Set Children value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_PriceModifier $children
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setChildren(\patest\StructType\RecordSetOfSales_PriceModifier $children = null)
    {
        if (is_null($children) || (is_array($children) && empty($children))) {
            unset($this->Children);
        } else {
            $this->Children = $children;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_PriceModifier|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_PriceModifier $details
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setDetails(\patest\StructType\RecordSetOfSales_PriceModifier $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get EffectiveAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getEffectiveAmount()
    {
        return isset($this->EffectiveAmount) ? $this->EffectiveAmount : null;
    }
    /**
     * Set EffectiveAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $effectiveAmount
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setEffectiveAmount(\patest\StructType\Money $effectiveAmount = null)
    {
        if (is_null($effectiveAmount) || (is_array($effectiveAmount) && empty($effectiveAmount))) {
            unset($this->EffectiveAmount);
        } else {
            $this->EffectiveAmount = $effectiveAmount;
        }
        return $this;
    }
    /**
     * Get ForwardTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForwardTransactionId()
    {
        return isset($this->ForwardTransactionId) ? $this->ForwardTransactionId : null;
    }
    /**
     * Set ForwardTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forwardTransactionId
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setForwardTransactionId($forwardTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($forwardTransactionId) && !is_string($forwardTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forwardTransactionId, true), gettype($forwardTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($forwardTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $forwardTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($forwardTransactionId, true)), __LINE__);
        }
        if (is_null($forwardTransactionId) || (is_array($forwardTransactionId) && empty($forwardTransactionId))) {
            unset($this->ForwardTransactionId);
        } else {
            $this->ForwardTransactionId = $forwardTransactionId;
        }
        return $this;
    }
    /**
     * Get IdInBackwardTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInBackwardTransaction()
    {
        return isset($this->IdInBackwardTransaction) ? $this->IdInBackwardTransaction : null;
    }
    /**
     * Set IdInBackwardTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInBackwardTransaction
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setIdInBackwardTransaction($idInBackwardTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInBackwardTransaction) && !(is_int($idInBackwardTransaction) || ctype_digit($idInBackwardTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInBackwardTransaction, true), gettype($idInBackwardTransaction)), __LINE__);
        }
        if (is_null($idInBackwardTransaction) || (is_array($idInBackwardTransaction) && empty($idInBackwardTransaction))) {
            unset($this->IdInBackwardTransaction);
        } else {
            $this->IdInBackwardTransaction = $idInBackwardTransaction;
        }
        return $this;
    }
    /**
     * Get IdInForwardTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInForwardTransaction()
    {
        return isset($this->IdInForwardTransaction) ? $this->IdInForwardTransaction : null;
    }
    /**
     * Set IdInForwardTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInForwardTransaction
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setIdInForwardTransaction($idInForwardTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInForwardTransaction) && !(is_int($idInForwardTransaction) || ctype_digit($idInForwardTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInForwardTransaction, true), gettype($idInForwardTransaction)), __LINE__);
        }
        if (is_null($idInForwardTransaction) || (is_array($idInForwardTransaction) && empty($idInForwardTransaction))) {
            unset($this->IdInForwardTransaction);
        } else {
            $this->IdInForwardTransaction = $idInForwardTransaction;
        }
        return $this;
    }
    /**
     * Get IdInSupplierTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInSupplierTransaction()
    {
        return isset($this->IdInSupplierTransaction) ? $this->IdInSupplierTransaction : null;
    }
    /**
     * Set IdInSupplierTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInSupplierTransaction
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setIdInSupplierTransaction($idInSupplierTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInSupplierTransaction) && !(is_int($idInSupplierTransaction) || ctype_digit($idInSupplierTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInSupplierTransaction, true), gettype($idInSupplierTransaction)), __LINE__);
        }
        if (is_null($idInSupplierTransaction) || (is_array($idInSupplierTransaction) && empty($idInSupplierTransaction))) {
            unset($this->IdInSupplierTransaction);
        } else {
            $this->IdInSupplierTransaction = $idInSupplierTransaction;
        }
        return $this;
    }
    /**
     * Get InsertionMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsertionMode()
    {
        return isset($this->InsertionMode) ? $this->InsertionMode : null;
    }
    /**
     * Set InsertionMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemInsertionMode::valueIsValid()
     * @uses \patest\EnumType\ItemInsertionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insertionMode
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setInsertionMode($insertionMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemInsertionMode::valueIsValid($insertionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemInsertionMode', is_array($insertionMode) ? implode(', ', $insertionMode) : var_export($insertionMode, true), implode(', ', \patest\EnumType\ItemInsertionMode::getValidValues())), __LINE__);
        }
        if (is_null($insertionMode) || (is_array($insertionMode) && empty($insertionMode))) {
            unset($this->InsertionMode);
        } else {
            $this->InsertionMode = $insertionMode;
        }
        return $this;
    }
    /**
     * Get IsEffective value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEffective()
    {
        return isset($this->IsEffective) ? $this->IsEffective : null;
    }
    /**
     * Set IsEffective value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEffective
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setIsEffective($isEffective = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEffective) && !is_bool($isEffective)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEffective, true), gettype($isEffective)), __LINE__);
        }
        if (is_null($isEffective) || (is_array($isEffective) && empty($isEffective))) {
            unset($this->IsEffective);
        } else {
            $this->IsEffective = $isEffective;
        }
        return $this;
    }
    /**
     * Get IsIncluded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIncluded()
    {
        return isset($this->IsIncluded) ? $this->IsIncluded : null;
    }
    /**
     * Set IsIncluded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIncluded
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setIsIncluded($isIncluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncluded) && !is_bool($isIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncluded, true), gettype($isIncluded)), __LINE__);
        }
        if (is_null($isIncluded) || (is_array($isIncluded) && empty($isIncluded))) {
            unset($this->IsIncluded);
        } else {
            $this->IsIncluded = $isIncluded;
        }
        return $this;
    }
    /**
     * Get IsPartOfFacePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPartOfFacePrice()
    {
        return isset($this->IsPartOfFacePrice) ? $this->IsPartOfFacePrice : null;
    }
    /**
     * Set IsPartOfFacePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPartOfFacePrice
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setIsPartOfFacePrice($isPartOfFacePrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPartOfFacePrice) && !is_bool($isPartOfFacePrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPartOfFacePrice, true), gettype($isPartOfFacePrice)), __LINE__);
        }
        if (is_null($isPartOfFacePrice) || (is_array($isPartOfFacePrice) && empty($isPartOfFacePrice))) {
            unset($this->IsPartOfFacePrice);
        } else {
            $this->IsPartOfFacePrice = $isPartOfFacePrice;
        }
        return $this;
    }
    /**
     * Get IsSubscriptionSourcedCommission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubscriptionSourcedCommission()
    {
        return isset($this->IsSubscriptionSourcedCommission) ? $this->IsSubscriptionSourcedCommission : null;
    }
    /**
     * Set IsSubscriptionSourcedCommission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubscriptionSourcedCommission
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setIsSubscriptionSourcedCommission($isSubscriptionSourcedCommission = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubscriptionSourcedCommission) && !is_bool($isSubscriptionSourcedCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubscriptionSourcedCommission, true), gettype($isSubscriptionSourcedCommission)), __LINE__);
        }
        if (is_null($isSubscriptionSourcedCommission) || (is_array($isSubscriptionSourcedCommission) && empty($isSubscriptionSourcedCommission))) {
            unset($this->IsSubscriptionSourcedCommission);
        } else {
            $this->IsSubscriptionSourcedCommission = $isSubscriptionSourcedCommission;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get Master value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaster()
    {
        return isset($this->Master) ? $this->Master : null;
    }
    /**
     * Set Master value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $master
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setMaster($master = null)
    {
        // validation for constraint: int
        if (!is_null($master) && !(is_int($master) || ctype_digit($master))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($master, true), gettype($master)), __LINE__);
        }
        if (is_null($master) || (is_array($master) && empty($master))) {
            unset($this->Master);
        } else {
            $this->Master = $master;
        }
        return $this;
    }
    /**
     * Get OrganizationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationId()
    {
        return isset($this->OrganizationId) ? $this->OrganizationId : null;
    }
    /**
     * Set OrganizationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationId
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setOrganizationId($organizationId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationId) && !is_string($organizationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationId, true), gettype($organizationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationId, true)), __LINE__);
        }
        if (is_null($organizationId) || (is_array($organizationId) && empty($organizationId))) {
            unset($this->OrganizationId);
        } else {
            $this->OrganizationId = $organizationId;
        }
        return $this;
    }
    /**
     * Get Origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrigin()
    {
        return isset($this->Origin) ? $this->Origin : null;
    }
    /**
     * Set Origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierOrigin::valueIsValid()
     * @uses \patest\EnumType\PriceModifierOrigin::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $origin
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierOrigin::valueIsValid($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierOrigin', is_array($origin) ? implode(', ', $origin) : var_export($origin, true), implode(', ', \patest\EnumType\PriceModifierOrigin::getValidValues())), __LINE__);
        }
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->Origin);
        } else {
            $this->Origin = $origin;
        }
        return $this;
    }
    /**
     * Get Parent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getParent()
    {
        return isset($this->Parent) ? $this->Parent : null;
    }
    /**
     * Set Parent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $parent
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setParent($parent = null)
    {
        // validation for constraint: int
        if (!is_null($parent) && !(is_int($parent) || ctype_digit($parent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parent, true), gettype($parent)), __LINE__);
        }
        if (is_null($parent) || (is_array($parent) && empty($parent))) {
            unset($this->Parent);
        } else {
            $this->Parent = $parent;
        }
        return $this;
    }
    /**
     * Get PayEffectiveness value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayEffectiveness()
    {
        return isset($this->PayEffectiveness) ? $this->PayEffectiveness : null;
    }
    /**
     * Set PayEffectiveness value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierPayEffectiveness::valueIsValid()
     * @uses \patest\EnumType\PriceModifierPayEffectiveness::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $payEffectiveness
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setPayEffectiveness($payEffectiveness = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierPayEffectiveness::valueIsValid($payEffectiveness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierPayEffectiveness', is_array($payEffectiveness) ? implode(', ', $payEffectiveness) : var_export($payEffectiveness, true), implode(', ', \patest\EnumType\PriceModifierPayEffectiveness::getValidValues())), __LINE__);
        }
        if (is_null($payEffectiveness) || (is_array($payEffectiveness) && empty($payEffectiveness))) {
            unset($this->PayEffectiveness);
        } else {
            $this->PayEffectiveness = $payEffectiveness;
        }
        return $this;
    }
    /**
     * Get PriceModifierDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_PriceModifiersDefinitionInfo|null
     */
    public function getPriceModifierDefinition()
    {
        return isset($this->PriceModifierDefinition) ? $this->PriceModifierDefinition : null;
    }
    /**
     * Set PriceModifierDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_PriceModifiersDefinitionInfo $priceModifierDefinition
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setPriceModifierDefinition(\patest\StructType\Sales_PriceModifiersDefinitionInfo $priceModifierDefinition = null)
    {
        if (is_null($priceModifierDefinition) || (is_array($priceModifierDefinition) && empty($priceModifierDefinition))) {
            unset($this->PriceModifierDefinition);
        } else {
            $this->PriceModifierDefinition = $priceModifierDefinition;
        }
        return $this;
    }
    /**
     * Get PriceModifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriceModifierId()
    {
        return isset($this->PriceModifierId) ? $this->PriceModifierId : null;
    }
    /**
     * Set PriceModifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priceModifierId
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setPriceModifierId($priceModifierId = null)
    {
        // validation for constraint: int
        if (!is_null($priceModifierId) && !(is_int($priceModifierId) || ctype_digit($priceModifierId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceModifierId, true), gettype($priceModifierId)), __LINE__);
        }
        if (is_null($priceModifierId) || (is_array($priceModifierId) && empty($priceModifierId))) {
            unset($this->PriceModifierId);
        } else {
            $this->PriceModifierId = $priceModifierId;
        }
        return $this;
    }
    /**
     * Get SourceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSourceAmount()
    {
        return isset($this->SourceAmount) ? $this->SourceAmount : null;
    }
    /**
     * Set SourceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $sourceAmount
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setSourceAmount(\patest\StructType\Money $sourceAmount = null)
    {
        if (is_null($sourceAmount) || (is_array($sourceAmount) && empty($sourceAmount))) {
            unset($this->SourceAmount);
        } else {
            $this->SourceAmount = $sourceAmount;
        }
        return $this;
    }
    /**
     * Get SupplierCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSupplierCompanyId()
    {
        return isset($this->SupplierCompanyId) ? $this->SupplierCompanyId : null;
    }
    /**
     * Set SupplierCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $supplierCompanyId
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setSupplierCompanyId($supplierCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($supplierCompanyId) && !(is_int($supplierCompanyId) || ctype_digit($supplierCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($supplierCompanyId, true), gettype($supplierCompanyId)), __LINE__);
        }
        if (is_null($supplierCompanyId) || (is_array($supplierCompanyId) && empty($supplierCompanyId))) {
            unset($this->SupplierCompanyId);
        } else {
            $this->SupplierCompanyId = $supplierCompanyId;
        }
        return $this;
    }
    /**
     * Get SupplierTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierTransactionId()
    {
        return isset($this->SupplierTransactionId) ? $this->SupplierTransactionId : null;
    }
    /**
     * Set SupplierTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierTransactionId
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setSupplierTransactionId($supplierTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransactionId) && !is_string($supplierTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransactionId, true), gettype($supplierTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($supplierTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $supplierTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($supplierTransactionId, true)), __LINE__);
        }
        if (is_null($supplierTransactionId) || (is_array($supplierTransactionId) && empty($supplierTransactionId))) {
            unset($this->SupplierTransactionId);
        } else {
            $this->SupplierTransactionId = $supplierTransactionId;
        }
        return $this;
    }
    /**
     * Get TaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTaxAmount()
    {
        return isset($this->TaxAmount) ? $this->TaxAmount : null;
    }
    /**
     * Set TaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $taxAmount
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setTaxAmount(\patest\StructType\Money $taxAmount = null)
    {
        if (is_null($taxAmount) || (is_array($taxAmount) && empty($taxAmount))) {
            unset($this->TaxAmount);
        } else {
            $this->TaxAmount = $taxAmount;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmount
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setTotalAmount(\patest\StructType\Money $totalAmount = null)
    {
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionId
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !(is_int($transactionId) || ctype_digit($transactionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $type
     * @return \patest\StructType\Sales_PriceModifier
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
