<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.PaymentPackageElement StructType
 * @subpackage Structs
 */
class Sales_PaymentPackageElement extends Sales_PackageElement
{
    /**
     * The ActionApplyPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionApplyPolicy;
    /**
     * Constructor method for Sales.PaymentPackageElement
     * @uses Sales_PaymentPackageElement::setActionApplyPolicy()
     * @param string $actionApplyPolicy
     */
    public function __construct($actionApplyPolicy = null)
    {
        $this
            ->setActionApplyPolicy($actionApplyPolicy);
    }
    /**
     * Get ActionApplyPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionApplyPolicy()
    {
        return isset($this->ActionApplyPolicy) ? $this->ActionApplyPolicy : null;
    }
    /**
     * Set ActionApplyPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentActionApplyPolicy::valueIsValid()
     * @uses \patest\EnumType\PaymentActionApplyPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionApplyPolicy
     * @return \patest\StructType\Sales_PaymentPackageElement
     */
    public function setActionApplyPolicy($actionApplyPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentActionApplyPolicy::valueIsValid($actionApplyPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentActionApplyPolicy', is_array($actionApplyPolicy) ? implode(', ', $actionApplyPolicy) : var_export($actionApplyPolicy, true), implode(', ', \patest\EnumType\PaymentActionApplyPolicy::getValidValues())), __LINE__);
        }
        if (is_null($actionApplyPolicy) || (is_array($actionApplyPolicy) && empty($actionApplyPolicy))) {
            unset($this->ActionApplyPolicy);
        } else {
            $this->ActionApplyPolicy = $actionApplyPolicy;
        }
        return $this;
    }
}
