<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.PackageElement StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Sales.PackageElement
 * @subpackage Structs
 */
class Sales_PackageElement extends Sales_CombinationElement
{
    /**
     * The ActionList
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfRuleEngine_Action
     */
    public $ActionList;
    /**
     * The BenefitDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BenefitDescription;
    /**
     * The IsDateRelated
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDateRelated;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_Media
     */
    public $Media;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * Constructor method for Sales.PackageElement
     * @uses Sales_PackageElement::setActionList()
     * @uses Sales_PackageElement::setBenefitDescription()
     * @uses Sales_PackageElement::setIsDateRelated()
     * @uses Sales_PackageElement::setMedia()
     * @uses Sales_PackageElement::setPriority()
     * @param \patest\StructType\RecordSetOfRuleEngine_Action $actionList
     * @param string $benefitDescription
     * @param bool $isDateRelated
     * @param \patest\StructType\Sales_Media $media
     * @param int $priority
     */
    public function __construct(\patest\StructType\RecordSetOfRuleEngine_Action $actionList = null, $benefitDescription = null, $isDateRelated = null, \patest\StructType\Sales_Media $media = null, $priority = null)
    {
        $this
            ->setActionList($actionList)
            ->setBenefitDescription($benefitDescription)
            ->setIsDateRelated($isDateRelated)
            ->setMedia($media)
            ->setPriority($priority);
    }
    /**
     * Get ActionList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfRuleEngine_Action|null
     */
    public function getActionList()
    {
        return isset($this->ActionList) ? $this->ActionList : null;
    }
    /**
     * Set ActionList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfRuleEngine_Action $actionList
     * @return \patest\StructType\Sales_PackageElement
     */
    public function setActionList(\patest\StructType\RecordSetOfRuleEngine_Action $actionList = null)
    {
        if (is_null($actionList) || (is_array($actionList) && empty($actionList))) {
            unset($this->ActionList);
        } else {
            $this->ActionList = $actionList;
        }
        return $this;
    }
    /**
     * Get BenefitDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitDescription()
    {
        return isset($this->BenefitDescription) ? $this->BenefitDescription : null;
    }
    /**
     * Set BenefitDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $benefitDescription
     * @return \patest\StructType\Sales_PackageElement
     */
    public function setBenefitDescription($benefitDescription = null)
    {
        // validation for constraint: string
        if (!is_null($benefitDescription) && !is_string($benefitDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitDescription, true), gettype($benefitDescription)), __LINE__);
        }
        if (is_null($benefitDescription) || (is_array($benefitDescription) && empty($benefitDescription))) {
            unset($this->BenefitDescription);
        } else {
            $this->BenefitDescription = $benefitDescription;
        }
        return $this;
    }
    /**
     * Get IsDateRelated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDateRelated()
    {
        return isset($this->IsDateRelated) ? $this->IsDateRelated : null;
    }
    /**
     * Set IsDateRelated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDateRelated
     * @return \patest\StructType\Sales_PackageElement
     */
    public function setIsDateRelated($isDateRelated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDateRelated) && !is_bool($isDateRelated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDateRelated, true), gettype($isDateRelated)), __LINE__);
        }
        if (is_null($isDateRelated) || (is_array($isDateRelated) && empty($isDateRelated))) {
            unset($this->IsDateRelated);
        } else {
            $this->IsDateRelated = $isDateRelated;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_Media $media
     * @return \patest\StructType\Sales_PackageElement
     */
    public function setMedia(\patest\StructType\Sales_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Sales_PackageElement
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
}
