<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.MergeClientIdentificationHistory StructType
 * @subpackage Structs
 */
class Sales_MergeClientIdentificationHistory extends PersistableEntity
{
    /**
     * The AbsorbedClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AbsorbedClientId;
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The ClientIdentificationEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientIdentificationEntity;
    /**
     * The LeadingClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LeadingClientId;
    /**
     * The TicketList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketList;
    /**
     * Constructor method for Sales.MergeClientIdentificationHistory
     * @uses Sales_MergeClientIdentificationHistory::setAbsorbedClientId()
     * @uses Sales_MergeClientIdentificationHistory::setAction()
     * @uses Sales_MergeClientIdentificationHistory::setClientIdentificationEntity()
     * @uses Sales_MergeClientIdentificationHistory::setLeadingClientId()
     * @uses Sales_MergeClientIdentificationHistory::setTicketList()
     * @param string $absorbedClientId
     * @param string $action
     * @param string $clientIdentificationEntity
     * @param string $leadingClientId
     * @param string $ticketList
     */
    public function __construct($absorbedClientId = null, $action = null, $clientIdentificationEntity = null, $leadingClientId = null, $ticketList = null)
    {
        $this
            ->setAbsorbedClientId($absorbedClientId)
            ->setAction($action)
            ->setClientIdentificationEntity($clientIdentificationEntity)
            ->setLeadingClientId($leadingClientId)
            ->setTicketList($ticketList);
    }
    /**
     * Get AbsorbedClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbsorbedClientId()
    {
        return isset($this->AbsorbedClientId) ? $this->AbsorbedClientId : null;
    }
    /**
     * Set AbsorbedClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $absorbedClientId
     * @return \patest\StructType\Sales_MergeClientIdentificationHistory
     */
    public function setAbsorbedClientId($absorbedClientId = null)
    {
        // validation for constraint: string
        if (!is_null($absorbedClientId) && !is_string($absorbedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($absorbedClientId, true), gettype($absorbedClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($absorbedClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $absorbedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($absorbedClientId, true)), __LINE__);
        }
        if (is_null($absorbedClientId) || (is_array($absorbedClientId) && empty($absorbedClientId))) {
            unset($this->AbsorbedClientId);
        } else {
            $this->AbsorbedClientId = $absorbedClientId;
        }
        return $this;
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $action
     * @return \patest\StructType\Sales_MergeClientIdentificationHistory
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get ClientIdentificationEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientIdentificationEntity()
    {
        return isset($this->ClientIdentificationEntity) ? $this->ClientIdentificationEntity : null;
    }
    /**
     * Set ClientIdentificationEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientIdentificationEntity
     * @return \patest\StructType\Sales_MergeClientIdentificationHistory
     */
    public function setClientIdentificationEntity($clientIdentificationEntity = null)
    {
        // validation for constraint: string
        if (!is_null($clientIdentificationEntity) && !is_string($clientIdentificationEntity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIdentificationEntity, true), gettype($clientIdentificationEntity)), __LINE__);
        }
        if (is_null($clientIdentificationEntity) || (is_array($clientIdentificationEntity) && empty($clientIdentificationEntity))) {
            unset($this->ClientIdentificationEntity);
        } else {
            $this->ClientIdentificationEntity = $clientIdentificationEntity;
        }
        return $this;
    }
    /**
     * Get LeadingClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadingClientId()
    {
        return isset($this->LeadingClientId) ? $this->LeadingClientId : null;
    }
    /**
     * Set LeadingClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadingClientId
     * @return \patest\StructType\Sales_MergeClientIdentificationHistory
     */
    public function setLeadingClientId($leadingClientId = null)
    {
        // validation for constraint: string
        if (!is_null($leadingClientId) && !is_string($leadingClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadingClientId, true), gettype($leadingClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($leadingClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $leadingClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($leadingClientId, true)), __LINE__);
        }
        if (is_null($leadingClientId) || (is_array($leadingClientId) && empty($leadingClientId))) {
            unset($this->LeadingClientId);
        } else {
            $this->LeadingClientId = $leadingClientId;
        }
        return $this;
    }
    /**
     * Get TicketList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketList()
    {
        return isset($this->TicketList) ? $this->TicketList : null;
    }
    /**
     * Set TicketList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketList
     * @return \patest\StructType\Sales_MergeClientIdentificationHistory
     */
    public function setTicketList($ticketList = null)
    {
        // validation for constraint: string
        if (!is_null($ticketList) && !is_string($ticketList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketList, true), gettype($ticketList)), __LINE__);
        }
        if (is_null($ticketList) || (is_array($ticketList) && empty($ticketList))) {
            unset($this->TicketList);
        } else {
            $this->TicketList = $ticketList;
        }
        return $this;
    }
}
