<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.MerchandiseItemDetails StructType
 * @subpackage Structs
 */
class Sales_MerchandiseItemDetails extends Sales_AbstractItemDetails
{
    /**
     * The CategoryName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CategoryName;
    /**
     * The HasHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasHistory;
    /**
     * The InsertionMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsertionMode;
    /**
     * The MerchandiseName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchandiseName;
    /**
     * The RequestedAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestedAction;
    /**
     * Constructor method for Sales.MerchandiseItemDetails
     * @uses Sales_MerchandiseItemDetails::setCategoryName()
     * @uses Sales_MerchandiseItemDetails::setHasHistory()
     * @uses Sales_MerchandiseItemDetails::setInsertionMode()
     * @uses Sales_MerchandiseItemDetails::setMerchandiseName()
     * @uses Sales_MerchandiseItemDetails::setRequestedAction()
     * @param string $categoryName
     * @param bool $hasHistory
     * @param string $insertionMode
     * @param string $merchandiseName
     * @param string $requestedAction
     */
    public function __construct($categoryName = null, $hasHistory = null, $insertionMode = null, $merchandiseName = null, $requestedAction = null)
    {
        $this
            ->setCategoryName($categoryName)
            ->setHasHistory($hasHistory)
            ->setInsertionMode($insertionMode)
            ->setMerchandiseName($merchandiseName)
            ->setRequestedAction($requestedAction);
    }
    /**
     * Get CategoryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryName()
    {
        return isset($this->CategoryName) ? $this->CategoryName : null;
    }
    /**
     * Set CategoryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryName
     * @return \patest\StructType\Sales_MerchandiseItemDetails
     */
    public function setCategoryName($categoryName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryName) && !is_string($categoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryName, true), gettype($categoryName)), __LINE__);
        }
        if (is_null($categoryName) || (is_array($categoryName) && empty($categoryName))) {
            unset($this->CategoryName);
        } else {
            $this->CategoryName = $categoryName;
        }
        return $this;
    }
    /**
     * Get HasHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasHistory()
    {
        return isset($this->HasHistory) ? $this->HasHistory : null;
    }
    /**
     * Set HasHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasHistory
     * @return \patest\StructType\Sales_MerchandiseItemDetails
     */
    public function setHasHistory($hasHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasHistory) && !is_bool($hasHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasHistory, true), gettype($hasHistory)), __LINE__);
        }
        if (is_null($hasHistory) || (is_array($hasHistory) && empty($hasHistory))) {
            unset($this->HasHistory);
        } else {
            $this->HasHistory = $hasHistory;
        }
        return $this;
    }
    /**
     * Get InsertionMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsertionMode()
    {
        return isset($this->InsertionMode) ? $this->InsertionMode : null;
    }
    /**
     * Set InsertionMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemInsertionMode::valueIsValid()
     * @uses \patest\EnumType\ItemInsertionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insertionMode
     * @return \patest\StructType\Sales_MerchandiseItemDetails
     */
    public function setInsertionMode($insertionMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemInsertionMode::valueIsValid($insertionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemInsertionMode', is_array($insertionMode) ? implode(', ', $insertionMode) : var_export($insertionMode, true), implode(', ', \patest\EnumType\ItemInsertionMode::getValidValues())), __LINE__);
        }
        if (is_null($insertionMode) || (is_array($insertionMode) && empty($insertionMode))) {
            unset($this->InsertionMode);
        } else {
            $this->InsertionMode = $insertionMode;
        }
        return $this;
    }
    /**
     * Get MerchandiseName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseName()
    {
        return isset($this->MerchandiseName) ? $this->MerchandiseName : null;
    }
    /**
     * Set MerchandiseName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseName
     * @return \patest\StructType\Sales_MerchandiseItemDetails
     */
    public function setMerchandiseName($merchandiseName = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseName) && !is_string($merchandiseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseName, true), gettype($merchandiseName)), __LINE__);
        }
        if (is_null($merchandiseName) || (is_array($merchandiseName) && empty($merchandiseName))) {
            unset($this->MerchandiseName);
        } else {
            $this->MerchandiseName = $merchandiseName;
        }
        return $this;
    }
    /**
     * Get RequestedAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestedAction()
    {
        return isset($this->RequestedAction) ? $this->RequestedAction : null;
    }
    /**
     * Set RequestedAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemRequestedAction::valueIsValid()
     * @uses \patest\EnumType\ItemRequestedAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestedAction
     * @return \patest\StructType\Sales_MerchandiseItemDetails
     */
    public function setRequestedAction($requestedAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemRequestedAction::valueIsValid($requestedAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemRequestedAction', is_array($requestedAction) ? implode(', ', $requestedAction) : var_export($requestedAction, true), implode(', ', \patest\EnumType\ItemRequestedAction::getValidValues())), __LINE__);
        }
        if (is_null($requestedAction) || (is_array($requestedAction) && empty($requestedAction))) {
            unset($this->RequestedAction);
        } else {
            $this->RequestedAction = $requestedAction;
        }
        return $this;
    }
}
