<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.MembershipItemDetails StructType
 * @subpackage Structs
 */
class Sales_MembershipItemDetails extends Sales_AbstractItemDetails
{
    /**
     * The BackwardTransaction
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BackwardTransaction;
    /**
     * The CurrentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentStatus;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ExtrasPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExtrasPriceTypeId;
    /**
     * The GuestsPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuestsPriceTypeId;
    /**
     * The IsAutoRenewRequested
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoRenewRequested;
    /**
     * The IsBenefitsShared
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBenefitsShared;
    /**
     * The IsGift
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGift;
    /**
     * The IsJoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsJoint;
    /**
     * The IsManuallySetDateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsManuallySetDateRange;
    /**
     * The IsRenewed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRenewed;
    /**
     * The IsUpdated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdated;
    /**
     * The JointMembers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_MembershipItemJointMemberDetails
     */
    public $JointMembers;
    /**
     * The JointMembershipPrintingOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JointMembershipPrintingOption;
    /**
     * The JointOwnersDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JointOwnersDetails;
    /**
     * The MembershipDefinitionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipDefinitionName;
    /**
     * The MembershipId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipId;
    /**
     * The MembershipInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipInstanceId;
    /**
     * The MembershipNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipNumber;
    /**
     * The MemberSince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MemberSince;
    /**
     * The NameOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameOnCard;
    /**
     * The NumberOfExtras
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfExtras;
    /**
     * The NumberOfGuests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfGuests;
    /**
     * The OwnersPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnersPriceTypeId;
    /**
     * The RenewOfInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RenewOfInstanceId;
    /**
     * The RequestedOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestedOperation;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The UpdateOfInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UpdateOfInstanceId;
    /**
     * Constructor method for Sales.MembershipItemDetails
     * @uses Sales_MembershipItemDetails::setBackwardTransaction()
     * @uses Sales_MembershipItemDetails::setCurrentStatus()
     * @uses Sales_MembershipItemDetails::setEndDate()
     * @uses Sales_MembershipItemDetails::setExtrasPriceTypeId()
     * @uses Sales_MembershipItemDetails::setGuestsPriceTypeId()
     * @uses Sales_MembershipItemDetails::setIsAutoRenewRequested()
     * @uses Sales_MembershipItemDetails::setIsBenefitsShared()
     * @uses Sales_MembershipItemDetails::setIsGift()
     * @uses Sales_MembershipItemDetails::setIsJoint()
     * @uses Sales_MembershipItemDetails::setIsManuallySetDateRange()
     * @uses Sales_MembershipItemDetails::setIsRenewed()
     * @uses Sales_MembershipItemDetails::setIsUpdated()
     * @uses Sales_MembershipItemDetails::setJointMembers()
     * @uses Sales_MembershipItemDetails::setJointMembershipPrintingOption()
     * @uses Sales_MembershipItemDetails::setJointOwnersDetails()
     * @uses Sales_MembershipItemDetails::setMembershipDefinitionName()
     * @uses Sales_MembershipItemDetails::setMembershipId()
     * @uses Sales_MembershipItemDetails::setMembershipInstanceId()
     * @uses Sales_MembershipItemDetails::setMembershipNumber()
     * @uses Sales_MembershipItemDetails::setMemberSince()
     * @uses Sales_MembershipItemDetails::setNameOnCard()
     * @uses Sales_MembershipItemDetails::setNumberOfExtras()
     * @uses Sales_MembershipItemDetails::setNumberOfGuests()
     * @uses Sales_MembershipItemDetails::setOwnersPriceTypeId()
     * @uses Sales_MembershipItemDetails::setRenewOfInstanceId()
     * @uses Sales_MembershipItemDetails::setRequestedOperation()
     * @uses Sales_MembershipItemDetails::setStartDate()
     * @uses Sales_MembershipItemDetails::setUpdateOfInstanceId()
     * @param string $backwardTransaction
     * @param string $currentStatus
     * @param string $endDate
     * @param string $extrasPriceTypeId
     * @param string $guestsPriceTypeId
     * @param bool $isAutoRenewRequested
     * @param bool $isBenefitsShared
     * @param bool $isGift
     * @param bool $isJoint
     * @param bool $isManuallySetDateRange
     * @param bool $isRenewed
     * @param bool $isUpdated
     * @param \patest\StructType\RecordSetOfSales_MembershipItemJointMemberDetails $jointMembers
     * @param string $jointMembershipPrintingOption
     * @param string $jointOwnersDetails
     * @param string $membershipDefinitionName
     * @param string $membershipId
     * @param string $membershipInstanceId
     * @param string $membershipNumber
     * @param string $memberSince
     * @param string $nameOnCard
     * @param int $numberOfExtras
     * @param int $numberOfGuests
     * @param string $ownersPriceTypeId
     * @param string $renewOfInstanceId
     * @param string $requestedOperation
     * @param string $startDate
     * @param string $updateOfInstanceId
     */
    public function __construct($backwardTransaction = null, $currentStatus = null, $endDate = null, $extrasPriceTypeId = null, $guestsPriceTypeId = null, $isAutoRenewRequested = null, $isBenefitsShared = null, $isGift = null, $isJoint = null, $isManuallySetDateRange = null, $isRenewed = null, $isUpdated = null, \patest\StructType\RecordSetOfSales_MembershipItemJointMemberDetails $jointMembers = null, $jointMembershipPrintingOption = null, $jointOwnersDetails = null, $membershipDefinitionName = null, $membershipId = null, $membershipInstanceId = null, $membershipNumber = null, $memberSince = null, $nameOnCard = null, $numberOfExtras = null, $numberOfGuests = null, $ownersPriceTypeId = null, $renewOfInstanceId = null, $requestedOperation = null, $startDate = null, $updateOfInstanceId = null)
    {
        $this
            ->setBackwardTransaction($backwardTransaction)
            ->setCurrentStatus($currentStatus)
            ->setEndDate($endDate)
            ->setExtrasPriceTypeId($extrasPriceTypeId)
            ->setGuestsPriceTypeId($guestsPriceTypeId)
            ->setIsAutoRenewRequested($isAutoRenewRequested)
            ->setIsBenefitsShared($isBenefitsShared)
            ->setIsGift($isGift)
            ->setIsJoint($isJoint)
            ->setIsManuallySetDateRange($isManuallySetDateRange)
            ->setIsRenewed($isRenewed)
            ->setIsUpdated($isUpdated)
            ->setJointMembers($jointMembers)
            ->setJointMembershipPrintingOption($jointMembershipPrintingOption)
            ->setJointOwnersDetails($jointOwnersDetails)
            ->setMembershipDefinitionName($membershipDefinitionName)
            ->setMembershipId($membershipId)
            ->setMembershipInstanceId($membershipInstanceId)
            ->setMembershipNumber($membershipNumber)
            ->setMemberSince($memberSince)
            ->setNameOnCard($nameOnCard)
            ->setNumberOfExtras($numberOfExtras)
            ->setNumberOfGuests($numberOfGuests)
            ->setOwnersPriceTypeId($ownersPriceTypeId)
            ->setRenewOfInstanceId($renewOfInstanceId)
            ->setRequestedOperation($requestedOperation)
            ->setStartDate($startDate)
            ->setUpdateOfInstanceId($updateOfInstanceId);
    }
    /**
     * Get BackwardTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackwardTransaction()
    {
        return isset($this->BackwardTransaction) ? $this->BackwardTransaction : null;
    }
    /**
     * Set BackwardTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backwardTransaction
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setBackwardTransaction($backwardTransaction = null)
    {
        // validation for constraint: string
        if (!is_null($backwardTransaction) && !is_string($backwardTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backwardTransaction, true), gettype($backwardTransaction)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($backwardTransaction) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $backwardTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($backwardTransaction, true)), __LINE__);
        }
        if (is_null($backwardTransaction) || (is_array($backwardTransaction) && empty($backwardTransaction))) {
            unset($this->BackwardTransaction);
        } else {
            $this->BackwardTransaction = $backwardTransaction;
        }
        return $this;
    }
    /**
     * Get CurrentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentStatus()
    {
        return isset($this->CurrentStatus) ? $this->CurrentStatus : null;
    }
    /**
     * Set CurrentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipStatus::valueIsValid()
     * @uses \patest\EnumType\MembershipStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currentStatus
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setCurrentStatus($currentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipStatus::valueIsValid($currentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipStatus', is_array($currentStatus) ? implode(', ', $currentStatus) : var_export($currentStatus, true), implode(', ', \patest\EnumType\MembershipStatus::getValidValues())), __LINE__);
        }
        if (is_null($currentStatus) || (is_array($currentStatus) && empty($currentStatus))) {
            unset($this->CurrentStatus);
        } else {
            $this->CurrentStatus = $currentStatus;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get ExtrasPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtrasPriceTypeId()
    {
        return isset($this->ExtrasPriceTypeId) ? $this->ExtrasPriceTypeId : null;
    }
    /**
     * Set ExtrasPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extrasPriceTypeId
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setExtrasPriceTypeId($extrasPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($extrasPriceTypeId) && !is_string($extrasPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extrasPriceTypeId, true), gettype($extrasPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($extrasPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $extrasPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($extrasPriceTypeId, true)), __LINE__);
        }
        if (is_null($extrasPriceTypeId) || (is_array($extrasPriceTypeId) && empty($extrasPriceTypeId))) {
            unset($this->ExtrasPriceTypeId);
        } else {
            $this->ExtrasPriceTypeId = $extrasPriceTypeId;
        }
        return $this;
    }
    /**
     * Get GuestsPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuestsPriceTypeId()
    {
        return isset($this->GuestsPriceTypeId) ? $this->GuestsPriceTypeId : null;
    }
    /**
     * Set GuestsPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guestsPriceTypeId
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setGuestsPriceTypeId($guestsPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($guestsPriceTypeId) && !is_string($guestsPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestsPriceTypeId, true), gettype($guestsPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guestsPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guestsPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guestsPriceTypeId, true)), __LINE__);
        }
        if (is_null($guestsPriceTypeId) || (is_array($guestsPriceTypeId) && empty($guestsPriceTypeId))) {
            unset($this->GuestsPriceTypeId);
        } else {
            $this->GuestsPriceTypeId = $guestsPriceTypeId;
        }
        return $this;
    }
    /**
     * Get IsAutoRenewRequested value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoRenewRequested()
    {
        return isset($this->IsAutoRenewRequested) ? $this->IsAutoRenewRequested : null;
    }
    /**
     * Set IsAutoRenewRequested value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoRenewRequested
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setIsAutoRenewRequested($isAutoRenewRequested = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoRenewRequested) && !is_bool($isAutoRenewRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoRenewRequested, true), gettype($isAutoRenewRequested)), __LINE__);
        }
        if (is_null($isAutoRenewRequested) || (is_array($isAutoRenewRequested) && empty($isAutoRenewRequested))) {
            unset($this->IsAutoRenewRequested);
        } else {
            $this->IsAutoRenewRequested = $isAutoRenewRequested;
        }
        return $this;
    }
    /**
     * Get IsBenefitsShared value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBenefitsShared()
    {
        return isset($this->IsBenefitsShared) ? $this->IsBenefitsShared : null;
    }
    /**
     * Set IsBenefitsShared value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBenefitsShared
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setIsBenefitsShared($isBenefitsShared = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBenefitsShared) && !is_bool($isBenefitsShared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBenefitsShared, true), gettype($isBenefitsShared)), __LINE__);
        }
        if (is_null($isBenefitsShared) || (is_array($isBenefitsShared) && empty($isBenefitsShared))) {
            unset($this->IsBenefitsShared);
        } else {
            $this->IsBenefitsShared = $isBenefitsShared;
        }
        return $this;
    }
    /**
     * Get IsGift value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGift()
    {
        return isset($this->IsGift) ? $this->IsGift : null;
    }
    /**
     * Set IsGift value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGift
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setIsGift($isGift = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGift) && !is_bool($isGift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGift, true), gettype($isGift)), __LINE__);
        }
        if (is_null($isGift) || (is_array($isGift) && empty($isGift))) {
            unset($this->IsGift);
        } else {
            $this->IsGift = $isGift;
        }
        return $this;
    }
    /**
     * Get IsJoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsJoint()
    {
        return isset($this->IsJoint) ? $this->IsJoint : null;
    }
    /**
     * Set IsJoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isJoint
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setIsJoint($isJoint = null)
    {
        // validation for constraint: boolean
        if (!is_null($isJoint) && !is_bool($isJoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isJoint, true), gettype($isJoint)), __LINE__);
        }
        if (is_null($isJoint) || (is_array($isJoint) && empty($isJoint))) {
            unset($this->IsJoint);
        } else {
            $this->IsJoint = $isJoint;
        }
        return $this;
    }
    /**
     * Get IsManuallySetDateRange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsManuallySetDateRange()
    {
        return isset($this->IsManuallySetDateRange) ? $this->IsManuallySetDateRange : null;
    }
    /**
     * Set IsManuallySetDateRange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isManuallySetDateRange
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setIsManuallySetDateRange($isManuallySetDateRange = null)
    {
        // validation for constraint: boolean
        if (!is_null($isManuallySetDateRange) && !is_bool($isManuallySetDateRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isManuallySetDateRange, true), gettype($isManuallySetDateRange)), __LINE__);
        }
        if (is_null($isManuallySetDateRange) || (is_array($isManuallySetDateRange) && empty($isManuallySetDateRange))) {
            unset($this->IsManuallySetDateRange);
        } else {
            $this->IsManuallySetDateRange = $isManuallySetDateRange;
        }
        return $this;
    }
    /**
     * Get IsRenewed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRenewed()
    {
        return isset($this->IsRenewed) ? $this->IsRenewed : null;
    }
    /**
     * Set IsRenewed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRenewed
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setIsRenewed($isRenewed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRenewed) && !is_bool($isRenewed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRenewed, true), gettype($isRenewed)), __LINE__);
        }
        if (is_null($isRenewed) || (is_array($isRenewed) && empty($isRenewed))) {
            unset($this->IsRenewed);
        } else {
            $this->IsRenewed = $isRenewed;
        }
        return $this;
    }
    /**
     * Get IsUpdated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdated()
    {
        return isset($this->IsUpdated) ? $this->IsUpdated : null;
    }
    /**
     * Set IsUpdated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdated
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setIsUpdated($isUpdated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdated) && !is_bool($isUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdated, true), gettype($isUpdated)), __LINE__);
        }
        if (is_null($isUpdated) || (is_array($isUpdated) && empty($isUpdated))) {
            unset($this->IsUpdated);
        } else {
            $this->IsUpdated = $isUpdated;
        }
        return $this;
    }
    /**
     * Get JointMembers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_MembershipItemJointMemberDetails|null
     */
    public function getJointMembers()
    {
        return isset($this->JointMembers) ? $this->JointMembers : null;
    }
    /**
     * Set JointMembers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_MembershipItemJointMemberDetails $jointMembers
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setJointMembers(\patest\StructType\RecordSetOfSales_MembershipItemJointMemberDetails $jointMembers = null)
    {
        if (is_null($jointMembers) || (is_array($jointMembers) && empty($jointMembers))) {
            unset($this->JointMembers);
        } else {
            $this->JointMembers = $jointMembers;
        }
        return $this;
    }
    /**
     * Get JointMembershipPrintingOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointMembershipPrintingOption()
    {
        return isset($this->JointMembershipPrintingOption) ? $this->JointMembershipPrintingOption : null;
    }
    /**
     * Set JointMembershipPrintingOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JointMembershipPrintingOption::valueIsValid()
     * @uses \patest\EnumType\JointMembershipPrintingOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $jointMembershipPrintingOption
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setJointMembershipPrintingOption($jointMembershipPrintingOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JointMembershipPrintingOption::valueIsValid($jointMembershipPrintingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JointMembershipPrintingOption', is_array($jointMembershipPrintingOption) ? implode(', ', $jointMembershipPrintingOption) : var_export($jointMembershipPrintingOption, true), implode(', ', \patest\EnumType\JointMembershipPrintingOption::getValidValues())), __LINE__);
        }
        if (is_null($jointMembershipPrintingOption) || (is_array($jointMembershipPrintingOption) && empty($jointMembershipPrintingOption))) {
            unset($this->JointMembershipPrintingOption);
        } else {
            $this->JointMembershipPrintingOption = $jointMembershipPrintingOption;
        }
        return $this;
    }
    /**
     * Get JointOwnersDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointOwnersDetails()
    {
        return isset($this->JointOwnersDetails) ? $this->JointOwnersDetails : null;
    }
    /**
     * Set JointOwnersDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jointOwnersDetails
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setJointOwnersDetails($jointOwnersDetails = null)
    {
        // validation for constraint: string
        if (!is_null($jointOwnersDetails) && !is_string($jointOwnersDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jointOwnersDetails, true), gettype($jointOwnersDetails)), __LINE__);
        }
        if (is_null($jointOwnersDetails) || (is_array($jointOwnersDetails) && empty($jointOwnersDetails))) {
            unset($this->JointOwnersDetails);
        } else {
            $this->JointOwnersDetails = $jointOwnersDetails;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionName()
    {
        return isset($this->MembershipDefinitionName) ? $this->MembershipDefinitionName : null;
    }
    /**
     * Set MembershipDefinitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionName
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setMembershipDefinitionName($membershipDefinitionName = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionName) && !is_string($membershipDefinitionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionName, true), gettype($membershipDefinitionName)), __LINE__);
        }
        if (is_null($membershipDefinitionName) || (is_array($membershipDefinitionName) && empty($membershipDefinitionName))) {
            unset($this->MembershipDefinitionName);
        } else {
            $this->MembershipDefinitionName = $membershipDefinitionName;
        }
        return $this;
    }
    /**
     * Get MembershipId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipId()
    {
        return isset($this->MembershipId) ? $this->MembershipId : null;
    }
    /**
     * Set MembershipId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipId
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setMembershipId($membershipId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipId) && !is_string($membershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipId, true), gettype($membershipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipId, true)), __LINE__);
        }
        if (is_null($membershipId) || (is_array($membershipId) && empty($membershipId))) {
            unset($this->MembershipId);
        } else {
            $this->MembershipId = $membershipId;
        }
        return $this;
    }
    /**
     * Get MembershipInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipInstanceId()
    {
        return isset($this->MembershipInstanceId) ? $this->MembershipInstanceId : null;
    }
    /**
     * Set MembershipInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipInstanceId
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setMembershipInstanceId($membershipInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipInstanceId) && !is_string($membershipInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipInstanceId, true), gettype($membershipInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipInstanceId, true)), __LINE__);
        }
        if (is_null($membershipInstanceId) || (is_array($membershipInstanceId) && empty($membershipInstanceId))) {
            unset($this->MembershipInstanceId);
        } else {
            $this->MembershipInstanceId = $membershipInstanceId;
        }
        return $this;
    }
    /**
     * Get MembershipNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipNumber()
    {
        return isset($this->MembershipNumber) ? $this->MembershipNumber : null;
    }
    /**
     * Set MembershipNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipNumber
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setMembershipNumber($membershipNumber = null)
    {
        // validation for constraint: string
        if (!is_null($membershipNumber) && !is_string($membershipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipNumber, true), gettype($membershipNumber)), __LINE__);
        }
        if (is_null($membershipNumber) || (is_array($membershipNumber) && empty($membershipNumber))) {
            unset($this->MembershipNumber);
        } else {
            $this->MembershipNumber = $membershipNumber;
        }
        return $this;
    }
    /**
     * Get MemberSince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMemberSince()
    {
        return isset($this->MemberSince) ? $this->MemberSince : null;
    }
    /**
     * Set MemberSince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $memberSince
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setMemberSince($memberSince = null)
    {
        // validation for constraint: string
        if (!is_null($memberSince) && !is_string($memberSince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberSince, true), gettype($memberSince)), __LINE__);
        }
        if (is_null($memberSince) || (is_array($memberSince) && empty($memberSince))) {
            unset($this->MemberSince);
        } else {
            $this->MemberSince = $memberSince;
        }
        return $this;
    }
    /**
     * Get NameOnCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameOnCard()
    {
        return isset($this->NameOnCard) ? $this->NameOnCard : null;
    }
    /**
     * Set NameOnCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameOnCard
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setNameOnCard($nameOnCard = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnCard) && !is_string($nameOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameOnCard, true), gettype($nameOnCard)), __LINE__);
        }
        if (is_null($nameOnCard) || (is_array($nameOnCard) && empty($nameOnCard))) {
            unset($this->NameOnCard);
        } else {
            $this->NameOnCard = $nameOnCard;
        }
        return $this;
    }
    /**
     * Get NumberOfExtras value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfExtras()
    {
        return isset($this->NumberOfExtras) ? $this->NumberOfExtras : null;
    }
    /**
     * Set NumberOfExtras value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfExtras
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setNumberOfExtras($numberOfExtras = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfExtras) && !(is_int($numberOfExtras) || ctype_digit($numberOfExtras))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfExtras, true), gettype($numberOfExtras)), __LINE__);
        }
        if (is_null($numberOfExtras) || (is_array($numberOfExtras) && empty($numberOfExtras))) {
            unset($this->NumberOfExtras);
        } else {
            $this->NumberOfExtras = $numberOfExtras;
        }
        return $this;
    }
    /**
     * Get NumberOfGuests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfGuests()
    {
        return isset($this->NumberOfGuests) ? $this->NumberOfGuests : null;
    }
    /**
     * Set NumberOfGuests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfGuests
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setNumberOfGuests($numberOfGuests = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfGuests) && !(is_int($numberOfGuests) || ctype_digit($numberOfGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfGuests, true), gettype($numberOfGuests)), __LINE__);
        }
        if (is_null($numberOfGuests) || (is_array($numberOfGuests) && empty($numberOfGuests))) {
            unset($this->NumberOfGuests);
        } else {
            $this->NumberOfGuests = $numberOfGuests;
        }
        return $this;
    }
    /**
     * Get OwnersPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnersPriceTypeId()
    {
        return isset($this->OwnersPriceTypeId) ? $this->OwnersPriceTypeId : null;
    }
    /**
     * Set OwnersPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownersPriceTypeId
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setOwnersPriceTypeId($ownersPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($ownersPriceTypeId) && !is_string($ownersPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownersPriceTypeId, true), gettype($ownersPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownersPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownersPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownersPriceTypeId, true)), __LINE__);
        }
        if (is_null($ownersPriceTypeId) || (is_array($ownersPriceTypeId) && empty($ownersPriceTypeId))) {
            unset($this->OwnersPriceTypeId);
        } else {
            $this->OwnersPriceTypeId = $ownersPriceTypeId;
        }
        return $this;
    }
    /**
     * Get RenewOfInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewOfInstanceId()
    {
        return isset($this->RenewOfInstanceId) ? $this->RenewOfInstanceId : null;
    }
    /**
     * Set RenewOfInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewOfInstanceId
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setRenewOfInstanceId($renewOfInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($renewOfInstanceId) && !is_string($renewOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewOfInstanceId, true), gettype($renewOfInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($renewOfInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $renewOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($renewOfInstanceId, true)), __LINE__);
        }
        if (is_null($renewOfInstanceId) || (is_array($renewOfInstanceId) && empty($renewOfInstanceId))) {
            unset($this->RenewOfInstanceId);
        } else {
            $this->RenewOfInstanceId = $renewOfInstanceId;
        }
        return $this;
    }
    /**
     * Get RequestedOperation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestedOperation()
    {
        return isset($this->RequestedOperation) ? $this->RequestedOperation : null;
    }
    /**
     * Set RequestedOperation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipRequestedOperation::valueIsValid()
     * @uses \patest\EnumType\MembershipRequestedOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestedOperation
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setRequestedOperation($requestedOperation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipRequestedOperation::valueIsValid($requestedOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipRequestedOperation', is_array($requestedOperation) ? implode(', ', $requestedOperation) : var_export($requestedOperation, true), implode(', ', \patest\EnumType\MembershipRequestedOperation::getValidValues())), __LINE__);
        }
        if (is_null($requestedOperation) || (is_array($requestedOperation) && empty($requestedOperation))) {
            unset($this->RequestedOperation);
        } else {
            $this->RequestedOperation = $requestedOperation;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get UpdateOfInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateOfInstanceId()
    {
        return isset($this->UpdateOfInstanceId) ? $this->UpdateOfInstanceId : null;
    }
    /**
     * Set UpdateOfInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateOfInstanceId
     * @return \patest\StructType\Sales_MembershipItemDetails
     */
    public function setUpdateOfInstanceId($updateOfInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($updateOfInstanceId) && !is_string($updateOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateOfInstanceId, true), gettype($updateOfInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($updateOfInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $updateOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($updateOfInstanceId, true)), __LINE__);
        }
        if (is_null($updateOfInstanceId) || (is_array($updateOfInstanceId) && empty($updateOfInstanceId))) {
            unset($this->UpdateOfInstanceId);
        } else {
            $this->UpdateOfInstanceId = $updateOfInstanceId;
        }
        return $this;
    }
}
