<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.LimitMembershipInTransactionEntity StructType
 * @subpackage Structs
 */
class Sales_LimitMembershipInTransactionEntity extends Sales_LimitSameMembershipPerOwnerEntity
{
    /**
     * The MembershipIds
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipIds;
    /**
     * The MembershipLimitByLevel
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MembershipLimitByLevel;
    /**
     * The MembershipOnlyForOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MembershipOnlyForOwner;
    /**
     * The MembershipOnlyInBasket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MembershipOnlyInBasket;
    /**
     * The SchemeIds
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchemeIds;
    /**
     * The SchemeLevelIds
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchemeLevelIds;
    /**
     * Constructor method for Sales.LimitMembershipInTransactionEntity
     * @uses Sales_LimitMembershipInTransactionEntity::setMembershipIds()
     * @uses Sales_LimitMembershipInTransactionEntity::setMembershipLimitByLevel()
     * @uses Sales_LimitMembershipInTransactionEntity::setMembershipOnlyForOwner()
     * @uses Sales_LimitMembershipInTransactionEntity::setMembershipOnlyInBasket()
     * @uses Sales_LimitMembershipInTransactionEntity::setSchemeIds()
     * @uses Sales_LimitMembershipInTransactionEntity::setSchemeLevelIds()
     * @param string $membershipIds
     * @param int $membershipLimitByLevel
     * @param bool $membershipOnlyForOwner
     * @param bool $membershipOnlyInBasket
     * @param string $schemeIds
     * @param string $schemeLevelIds
     */
    public function __construct($membershipIds = null, $membershipLimitByLevel = null, $membershipOnlyForOwner = null, $membershipOnlyInBasket = null, $schemeIds = null, $schemeLevelIds = null)
    {
        $this
            ->setMembershipIds($membershipIds)
            ->setMembershipLimitByLevel($membershipLimitByLevel)
            ->setMembershipOnlyForOwner($membershipOnlyForOwner)
            ->setMembershipOnlyInBasket($membershipOnlyInBasket)
            ->setSchemeIds($schemeIds)
            ->setSchemeLevelIds($schemeLevelIds);
    }
    /**
     * Get MembershipIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipIds()
    {
        return isset($this->MembershipIds) ? $this->MembershipIds : null;
    }
    /**
     * Set MembershipIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipIds
     * @return \patest\StructType\Sales_LimitMembershipInTransactionEntity
     */
    public function setMembershipIds($membershipIds = null)
    {
        // validation for constraint: string
        if (!is_null($membershipIds) && !is_string($membershipIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipIds, true), gettype($membershipIds)), __LINE__);
        }
        if (is_null($membershipIds) || (is_array($membershipIds) && empty($membershipIds))) {
            unset($this->MembershipIds);
        } else {
            $this->MembershipIds = $membershipIds;
        }
        return $this;
    }
    /**
     * Get MembershipLimitByLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMembershipLimitByLevel()
    {
        return isset($this->MembershipLimitByLevel) ? $this->MembershipLimitByLevel : null;
    }
    /**
     * Set MembershipLimitByLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $membershipLimitByLevel
     * @return \patest\StructType\Sales_LimitMembershipInTransactionEntity
     */
    public function setMembershipLimitByLevel($membershipLimitByLevel = null)
    {
        // validation for constraint: int
        if (!is_null($membershipLimitByLevel) && !(is_int($membershipLimitByLevel) || ctype_digit($membershipLimitByLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($membershipLimitByLevel, true), gettype($membershipLimitByLevel)), __LINE__);
        }
        if (is_null($membershipLimitByLevel) || (is_array($membershipLimitByLevel) && empty($membershipLimitByLevel))) {
            unset($this->MembershipLimitByLevel);
        } else {
            $this->MembershipLimitByLevel = $membershipLimitByLevel;
        }
        return $this;
    }
    /**
     * Get MembershipOnlyForOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMembershipOnlyForOwner()
    {
        return isset($this->MembershipOnlyForOwner) ? $this->MembershipOnlyForOwner : null;
    }
    /**
     * Set MembershipOnlyForOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $membershipOnlyForOwner
     * @return \patest\StructType\Sales_LimitMembershipInTransactionEntity
     */
    public function setMembershipOnlyForOwner($membershipOnlyForOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($membershipOnlyForOwner) && !is_bool($membershipOnlyForOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($membershipOnlyForOwner, true), gettype($membershipOnlyForOwner)), __LINE__);
        }
        if (is_null($membershipOnlyForOwner) || (is_array($membershipOnlyForOwner) && empty($membershipOnlyForOwner))) {
            unset($this->MembershipOnlyForOwner);
        } else {
            $this->MembershipOnlyForOwner = $membershipOnlyForOwner;
        }
        return $this;
    }
    /**
     * Get MembershipOnlyInBasket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMembershipOnlyInBasket()
    {
        return isset($this->MembershipOnlyInBasket) ? $this->MembershipOnlyInBasket : null;
    }
    /**
     * Set MembershipOnlyInBasket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $membershipOnlyInBasket
     * @return \patest\StructType\Sales_LimitMembershipInTransactionEntity
     */
    public function setMembershipOnlyInBasket($membershipOnlyInBasket = null)
    {
        // validation for constraint: boolean
        if (!is_null($membershipOnlyInBasket) && !is_bool($membershipOnlyInBasket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($membershipOnlyInBasket, true), gettype($membershipOnlyInBasket)), __LINE__);
        }
        if (is_null($membershipOnlyInBasket) || (is_array($membershipOnlyInBasket) && empty($membershipOnlyInBasket))) {
            unset($this->MembershipOnlyInBasket);
        } else {
            $this->MembershipOnlyInBasket = $membershipOnlyInBasket;
        }
        return $this;
    }
    /**
     * Get SchemeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeIds()
    {
        return isset($this->SchemeIds) ? $this->SchemeIds : null;
    }
    /**
     * Set SchemeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeIds
     * @return \patest\StructType\Sales_LimitMembershipInTransactionEntity
     */
    public function setSchemeIds($schemeIds = null)
    {
        // validation for constraint: string
        if (!is_null($schemeIds) && !is_string($schemeIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeIds, true), gettype($schemeIds)), __LINE__);
        }
        if (is_null($schemeIds) || (is_array($schemeIds) && empty($schemeIds))) {
            unset($this->SchemeIds);
        } else {
            $this->SchemeIds = $schemeIds;
        }
        return $this;
    }
    /**
     * Get SchemeLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeLevelIds()
    {
        return isset($this->SchemeLevelIds) ? $this->SchemeLevelIds : null;
    }
    /**
     * Set SchemeLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeLevelIds
     * @return \patest\StructType\Sales_LimitMembershipInTransactionEntity
     */
    public function setSchemeLevelIds($schemeLevelIds = null)
    {
        // validation for constraint: string
        if (!is_null($schemeLevelIds) && !is_string($schemeLevelIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeLevelIds, true), gettype($schemeLevelIds)), __LINE__);
        }
        if (is_null($schemeLevelIds) || (is_array($schemeLevelIds) && empty($schemeLevelIds))) {
            unset($this->SchemeLevelIds);
        } else {
            $this->SchemeLevelIds = $schemeLevelIds;
        }
        return $this;
    }
}
