<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.LiabilityItemForDraftInvoice StructType
 * @subpackage Structs
 */
class Sales_LiabilityItemForDraftInvoice extends AnyEntity
{
    /**
     * The AmountPerItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $AmountPerItem;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The CommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CommissionAmount;
    /**
     * The DefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefinitionId;
    /**
     * The DefinitionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefinitionName;
    /**
     * The DueAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DueAmount;
    /**
     * The FacePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $FacePrice;
    /**
     * The FullAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $FullAmount;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallName;
    /**
     * The IdsInTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdsInTransaction;
    /**
     * The IsReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReservation;
    /**
     * The IsSelected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSelected;
    /**
     * The ItemTaxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ItemTaxAmount;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The ListPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ListPrice;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaidAmount;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Qty;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectorName;
    /**
     * The SellItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SellItemIds;
    /**
     * The ServiceSpecificIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceSpecificIds;
    /**
     * The ShortDefinitionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShortDefinitionName;
    /**
     * The TotalTaxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalTaxAmount;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionNumber;
    /**
     * Constructor method for Sales.LiabilityItemForDraftInvoice
     * @uses Sales_LiabilityItemForDraftInvoice::setAmountPerItem()
     * @uses Sales_LiabilityItemForDraftInvoice::setAreaName()
     * @uses Sales_LiabilityItemForDraftInvoice::setCommissionAmount()
     * @uses Sales_LiabilityItemForDraftInvoice::setDefinitionId()
     * @uses Sales_LiabilityItemForDraftInvoice::setDefinitionName()
     * @uses Sales_LiabilityItemForDraftInvoice::setDueAmount()
     * @uses Sales_LiabilityItemForDraftInvoice::setFacePrice()
     * @uses Sales_LiabilityItemForDraftInvoice::setFullAmount()
     * @uses Sales_LiabilityItemForDraftInvoice::setHallName()
     * @uses Sales_LiabilityItemForDraftInvoice::setIdsInTransaction()
     * @uses Sales_LiabilityItemForDraftInvoice::setIsReservation()
     * @uses Sales_LiabilityItemForDraftInvoice::setIsSelected()
     * @uses Sales_LiabilityItemForDraftInvoice::setItemTaxAmount()
     * @uses Sales_LiabilityItemForDraftInvoice::setItemType()
     * @uses Sales_LiabilityItemForDraftInvoice::setListPrice()
     * @uses Sales_LiabilityItemForDraftInvoice::setPaidAmount()
     * @uses Sales_LiabilityItemForDraftInvoice::setQty()
     * @uses Sales_LiabilityItemForDraftInvoice::setRowName()
     * @uses Sales_LiabilityItemForDraftInvoice::setSeat()
     * @uses Sales_LiabilityItemForDraftInvoice::setSectorName()
     * @uses Sales_LiabilityItemForDraftInvoice::setSellItemIds()
     * @uses Sales_LiabilityItemForDraftInvoice::setServiceSpecificIds()
     * @uses Sales_LiabilityItemForDraftInvoice::setShortDefinitionName()
     * @uses Sales_LiabilityItemForDraftInvoice::setTotalTaxAmount()
     * @uses Sales_LiabilityItemForDraftInvoice::setTransactionDate()
     * @uses Sales_LiabilityItemForDraftInvoice::setTransactionGuid()
     * @uses Sales_LiabilityItemForDraftInvoice::setTransactionNumber()
     * @param \patest\StructType\Money $amountPerItem
     * @param string $areaName
     * @param \patest\StructType\Money $commissionAmount
     * @param string $definitionId
     * @param string $definitionName
     * @param \patest\StructType\Money $dueAmount
     * @param \patest\StructType\Money $facePrice
     * @param \patest\StructType\Money $fullAmount
     * @param string $hallName
     * @param string $idsInTransaction
     * @param bool $isReservation
     * @param bool $isSelected
     * @param \patest\StructType\Money $itemTaxAmount
     * @param int $itemType
     * @param \patest\StructType\Money $listPrice
     * @param \patest\StructType\Money $paidAmount
     * @param int $qty
     * @param string $rowName
     * @param string $seat
     * @param string $sectorName
     * @param string $sellItemIds
     * @param string $serviceSpecificIds
     * @param string $shortDefinitionName
     * @param \patest\StructType\Money $totalTaxAmount
     * @param string $transactionDate
     * @param string $transactionGuid
     * @param string $transactionNumber
     */
    public function __construct(\patest\StructType\Money $amountPerItem = null, $areaName = null, \patest\StructType\Money $commissionAmount = null, $definitionId = null, $definitionName = null, \patest\StructType\Money $dueAmount = null, \patest\StructType\Money $facePrice = null, \patest\StructType\Money $fullAmount = null, $hallName = null, $idsInTransaction = null, $isReservation = null, $isSelected = null, \patest\StructType\Money $itemTaxAmount = null, $itemType = null, \patest\StructType\Money $listPrice = null, \patest\StructType\Money $paidAmount = null, $qty = null, $rowName = null, $seat = null, $sectorName = null, $sellItemIds = null, $serviceSpecificIds = null, $shortDefinitionName = null, \patest\StructType\Money $totalTaxAmount = null, $transactionDate = null, $transactionGuid = null, $transactionNumber = null)
    {
        $this
            ->setAmountPerItem($amountPerItem)
            ->setAreaName($areaName)
            ->setCommissionAmount($commissionAmount)
            ->setDefinitionId($definitionId)
            ->setDefinitionName($definitionName)
            ->setDueAmount($dueAmount)
            ->setFacePrice($facePrice)
            ->setFullAmount($fullAmount)
            ->setHallName($hallName)
            ->setIdsInTransaction($idsInTransaction)
            ->setIsReservation($isReservation)
            ->setIsSelected($isSelected)
            ->setItemTaxAmount($itemTaxAmount)
            ->setItemType($itemType)
            ->setListPrice($listPrice)
            ->setPaidAmount($paidAmount)
            ->setQty($qty)
            ->setRowName($rowName)
            ->setSeat($seat)
            ->setSectorName($sectorName)
            ->setSellItemIds($sellItemIds)
            ->setServiceSpecificIds($serviceSpecificIds)
            ->setShortDefinitionName($shortDefinitionName)
            ->setTotalTaxAmount($totalTaxAmount)
            ->setTransactionDate($transactionDate)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get AmountPerItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmountPerItem()
    {
        return isset($this->AmountPerItem) ? $this->AmountPerItem : null;
    }
    /**
     * Set AmountPerItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amountPerItem
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setAmountPerItem(\patest\StructType\Money $amountPerItem = null)
    {
        if (is_null($amountPerItem) || (is_array($amountPerItem) && empty($amountPerItem))) {
            unset($this->AmountPerItem);
        } else {
            $this->AmountPerItem = $amountPerItem;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get CommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCommissionAmount()
    {
        return isset($this->CommissionAmount) ? $this->CommissionAmount : null;
    }
    /**
     * Set CommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $commissionAmount
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setCommissionAmount(\patest\StructType\Money $commissionAmount = null)
    {
        if (is_null($commissionAmount) || (is_array($commissionAmount) && empty($commissionAmount))) {
            unset($this->CommissionAmount);
        } else {
            $this->CommissionAmount = $commissionAmount;
        }
        return $this;
    }
    /**
     * Get DefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefinitionId()
    {
        return isset($this->DefinitionId) ? $this->DefinitionId : null;
    }
    /**
     * Set DefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $definitionId
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setDefinitionId($definitionId = null)
    {
        // validation for constraint: string
        if (!is_null($definitionId) && !is_string($definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($definitionId, true), gettype($definitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($definitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($definitionId, true)), __LINE__);
        }
        if (is_null($definitionId) || (is_array($definitionId) && empty($definitionId))) {
            unset($this->DefinitionId);
        } else {
            $this->DefinitionId = $definitionId;
        }
        return $this;
    }
    /**
     * Get DefinitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefinitionName()
    {
        return isset($this->DefinitionName) ? $this->DefinitionName : null;
    }
    /**
     * Set DefinitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $definitionName
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setDefinitionName($definitionName = null)
    {
        // validation for constraint: string
        if (!is_null($definitionName) && !is_string($definitionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($definitionName, true), gettype($definitionName)), __LINE__);
        }
        if (is_null($definitionName) || (is_array($definitionName) && empty($definitionName))) {
            unset($this->DefinitionName);
        } else {
            $this->DefinitionName = $definitionName;
        }
        return $this;
    }
    /**
     * Get DueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDueAmount()
    {
        return isset($this->DueAmount) ? $this->DueAmount : null;
    }
    /**
     * Set DueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $dueAmount
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setDueAmount(\patest\StructType\Money $dueAmount = null)
    {
        if (is_null($dueAmount) || (is_array($dueAmount) && empty($dueAmount))) {
            unset($this->DueAmount);
        } else {
            $this->DueAmount = $dueAmount;
        }
        return $this;
    }
    /**
     * Get FacePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getFacePrice()
    {
        return isset($this->FacePrice) ? $this->FacePrice : null;
    }
    /**
     * Set FacePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $facePrice
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setFacePrice(\patest\StructType\Money $facePrice = null)
    {
        if (is_null($facePrice) || (is_array($facePrice) && empty($facePrice))) {
            unset($this->FacePrice);
        } else {
            $this->FacePrice = $facePrice;
        }
        return $this;
    }
    /**
     * Get FullAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getFullAmount()
    {
        return isset($this->FullAmount) ? $this->FullAmount : null;
    }
    /**
     * Set FullAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $fullAmount
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setFullAmount(\patest\StructType\Money $fullAmount = null)
    {
        if (is_null($fullAmount) || (is_array($fullAmount) && empty($fullAmount))) {
            unset($this->FullAmount);
        } else {
            $this->FullAmount = $fullAmount;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallName
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setHallName($hallName = null)
    {
        // validation for constraint: string
        if (!is_null($hallName) && !is_string($hallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallName, true), gettype($hallName)), __LINE__);
        }
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get IdsInTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdsInTransaction()
    {
        return isset($this->IdsInTransaction) ? $this->IdsInTransaction : null;
    }
    /**
     * Set IdsInTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idsInTransaction
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setIdsInTransaction($idsInTransaction = null)
    {
        // validation for constraint: string
        if (!is_null($idsInTransaction) && !is_string($idsInTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idsInTransaction, true), gettype($idsInTransaction)), __LINE__);
        }
        if (is_null($idsInTransaction) || (is_array($idsInTransaction) && empty($idsInTransaction))) {
            unset($this->IdsInTransaction);
        } else {
            $this->IdsInTransaction = $idsInTransaction;
        }
        return $this;
    }
    /**
     * Get IsReservation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReservation()
    {
        return isset($this->IsReservation) ? $this->IsReservation : null;
    }
    /**
     * Set IsReservation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReservation
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setIsReservation($isReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReservation) && !is_bool($isReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReservation, true), gettype($isReservation)), __LINE__);
        }
        if (is_null($isReservation) || (is_array($isReservation) && empty($isReservation))) {
            unset($this->IsReservation);
        } else {
            $this->IsReservation = $isReservation;
        }
        return $this;
    }
    /**
     * Get IsSelected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSelected()
    {
        return isset($this->IsSelected) ? $this->IsSelected : null;
    }
    /**
     * Set IsSelected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSelected
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setIsSelected($isSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSelected) && !is_bool($isSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSelected, true), gettype($isSelected)), __LINE__);
        }
        if (is_null($isSelected) || (is_array($isSelected) && empty($isSelected))) {
            unset($this->IsSelected);
        } else {
            $this->IsSelected = $isSelected;
        }
        return $this;
    }
    /**
     * Get ItemTaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getItemTaxAmount()
    {
        return isset($this->ItemTaxAmount) ? $this->ItemTaxAmount : null;
    }
    /**
     * Set ItemTaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $itemTaxAmount
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setItemTaxAmount(\patest\StructType\Money $itemTaxAmount = null)
    {
        if (is_null($itemTaxAmount) || (is_array($itemTaxAmount) && empty($itemTaxAmount))) {
            unset($this->ItemTaxAmount);
        } else {
            $this->ItemTaxAmount = $itemTaxAmount;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get ListPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getListPrice()
    {
        return isset($this->ListPrice) ? $this->ListPrice : null;
    }
    /**
     * Set ListPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $listPrice
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setListPrice(\patest\StructType\Money $listPrice = null)
    {
        if (is_null($listPrice) || (is_array($listPrice) && empty($listPrice))) {
            unset($this->ListPrice);
        } else {
            $this->ListPrice = $listPrice;
        }
        return $this;
    }
    /**
     * Get PaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaidAmount()
    {
        return isset($this->PaidAmount) ? $this->PaidAmount : null;
    }
    /**
     * Set PaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paidAmount
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setPaidAmount(\patest\StructType\Money $paidAmount = null)
    {
        if (is_null($paidAmount) || (is_array($paidAmount) && empty($paidAmount))) {
            unset($this->PaidAmount);
        } else {
            $this->PaidAmount = $paidAmount;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $qty
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setQty($qty = null)
    {
        // validation for constraint: int
        if (!is_null($qty) && !(is_int($qty) || ctype_digit($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get Seat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * Set Seat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seat
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorName
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setSectorName($sectorName = null)
    {
        // validation for constraint: string
        if (!is_null($sectorName) && !is_string($sectorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorName, true), gettype($sectorName)), __LINE__);
        }
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get SellItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellItemIds()
    {
        return isset($this->SellItemIds) ? $this->SellItemIds : null;
    }
    /**
     * Set SellItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sellItemIds
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setSellItemIds($sellItemIds = null)
    {
        // validation for constraint: string
        if (!is_null($sellItemIds) && !is_string($sellItemIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellItemIds, true), gettype($sellItemIds)), __LINE__);
        }
        if (is_null($sellItemIds) || (is_array($sellItemIds) && empty($sellItemIds))) {
            unset($this->SellItemIds);
        } else {
            $this->SellItemIds = $sellItemIds;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceSpecificIds()
    {
        return isset($this->ServiceSpecificIds) ? $this->ServiceSpecificIds : null;
    }
    /**
     * Set ServiceSpecificIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceSpecificIds
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setServiceSpecificIds($serviceSpecificIds = null)
    {
        // validation for constraint: string
        if (!is_null($serviceSpecificIds) && !is_string($serviceSpecificIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceSpecificIds, true), gettype($serviceSpecificIds)), __LINE__);
        }
        if (is_null($serviceSpecificIds) || (is_array($serviceSpecificIds) && empty($serviceSpecificIds))) {
            unset($this->ServiceSpecificIds);
        } else {
            $this->ServiceSpecificIds = $serviceSpecificIds;
        }
        return $this;
    }
    /**
     * Get ShortDefinitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShortDefinitionName()
    {
        return isset($this->ShortDefinitionName) ? $this->ShortDefinitionName : null;
    }
    /**
     * Set ShortDefinitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shortDefinitionName
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setShortDefinitionName($shortDefinitionName = null)
    {
        // validation for constraint: string
        if (!is_null($shortDefinitionName) && !is_string($shortDefinitionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDefinitionName, true), gettype($shortDefinitionName)), __LINE__);
        }
        if (is_null($shortDefinitionName) || (is_array($shortDefinitionName) && empty($shortDefinitionName))) {
            unset($this->ShortDefinitionName);
        } else {
            $this->ShortDefinitionName = $shortDefinitionName;
        }
        return $this;
    }
    /**
     * Get TotalTaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalTaxAmount()
    {
        return isset($this->TotalTaxAmount) ? $this->TotalTaxAmount : null;
    }
    /**
     * Set TotalTaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalTaxAmount
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setTotalTaxAmount(\patest\StructType\Money $totalTaxAmount = null)
    {
        if (is_null($totalTaxAmount) || (is_array($totalTaxAmount) && empty($totalTaxAmount))) {
            unset($this->TotalTaxAmount);
        } else {
            $this->TotalTaxAmount = $totalTaxAmount;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionNumber
     * @return \patest\StructType\Sales_LiabilityItemForDraftInvoice
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
