<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ItemRelation StructType
 * @subpackage Structs
 */
class Sales_ItemRelation extends AnyEntity
{
    /**
     * The ContextName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextName;
    /**
     * The ExchangeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExchangeType;
    /**
     * The HolderTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderTenantId;
    /**
     * The RelatedItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RelatedItemId;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionId;
    /**
     * Constructor method for Sales.ItemRelation
     * @uses Sales_ItemRelation::setContextName()
     * @uses Sales_ItemRelation::setExchangeType()
     * @uses Sales_ItemRelation::setHolderTenantId()
     * @uses Sales_ItemRelation::setRelatedItemId()
     * @uses Sales_ItemRelation::setTransactionId()
     * @param string $contextName
     * @param string $exchangeType
     * @param int $holderTenantId
     * @param int $relatedItemId
     * @param int $transactionId
     */
    public function __construct($contextName = null, $exchangeType = null, $holderTenantId = null, $relatedItemId = null, $transactionId = null)
    {
        $this
            ->setContextName($contextName)
            ->setExchangeType($exchangeType)
            ->setHolderTenantId($holderTenantId)
            ->setRelatedItemId($relatedItemId)
            ->setTransactionId($transactionId);
    }
    /**
     * Get ContextName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextName()
    {
        return isset($this->ContextName) ? $this->ContextName : null;
    }
    /**
     * Set ContextName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextName
     * @return \patest\StructType\Sales_ItemRelation
     */
    public function setContextName($contextName = null)
    {
        // validation for constraint: string
        if (!is_null($contextName) && !is_string($contextName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextName, true), gettype($contextName)), __LINE__);
        }
        if (is_null($contextName) || (is_array($contextName) && empty($contextName))) {
            unset($this->ContextName);
        } else {
            $this->ContextName = $contextName;
        }
        return $this;
    }
    /**
     * Get ExchangeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExchangeType()
    {
        return isset($this->ExchangeType) ? $this->ExchangeType : null;
    }
    /**
     * Set ExchangeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ExchangeType::valueIsValid()
     * @uses \patest\EnumType\ExchangeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $exchangeType
     * @return \patest\StructType\Sales_ItemRelation
     */
    public function setExchangeType($exchangeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ExchangeType::valueIsValid($exchangeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ExchangeType', is_array($exchangeType) ? implode(', ', $exchangeType) : var_export($exchangeType, true), implode(', ', \patest\EnumType\ExchangeType::getValidValues())), __LINE__);
        }
        if (is_null($exchangeType) || (is_array($exchangeType) && empty($exchangeType))) {
            unset($this->ExchangeType);
        } else {
            $this->ExchangeType = $exchangeType;
        }
        return $this;
    }
    /**
     * Get HolderTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderTenantId()
    {
        return isset($this->HolderTenantId) ? $this->HolderTenantId : null;
    }
    /**
     * Set HolderTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderTenantId
     * @return \patest\StructType\Sales_ItemRelation
     */
    public function setHolderTenantId($holderTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($holderTenantId) && !(is_int($holderTenantId) || ctype_digit($holderTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderTenantId, true), gettype($holderTenantId)), __LINE__);
        }
        if (is_null($holderTenantId) || (is_array($holderTenantId) && empty($holderTenantId))) {
            unset($this->HolderTenantId);
        } else {
            $this->HolderTenantId = $holderTenantId;
        }
        return $this;
    }
    /**
     * Get RelatedItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatedItemId()
    {
        return isset($this->RelatedItemId) ? $this->RelatedItemId : null;
    }
    /**
     * Set RelatedItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatedItemId
     * @return \patest\StructType\Sales_ItemRelation
     */
    public function setRelatedItemId($relatedItemId = null)
    {
        // validation for constraint: int
        if (!is_null($relatedItemId) && !(is_int($relatedItemId) || ctype_digit($relatedItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatedItemId, true), gettype($relatedItemId)), __LINE__);
        }
        if (is_null($relatedItemId) || (is_array($relatedItemId) && empty($relatedItemId))) {
            unset($this->RelatedItemId);
        } else {
            $this->RelatedItemId = $relatedItemId;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionId
     * @return \patest\StructType\Sales_ItemRelation
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !(is_int($transactionId) || ctype_digit($transactionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
}
