<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ItemInformation StructType
 * @subpackage Structs
 */
class Sales_ItemInformation extends AnyEntity
{
    /**
     * The AccessCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessCardNumber;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The AttachedToBenefitInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AttachedToBenefitInstanceId;
    /**
     * The BackwardTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BackwardTransactionId;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The CanRenew
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanRenew;
    /**
     * The CollectionMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectionMethod;
    /**
     * The CollectionTarget
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectionTarget;
    /**
     * The ComplimentaryConfirmByKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComplimentaryConfirmByKey;
    /**
     * The Context
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Context;
    /**
     * The DepositCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositCategoryId;
    /**
     * The DepositOriginalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DepositOriginalAmount;
    /**
     * The DepositRemainingAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DepositRemainingAmount;
    /**
     * The ExtraData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraData;
    /**
     * The FinancialJournalTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FinancialJournalTargetId;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallName;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IdInBackwardTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInBackwardTransaction;
    /**
     * The InsertionMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsertionMode;
    /**
     * The IsComplimentary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsComplimentary;
    /**
     * The IsExtraProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExtraProduct;
    /**
     * The IsInCustodyChain
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInCustodyChain;
    /**
     * The IsJointOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsJointOwners;
    /**
     * The IsPrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrinted;
    /**
     * The IsSelected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSelected;
    /**
     * The ItemDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemDescription;
    /**
     * The ItemExtraFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemExtraFields;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemType;
    /**
     * The ItemTypeIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemTypeIdentifier;
    /**
     * The LinkingProductName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LinkingProductName;
    /**
     * The MerchAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMerchandise_AttributeTypeValue
     */
    public $MerchAttributes;
    /**
     * The MerchCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchCategoryId;
    /**
     * The MerchItemTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchItemTypeId;
    /**
     * The MerchProductName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchProductName;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The OwnerAge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OwnerAge;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The Payer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Payer;
    /**
     * The PayerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PayerId;
    /**
     * The PinnedPromptName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PinnedPromptName;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * The RequestedAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestedAction;
    /**
     * The ReservationExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationExpiryDate;
    /**
     * The Row
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Row;
    /**
     * The SalesRepDisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesRepDisplayName;
    /**
     * The SalesRepresentativeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepresentativeId;
    /**
     * The SaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleStatus;
    /**
     * The Scanned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Scanned;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * The SeatTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatTypeName;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectorName;
    /**
     * The ServiceSpecificId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServiceSpecificId;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketNumber;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TravelGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TravelGroupId;
    /**
     * The Union
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Union;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The ValidationErrorExists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ValidationErrorExists;
    /**
     * Constructor method for Sales.ItemInformation
     * @uses Sales_ItemInformation::setAccessCardNumber()
     * @uses Sales_ItemInformation::setAreaId()
     * @uses Sales_ItemInformation::setAreaName()
     * @uses Sales_ItemInformation::setAttachedToBenefitInstanceId()
     * @uses Sales_ItemInformation::setBackwardTransactionId()
     * @uses Sales_ItemInformation::setBarcode()
     * @uses Sales_ItemInformation::setCanRenew()
     * @uses Sales_ItemInformation::setCollectionMethod()
     * @uses Sales_ItemInformation::setCollectionTarget()
     * @uses Sales_ItemInformation::setComplimentaryConfirmByKey()
     * @uses Sales_ItemInformation::setContext()
     * @uses Sales_ItemInformation::setDepositCategoryId()
     * @uses Sales_ItemInformation::setDepositOriginalAmount()
     * @uses Sales_ItemInformation::setDepositRemainingAmount()
     * @uses Sales_ItemInformation::setExtraData()
     * @uses Sales_ItemInformation::setFinancialJournalTargetId()
     * @uses Sales_ItemInformation::setHallId()
     * @uses Sales_ItemInformation::setHallName()
     * @uses Sales_ItemInformation::setId()
     * @uses Sales_ItemInformation::setIdInBackwardTransaction()
     * @uses Sales_ItemInformation::setInsertionMode()
     * @uses Sales_ItemInformation::setIsComplimentary()
     * @uses Sales_ItemInformation::setIsExtraProduct()
     * @uses Sales_ItemInformation::setIsInCustodyChain()
     * @uses Sales_ItemInformation::setIsJointOwners()
     * @uses Sales_ItemInformation::setIsPrinted()
     * @uses Sales_ItemInformation::setIsSelected()
     * @uses Sales_ItemInformation::setItemDescription()
     * @uses Sales_ItemInformation::setItemExtraFields()
     * @uses Sales_ItemInformation::setItemId()
     * @uses Sales_ItemInformation::setItemType()
     * @uses Sales_ItemInformation::setItemTypeIdentifier()
     * @uses Sales_ItemInformation::setLinkingProductName()
     * @uses Sales_ItemInformation::setMerchAttributes()
     * @uses Sales_ItemInformation::setMerchCategoryId()
     * @uses Sales_ItemInformation::setMerchItemTypeId()
     * @uses Sales_ItemInformation::setMerchProductName()
     * @uses Sales_ItemInformation::setNote()
     * @uses Sales_ItemInformation::setOwnerAge()
     * @uses Sales_ItemInformation::setOwnerId()
     * @uses Sales_ItemInformation::setPayer()
     * @uses Sales_ItemInformation::setPayerId()
     * @uses Sales_ItemInformation::setPinnedPromptName()
     * @uses Sales_ItemInformation::setPriceTypeId()
     * @uses Sales_ItemInformation::setPriceTypeName()
     * @uses Sales_ItemInformation::setProductId()
     * @uses Sales_ItemInformation::setRequestedAction()
     * @uses Sales_ItemInformation::setReservationExpiryDate()
     * @uses Sales_ItemInformation::setRow()
     * @uses Sales_ItemInformation::setSalesRepDisplayName()
     * @uses Sales_ItemInformation::setSalesRepresentativeId()
     * @uses Sales_ItemInformation::setSaleStatus()
     * @uses Sales_ItemInformation::setScanned()
     * @uses Sales_ItemInformation::setSeat()
     * @uses Sales_ItemInformation::setSeatTypeName()
     * @uses Sales_ItemInformation::setSectorName()
     * @uses Sales_ItemInformation::setServiceSpecificId()
     * @uses Sales_ItemInformation::setTicketNumber()
     * @uses Sales_ItemInformation::setTransactionDate()
     * @uses Sales_ItemInformation::setTransactionGuid()
     * @uses Sales_ItemInformation::setTransactionNumber()
     * @uses Sales_ItemInformation::setTravelGroupId()
     * @uses Sales_ItemInformation::setUnion()
     * @uses Sales_ItemInformation::setUserName()
     * @uses Sales_ItemInformation::setValidationErrorExists()
     * @param string $accessCardNumber
     * @param string $areaId
     * @param string $areaName
     * @param string $attachedToBenefitInstanceId
     * @param string $backwardTransactionId
     * @param string $barcode
     * @param bool $canRenew
     * @param string $collectionMethod
     * @param string $collectionTarget
     * @param string $complimentaryConfirmByKey
     * @param string $context
     * @param string $depositCategoryId
     * @param \patest\StructType\Money $depositOriginalAmount
     * @param \patest\StructType\Money $depositRemainingAmount
     * @param string $extraData
     * @param string $financialJournalTargetId
     * @param string $hallId
     * @param string $hallName
     * @param string $id
     * @param int $idInBackwardTransaction
     * @param string $insertionMode
     * @param string $isComplimentary
     * @param bool $isExtraProduct
     * @param bool $isInCustodyChain
     * @param string $isJointOwners
     * @param bool $isPrinted
     * @param bool $isSelected
     * @param string $itemDescription
     * @param string $itemExtraFields
     * @param int $itemId
     * @param string $itemType
     * @param int $itemTypeIdentifier
     * @param string $linkingProductName
     * @param \patest\StructType\RecordSetOfMerchandise_AttributeTypeValue $merchAttributes
     * @param string $merchCategoryId
     * @param string $merchItemTypeId
     * @param string $merchProductName
     * @param string $note
     * @param int $ownerAge
     * @param string $ownerId
     * @param string $payer
     * @param string $payerId
     * @param string $pinnedPromptName
     * @param string $priceTypeId
     * @param string $priceTypeName
     * @param string $productId
     * @param string $requestedAction
     * @param string $reservationExpiryDate
     * @param string $row
     * @param string $salesRepDisplayName
     * @param string $salesRepresentativeId
     * @param string $saleStatus
     * @param string $scanned
     * @param string $seat
     * @param string $seatTypeName
     * @param string $sectorName
     * @param string $serviceSpecificId
     * @param int $ticketNumber
     * @param string $transactionDate
     * @param string $transactionGuid
     * @param int $transactionNumber
     * @param int $travelGroupId
     * @param string $union
     * @param string $userName
     * @param bool $validationErrorExists
     */
    public function __construct($accessCardNumber = null, $areaId = null, $areaName = null, $attachedToBenefitInstanceId = null, $backwardTransactionId = null, $barcode = null, $canRenew = null, $collectionMethod = null, $collectionTarget = null, $complimentaryConfirmByKey = null, $context = null, $depositCategoryId = null, \patest\StructType\Money $depositOriginalAmount = null, \patest\StructType\Money $depositRemainingAmount = null, $extraData = null, $financialJournalTargetId = null, $hallId = null, $hallName = null, $id = null, $idInBackwardTransaction = null, $insertionMode = null, $isComplimentary = null, $isExtraProduct = null, $isInCustodyChain = null, $isJointOwners = null, $isPrinted = null, $isSelected = null, $itemDescription = null, $itemExtraFields = null, $itemId = null, $itemType = null, $itemTypeIdentifier = null, $linkingProductName = null, \patest\StructType\RecordSetOfMerchandise_AttributeTypeValue $merchAttributes = null, $merchCategoryId = null, $merchItemTypeId = null, $merchProductName = null, $note = null, $ownerAge = null, $ownerId = null, $payer = null, $payerId = null, $pinnedPromptName = null, $priceTypeId = null, $priceTypeName = null, $productId = null, $requestedAction = null, $reservationExpiryDate = null, $row = null, $salesRepDisplayName = null, $salesRepresentativeId = null, $saleStatus = null, $scanned = null, $seat = null, $seatTypeName = null, $sectorName = null, $serviceSpecificId = null, $ticketNumber = null, $transactionDate = null, $transactionGuid = null, $transactionNumber = null, $travelGroupId = null, $union = null, $userName = null, $validationErrorExists = null)
    {
        $this
            ->setAccessCardNumber($accessCardNumber)
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setAttachedToBenefitInstanceId($attachedToBenefitInstanceId)
            ->setBackwardTransactionId($backwardTransactionId)
            ->setBarcode($barcode)
            ->setCanRenew($canRenew)
            ->setCollectionMethod($collectionMethod)
            ->setCollectionTarget($collectionTarget)
            ->setComplimentaryConfirmByKey($complimentaryConfirmByKey)
            ->setContext($context)
            ->setDepositCategoryId($depositCategoryId)
            ->setDepositOriginalAmount($depositOriginalAmount)
            ->setDepositRemainingAmount($depositRemainingAmount)
            ->setExtraData($extraData)
            ->setFinancialJournalTargetId($financialJournalTargetId)
            ->setHallId($hallId)
            ->setHallName($hallName)
            ->setId($id)
            ->setIdInBackwardTransaction($idInBackwardTransaction)
            ->setInsertionMode($insertionMode)
            ->setIsComplimentary($isComplimentary)
            ->setIsExtraProduct($isExtraProduct)
            ->setIsInCustodyChain($isInCustodyChain)
            ->setIsJointOwners($isJointOwners)
            ->setIsPrinted($isPrinted)
            ->setIsSelected($isSelected)
            ->setItemDescription($itemDescription)
            ->setItemExtraFields($itemExtraFields)
            ->setItemId($itemId)
            ->setItemType($itemType)
            ->setItemTypeIdentifier($itemTypeIdentifier)
            ->setLinkingProductName($linkingProductName)
            ->setMerchAttributes($merchAttributes)
            ->setMerchCategoryId($merchCategoryId)
            ->setMerchItemTypeId($merchItemTypeId)
            ->setMerchProductName($merchProductName)
            ->setNote($note)
            ->setOwnerAge($ownerAge)
            ->setOwnerId($ownerId)
            ->setPayer($payer)
            ->setPayerId($payerId)
            ->setPinnedPromptName($pinnedPromptName)
            ->setPriceTypeId($priceTypeId)
            ->setPriceTypeName($priceTypeName)
            ->setProductId($productId)
            ->setRequestedAction($requestedAction)
            ->setReservationExpiryDate($reservationExpiryDate)
            ->setRow($row)
            ->setSalesRepDisplayName($salesRepDisplayName)
            ->setSalesRepresentativeId($salesRepresentativeId)
            ->setSaleStatus($saleStatus)
            ->setScanned($scanned)
            ->setSeat($seat)
            ->setSeatTypeName($seatTypeName)
            ->setSectorName($sectorName)
            ->setServiceSpecificId($serviceSpecificId)
            ->setTicketNumber($ticketNumber)
            ->setTransactionDate($transactionDate)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber)
            ->setTravelGroupId($travelGroupId)
            ->setUnion($union)
            ->setUserName($userName)
            ->setValidationErrorExists($validationErrorExists);
    }
    /**
     * Get AccessCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCardNumber()
    {
        return isset($this->AccessCardNumber) ? $this->AccessCardNumber : null;
    }
    /**
     * Set AccessCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCardNumber
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setAccessCardNumber($accessCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accessCardNumber) && !is_string($accessCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCardNumber, true), gettype($accessCardNumber)), __LINE__);
        }
        if (is_null($accessCardNumber) || (is_array($accessCardNumber) && empty($accessCardNumber))) {
            unset($this->AccessCardNumber);
        } else {
            $this->AccessCardNumber = $accessCardNumber;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get AttachedToBenefitInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttachedToBenefitInstanceId()
    {
        return isset($this->AttachedToBenefitInstanceId) ? $this->AttachedToBenefitInstanceId : null;
    }
    /**
     * Set AttachedToBenefitInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attachedToBenefitInstanceId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setAttachedToBenefitInstanceId($attachedToBenefitInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($attachedToBenefitInstanceId) && !is_string($attachedToBenefitInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachedToBenefitInstanceId, true), gettype($attachedToBenefitInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attachedToBenefitInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attachedToBenefitInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attachedToBenefitInstanceId, true)), __LINE__);
        }
        if (is_null($attachedToBenefitInstanceId) || (is_array($attachedToBenefitInstanceId) && empty($attachedToBenefitInstanceId))) {
            unset($this->AttachedToBenefitInstanceId);
        } else {
            $this->AttachedToBenefitInstanceId = $attachedToBenefitInstanceId;
        }
        return $this;
    }
    /**
     * Get BackwardTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackwardTransactionId()
    {
        return isset($this->BackwardTransactionId) ? $this->BackwardTransactionId : null;
    }
    /**
     * Set BackwardTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backwardTransactionId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setBackwardTransactionId($backwardTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($backwardTransactionId) && !is_string($backwardTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backwardTransactionId, true), gettype($backwardTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($backwardTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $backwardTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($backwardTransactionId, true)), __LINE__);
        }
        if (is_null($backwardTransactionId) || (is_array($backwardTransactionId) && empty($backwardTransactionId))) {
            unset($this->BackwardTransactionId);
        } else {
            $this->BackwardTransactionId = $backwardTransactionId;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get CanRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanRenew()
    {
        return isset($this->CanRenew) ? $this->CanRenew : null;
    }
    /**
     * Set CanRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canRenew
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setCanRenew($canRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($canRenew) && !is_bool($canRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canRenew, true), gettype($canRenew)), __LINE__);
        }
        if (is_null($canRenew) || (is_array($canRenew) && empty($canRenew))) {
            unset($this->CanRenew);
        } else {
            $this->CanRenew = $canRenew;
        }
        return $this;
    }
    /**
     * Get CollectionMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectionMethod()
    {
        return isset($this->CollectionMethod) ? $this->CollectionMethod : null;
    }
    /**
     * Set CollectionMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectionMethod
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setCollectionMethod($collectionMethod = null)
    {
        // validation for constraint: string
        if (!is_null($collectionMethod) && !is_string($collectionMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectionMethod, true), gettype($collectionMethod)), __LINE__);
        }
        if (is_null($collectionMethod) || (is_array($collectionMethod) && empty($collectionMethod))) {
            unset($this->CollectionMethod);
        } else {
            $this->CollectionMethod = $collectionMethod;
        }
        return $this;
    }
    /**
     * Get CollectionTarget value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectionTarget()
    {
        return isset($this->CollectionTarget) ? $this->CollectionTarget : null;
    }
    /**
     * Set CollectionTarget value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectionTarget
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setCollectionTarget($collectionTarget = null)
    {
        // validation for constraint: string
        if (!is_null($collectionTarget) && !is_string($collectionTarget)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectionTarget, true), gettype($collectionTarget)), __LINE__);
        }
        if (is_null($collectionTarget) || (is_array($collectionTarget) && empty($collectionTarget))) {
            unset($this->CollectionTarget);
        } else {
            $this->CollectionTarget = $collectionTarget;
        }
        return $this;
    }
    /**
     * Get ComplimentaryConfirmByKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComplimentaryConfirmByKey()
    {
        return isset($this->ComplimentaryConfirmByKey) ? $this->ComplimentaryConfirmByKey : null;
    }
    /**
     * Set ComplimentaryConfirmByKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $complimentaryConfirmByKey
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setComplimentaryConfirmByKey($complimentaryConfirmByKey = null)
    {
        // validation for constraint: string
        if (!is_null($complimentaryConfirmByKey) && !is_string($complimentaryConfirmByKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($complimentaryConfirmByKey, true), gettype($complimentaryConfirmByKey)), __LINE__);
        }
        if (is_null($complimentaryConfirmByKey) || (is_array($complimentaryConfirmByKey) && empty($complimentaryConfirmByKey))) {
            unset($this->ComplimentaryConfirmByKey);
        } else {
            $this->ComplimentaryConfirmByKey = $complimentaryConfirmByKey;
        }
        return $this;
    }
    /**
     * Get Context value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContext()
    {
        return isset($this->Context) ? $this->Context : null;
    }
    /**
     * Set Context value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ProductItemInformationContext::valueIsValid()
     * @uses \patest\EnumType\ProductItemInformationContext::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $context
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setContext($context = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ProductItemInformationContext::valueIsValid($context)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ProductItemInformationContext', is_array($context) ? implode(', ', $context) : var_export($context, true), implode(', ', \patest\EnumType\ProductItemInformationContext::getValidValues())), __LINE__);
        }
        if (is_null($context) || (is_array($context) && empty($context))) {
            unset($this->Context);
        } else {
            $this->Context = $context;
        }
        return $this;
    }
    /**
     * Get DepositCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositCategoryId()
    {
        return isset($this->DepositCategoryId) ? $this->DepositCategoryId : null;
    }
    /**
     * Set DepositCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositCategoryId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setDepositCategoryId($depositCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($depositCategoryId) && !is_string($depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositCategoryId, true), gettype($depositCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositCategoryId, true)), __LINE__);
        }
        if (is_null($depositCategoryId) || (is_array($depositCategoryId) && empty($depositCategoryId))) {
            unset($this->DepositCategoryId);
        } else {
            $this->DepositCategoryId = $depositCategoryId;
        }
        return $this;
    }
    /**
     * Get DepositOriginalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDepositOriginalAmount()
    {
        return isset($this->DepositOriginalAmount) ? $this->DepositOriginalAmount : null;
    }
    /**
     * Set DepositOriginalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $depositOriginalAmount
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setDepositOriginalAmount(\patest\StructType\Money $depositOriginalAmount = null)
    {
        if (is_null($depositOriginalAmount) || (is_array($depositOriginalAmount) && empty($depositOriginalAmount))) {
            unset($this->DepositOriginalAmount);
        } else {
            $this->DepositOriginalAmount = $depositOriginalAmount;
        }
        return $this;
    }
    /**
     * Get DepositRemainingAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDepositRemainingAmount()
    {
        return isset($this->DepositRemainingAmount) ? $this->DepositRemainingAmount : null;
    }
    /**
     * Set DepositRemainingAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $depositRemainingAmount
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setDepositRemainingAmount(\patest\StructType\Money $depositRemainingAmount = null)
    {
        if (is_null($depositRemainingAmount) || (is_array($depositRemainingAmount) && empty($depositRemainingAmount))) {
            unset($this->DepositRemainingAmount);
        } else {
            $this->DepositRemainingAmount = $depositRemainingAmount;
        }
        return $this;
    }
    /**
     * Get ExtraData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraData()
    {
        return isset($this->ExtraData) ? $this->ExtraData : null;
    }
    /**
     * Set ExtraData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraData
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setExtraData($extraData = null)
    {
        // validation for constraint: string
        if (!is_null($extraData) && !is_string($extraData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraData, true), gettype($extraData)), __LINE__);
        }
        if (is_null($extraData) || (is_array($extraData) && empty($extraData))) {
            unset($this->ExtraData);
        } else {
            $this->ExtraData = $extraData;
        }
        return $this;
    }
    /**
     * Get FinancialJournalTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinancialJournalTargetId()
    {
        return isset($this->FinancialJournalTargetId) ? $this->FinancialJournalTargetId : null;
    }
    /**
     * Set FinancialJournalTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $financialJournalTargetId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setFinancialJournalTargetId($financialJournalTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($financialJournalTargetId) && !is_string($financialJournalTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($financialJournalTargetId, true), gettype($financialJournalTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($financialJournalTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $financialJournalTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($financialJournalTargetId, true)), __LINE__);
        }
        if (is_null($financialJournalTargetId) || (is_array($financialJournalTargetId) && empty($financialJournalTargetId))) {
            unset($this->FinancialJournalTargetId);
        } else {
            $this->FinancialJournalTargetId = $financialJournalTargetId;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallName
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setHallName($hallName = null)
    {
        // validation for constraint: string
        if (!is_null($hallName) && !is_string($hallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallName, true), gettype($hallName)), __LINE__);
        }
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IdInBackwardTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInBackwardTransaction()
    {
        return isset($this->IdInBackwardTransaction) ? $this->IdInBackwardTransaction : null;
    }
    /**
     * Set IdInBackwardTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInBackwardTransaction
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setIdInBackwardTransaction($idInBackwardTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInBackwardTransaction) && !(is_int($idInBackwardTransaction) || ctype_digit($idInBackwardTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInBackwardTransaction, true), gettype($idInBackwardTransaction)), __LINE__);
        }
        if (is_null($idInBackwardTransaction) || (is_array($idInBackwardTransaction) && empty($idInBackwardTransaction))) {
            unset($this->IdInBackwardTransaction);
        } else {
            $this->IdInBackwardTransaction = $idInBackwardTransaction;
        }
        return $this;
    }
    /**
     * Get InsertionMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsertionMode()
    {
        return isset($this->InsertionMode) ? $this->InsertionMode : null;
    }
    /**
     * Set InsertionMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemInsertionMode::valueIsValid()
     * @uses \patest\EnumType\ItemInsertionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insertionMode
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setInsertionMode($insertionMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemInsertionMode::valueIsValid($insertionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemInsertionMode', is_array($insertionMode) ? implode(', ', $insertionMode) : var_export($insertionMode, true), implode(', ', \patest\EnumType\ItemInsertionMode::getValidValues())), __LINE__);
        }
        if (is_null($insertionMode) || (is_array($insertionMode) && empty($insertionMode))) {
            unset($this->InsertionMode);
        } else {
            $this->InsertionMode = $insertionMode;
        }
        return $this;
    }
    /**
     * Get IsComplimentary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsComplimentary()
    {
        return isset($this->IsComplimentary) ? $this->IsComplimentary : null;
    }
    /**
     * Set IsComplimentary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ComplimentaryStatus::valueIsValid()
     * @uses \patest\EnumType\ComplimentaryStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $isComplimentary
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setIsComplimentary($isComplimentary = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ComplimentaryStatus::valueIsValid($isComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ComplimentaryStatus', is_array($isComplimentary) ? implode(', ', $isComplimentary) : var_export($isComplimentary, true), implode(', ', \patest\EnumType\ComplimentaryStatus::getValidValues())), __LINE__);
        }
        if (is_null($isComplimentary) || (is_array($isComplimentary) && empty($isComplimentary))) {
            unset($this->IsComplimentary);
        } else {
            $this->IsComplimentary = $isComplimentary;
        }
        return $this;
    }
    /**
     * Get IsExtraProduct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExtraProduct()
    {
        return isset($this->IsExtraProduct) ? $this->IsExtraProduct : null;
    }
    /**
     * Set IsExtraProduct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExtraProduct
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setIsExtraProduct($isExtraProduct = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExtraProduct) && !is_bool($isExtraProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExtraProduct, true), gettype($isExtraProduct)), __LINE__);
        }
        if (is_null($isExtraProduct) || (is_array($isExtraProduct) && empty($isExtraProduct))) {
            unset($this->IsExtraProduct);
        } else {
            $this->IsExtraProduct = $isExtraProduct;
        }
        return $this;
    }
    /**
     * Get IsInCustodyChain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInCustodyChain()
    {
        return isset($this->IsInCustodyChain) ? $this->IsInCustodyChain : null;
    }
    /**
     * Set IsInCustodyChain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInCustodyChain
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setIsInCustodyChain($isInCustodyChain = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInCustodyChain) && !is_bool($isInCustodyChain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInCustodyChain, true), gettype($isInCustodyChain)), __LINE__);
        }
        if (is_null($isInCustodyChain) || (is_array($isInCustodyChain) && empty($isInCustodyChain))) {
            unset($this->IsInCustodyChain);
        } else {
            $this->IsInCustodyChain = $isInCustodyChain;
        }
        return $this;
    }
    /**
     * Get IsJointOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsJointOwners()
    {
        return isset($this->IsJointOwners) ? $this->IsJointOwners : null;
    }
    /**
     * Set IsJointOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JointOnwersStatus::valueIsValid()
     * @uses \patest\EnumType\JointOnwersStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $isJointOwners
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setIsJointOwners($isJointOwners = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JointOnwersStatus::valueIsValid($isJointOwners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JointOnwersStatus', is_array($isJointOwners) ? implode(', ', $isJointOwners) : var_export($isJointOwners, true), implode(', ', \patest\EnumType\JointOnwersStatus::getValidValues())), __LINE__);
        }
        if (is_null($isJointOwners) || (is_array($isJointOwners) && empty($isJointOwners))) {
            unset($this->IsJointOwners);
        } else {
            $this->IsJointOwners = $isJointOwners;
        }
        return $this;
    }
    /**
     * Get IsPrinted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrinted()
    {
        return isset($this->IsPrinted) ? $this->IsPrinted : null;
    }
    /**
     * Set IsPrinted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrinted
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setIsPrinted($isPrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinted) && !is_bool($isPrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinted, true), gettype($isPrinted)), __LINE__);
        }
        if (is_null($isPrinted) || (is_array($isPrinted) && empty($isPrinted))) {
            unset($this->IsPrinted);
        } else {
            $this->IsPrinted = $isPrinted;
        }
        return $this;
    }
    /**
     * Get IsSelected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSelected()
    {
        return isset($this->IsSelected) ? $this->IsSelected : null;
    }
    /**
     * Set IsSelected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSelected
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setIsSelected($isSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSelected) && !is_bool($isSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSelected, true), gettype($isSelected)), __LINE__);
        }
        if (is_null($isSelected) || (is_array($isSelected) && empty($isSelected))) {
            unset($this->IsSelected);
        } else {
            $this->IsSelected = $isSelected;
        }
        return $this;
    }
    /**
     * Get ItemDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemDescription()
    {
        return isset($this->ItemDescription) ? $this->ItemDescription : null;
    }
    /**
     * Set ItemDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemDescription
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDescription, true), gettype($itemDescription)), __LINE__);
        }
        if (is_null($itemDescription) || (is_array($itemDescription) && empty($itemDescription))) {
            unset($this->ItemDescription);
        } else {
            $this->ItemDescription = $itemDescription;
        }
        return $this;
    }
    /**
     * Get ItemExtraFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemExtraFields()
    {
        return isset($this->ItemExtraFields) ? $this->ItemExtraFields : null;
    }
    /**
     * Set ItemExtraFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemExtraFields
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setItemExtraFields($itemExtraFields = null)
    {
        // validation for constraint: string
        if (!is_null($itemExtraFields) && !is_string($itemExtraFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemExtraFields, true), gettype($itemExtraFields)), __LINE__);
        }
        if (is_null($itemExtraFields) || (is_array($itemExtraFields) && empty($itemExtraFields))) {
            unset($this->ItemExtraFields);
        } else {
            $this->ItemExtraFields = $itemExtraFields;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemType
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: string
        if (!is_null($itemType) && !is_string($itemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get ItemTypeIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemTypeIdentifier()
    {
        return isset($this->ItemTypeIdentifier) ? $this->ItemTypeIdentifier : null;
    }
    /**
     * Set ItemTypeIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemTypeIdentifier
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setItemTypeIdentifier($itemTypeIdentifier = null)
    {
        // validation for constraint: int
        if (!is_null($itemTypeIdentifier) && !(is_int($itemTypeIdentifier) || ctype_digit($itemTypeIdentifier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemTypeIdentifier, true), gettype($itemTypeIdentifier)), __LINE__);
        }
        if (is_null($itemTypeIdentifier) || (is_array($itemTypeIdentifier) && empty($itemTypeIdentifier))) {
            unset($this->ItemTypeIdentifier);
        } else {
            $this->ItemTypeIdentifier = $itemTypeIdentifier;
        }
        return $this;
    }
    /**
     * Get LinkingProductName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkingProductName()
    {
        return isset($this->LinkingProductName) ? $this->LinkingProductName : null;
    }
    /**
     * Set LinkingProductName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkingProductName
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setLinkingProductName($linkingProductName = null)
    {
        // validation for constraint: string
        if (!is_null($linkingProductName) && !is_string($linkingProductName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkingProductName, true), gettype($linkingProductName)), __LINE__);
        }
        if (is_null($linkingProductName) || (is_array($linkingProductName) && empty($linkingProductName))) {
            unset($this->LinkingProductName);
        } else {
            $this->LinkingProductName = $linkingProductName;
        }
        return $this;
    }
    /**
     * Get MerchAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMerchandise_AttributeTypeValue|null
     */
    public function getMerchAttributes()
    {
        return isset($this->MerchAttributes) ? $this->MerchAttributes : null;
    }
    /**
     * Set MerchAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMerchandise_AttributeTypeValue $merchAttributes
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setMerchAttributes(\patest\StructType\RecordSetOfMerchandise_AttributeTypeValue $merchAttributes = null)
    {
        if (is_null($merchAttributes) || (is_array($merchAttributes) && empty($merchAttributes))) {
            unset($this->MerchAttributes);
        } else {
            $this->MerchAttributes = $merchAttributes;
        }
        return $this;
    }
    /**
     * Get MerchCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchCategoryId()
    {
        return isset($this->MerchCategoryId) ? $this->MerchCategoryId : null;
    }
    /**
     * Set MerchCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchCategoryId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setMerchCategoryId($merchCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($merchCategoryId) && !is_string($merchCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchCategoryId, true), gettype($merchCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchCategoryId, true)), __LINE__);
        }
        if (is_null($merchCategoryId) || (is_array($merchCategoryId) && empty($merchCategoryId))) {
            unset($this->MerchCategoryId);
        } else {
            $this->MerchCategoryId = $merchCategoryId;
        }
        return $this;
    }
    /**
     * Get MerchItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchItemTypeId()
    {
        return isset($this->MerchItemTypeId) ? $this->MerchItemTypeId : null;
    }
    /**
     * Set MerchItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchItemTypeId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setMerchItemTypeId($merchItemTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($merchItemTypeId) && !is_string($merchItemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchItemTypeId, true), gettype($merchItemTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchItemTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchItemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchItemTypeId, true)), __LINE__);
        }
        if (is_null($merchItemTypeId) || (is_array($merchItemTypeId) && empty($merchItemTypeId))) {
            unset($this->MerchItemTypeId);
        } else {
            $this->MerchItemTypeId = $merchItemTypeId;
        }
        return $this;
    }
    /**
     * Get MerchProductName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchProductName()
    {
        return isset($this->MerchProductName) ? $this->MerchProductName : null;
    }
    /**
     * Set MerchProductName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchProductName
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setMerchProductName($merchProductName = null)
    {
        // validation for constraint: string
        if (!is_null($merchProductName) && !is_string($merchProductName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchProductName, true), gettype($merchProductName)), __LINE__);
        }
        if (is_null($merchProductName) || (is_array($merchProductName) && empty($merchProductName))) {
            unset($this->MerchProductName);
        } else {
            $this->MerchProductName = $merchProductName;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get OwnerAge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOwnerAge()
    {
        return isset($this->OwnerAge) ? $this->OwnerAge : null;
    }
    /**
     * Set OwnerAge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ownerAge
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setOwnerAge($ownerAge = null)
    {
        // validation for constraint: int
        if (!is_null($ownerAge) && !(is_int($ownerAge) || ctype_digit($ownerAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ownerAge, true), gettype($ownerAge)), __LINE__);
        }
        if (is_null($ownerAge) || (is_array($ownerAge) && empty($ownerAge))) {
            unset($this->OwnerAge);
        } else {
            $this->OwnerAge = $ownerAge;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get Payer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayer()
    {
        return isset($this->Payer) ? $this->Payer : null;
    }
    /**
     * Set Payer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payer
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setPayer($payer = null)
    {
        // validation for constraint: string
        if (!is_null($payer) && !is_string($payer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payer, true), gettype($payer)), __LINE__);
        }
        if (is_null($payer) || (is_array($payer) && empty($payer))) {
            unset($this->Payer);
        } else {
            $this->Payer = $payer;
        }
        return $this;
    }
    /**
     * Get PayerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerId()
    {
        return isset($this->PayerId) ? $this->PayerId : null;
    }
    /**
     * Set PayerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setPayerId($payerId = null)
    {
        // validation for constraint: string
        if (!is_null($payerId) && !is_string($payerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerId, true), gettype($payerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($payerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $payerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($payerId, true)), __LINE__);
        }
        if (is_null($payerId) || (is_array($payerId) && empty($payerId))) {
            unset($this->PayerId);
        } else {
            $this->PayerId = $payerId;
        }
        return $this;
    }
    /**
     * Get PinnedPromptName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPinnedPromptName()
    {
        return isset($this->PinnedPromptName) ? $this->PinnedPromptName : null;
    }
    /**
     * Set PinnedPromptName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pinnedPromptName
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setPinnedPromptName($pinnedPromptName = null)
    {
        // validation for constraint: string
        if (!is_null($pinnedPromptName) && !is_string($pinnedPromptName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pinnedPromptName, true), gettype($pinnedPromptName)), __LINE__);
        }
        if (is_null($pinnedPromptName) || (is_array($pinnedPromptName) && empty($pinnedPromptName))) {
            unset($this->PinnedPromptName);
        } else {
            $this->PinnedPromptName = $pinnedPromptName;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductId()
    {
        return isset($this->ProductId) ? $this->ProductId : null;
    }
    /**
     * Set ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->ProductId);
        } else {
            $this->ProductId = $productId;
        }
        return $this;
    }
    /**
     * Get RequestedAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestedAction()
    {
        return isset($this->RequestedAction) ? $this->RequestedAction : null;
    }
    /**
     * Set RequestedAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemRequestedAction::valueIsValid()
     * @uses \patest\EnumType\ItemRequestedAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestedAction
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setRequestedAction($requestedAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemRequestedAction::valueIsValid($requestedAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemRequestedAction', is_array($requestedAction) ? implode(', ', $requestedAction) : var_export($requestedAction, true), implode(', ', \patest\EnumType\ItemRequestedAction::getValidValues())), __LINE__);
        }
        if (is_null($requestedAction) || (is_array($requestedAction) && empty($requestedAction))) {
            unset($this->RequestedAction);
        } else {
            $this->RequestedAction = $requestedAction;
        }
        return $this;
    }
    /**
     * Get ReservationExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationExpiryDate()
    {
        return isset($this->ReservationExpiryDate) ? $this->ReservationExpiryDate : null;
    }
    /**
     * Set ReservationExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationExpiryDate
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setReservationExpiryDate($reservationExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($reservationExpiryDate) && !is_string($reservationExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationExpiryDate, true), gettype($reservationExpiryDate)), __LINE__);
        }
        if (is_null($reservationExpiryDate) || (is_array($reservationExpiryDate) && empty($reservationExpiryDate))) {
            unset($this->ReservationExpiryDate);
        } else {
            $this->ReservationExpiryDate = $reservationExpiryDate;
        }
        return $this;
    }
    /**
     * Get Row value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRow()
    {
        return isset($this->Row) ? $this->Row : null;
    }
    /**
     * Set Row value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $row
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setRow($row = null)
    {
        // validation for constraint: string
        if (!is_null($row) && !is_string($row)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($row, true), gettype($row)), __LINE__);
        }
        if (is_null($row) || (is_array($row) && empty($row))) {
            unset($this->Row);
        } else {
            $this->Row = $row;
        }
        return $this;
    }
    /**
     * Get SalesRepDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepDisplayName()
    {
        return isset($this->SalesRepDisplayName) ? $this->SalesRepDisplayName : null;
    }
    /**
     * Set SalesRepDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepDisplayName
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setSalesRepDisplayName($salesRepDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepDisplayName) && !is_string($salesRepDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepDisplayName, true), gettype($salesRepDisplayName)), __LINE__);
        }
        if (is_null($salesRepDisplayName) || (is_array($salesRepDisplayName) && empty($salesRepDisplayName))) {
            unset($this->SalesRepDisplayName);
        } else {
            $this->SalesRepDisplayName = $salesRepDisplayName;
        }
        return $this;
    }
    /**
     * Get SalesRepresentativeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepresentativeId()
    {
        return isset($this->SalesRepresentativeId) ? $this->SalesRepresentativeId : null;
    }
    /**
     * Set SalesRepresentativeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepresentativeId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setSalesRepresentativeId($salesRepresentativeId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepresentativeId) && !is_string($salesRepresentativeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepresentativeId, true), gettype($salesRepresentativeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepresentativeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepresentativeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepresentativeId, true)), __LINE__);
        }
        if (is_null($salesRepresentativeId) || (is_array($salesRepresentativeId) && empty($salesRepresentativeId))) {
            unset($this->SalesRepresentativeId);
        } else {
            $this->SalesRepresentativeId = $salesRepresentativeId;
        }
        return $this;
    }
    /**
     * Get SaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleStatus()
    {
        return isset($this->SaleStatus) ? $this->SaleStatus : null;
    }
    /**
     * Set SaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ProductItemSalesStatus::valueIsValid()
     * @uses \patest\EnumType\ProductItemSalesStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $saleStatus
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setSaleStatus($saleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ProductItemSalesStatus::valueIsValid($saleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ProductItemSalesStatus', is_array($saleStatus) ? implode(', ', $saleStatus) : var_export($saleStatus, true), implode(', ', \patest\EnumType\ProductItemSalesStatus::getValidValues())), __LINE__);
        }
        if (is_null($saleStatus) || (is_array($saleStatus) && empty($saleStatus))) {
            unset($this->SaleStatus);
        } else {
            $this->SaleStatus = $saleStatus;
        }
        return $this;
    }
    /**
     * Get Scanned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScanned()
    {
        return isset($this->Scanned) ? $this->Scanned : null;
    }
    /**
     * Set Scanned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scanned
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setScanned($scanned = null)
    {
        // validation for constraint: string
        if (!is_null($scanned) && !is_string($scanned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanned, true), gettype($scanned)), __LINE__);
        }
        if (is_null($scanned) || (is_array($scanned) && empty($scanned))) {
            unset($this->Scanned);
        } else {
            $this->Scanned = $scanned;
        }
        return $this;
    }
    /**
     * Get Seat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * Set Seat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seat
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
    /**
     * Get SeatTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeName()
    {
        return isset($this->SeatTypeName) ? $this->SeatTypeName : null;
    }
    /**
     * Set SeatTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeName
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setSeatTypeName($seatTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeName) && !is_string($seatTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeName, true), gettype($seatTypeName)), __LINE__);
        }
        if (is_null($seatTypeName) || (is_array($seatTypeName) && empty($seatTypeName))) {
            unset($this->SeatTypeName);
        } else {
            $this->SeatTypeName = $seatTypeName;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorName
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setSectorName($sectorName = null)
    {
        // validation for constraint: string
        if (!is_null($sectorName) && !is_string($sectorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorName, true), gettype($sectorName)), __LINE__);
        }
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceSpecificId()
    {
        return isset($this->ServiceSpecificId) ? $this->ServiceSpecificId : null;
    }
    /**
     * Set ServiceSpecificId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceSpecificId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setServiceSpecificId($serviceSpecificId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceSpecificId) && !is_string($serviceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceSpecificId, true), gettype($serviceSpecificId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($serviceSpecificId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $serviceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($serviceSpecificId, true)), __LINE__);
        }
        if (is_null($serviceSpecificId) || (is_array($serviceSpecificId) && empty($serviceSpecificId))) {
            unset($this->ServiceSpecificId);
        } else {
            $this->ServiceSpecificId = $serviceSpecificId;
        }
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketNumber
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TravelGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTravelGroupId()
    {
        return isset($this->TravelGroupId) ? $this->TravelGroupId : null;
    }
    /**
     * Set TravelGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $travelGroupId
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setTravelGroupId($travelGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($travelGroupId) && !(is_int($travelGroupId) || ctype_digit($travelGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelGroupId, true), gettype($travelGroupId)), __LINE__);
        }
        if (is_null($travelGroupId) || (is_array($travelGroupId) && empty($travelGroupId))) {
            unset($this->TravelGroupId);
        } else {
            $this->TravelGroupId = $travelGroupId;
        }
        return $this;
    }
    /**
     * Get Union value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnion()
    {
        return isset($this->Union) ? $this->Union : null;
    }
    /**
     * Set Union value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $union
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setUnion($union = null)
    {
        // validation for constraint: string
        if (!is_null($union) && !is_string($union)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($union, true), gettype($union)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($union) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $union)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($union, true)), __LINE__);
        }
        if (is_null($union) || (is_array($union) && empty($union))) {
            unset($this->Union);
        } else {
            $this->Union = $union;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get ValidationErrorExists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getValidationErrorExists()
    {
        return isset($this->ValidationErrorExists) ? $this->ValidationErrorExists : null;
    }
    /**
     * Set ValidationErrorExists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $validationErrorExists
     * @return \patest\StructType\Sales_ItemInformation
     */
    public function setValidationErrorExists($validationErrorExists = null)
    {
        // validation for constraint: boolean
        if (!is_null($validationErrorExists) && !is_bool($validationErrorExists)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validationErrorExists, true), gettype($validationErrorExists)), __LINE__);
        }
        if (is_null($validationErrorExists) || (is_array($validationErrorExists) && empty($validationErrorExists))) {
            unset($this->ValidationErrorExists);
        } else {
            $this->ValidationErrorExists = $validationErrorExists;
        }
        return $this;
    }
}
