<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.InvoiceItemsGroupRecord StructType
 * @subpackage Structs
 */
class Sales_InvoiceItemsGroupRecord extends PersistableEntity
{
    /**
     * The AmountPerItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $AmountPerItem;
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Area;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The Hall
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Hall;
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvoiceId;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_InvoiceItemRecord
     */
    public $Items;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The PriceTypeDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeDetails;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Product;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The Seats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seats;
    /**
     * The Sector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sector;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmount;
    /**
     * The TotalAmountNeto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmountNeto;
    /**
     * The TotalInsideCommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalInsideCommissionAmount;
    /**
     * The TotalInsuranceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalInsuranceAmount;
    /**
     * The TotalVatAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalVatAmount;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Sales.InvoiceItemsGroupRecord
     * @uses Sales_InvoiceItemsGroupRecord::setAmountPerItem()
     * @uses Sales_InvoiceItemsGroupRecord::setArea()
     * @uses Sales_InvoiceItemsGroupRecord::setDetails()
     * @uses Sales_InvoiceItemsGroupRecord::setHall()
     * @uses Sales_InvoiceItemsGroupRecord::setInvoiceId()
     * @uses Sales_InvoiceItemsGroupRecord::setItems()
     * @uses Sales_InvoiceItemsGroupRecord::setItemType()
     * @uses Sales_InvoiceItemsGroupRecord::setPriceTypeDetails()
     * @uses Sales_InvoiceItemsGroupRecord::setProduct()
     * @uses Sales_InvoiceItemsGroupRecord::setQuantity()
     * @uses Sales_InvoiceItemsGroupRecord::setRowName()
     * @uses Sales_InvoiceItemsGroupRecord::setSeats()
     * @uses Sales_InvoiceItemsGroupRecord::setSector()
     * @uses Sales_InvoiceItemsGroupRecord::setTotalAmount()
     * @uses Sales_InvoiceItemsGroupRecord::setTotalAmountNeto()
     * @uses Sales_InvoiceItemsGroupRecord::setTotalInsideCommissionAmount()
     * @uses Sales_InvoiceItemsGroupRecord::setTotalInsuranceAmount()
     * @uses Sales_InvoiceItemsGroupRecord::setTotalVatAmount()
     * @uses Sales_InvoiceItemsGroupRecord::setTransactionId()
     * @uses Sales_InvoiceItemsGroupRecord::setTransactionNumber()
     * @param \patest\StructType\Money $amountPerItem
     * @param string $area
     * @param string $details
     * @param string $hall
     * @param string $invoiceId
     * @param \patest\StructType\RecordSetOfSales_InvoiceItemRecord $items
     * @param int $itemType
     * @param string $priceTypeDetails
     * @param string $product
     * @param int $quantity
     * @param string $rowName
     * @param string $seats
     * @param string $sector
     * @param \patest\StructType\Money $totalAmount
     * @param \patest\StructType\Money $totalAmountNeto
     * @param \patest\StructType\Money $totalInsideCommissionAmount
     * @param \patest\StructType\Money $totalInsuranceAmount
     * @param \patest\StructType\Money $totalVatAmount
     * @param string $transactionId
     * @param int $transactionNumber
     */
    public function __construct(\patest\StructType\Money $amountPerItem = null, $area = null, $details = null, $hall = null, $invoiceId = null, \patest\StructType\RecordSetOfSales_InvoiceItemRecord $items = null, $itemType = null, $priceTypeDetails = null, $product = null, $quantity = null, $rowName = null, $seats = null, $sector = null, \patest\StructType\Money $totalAmount = null, \patest\StructType\Money $totalAmountNeto = null, \patest\StructType\Money $totalInsideCommissionAmount = null, \patest\StructType\Money $totalInsuranceAmount = null, \patest\StructType\Money $totalVatAmount = null, $transactionId = null, $transactionNumber = null)
    {
        $this
            ->setAmountPerItem($amountPerItem)
            ->setArea($area)
            ->setDetails($details)
            ->setHall($hall)
            ->setInvoiceId($invoiceId)
            ->setItems($items)
            ->setItemType($itemType)
            ->setPriceTypeDetails($priceTypeDetails)
            ->setProduct($product)
            ->setQuantity($quantity)
            ->setRowName($rowName)
            ->setSeats($seats)
            ->setSector($sector)
            ->setTotalAmount($totalAmount)
            ->setTotalAmountNeto($totalAmountNeto)
            ->setTotalInsideCommissionAmount($totalInsideCommissionAmount)
            ->setTotalInsuranceAmount($totalInsuranceAmount)
            ->setTotalVatAmount($totalVatAmount)
            ->setTransactionId($transactionId)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get AmountPerItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmountPerItem()
    {
        return isset($this->AmountPerItem) ? $this->AmountPerItem : null;
    }
    /**
     * Set AmountPerItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amountPerItem
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setAmountPerItem(\patest\StructType\Money $amountPerItem = null)
    {
        if (is_null($amountPerItem) || (is_array($amountPerItem) && empty($amountPerItem))) {
            unset($this->AmountPerItem);
        } else {
            $this->AmountPerItem = $amountPerItem;
        }
        return $this;
    }
    /**
     * Get Area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArea()
    {
        return isset($this->Area) ? $this->Area : null;
    }
    /**
     * Set Area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $area
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setArea($area = null)
    {
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($area, true), gettype($area)), __LINE__);
        }
        if (is_null($area) || (is_array($area) && empty($area))) {
            unset($this->Area);
        } else {
            $this->Area = $area;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $details
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get Hall value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHall()
    {
        return isset($this->Hall) ? $this->Hall : null;
    }
    /**
     * Set Hall value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hall
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setHall($hall = null)
    {
        // validation for constraint: string
        if (!is_null($hall) && !is_string($hall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hall, true), gettype($hall)), __LINE__);
        }
        if (is_null($hall) || (is_array($hall) && empty($hall))) {
            unset($this->Hall);
        } else {
            $this->Hall = $hall;
        }
        return $this;
    }
    /**
     * Get InvoiceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceId()
    {
        return isset($this->InvoiceId) ? $this->InvoiceId : null;
    }
    /**
     * Set InvoiceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceId
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invoiceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invoiceId, true)), __LINE__);
        }
        if (is_null($invoiceId) || (is_array($invoiceId) && empty($invoiceId))) {
            unset($this->InvoiceId);
        } else {
            $this->InvoiceId = $invoiceId;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_InvoiceItemRecord|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_InvoiceItemRecord $items
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setItems(\patest\StructType\RecordSetOfSales_InvoiceItemRecord $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get PriceTypeDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeDetails()
    {
        return isset($this->PriceTypeDetails) ? $this->PriceTypeDetails : null;
    }
    /**
     * Set PriceTypeDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeDetails
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setPriceTypeDetails($priceTypeDetails = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeDetails) && !is_string($priceTypeDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeDetails, true), gettype($priceTypeDetails)), __LINE__);
        }
        if (is_null($priceTypeDetails) || (is_array($priceTypeDetails) && empty($priceTypeDetails))) {
            unset($this->PriceTypeDetails);
        } else {
            $this->PriceTypeDetails = $priceTypeDetails;
        }
        return $this;
    }
    /**
     * Get Product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProduct()
    {
        return isset($this->Product) ? $this->Product : null;
    }
    /**
     * Set Product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $product
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        if (is_null($product) || (is_array($product) && empty($product))) {
            unset($this->Product);
        } else {
            $this->Product = $product;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get Seats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeats()
    {
        return isset($this->Seats) ? $this->Seats : null;
    }
    /**
     * Set Seats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seats
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setSeats($seats = null)
    {
        // validation for constraint: string
        if (!is_null($seats) && !is_string($seats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seats, true), gettype($seats)), __LINE__);
        }
        if (is_null($seats) || (is_array($seats) && empty($seats))) {
            unset($this->Seats);
        } else {
            $this->Seats = $seats;
        }
        return $this;
    }
    /**
     * Get Sector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSector()
    {
        return isset($this->Sector) ? $this->Sector : null;
    }
    /**
     * Set Sector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sector
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setSector($sector = null)
    {
        // validation for constraint: string
        if (!is_null($sector) && !is_string($sector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sector, true), gettype($sector)), __LINE__);
        }
        if (is_null($sector) || (is_array($sector) && empty($sector))) {
            unset($this->Sector);
        } else {
            $this->Sector = $sector;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmount
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setTotalAmount(\patest\StructType\Money $totalAmount = null)
    {
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get TotalAmountNeto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmountNeto()
    {
        return isset($this->TotalAmountNeto) ? $this->TotalAmountNeto : null;
    }
    /**
     * Set TotalAmountNeto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmountNeto
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setTotalAmountNeto(\patest\StructType\Money $totalAmountNeto = null)
    {
        if (is_null($totalAmountNeto) || (is_array($totalAmountNeto) && empty($totalAmountNeto))) {
            unset($this->TotalAmountNeto);
        } else {
            $this->TotalAmountNeto = $totalAmountNeto;
        }
        return $this;
    }
    /**
     * Get TotalInsideCommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalInsideCommissionAmount()
    {
        return isset($this->TotalInsideCommissionAmount) ? $this->TotalInsideCommissionAmount : null;
    }
    /**
     * Set TotalInsideCommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalInsideCommissionAmount
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setTotalInsideCommissionAmount(\patest\StructType\Money $totalInsideCommissionAmount = null)
    {
        if (is_null($totalInsideCommissionAmount) || (is_array($totalInsideCommissionAmount) && empty($totalInsideCommissionAmount))) {
            unset($this->TotalInsideCommissionAmount);
        } else {
            $this->TotalInsideCommissionAmount = $totalInsideCommissionAmount;
        }
        return $this;
    }
    /**
     * Get TotalInsuranceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalInsuranceAmount()
    {
        return isset($this->TotalInsuranceAmount) ? $this->TotalInsuranceAmount : null;
    }
    /**
     * Set TotalInsuranceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalInsuranceAmount
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setTotalInsuranceAmount(\patest\StructType\Money $totalInsuranceAmount = null)
    {
        if (is_null($totalInsuranceAmount) || (is_array($totalInsuranceAmount) && empty($totalInsuranceAmount))) {
            unset($this->TotalInsuranceAmount);
        } else {
            $this->TotalInsuranceAmount = $totalInsuranceAmount;
        }
        return $this;
    }
    /**
     * Get TotalVatAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalVatAmount()
    {
        return isset($this->TotalVatAmount) ? $this->TotalVatAmount : null;
    }
    /**
     * Set TotalVatAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalVatAmount
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setTotalVatAmount(\patest\StructType\Money $totalVatAmount = null)
    {
        if (is_null($totalVatAmount) || (is_array($totalVatAmount) && empty($totalVatAmount))) {
            unset($this->TotalVatAmount);
        } else {
            $this->TotalVatAmount = $totalVatAmount;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Sales_InvoiceItemsGroupRecord
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
