<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.FinancialJournalTargetIdentityEntity StructType
 * @subpackage Structs
 */
class Sales_FinancialJournalTargetIdentityEntity extends AnyEntity
{
    /**
     * The SubTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubTargetId;
    /**
     * The TargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetId;
    /**
     * The TargetKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetKind;
    /**
     * Constructor method for Sales.FinancialJournalTargetIdentityEntity
     * @uses Sales_FinancialJournalTargetIdentityEntity::setSubTargetId()
     * @uses Sales_FinancialJournalTargetIdentityEntity::setTargetId()
     * @uses Sales_FinancialJournalTargetIdentityEntity::setTargetKind()
     * @param string $subTargetId
     * @param string $targetId
     * @param string $targetKind
     */
    public function __construct($subTargetId = null, $targetId = null, $targetKind = null)
    {
        $this
            ->setSubTargetId($subTargetId)
            ->setTargetId($targetId)
            ->setTargetKind($targetKind);
    }
    /**
     * Get SubTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubTargetId()
    {
        return isset($this->SubTargetId) ? $this->SubTargetId : null;
    }
    /**
     * Set SubTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subTargetId
     * @return \patest\StructType\Sales_FinancialJournalTargetIdentityEntity
     */
    public function setSubTargetId($subTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($subTargetId) && !is_string($subTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subTargetId, true), gettype($subTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subTargetId, true)), __LINE__);
        }
        if (is_null($subTargetId) || (is_array($subTargetId) && empty($subTargetId))) {
            unset($this->SubTargetId);
        } else {
            $this->SubTargetId = $subTargetId;
        }
        return $this;
    }
    /**
     * Get TargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetId()
    {
        return isset($this->TargetId) ? $this->TargetId : null;
    }
    /**
     * Set TargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetId
     * @return \patest\StructType\Sales_FinancialJournalTargetIdentityEntity
     */
    public function setTargetId($targetId = null)
    {
        // validation for constraint: string
        if (!is_null($targetId) && !is_string($targetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetId, true), gettype($targetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetId, true)), __LINE__);
        }
        if (is_null($targetId) || (is_array($targetId) && empty($targetId))) {
            unset($this->TargetId);
        } else {
            $this->TargetId = $targetId;
        }
        return $this;
    }
    /**
     * Get TargetKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetKind()
    {
        return isset($this->TargetKind) ? $this->TargetKind : null;
    }
    /**
     * Set TargetKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialJournalTargetKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalTargetKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $targetKind
     * @return \patest\StructType\Sales_FinancialJournalTargetIdentityEntity
     */
    public function setTargetKind($targetKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalTargetKind::valueIsValid($targetKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalTargetKind', is_array($targetKind) ? implode(', ', $targetKind) : var_export($targetKind, true), implode(', ', \patest\EnumType\FinancialJournalTargetKind::getValidValues())), __LINE__);
        }
        if (is_null($targetKind) || (is_array($targetKind) && empty($targetKind))) {
            unset($this->TargetKind);
        } else {
            $this->TargetKind = $targetKind;
        }
        return $this;
    }
}
