<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ExtraProductElement StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Sales.ExtraProductElement
 * @subpackage Structs
 */
class Sales_ExtraProductElement extends PersistableEntity
{
    /**
     * The ElementTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ElementTypeName;
    /**
     * The ExtraDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraDetails;
    /**
     * The FixedQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FixedQuantity;
    /**
     * The MatchLinkedElementPriceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MatchLinkedElementPriceType;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PromptDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PromptDefinitionId;
    /**
     * The QuantityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QuantityType;
    /**
     * The RatioElementQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RatioElementQuantity;
    /**
     * The RatioExtrasQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RatioExtrasQuantity;
    /**
     * The RelatedItemTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RelatedItemTypeId;
    /**
     * The SmallerQuantityIsAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SmallerQuantityIsAllowed;
    /**
     * The ZeroQuantityIsAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ZeroQuantityIsAllowed;
    /**
     * Constructor method for Sales.ExtraProductElement
     * @uses Sales_ExtraProductElement::setElementTypeName()
     * @uses Sales_ExtraProductElement::setExtraDetails()
     * @uses Sales_ExtraProductElement::setFixedQuantity()
     * @uses Sales_ExtraProductElement::setMatchLinkedElementPriceType()
     * @uses Sales_ExtraProductElement::setName()
     * @uses Sales_ExtraProductElement::setPriceTypeId()
     * @uses Sales_ExtraProductElement::setPromptDefinitionId()
     * @uses Sales_ExtraProductElement::setQuantityType()
     * @uses Sales_ExtraProductElement::setRatioElementQuantity()
     * @uses Sales_ExtraProductElement::setRatioExtrasQuantity()
     * @uses Sales_ExtraProductElement::setRelatedItemTypeId()
     * @uses Sales_ExtraProductElement::setSmallerQuantityIsAllowed()
     * @uses Sales_ExtraProductElement::setZeroQuantityIsAllowed()
     * @param string $elementTypeName
     * @param string $extraDetails
     * @param int $fixedQuantity
     * @param bool $matchLinkedElementPriceType
     * @param \patest\StructType\GlobalString $name
     * @param string $priceTypeId
     * @param string $promptDefinitionId
     * @param string $quantityType
     * @param int $ratioElementQuantity
     * @param int $ratioExtrasQuantity
     * @param int $relatedItemTypeId
     * @param bool $smallerQuantityIsAllowed
     * @param bool $zeroQuantityIsAllowed
     */
    public function __construct($elementTypeName = null, $extraDetails = null, $fixedQuantity = null, $matchLinkedElementPriceType = null, \patest\StructType\GlobalString $name = null, $priceTypeId = null, $promptDefinitionId = null, $quantityType = null, $ratioElementQuantity = null, $ratioExtrasQuantity = null, $relatedItemTypeId = null, $smallerQuantityIsAllowed = null, $zeroQuantityIsAllowed = null)
    {
        $this
            ->setElementTypeName($elementTypeName)
            ->setExtraDetails($extraDetails)
            ->setFixedQuantity($fixedQuantity)
            ->setMatchLinkedElementPriceType($matchLinkedElementPriceType)
            ->setName($name)
            ->setPriceTypeId($priceTypeId)
            ->setPromptDefinitionId($promptDefinitionId)
            ->setQuantityType($quantityType)
            ->setRatioElementQuantity($ratioElementQuantity)
            ->setRatioExtrasQuantity($ratioExtrasQuantity)
            ->setRelatedItemTypeId($relatedItemTypeId)
            ->setSmallerQuantityIsAllowed($smallerQuantityIsAllowed)
            ->setZeroQuantityIsAllowed($zeroQuantityIsAllowed);
    }
    /**
     * Get ElementTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getElementTypeName()
    {
        return isset($this->ElementTypeName) ? $this->ElementTypeName : null;
    }
    /**
     * Set ElementTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $elementTypeName
     * @return \patest\StructType\Sales_ExtraProductElement
     */
    public function setElementTypeName($elementTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($elementTypeName) && !is_string($elementTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($elementTypeName, true), gettype($elementTypeName)), __LINE__);
        }
        if (is_null($elementTypeName) || (is_array($elementTypeName) && empty($elementTypeName))) {
            unset($this->ElementTypeName);
        } else {
            $this->ElementTypeName = $elementTypeName;
        }
        return $this;
    }
    /**
     * Get ExtraDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraDetails()
    {
        return isset($this->ExtraDetails) ? $this->ExtraDetails : null;
    }
    /**
     * Set ExtraDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraDetails
     * @return \patest\StructType\Sales_ExtraProductElement
     */
    public function setExtraDetails($extraDetails = null)
    {
        // validation for constraint: string
        if (!is_null($extraDetails) && !is_string($extraDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraDetails, true), gettype($extraDetails)), __LINE__);
        }
        if (is_null($extraDetails) || (is_array($extraDetails) && empty($extraDetails))) {
            unset($this->ExtraDetails);
        } else {
            $this->ExtraDetails = $extraDetails;
        }
        return $this;
    }
    /**
     * Get FixedQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFixedQuantity()
    {
        return isset($this->FixedQuantity) ? $this->FixedQuantity : null;
    }
    /**
     * Set FixedQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fixedQuantity
     * @return \patest\StructType\Sales_ExtraProductElement
     */
    public function setFixedQuantity($fixedQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($fixedQuantity) && !(is_int($fixedQuantity) || ctype_digit($fixedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fixedQuantity, true), gettype($fixedQuantity)), __LINE__);
        }
        if (is_null($fixedQuantity) || (is_array($fixedQuantity) && empty($fixedQuantity))) {
            unset($this->FixedQuantity);
        } else {
            $this->FixedQuantity = $fixedQuantity;
        }
        return $this;
    }
    /**
     * Get MatchLinkedElementPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMatchLinkedElementPriceType()
    {
        return isset($this->MatchLinkedElementPriceType) ? $this->MatchLinkedElementPriceType : null;
    }
    /**
     * Set MatchLinkedElementPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $matchLinkedElementPriceType
     * @return \patest\StructType\Sales_ExtraProductElement
     */
    public function setMatchLinkedElementPriceType($matchLinkedElementPriceType = null)
    {
        // validation for constraint: boolean
        if (!is_null($matchLinkedElementPriceType) && !is_bool($matchLinkedElementPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($matchLinkedElementPriceType, true), gettype($matchLinkedElementPriceType)), __LINE__);
        }
        if (is_null($matchLinkedElementPriceType) || (is_array($matchLinkedElementPriceType) && empty($matchLinkedElementPriceType))) {
            unset($this->MatchLinkedElementPriceType);
        } else {
            $this->MatchLinkedElementPriceType = $matchLinkedElementPriceType;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Sales_ExtraProductElement
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Sales_ExtraProductElement
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PromptDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromptDefinitionId()
    {
        return isset($this->PromptDefinitionId) ? $this->PromptDefinitionId : null;
    }
    /**
     * Set PromptDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promptDefinitionId
     * @return \patest\StructType\Sales_ExtraProductElement
     */
    public function setPromptDefinitionId($promptDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($promptDefinitionId) && !is_string($promptDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promptDefinitionId, true), gettype($promptDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($promptDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $promptDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($promptDefinitionId, true)), __LINE__);
        }
        if (is_null($promptDefinitionId) || (is_array($promptDefinitionId) && empty($promptDefinitionId))) {
            unset($this->PromptDefinitionId);
        } else {
            $this->PromptDefinitionId = $promptDefinitionId;
        }
        return $this;
    }
    /**
     * Get QuantityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQuantityType()
    {
        return isset($this->QuantityType) ? $this->QuantityType : null;
    }
    /**
     * Set QuantityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OfferedQuantityType::valueIsValid()
     * @uses \patest\EnumType\OfferedQuantityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quantityType
     * @return \patest\StructType\Sales_ExtraProductElement
     */
    public function setQuantityType($quantityType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OfferedQuantityType::valueIsValid($quantityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OfferedQuantityType', is_array($quantityType) ? implode(', ', $quantityType) : var_export($quantityType, true), implode(', ', \patest\EnumType\OfferedQuantityType::getValidValues())), __LINE__);
        }
        if (is_null($quantityType) || (is_array($quantityType) && empty($quantityType))) {
            unset($this->QuantityType);
        } else {
            $this->QuantityType = $quantityType;
        }
        return $this;
    }
    /**
     * Get RatioElementQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRatioElementQuantity()
    {
        return isset($this->RatioElementQuantity) ? $this->RatioElementQuantity : null;
    }
    /**
     * Set RatioElementQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ratioElementQuantity
     * @return \patest\StructType\Sales_ExtraProductElement
     */
    public function setRatioElementQuantity($ratioElementQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($ratioElementQuantity) && !(is_int($ratioElementQuantity) || ctype_digit($ratioElementQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ratioElementQuantity, true), gettype($ratioElementQuantity)), __LINE__);
        }
        if (is_null($ratioElementQuantity) || (is_array($ratioElementQuantity) && empty($ratioElementQuantity))) {
            unset($this->RatioElementQuantity);
        } else {
            $this->RatioElementQuantity = $ratioElementQuantity;
        }
        return $this;
    }
    /**
     * Get RatioExtrasQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRatioExtrasQuantity()
    {
        return isset($this->RatioExtrasQuantity) ? $this->RatioExtrasQuantity : null;
    }
    /**
     * Set RatioExtrasQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ratioExtrasQuantity
     * @return \patest\StructType\Sales_ExtraProductElement
     */
    public function setRatioExtrasQuantity($ratioExtrasQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($ratioExtrasQuantity) && !(is_int($ratioExtrasQuantity) || ctype_digit($ratioExtrasQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ratioExtrasQuantity, true), gettype($ratioExtrasQuantity)), __LINE__);
        }
        if (is_null($ratioExtrasQuantity) || (is_array($ratioExtrasQuantity) && empty($ratioExtrasQuantity))) {
            unset($this->RatioExtrasQuantity);
        } else {
            $this->RatioExtrasQuantity = $ratioExtrasQuantity;
        }
        return $this;
    }
    /**
     * Get RelatedItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatedItemTypeId()
    {
        return isset($this->RelatedItemTypeId) ? $this->RelatedItemTypeId : null;
    }
    /**
     * Set RelatedItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatedItemTypeId
     * @return \patest\StructType\Sales_ExtraProductElement
     */
    public function setRelatedItemTypeId($relatedItemTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($relatedItemTypeId) && !(is_int($relatedItemTypeId) || ctype_digit($relatedItemTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatedItemTypeId, true), gettype($relatedItemTypeId)), __LINE__);
        }
        if (is_null($relatedItemTypeId) || (is_array($relatedItemTypeId) && empty($relatedItemTypeId))) {
            unset($this->RelatedItemTypeId);
        } else {
            $this->RelatedItemTypeId = $relatedItemTypeId;
        }
        return $this;
    }
    /**
     * Get SmallerQuantityIsAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSmallerQuantityIsAllowed()
    {
        return isset($this->SmallerQuantityIsAllowed) ? $this->SmallerQuantityIsAllowed : null;
    }
    /**
     * Set SmallerQuantityIsAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $smallerQuantityIsAllowed
     * @return \patest\StructType\Sales_ExtraProductElement
     */
    public function setSmallerQuantityIsAllowed($smallerQuantityIsAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($smallerQuantityIsAllowed) && !is_bool($smallerQuantityIsAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smallerQuantityIsAllowed, true), gettype($smallerQuantityIsAllowed)), __LINE__);
        }
        if (is_null($smallerQuantityIsAllowed) || (is_array($smallerQuantityIsAllowed) && empty($smallerQuantityIsAllowed))) {
            unset($this->SmallerQuantityIsAllowed);
        } else {
            $this->SmallerQuantityIsAllowed = $smallerQuantityIsAllowed;
        }
        return $this;
    }
    /**
     * Get ZeroQuantityIsAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getZeroQuantityIsAllowed()
    {
        return isset($this->ZeroQuantityIsAllowed) ? $this->ZeroQuantityIsAllowed : null;
    }
    /**
     * Set ZeroQuantityIsAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $zeroQuantityIsAllowed
     * @return \patest\StructType\Sales_ExtraProductElement
     */
    public function setZeroQuantityIsAllowed($zeroQuantityIsAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($zeroQuantityIsAllowed) && !is_bool($zeroQuantityIsAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($zeroQuantityIsAllowed, true), gettype($zeroQuantityIsAllowed)), __LINE__);
        }
        if (is_null($zeroQuantityIsAllowed) || (is_array($zeroQuantityIsAllowed) && empty($zeroQuantityIsAllowed))) {
            unset($this->ZeroQuantityIsAllowed);
        } else {
            $this->ZeroQuantityIsAllowed = $zeroQuantityIsAllowed;
        }
        return $this;
    }
}
