<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ExpandedSettlementDeductionItem StructType
 * @subpackage Structs
 */
class Sales_ExpandedSettlementDeductionItem extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The DeliveryNoteNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DeliveryNoteNumber;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The InsideCommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $InsideCommissionAmount;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InvoiceNumber;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemId;
    /**
     * The ItemNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemNumber;
    /**
     * The OriginalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $OriginalAmount;
    /**
     * The RemainingAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RemainingAmount;
    /**
     * Constructor method for Sales.ExpandedSettlementDeductionItem
     * @uses Sales_ExpandedSettlementDeductionItem::setClientId()
     * @uses Sales_ExpandedSettlementDeductionItem::setCreationDate()
     * @uses Sales_ExpandedSettlementDeductionItem::setDeliveryNoteNumber()
     * @uses Sales_ExpandedSettlementDeductionItem::setEventDate()
     * @uses Sales_ExpandedSettlementDeductionItem::setEventId()
     * @uses Sales_ExpandedSettlementDeductionItem::setHolderCompanyId()
     * @uses Sales_ExpandedSettlementDeductionItem::setInsideCommissionAmount()
     * @uses Sales_ExpandedSettlementDeductionItem::setInvoiceNumber()
     * @uses Sales_ExpandedSettlementDeductionItem::setItemId()
     * @uses Sales_ExpandedSettlementDeductionItem::setItemNumber()
     * @uses Sales_ExpandedSettlementDeductionItem::setOriginalAmount()
     * @uses Sales_ExpandedSettlementDeductionItem::setRemainingAmount()
     * @param string $clientId
     * @param string $creationDate
     * @param int $deliveryNoteNumber
     * @param string $eventDate
     * @param string $eventId
     * @param int $holderCompanyId
     * @param \patest\StructType\Money $insideCommissionAmount
     * @param int $invoiceNumber
     * @param string $itemId
     * @param int $itemNumber
     * @param \patest\StructType\Money $originalAmount
     * @param \patest\StructType\Money $remainingAmount
     */
    public function __construct($clientId = null, $creationDate = null, $deliveryNoteNumber = null, $eventDate = null, $eventId = null, $holderCompanyId = null, \patest\StructType\Money $insideCommissionAmount = null, $invoiceNumber = null, $itemId = null, $itemNumber = null, \patest\StructType\Money $originalAmount = null, \patest\StructType\Money $remainingAmount = null)
    {
        $this
            ->setClientId($clientId)
            ->setCreationDate($creationDate)
            ->setDeliveryNoteNumber($deliveryNoteNumber)
            ->setEventDate($eventDate)
            ->setEventId($eventId)
            ->setHolderCompanyId($holderCompanyId)
            ->setInsideCommissionAmount($insideCommissionAmount)
            ->setInvoiceNumber($invoiceNumber)
            ->setItemId($itemId)
            ->setItemNumber($itemNumber)
            ->setOriginalAmount($originalAmount)
            ->setRemainingAmount($remainingAmount);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_ExpandedSettlementDeductionItem
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Sales_ExpandedSettlementDeductionItem
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get DeliveryNoteNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeliveryNoteNumber()
    {
        return isset($this->DeliveryNoteNumber) ? $this->DeliveryNoteNumber : null;
    }
    /**
     * Set DeliveryNoteNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deliveryNoteNumber
     * @return \patest\StructType\Sales_ExpandedSettlementDeductionItem
     */
    public function setDeliveryNoteNumber($deliveryNoteNumber = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryNoteNumber) && !(is_int($deliveryNoteNumber) || ctype_digit($deliveryNoteNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryNoteNumber, true), gettype($deliveryNoteNumber)), __LINE__);
        }
        if (is_null($deliveryNoteNumber) || (is_array($deliveryNoteNumber) && empty($deliveryNoteNumber))) {
            unset($this->DeliveryNoteNumber);
        } else {
            $this->DeliveryNoteNumber = $deliveryNoteNumber;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Sales_ExpandedSettlementDeductionItem
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Sales_ExpandedSettlementDeductionItem
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Sales_ExpandedSettlementDeductionItem
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get InsideCommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getInsideCommissionAmount()
    {
        return isset($this->InsideCommissionAmount) ? $this->InsideCommissionAmount : null;
    }
    /**
     * Set InsideCommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $insideCommissionAmount
     * @return \patest\StructType\Sales_ExpandedSettlementDeductionItem
     */
    public function setInsideCommissionAmount(\patest\StructType\Money $insideCommissionAmount = null)
    {
        if (is_null($insideCommissionAmount) || (is_array($insideCommissionAmount) && empty($insideCommissionAmount))) {
            unset($this->InsideCommissionAmount);
        } else {
            $this->InsideCommissionAmount = $insideCommissionAmount;
        }
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInvoiceNumber()
    {
        return isset($this->InvoiceNumber) ? $this->InvoiceNumber : null;
    }
    /**
     * Set InvoiceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $invoiceNumber
     * @return \patest\StructType\Sales_ExpandedSettlementDeductionItem
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceNumber) && !(is_int($invoiceNumber) || ctype_digit($invoiceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        if (is_null($invoiceNumber) || (is_array($invoiceNumber) && empty($invoiceNumber))) {
            unset($this->InvoiceNumber);
        } else {
            $this->InvoiceNumber = $invoiceNumber;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemId
     * @return \patest\StructType\Sales_ExpandedSettlementDeductionItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemId, true)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get ItemNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemNumber()
    {
        return isset($this->ItemNumber) ? $this->ItemNumber : null;
    }
    /**
     * Set ItemNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemNumber
     * @return \patest\StructType\Sales_ExpandedSettlementDeductionItem
     */
    public function setItemNumber($itemNumber = null)
    {
        // validation for constraint: int
        if (!is_null($itemNumber) && !(is_int($itemNumber) || ctype_digit($itemNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemNumber, true), gettype($itemNumber)), __LINE__);
        }
        if (is_null($itemNumber) || (is_array($itemNumber) && empty($itemNumber))) {
            unset($this->ItemNumber);
        } else {
            $this->ItemNumber = $itemNumber;
        }
        return $this;
    }
    /**
     * Get OriginalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getOriginalAmount()
    {
        return isset($this->OriginalAmount) ? $this->OriginalAmount : null;
    }
    /**
     * Set OriginalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $originalAmount
     * @return \patest\StructType\Sales_ExpandedSettlementDeductionItem
     */
    public function setOriginalAmount(\patest\StructType\Money $originalAmount = null)
    {
        if (is_null($originalAmount) || (is_array($originalAmount) && empty($originalAmount))) {
            unset($this->OriginalAmount);
        } else {
            $this->OriginalAmount = $originalAmount;
        }
        return $this;
    }
    /**
     * Get RemainingAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRemainingAmount()
    {
        return isset($this->RemainingAmount) ? $this->RemainingAmount : null;
    }
    /**
     * Set RemainingAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $remainingAmount
     * @return \patest\StructType\Sales_ExpandedSettlementDeductionItem
     */
    public function setRemainingAmount(\patest\StructType\Money $remainingAmount = null)
    {
        if (is_null($remainingAmount) || (is_array($remainingAmount) && empty($remainingAmount))) {
            unset($this->RemainingAmount);
        } else {
            $this->RemainingAmount = $remainingAmount;
        }
        return $this;
    }
}
