<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ExchangeRate StructType
 * @subpackage Structs
 */
class Sales_ExchangeRate extends PersistableEntity
{
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ExchangeRate;
    /**
     * The ExchangeUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExchangeUnit;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The LastUseAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUseAt;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The TargetCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetCurrencyCode;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Sales.ExchangeRate
     * @uses Sales_ExchangeRate::setExchangeRate()
     * @uses Sales_ExchangeRate::setExchangeUnit()
     * @uses Sales_ExchangeRate::setFromDate()
     * @uses Sales_ExchangeRate::setLastUseAt()
     * @uses Sales_ExchangeRate::setOrganizationUnitId()
     * @uses Sales_ExchangeRate::setTargetCurrencyCode()
     * @uses Sales_ExchangeRate::setToDate()
     * @uses Sales_ExchangeRate::setVisibleBySubordinates()
     * @param float $exchangeRate
     * @param int $exchangeUnit
     * @param string $fromDate
     * @param string $lastUseAt
     * @param string $organizationUnitId
     * @param string $targetCurrencyCode
     * @param string $toDate
     * @param bool $visibleBySubordinates
     */
    public function __construct($exchangeRate = null, $exchangeUnit = null, $fromDate = null, $lastUseAt = null, $organizationUnitId = null, $targetCurrencyCode = null, $toDate = null, $visibleBySubordinates = null)
    {
        $this
            ->setExchangeRate($exchangeRate)
            ->setExchangeUnit($exchangeUnit)
            ->setFromDate($fromDate)
            ->setLastUseAt($lastUseAt)
            ->setOrganizationUnitId($organizationUnitId)
            ->setTargetCurrencyCode($targetCurrencyCode)
            ->setToDate($toDate)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get ExchangeRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getExchangeRate()
    {
        return isset($this->ExchangeRate) ? $this->ExchangeRate : null;
    }
    /**
     * Set ExchangeRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $exchangeRate
     * @return \patest\StructType\Sales_ExchangeRate
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        if (is_null($exchangeRate) || (is_array($exchangeRate) && empty($exchangeRate))) {
            unset($this->ExchangeRate);
        } else {
            $this->ExchangeRate = $exchangeRate;
        }
        return $this;
    }
    /**
     * Get ExchangeUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExchangeUnit()
    {
        return isset($this->ExchangeUnit) ? $this->ExchangeUnit : null;
    }
    /**
     * Set ExchangeUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $exchangeUnit
     * @return \patest\StructType\Sales_ExchangeRate
     */
    public function setExchangeUnit($exchangeUnit = null)
    {
        // validation for constraint: int
        if (!is_null($exchangeUnit) && !(is_int($exchangeUnit) || ctype_digit($exchangeUnit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exchangeUnit, true), gettype($exchangeUnit)), __LINE__);
        }
        if (is_null($exchangeUnit) || (is_array($exchangeUnit) && empty($exchangeUnit))) {
            unset($this->ExchangeUnit);
        } else {
            $this->ExchangeUnit = $exchangeUnit;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Sales_ExchangeRate
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get LastUseAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUseAt()
    {
        return isset($this->LastUseAt) ? $this->LastUseAt : null;
    }
    /**
     * Set LastUseAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUseAt
     * @return \patest\StructType\Sales_ExchangeRate
     */
    public function setLastUseAt($lastUseAt = null)
    {
        // validation for constraint: string
        if (!is_null($lastUseAt) && !is_string($lastUseAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUseAt, true), gettype($lastUseAt)), __LINE__);
        }
        if (is_null($lastUseAt) || (is_array($lastUseAt) && empty($lastUseAt))) {
            unset($this->LastUseAt);
        } else {
            $this->LastUseAt = $lastUseAt;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Sales_ExchangeRate
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get TargetCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetCurrencyCode()
    {
        return isset($this->TargetCurrencyCode) ? $this->TargetCurrencyCode : null;
    }
    /**
     * Set TargetCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetCurrencyCode
     * @return \patest\StructType\Sales_ExchangeRate
     */
    public function setTargetCurrencyCode($targetCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($targetCurrencyCode) && !is_string($targetCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetCurrencyCode, true), gettype($targetCurrencyCode)), __LINE__);
        }
        if (is_null($targetCurrencyCode) || (is_array($targetCurrencyCode) && empty($targetCurrencyCode))) {
            unset($this->TargetCurrencyCode);
        } else {
            $this->TargetCurrencyCode = $targetCurrencyCode;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Sales_ExchangeRate
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Sales_ExchangeRate
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
