<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.EventPackageElement StructType
 * @subpackage Structs
 */
class Sales_EventPackageElement extends Sales_ProductPackageElement
{
    /**
     * The MaxTicketsPerEvent
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxTicketsPerEvent;
    /**
     * The MinTicketsPerEvent
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinTicketsPerEvent;
    /**
     * The SameQuantityPerEvent
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SameQuantityPerEvent;
    /**
     * Constructor method for Sales.EventPackageElement
     * @uses Sales_EventPackageElement::setMaxTicketsPerEvent()
     * @uses Sales_EventPackageElement::setMinTicketsPerEvent()
     * @uses Sales_EventPackageElement::setSameQuantityPerEvent()
     * @param int $maxTicketsPerEvent
     * @param int $minTicketsPerEvent
     * @param bool $sameQuantityPerEvent
     */
    public function __construct($maxTicketsPerEvent = null, $minTicketsPerEvent = null, $sameQuantityPerEvent = null)
    {
        $this
            ->setMaxTicketsPerEvent($maxTicketsPerEvent)
            ->setMinTicketsPerEvent($minTicketsPerEvent)
            ->setSameQuantityPerEvent($sameQuantityPerEvent);
    }
    /**
     * Get MaxTicketsPerEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxTicketsPerEvent()
    {
        return isset($this->MaxTicketsPerEvent) ? $this->MaxTicketsPerEvent : null;
    }
    /**
     * Set MaxTicketsPerEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxTicketsPerEvent
     * @return \patest\StructType\Sales_EventPackageElement
     */
    public function setMaxTicketsPerEvent($maxTicketsPerEvent = null)
    {
        // validation for constraint: int
        if (!is_null($maxTicketsPerEvent) && !(is_int($maxTicketsPerEvent) || ctype_digit($maxTicketsPerEvent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTicketsPerEvent, true), gettype($maxTicketsPerEvent)), __LINE__);
        }
        if (is_null($maxTicketsPerEvent) || (is_array($maxTicketsPerEvent) && empty($maxTicketsPerEvent))) {
            unset($this->MaxTicketsPerEvent);
        } else {
            $this->MaxTicketsPerEvent = $maxTicketsPerEvent;
        }
        return $this;
    }
    /**
     * Get MinTicketsPerEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinTicketsPerEvent()
    {
        return isset($this->MinTicketsPerEvent) ? $this->MinTicketsPerEvent : null;
    }
    /**
     * Set MinTicketsPerEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minTicketsPerEvent
     * @return \patest\StructType\Sales_EventPackageElement
     */
    public function setMinTicketsPerEvent($minTicketsPerEvent = null)
    {
        // validation for constraint: int
        if (!is_null($minTicketsPerEvent) && !(is_int($minTicketsPerEvent) || ctype_digit($minTicketsPerEvent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minTicketsPerEvent, true), gettype($minTicketsPerEvent)), __LINE__);
        }
        if (is_null($minTicketsPerEvent) || (is_array($minTicketsPerEvent) && empty($minTicketsPerEvent))) {
            unset($this->MinTicketsPerEvent);
        } else {
            $this->MinTicketsPerEvent = $minTicketsPerEvent;
        }
        return $this;
    }
    /**
     * Get SameQuantityPerEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSameQuantityPerEvent()
    {
        return isset($this->SameQuantityPerEvent) ? $this->SameQuantityPerEvent : null;
    }
    /**
     * Set SameQuantityPerEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sameQuantityPerEvent
     * @return \patest\StructType\Sales_EventPackageElement
     */
    public function setSameQuantityPerEvent($sameQuantityPerEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($sameQuantityPerEvent) && !is_bool($sameQuantityPerEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sameQuantityPerEvent, true), gettype($sameQuantityPerEvent)), __LINE__);
        }
        if (is_null($sameQuantityPerEvent) || (is_array($sameQuantityPerEvent) && empty($sameQuantityPerEvent))) {
            unset($this->SameQuantityPerEvent);
        } else {
            $this->SameQuantityPerEvent = $sameQuantityPerEvent;
        }
        return $this;
    }
}
