<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.DraftInvoiceItem StructType
 * @subpackage Structs
 */
class Sales_DraftInvoiceItem extends PersistableEntity
{
    /**
     * The CommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CommissionAmount;
    /**
     * The CurrentlyUnpaid
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CurrentlyUnpaid;
    /**
     * The DraftInvoiceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DraftInvoiceId;
    /**
     * The FacePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $FacePrice;
    /**
     * The IsReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReservation;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemId;
    /**
     * The ItemKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemKind;
    /**
     * The LineNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LineNumber;
    /**
     * The NewItemIdOfReservation
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewItemIdOfReservation;
    /**
     * The OriginalDueAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $OriginalDueAmount;
    /**
     * The OriginalPaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $OriginalPaidAmount;
    /**
     * The OriginalTotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $OriginalTotalAmount;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Sales.DraftInvoiceItem
     * @uses Sales_DraftInvoiceItem::setCommissionAmount()
     * @uses Sales_DraftInvoiceItem::setCurrentlyUnpaid()
     * @uses Sales_DraftInvoiceItem::setDraftInvoiceId()
     * @uses Sales_DraftInvoiceItem::setFacePrice()
     * @uses Sales_DraftInvoiceItem::setIsReservation()
     * @uses Sales_DraftInvoiceItem::setItemId()
     * @uses Sales_DraftInvoiceItem::setItemKind()
     * @uses Sales_DraftInvoiceItem::setLineNumber()
     * @uses Sales_DraftInvoiceItem::setNewItemIdOfReservation()
     * @uses Sales_DraftInvoiceItem::setOriginalDueAmount()
     * @uses Sales_DraftInvoiceItem::setOriginalPaidAmount()
     * @uses Sales_DraftInvoiceItem::setOriginalTotalAmount()
     * @uses Sales_DraftInvoiceItem::setStatus()
     * @param \patest\StructType\Money $commissionAmount
     * @param bool $currentlyUnpaid
     * @param string $draftInvoiceId
     * @param \patest\StructType\Money $facePrice
     * @param bool $isReservation
     * @param string $itemId
     * @param string $itemKind
     * @param int $lineNumber
     * @param string $newItemIdOfReservation
     * @param \patest\StructType\Money $originalDueAmount
     * @param \patest\StructType\Money $originalPaidAmount
     * @param \patest\StructType\Money $originalTotalAmount
     * @param string $status
     */
    public function __construct(\patest\StructType\Money $commissionAmount = null, $currentlyUnpaid = null, $draftInvoiceId = null, \patest\StructType\Money $facePrice = null, $isReservation = null, $itemId = null, $itemKind = null, $lineNumber = null, $newItemIdOfReservation = null, \patest\StructType\Money $originalDueAmount = null, \patest\StructType\Money $originalPaidAmount = null, \patest\StructType\Money $originalTotalAmount = null, $status = null)
    {
        $this
            ->setCommissionAmount($commissionAmount)
            ->setCurrentlyUnpaid($currentlyUnpaid)
            ->setDraftInvoiceId($draftInvoiceId)
            ->setFacePrice($facePrice)
            ->setIsReservation($isReservation)
            ->setItemId($itemId)
            ->setItemKind($itemKind)
            ->setLineNumber($lineNumber)
            ->setNewItemIdOfReservation($newItemIdOfReservation)
            ->setOriginalDueAmount($originalDueAmount)
            ->setOriginalPaidAmount($originalPaidAmount)
            ->setOriginalTotalAmount($originalTotalAmount)
            ->setStatus($status);
    }
    /**
     * Get CommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCommissionAmount()
    {
        return isset($this->CommissionAmount) ? $this->CommissionAmount : null;
    }
    /**
     * Set CommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $commissionAmount
     * @return \patest\StructType\Sales_DraftInvoiceItem
     */
    public function setCommissionAmount(\patest\StructType\Money $commissionAmount = null)
    {
        if (is_null($commissionAmount) || (is_array($commissionAmount) && empty($commissionAmount))) {
            unset($this->CommissionAmount);
        } else {
            $this->CommissionAmount = $commissionAmount;
        }
        return $this;
    }
    /**
     * Get CurrentlyUnpaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCurrentlyUnpaid()
    {
        return isset($this->CurrentlyUnpaid) ? $this->CurrentlyUnpaid : null;
    }
    /**
     * Set CurrentlyUnpaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $currentlyUnpaid
     * @return \patest\StructType\Sales_DraftInvoiceItem
     */
    public function setCurrentlyUnpaid($currentlyUnpaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($currentlyUnpaid) && !is_bool($currentlyUnpaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($currentlyUnpaid, true), gettype($currentlyUnpaid)), __LINE__);
        }
        if (is_null($currentlyUnpaid) || (is_array($currentlyUnpaid) && empty($currentlyUnpaid))) {
            unset($this->CurrentlyUnpaid);
        } else {
            $this->CurrentlyUnpaid = $currentlyUnpaid;
        }
        return $this;
    }
    /**
     * Get DraftInvoiceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDraftInvoiceId()
    {
        return isset($this->DraftInvoiceId) ? $this->DraftInvoiceId : null;
    }
    /**
     * Set DraftInvoiceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $draftInvoiceId
     * @return \patest\StructType\Sales_DraftInvoiceItem
     */
    public function setDraftInvoiceId($draftInvoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($draftInvoiceId) && !is_string($draftInvoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($draftInvoiceId, true), gettype($draftInvoiceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($draftInvoiceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $draftInvoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($draftInvoiceId, true)), __LINE__);
        }
        if (is_null($draftInvoiceId) || (is_array($draftInvoiceId) && empty($draftInvoiceId))) {
            unset($this->DraftInvoiceId);
        } else {
            $this->DraftInvoiceId = $draftInvoiceId;
        }
        return $this;
    }
    /**
     * Get FacePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getFacePrice()
    {
        return isset($this->FacePrice) ? $this->FacePrice : null;
    }
    /**
     * Set FacePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $facePrice
     * @return \patest\StructType\Sales_DraftInvoiceItem
     */
    public function setFacePrice(\patest\StructType\Money $facePrice = null)
    {
        if (is_null($facePrice) || (is_array($facePrice) && empty($facePrice))) {
            unset($this->FacePrice);
        } else {
            $this->FacePrice = $facePrice;
        }
        return $this;
    }
    /**
     * Get IsReservation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReservation()
    {
        return isset($this->IsReservation) ? $this->IsReservation : null;
    }
    /**
     * Set IsReservation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReservation
     * @return \patest\StructType\Sales_DraftInvoiceItem
     */
    public function setIsReservation($isReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReservation) && !is_bool($isReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReservation, true), gettype($isReservation)), __LINE__);
        }
        if (is_null($isReservation) || (is_array($isReservation) && empty($isReservation))) {
            unset($this->IsReservation);
        } else {
            $this->IsReservation = $isReservation;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemId
     * @return \patest\StructType\Sales_DraftInvoiceItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemId, true)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get ItemKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemKind()
    {
        return isset($this->ItemKind) ? $this->ItemKind : null;
    }
    /**
     * Set ItemKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialJournalTargetKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalTargetKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemKind
     * @return \patest\StructType\Sales_DraftInvoiceItem
     */
    public function setItemKind($itemKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalTargetKind::valueIsValid($itemKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalTargetKind', is_array($itemKind) ? implode(', ', $itemKind) : var_export($itemKind, true), implode(', ', \patest\EnumType\FinancialJournalTargetKind::getValidValues())), __LINE__);
        }
        if (is_null($itemKind) || (is_array($itemKind) && empty($itemKind))) {
            unset($this->ItemKind);
        } else {
            $this->ItemKind = $itemKind;
        }
        return $this;
    }
    /**
     * Get LineNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLineNumber()
    {
        return isset($this->LineNumber) ? $this->LineNumber : null;
    }
    /**
     * Set LineNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lineNumber
     * @return \patest\StructType\Sales_DraftInvoiceItem
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !(is_int($lineNumber) || ctype_digit($lineNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNumber, true), gettype($lineNumber)), __LINE__);
        }
        if (is_null($lineNumber) || (is_array($lineNumber) && empty($lineNumber))) {
            unset($this->LineNumber);
        } else {
            $this->LineNumber = $lineNumber;
        }
        return $this;
    }
    /**
     * Get NewItemIdOfReservation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewItemIdOfReservation()
    {
        return isset($this->NewItemIdOfReservation) ? $this->NewItemIdOfReservation : null;
    }
    /**
     * Set NewItemIdOfReservation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newItemIdOfReservation
     * @return \patest\StructType\Sales_DraftInvoiceItem
     */
    public function setNewItemIdOfReservation($newItemIdOfReservation = null)
    {
        // validation for constraint: string
        if (!is_null($newItemIdOfReservation) && !is_string($newItemIdOfReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newItemIdOfReservation, true), gettype($newItemIdOfReservation)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newItemIdOfReservation) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newItemIdOfReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newItemIdOfReservation, true)), __LINE__);
        }
        if (is_null($newItemIdOfReservation) || (is_array($newItemIdOfReservation) && empty($newItemIdOfReservation))) {
            unset($this->NewItemIdOfReservation);
        } else {
            $this->NewItemIdOfReservation = $newItemIdOfReservation;
        }
        return $this;
    }
    /**
     * Get OriginalDueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getOriginalDueAmount()
    {
        return isset($this->OriginalDueAmount) ? $this->OriginalDueAmount : null;
    }
    /**
     * Set OriginalDueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $originalDueAmount
     * @return \patest\StructType\Sales_DraftInvoiceItem
     */
    public function setOriginalDueAmount(\patest\StructType\Money $originalDueAmount = null)
    {
        if (is_null($originalDueAmount) || (is_array($originalDueAmount) && empty($originalDueAmount))) {
            unset($this->OriginalDueAmount);
        } else {
            $this->OriginalDueAmount = $originalDueAmount;
        }
        return $this;
    }
    /**
     * Get OriginalPaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getOriginalPaidAmount()
    {
        return isset($this->OriginalPaidAmount) ? $this->OriginalPaidAmount : null;
    }
    /**
     * Set OriginalPaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $originalPaidAmount
     * @return \patest\StructType\Sales_DraftInvoiceItem
     */
    public function setOriginalPaidAmount(\patest\StructType\Money $originalPaidAmount = null)
    {
        if (is_null($originalPaidAmount) || (is_array($originalPaidAmount) && empty($originalPaidAmount))) {
            unset($this->OriginalPaidAmount);
        } else {
            $this->OriginalPaidAmount = $originalPaidAmount;
        }
        return $this;
    }
    /**
     * Get OriginalTotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getOriginalTotalAmount()
    {
        return isset($this->OriginalTotalAmount) ? $this->OriginalTotalAmount : null;
    }
    /**
     * Set OriginalTotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $originalTotalAmount
     * @return \patest\StructType\Sales_DraftInvoiceItem
     */
    public function setOriginalTotalAmount(\patest\StructType\Money $originalTotalAmount = null)
    {
        if (is_null($originalTotalAmount) || (is_array($originalTotalAmount) && empty($originalTotalAmount))) {
            unset($this->OriginalTotalAmount);
        } else {
            $this->OriginalTotalAmount = $originalTotalAmount;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DraftInvoiceItemStatus::valueIsValid()
     * @uses \patest\EnumType\DraftInvoiceItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Sales_DraftInvoiceItem
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DraftInvoiceItemStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DraftInvoiceItemStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\DraftInvoiceItemStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
