<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ClientSalesTransactionFilterEntity StructType
 * @subpackage Structs
 */
class Sales_ClientSalesTransactionFilterEntity extends FilterEntity
{
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The TransactionDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDateFrom;
    /**
     * The TransactionDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDateTo;
    /**
     * The TransactionDateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDateType;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Sales.ClientSalesTransactionFilterEntity
     * @uses Sales_ClientSalesTransactionFilterEntity::setApplicationChannel()
     * @uses Sales_ClientSalesTransactionFilterEntity::setTransactionDateFrom()
     * @uses Sales_ClientSalesTransactionFilterEntity::setTransactionDateTo()
     * @uses Sales_ClientSalesTransactionFilterEntity::setTransactionDateType()
     * @uses Sales_ClientSalesTransactionFilterEntity::setTransactionNumber()
     * @param string $applicationChannel
     * @param string $transactionDateFrom
     * @param string $transactionDateTo
     * @param string $transactionDateType
     * @param int $transactionNumber
     */
    public function __construct($applicationChannel = null, $transactionDateFrom = null, $transactionDateTo = null, $transactionDateType = null, $transactionNumber = null)
    {
        $this
            ->setApplicationChannel($applicationChannel)
            ->setTransactionDateFrom($transactionDateFrom)
            ->setTransactionDateTo($transactionDateTo)
            ->setTransactionDateType($transactionDateType)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Sales_ClientSalesTransactionFilterEntity
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get TransactionDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDateFrom()
    {
        return isset($this->TransactionDateFrom) ? $this->TransactionDateFrom : null;
    }
    /**
     * Set TransactionDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDateFrom
     * @return \patest\StructType\Sales_ClientSalesTransactionFilterEntity
     */
    public function setTransactionDateFrom($transactionDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateFrom) && !is_string($transactionDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDateFrom, true), gettype($transactionDateFrom)), __LINE__);
        }
        if (is_null($transactionDateFrom) || (is_array($transactionDateFrom) && empty($transactionDateFrom))) {
            unset($this->TransactionDateFrom);
        } else {
            $this->TransactionDateFrom = $transactionDateFrom;
        }
        return $this;
    }
    /**
     * Get TransactionDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDateTo()
    {
        return isset($this->TransactionDateTo) ? $this->TransactionDateTo : null;
    }
    /**
     * Set TransactionDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDateTo
     * @return \patest\StructType\Sales_ClientSalesTransactionFilterEntity
     */
    public function setTransactionDateTo($transactionDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateTo) && !is_string($transactionDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDateTo, true), gettype($transactionDateTo)), __LINE__);
        }
        if (is_null($transactionDateTo) || (is_array($transactionDateTo) && empty($transactionDateTo))) {
            unset($this->TransactionDateTo);
        } else {
            $this->TransactionDateTo = $transactionDateTo;
        }
        return $this;
    }
    /**
     * Get TransactionDateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDateType()
    {
        return isset($this->TransactionDateType) ? $this->TransactionDateType : null;
    }
    /**
     * Set TransactionDateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DateEnum::valueIsValid()
     * @uses \patest\EnumType\DateEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionDateType
     * @return \patest\StructType\Sales_ClientSalesTransactionFilterEntity
     */
    public function setTransactionDateType($transactionDateType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DateEnum::valueIsValid($transactionDateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DateEnum', is_array($transactionDateType) ? implode(', ', $transactionDateType) : var_export($transactionDateType, true), implode(', ', \patest\EnumType\DateEnum::getValidValues())), __LINE__);
        }
        if (is_null($transactionDateType) || (is_array($transactionDateType) && empty($transactionDateType))) {
            unset($this->TransactionDateType);
        } else {
            $this->TransactionDateType = $transactionDateType;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Sales_ClientSalesTransactionFilterEntity
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
