<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.ClientCreditItemDetails StructType
 * @subpackage Structs
 */
class Sales_ClientCreditItemDetails extends Sales_AbstractItemDetails
{
    /**
     * The DebtItemDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_AbstractItemDetails
     */
    public $DebtItemDetails;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The TargetType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetType;
    /**
     * Constructor method for Sales.ClientCreditItemDetails
     * @uses Sales_ClientCreditItemDetails::setDebtItemDetails()
     * @uses Sales_ClientCreditItemDetails::setItemType()
     * @uses Sales_ClientCreditItemDetails::setTargetType()
     * @param \patest\StructType\Sales_AbstractItemDetails $debtItemDetails
     * @param int $itemType
     * @param string $targetType
     */
    public function __construct(\patest\StructType\Sales_AbstractItemDetails $debtItemDetails = null, $itemType = null, $targetType = null)
    {
        $this
            ->setDebtItemDetails($debtItemDetails)
            ->setItemType($itemType)
            ->setTargetType($targetType);
    }
    /**
     * Get DebtItemDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_AbstractItemDetails|null
     */
    public function getDebtItemDetails()
    {
        return isset($this->DebtItemDetails) ? $this->DebtItemDetails : null;
    }
    /**
     * Set DebtItemDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_AbstractItemDetails $debtItemDetails
     * @return \patest\StructType\Sales_ClientCreditItemDetails
     */
    public function setDebtItemDetails(\patest\StructType\Sales_AbstractItemDetails $debtItemDetails = null)
    {
        if (is_null($debtItemDetails) || (is_array($debtItemDetails) && empty($debtItemDetails))) {
            unset($this->DebtItemDetails);
        } else {
            $this->DebtItemDetails = $debtItemDetails;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Sales_ClientCreditItemDetails
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get TargetType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetType()
    {
        return isset($this->TargetType) ? $this->TargetType : null;
    }
    /**
     * Set TargetType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DepositTargetType::valueIsValid()
     * @uses \patest\EnumType\DepositTargetType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $targetType
     * @return \patest\StructType\Sales_ClientCreditItemDetails
     */
    public function setTargetType($targetType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DepositTargetType::valueIsValid($targetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DepositTargetType', is_array($targetType) ? implode(', ', $targetType) : var_export($targetType, true), implode(', ', \patest\EnumType\DepositTargetType::getValidValues())), __LINE__);
        }
        if (is_null($targetType) || (is_array($targetType) && empty($targetType))) {
            unset($this->TargetType);
        } else {
            $this->TargetType = $targetType;
        }
        return $this;
    }
}
