<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.CancelDeductionHistory StructType
 * @subpackage Structs
 */
class Sales_CancelDeductionHistory extends PersistableEntity
{
    /**
     * The CanceledAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CanceledAuditId;
    /**
     * The CanceledDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CanceledDateTime;
    /**
     * The DeductedAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DeductedAuditId;
    /**
     * The DeductedDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeductedDateTime;
    /**
     * The DeductionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DeductionAmount;
    /**
     * The DeductionItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeductionItemId;
    /**
     * The DeductionItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeductionItemType;
    /**
     * The DepositId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositId;
    /**
     * The IsFullDeducted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFullDeducted;
    /**
     * Constructor method for Sales.CancelDeductionHistory
     * @uses Sales_CancelDeductionHistory::setCanceledAuditId()
     * @uses Sales_CancelDeductionHistory::setCanceledDateTime()
     * @uses Sales_CancelDeductionHistory::setDeductedAuditId()
     * @uses Sales_CancelDeductionHistory::setDeductedDateTime()
     * @uses Sales_CancelDeductionHistory::setDeductionAmount()
     * @uses Sales_CancelDeductionHistory::setDeductionItemId()
     * @uses Sales_CancelDeductionHistory::setDeductionItemType()
     * @uses Sales_CancelDeductionHistory::setDepositId()
     * @uses Sales_CancelDeductionHistory::setIsFullDeducted()
     * @param int $canceledAuditId
     * @param string $canceledDateTime
     * @param int $deductedAuditId
     * @param string $deductedDateTime
     * @param \patest\StructType\Money $deductionAmount
     * @param string $deductionItemId
     * @param string $deductionItemType
     * @param string $depositId
     * @param bool $isFullDeducted
     */
    public function __construct($canceledAuditId = null, $canceledDateTime = null, $deductedAuditId = null, $deductedDateTime = null, \patest\StructType\Money $deductionAmount = null, $deductionItemId = null, $deductionItemType = null, $depositId = null, $isFullDeducted = null)
    {
        $this
            ->setCanceledAuditId($canceledAuditId)
            ->setCanceledDateTime($canceledDateTime)
            ->setDeductedAuditId($deductedAuditId)
            ->setDeductedDateTime($deductedDateTime)
            ->setDeductionAmount($deductionAmount)
            ->setDeductionItemId($deductionItemId)
            ->setDeductionItemType($deductionItemType)
            ->setDepositId($depositId)
            ->setIsFullDeducted($isFullDeducted);
    }
    /**
     * Get CanceledAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCanceledAuditId()
    {
        return isset($this->CanceledAuditId) ? $this->CanceledAuditId : null;
    }
    /**
     * Set CanceledAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $canceledAuditId
     * @return \patest\StructType\Sales_CancelDeductionHistory
     */
    public function setCanceledAuditId($canceledAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($canceledAuditId) && !(is_int($canceledAuditId) || ctype_digit($canceledAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($canceledAuditId, true), gettype($canceledAuditId)), __LINE__);
        }
        if (is_null($canceledAuditId) || (is_array($canceledAuditId) && empty($canceledAuditId))) {
            unset($this->CanceledAuditId);
        } else {
            $this->CanceledAuditId = $canceledAuditId;
        }
        return $this;
    }
    /**
     * Get CanceledDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCanceledDateTime()
    {
        return isset($this->CanceledDateTime) ? $this->CanceledDateTime : null;
    }
    /**
     * Set CanceledDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $canceledDateTime
     * @return \patest\StructType\Sales_CancelDeductionHistory
     */
    public function setCanceledDateTime($canceledDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($canceledDateTime) && !is_string($canceledDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($canceledDateTime, true), gettype($canceledDateTime)), __LINE__);
        }
        if (is_null($canceledDateTime) || (is_array($canceledDateTime) && empty($canceledDateTime))) {
            unset($this->CanceledDateTime);
        } else {
            $this->CanceledDateTime = $canceledDateTime;
        }
        return $this;
    }
    /**
     * Get DeductedAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeductedAuditId()
    {
        return isset($this->DeductedAuditId) ? $this->DeductedAuditId : null;
    }
    /**
     * Set DeductedAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deductedAuditId
     * @return \patest\StructType\Sales_CancelDeductionHistory
     */
    public function setDeductedAuditId($deductedAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($deductedAuditId) && !(is_int($deductedAuditId) || ctype_digit($deductedAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deductedAuditId, true), gettype($deductedAuditId)), __LINE__);
        }
        if (is_null($deductedAuditId) || (is_array($deductedAuditId) && empty($deductedAuditId))) {
            unset($this->DeductedAuditId);
        } else {
            $this->DeductedAuditId = $deductedAuditId;
        }
        return $this;
    }
    /**
     * Get DeductedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeductedDateTime()
    {
        return isset($this->DeductedDateTime) ? $this->DeductedDateTime : null;
    }
    /**
     * Set DeductedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deductedDateTime
     * @return \patest\StructType\Sales_CancelDeductionHistory
     */
    public function setDeductedDateTime($deductedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($deductedDateTime) && !is_string($deductedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deductedDateTime, true), gettype($deductedDateTime)), __LINE__);
        }
        if (is_null($deductedDateTime) || (is_array($deductedDateTime) && empty($deductedDateTime))) {
            unset($this->DeductedDateTime);
        } else {
            $this->DeductedDateTime = $deductedDateTime;
        }
        return $this;
    }
    /**
     * Get DeductionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDeductionAmount()
    {
        return isset($this->DeductionAmount) ? $this->DeductionAmount : null;
    }
    /**
     * Set DeductionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $deductionAmount
     * @return \patest\StructType\Sales_CancelDeductionHistory
     */
    public function setDeductionAmount(\patest\StructType\Money $deductionAmount = null)
    {
        if (is_null($deductionAmount) || (is_array($deductionAmount) && empty($deductionAmount))) {
            unset($this->DeductionAmount);
        } else {
            $this->DeductionAmount = $deductionAmount;
        }
        return $this;
    }
    /**
     * Get DeductionItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeductionItemId()
    {
        return isset($this->DeductionItemId) ? $this->DeductionItemId : null;
    }
    /**
     * Set DeductionItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deductionItemId
     * @return \patest\StructType\Sales_CancelDeductionHistory
     */
    public function setDeductionItemId($deductionItemId = null)
    {
        // validation for constraint: string
        if (!is_null($deductionItemId) && !is_string($deductionItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deductionItemId, true), gettype($deductionItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deductionItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deductionItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deductionItemId, true)), __LINE__);
        }
        if (is_null($deductionItemId) || (is_array($deductionItemId) && empty($deductionItemId))) {
            unset($this->DeductionItemId);
        } else {
            $this->DeductionItemId = $deductionItemId;
        }
        return $this;
    }
    /**
     * Get DeductionItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeductionItemType()
    {
        return isset($this->DeductionItemType) ? $this->DeductionItemType : null;
    }
    /**
     * Set DeductionItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DeductionItemKind::valueIsValid()
     * @uses \patest\EnumType\DeductionItemKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deductionItemType
     * @return \patest\StructType\Sales_CancelDeductionHistory
     */
    public function setDeductionItemType($deductionItemType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DeductionItemKind::valueIsValid($deductionItemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DeductionItemKind', is_array($deductionItemType) ? implode(', ', $deductionItemType) : var_export($deductionItemType, true), implode(', ', \patest\EnumType\DeductionItemKind::getValidValues())), __LINE__);
        }
        if (is_null($deductionItemType) || (is_array($deductionItemType) && empty($deductionItemType))) {
            unset($this->DeductionItemType);
        } else {
            $this->DeductionItemType = $deductionItemType;
        }
        return $this;
    }
    /**
     * Get DepositId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositId()
    {
        return isset($this->DepositId) ? $this->DepositId : null;
    }
    /**
     * Set DepositId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositId
     * @return \patest\StructType\Sales_CancelDeductionHistory
     */
    public function setDepositId($depositId = null)
    {
        // validation for constraint: string
        if (!is_null($depositId) && !is_string($depositId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositId, true), gettype($depositId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositId, true)), __LINE__);
        }
        if (is_null($depositId) || (is_array($depositId) && empty($depositId))) {
            unset($this->DepositId);
        } else {
            $this->DepositId = $depositId;
        }
        return $this;
    }
    /**
     * Get IsFullDeducted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFullDeducted()
    {
        return isset($this->IsFullDeducted) ? $this->IsFullDeducted : null;
    }
    /**
     * Set IsFullDeducted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFullDeducted
     * @return \patest\StructType\Sales_CancelDeductionHistory
     */
    public function setIsFullDeducted($isFullDeducted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFullDeducted) && !is_bool($isFullDeducted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFullDeducted, true), gettype($isFullDeducted)), __LINE__);
        }
        if (is_null($isFullDeducted) || (is_array($isFullDeducted) && empty($isFullDeducted))) {
            unset($this->IsFullDeducted);
        } else {
            $this->IsFullDeducted = $isFullDeducted;
        }
        return $this;
    }
}
