<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.BulkEditItemInformation StructType
 * @subpackage Structs
 */
class Sales_BulkEditItemInformation extends AnyEntity
{
    /**
     * The IsComplimentary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsComplimentary;
    /**
     * The IsExchangeAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExchangeAction;
    /**
     * The IsReplaceAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReplaceAction;
    /**
     * The IsSubscriberTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubscriberTicket;
    /**
     * The ItemDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemDescription;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * Constructor method for Sales.BulkEditItemInformation
     * @uses Sales_BulkEditItemInformation::setIsComplimentary()
     * @uses Sales_BulkEditItemInformation::setIsExchangeAction()
     * @uses Sales_BulkEditItemInformation::setIsReplaceAction()
     * @uses Sales_BulkEditItemInformation::setIsSubscriberTicket()
     * @uses Sales_BulkEditItemInformation::setItemDescription()
     * @uses Sales_BulkEditItemInformation::setItemId()
     * @uses Sales_BulkEditItemInformation::setItemType()
     * @param bool $isComplimentary
     * @param bool $isExchangeAction
     * @param bool $isReplaceAction
     * @param bool $isSubscriberTicket
     * @param string $itemDescription
     * @param int $itemId
     * @param int $itemType
     */
    public function __construct($isComplimentary = null, $isExchangeAction = null, $isReplaceAction = null, $isSubscriberTicket = null, $itemDescription = null, $itemId = null, $itemType = null)
    {
        $this
            ->setIsComplimentary($isComplimentary)
            ->setIsExchangeAction($isExchangeAction)
            ->setIsReplaceAction($isReplaceAction)
            ->setIsSubscriberTicket($isSubscriberTicket)
            ->setItemDescription($itemDescription)
            ->setItemId($itemId)
            ->setItemType($itemType);
    }
    /**
     * Get IsComplimentary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsComplimentary()
    {
        return isset($this->IsComplimentary) ? $this->IsComplimentary : null;
    }
    /**
     * Set IsComplimentary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isComplimentary
     * @return \patest\StructType\Sales_BulkEditItemInformation
     */
    public function setIsComplimentary($isComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplimentary) && !is_bool($isComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplimentary, true), gettype($isComplimentary)), __LINE__);
        }
        if (is_null($isComplimentary) || (is_array($isComplimentary) && empty($isComplimentary))) {
            unset($this->IsComplimentary);
        } else {
            $this->IsComplimentary = $isComplimentary;
        }
        return $this;
    }
    /**
     * Get IsExchangeAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExchangeAction()
    {
        return isset($this->IsExchangeAction) ? $this->IsExchangeAction : null;
    }
    /**
     * Set IsExchangeAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExchangeAction
     * @return \patest\StructType\Sales_BulkEditItemInformation
     */
    public function setIsExchangeAction($isExchangeAction = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExchangeAction) && !is_bool($isExchangeAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExchangeAction, true), gettype($isExchangeAction)), __LINE__);
        }
        if (is_null($isExchangeAction) || (is_array($isExchangeAction) && empty($isExchangeAction))) {
            unset($this->IsExchangeAction);
        } else {
            $this->IsExchangeAction = $isExchangeAction;
        }
        return $this;
    }
    /**
     * Get IsReplaceAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReplaceAction()
    {
        return isset($this->IsReplaceAction) ? $this->IsReplaceAction : null;
    }
    /**
     * Set IsReplaceAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReplaceAction
     * @return \patest\StructType\Sales_BulkEditItemInformation
     */
    public function setIsReplaceAction($isReplaceAction = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReplaceAction) && !is_bool($isReplaceAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReplaceAction, true), gettype($isReplaceAction)), __LINE__);
        }
        if (is_null($isReplaceAction) || (is_array($isReplaceAction) && empty($isReplaceAction))) {
            unset($this->IsReplaceAction);
        } else {
            $this->IsReplaceAction = $isReplaceAction;
        }
        return $this;
    }
    /**
     * Get IsSubscriberTicket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubscriberTicket()
    {
        return isset($this->IsSubscriberTicket) ? $this->IsSubscriberTicket : null;
    }
    /**
     * Set IsSubscriberTicket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubscriberTicket
     * @return \patest\StructType\Sales_BulkEditItemInformation
     */
    public function setIsSubscriberTicket($isSubscriberTicket = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubscriberTicket) && !is_bool($isSubscriberTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubscriberTicket, true), gettype($isSubscriberTicket)), __LINE__);
        }
        if (is_null($isSubscriberTicket) || (is_array($isSubscriberTicket) && empty($isSubscriberTicket))) {
            unset($this->IsSubscriberTicket);
        } else {
            $this->IsSubscriberTicket = $isSubscriberTicket;
        }
        return $this;
    }
    /**
     * Get ItemDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemDescription()
    {
        return isset($this->ItemDescription) ? $this->ItemDescription : null;
    }
    /**
     * Set ItemDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemDescription
     * @return \patest\StructType\Sales_BulkEditItemInformation
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDescription, true), gettype($itemDescription)), __LINE__);
        }
        if (is_null($itemDescription) || (is_array($itemDescription) && empty($itemDescription))) {
            unset($this->ItemDescription);
        } else {
            $this->ItemDescription = $itemDescription;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \patest\StructType\Sales_BulkEditItemInformation
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Sales_BulkEditItemInformation
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
}
